/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.message;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.workflow.MessageCenterServiceHelper;
import kd.bos.url.UrlService;
import kd.bos.workflow.engine.msg.info.MessageInfo;
import kd.fi.er.business.trip.util.TripCommonUtil;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.common.CarTypeEnum;
import org.apache.commons.lang.StringUtils;

public class ErMessageServiceHelper {
    private static final Log logger = LogFactory.getLog(ErMessageServiceHelper.class);
    public static final String ER_CAS_PAY_SCENE = "er_cas_pay";
    public static final String TRIP_ORDER_CHANGE_SCENE = "trip_order_change";
    public static final String TRIP_REQBILLSYNCMSG_SCENE = "trip_reqbillsyncmsg";
    public static final String TRIP_ORDER_NOTICE_CONFRIM_SCENE = "trip_order_notice_confrim";
    public static final String ER_CHECKING_EXP_LIST_MSG = "er_checking_exp_list_msg";
    public static final String ER_TRIPSYNC_LOG_YZJ = "er_tripsync_log_yzj";
    private static final Map<String, String> map = new HashMap<String, String>(6);

    private ErMessageServiceHelper() {
    }

    public static void sendMessageByBillDO(String scene, String entityNumber, DynamicObject[] billArray, String userPropertyName) {
        if (billArray == null || billArray.length < 1) {
            return;
        }
        Set<String> channelNos = ErMessageServiceHelper.getChannelNos(scene, entityNumber);
        if (channelNos == null || channelNos.size() < 1) {
            return;
        }
        for (DynamicObject billObj : billArray) {
            Object user = billObj.get(userPropertyName);
            Long userId = ErCommonUtils.getPk(user);
            if (userId == null) continue;
            Long billId = (Long)billObj.getPkValue();
            ArrayList<Long> userIds = new ArrayList<Long>();
            userIds.add(userId);
            logger.info(String.format("\u8d39\u63a7\u53d1\u9001\u6d88\u606f,\u6d88\u606f\u573a\u666f\u4e3a:%s,\u5355\u636e\u5b9e\u4f53\u6807\u8bc6\u4e3a:%s,\u5355\u636eID\u4e3a:%s,\u6d88\u606f\u63a5\u6536\u7528\u6237\u4e3a:%s", scene, entityNumber, billId, userIds));
            ErMessageServiceHelper.sendMsg(channelNos, scene, entityNumber, billId, userIds);
        }
    }

    public static void sendMessageByBillId(String scene, String entityNumber, Set<Long> billIds, List<Long> userIds) {
        logger.info(String.format("\u8d39\u63a7\u53d1\u9001\u6d88\u606f,\u6d88\u606f\u573a\u666f\u4e3a:%s,\u5355\u636e\u5b9e\u4f53\u6807\u8bc6\u4e3a:%s,\u5355\u636eIDs\u4e3a:%s,\u6d88\u606f\u63a5\u6536\u7528\u6237\u4e3a:%s", scene, entityNumber, billIds, userIds));
        if (billIds == null || billIds.size() < 1) {
            return;
        }
        Set<String> channelNos = ErMessageServiceHelper.getChannelNos(scene, entityNumber);
        if (channelNos == null || channelNos.size() < 1) {
            return;
        }
        for (Long billId : billIds) {
            ErMessageServiceHelper.sendMsg(channelNos, scene, entityNumber, billId, userIds);
        }
    }

    private static void sendMsg(Set<String> channelNos, String scene, String entityNumber, Long billId, List<Long> userIds) {
        if (userIds == null || userIds.size() < 1) {
            return;
        }
        if (channelNos == null || channelNos.size() < 1) {
            channelNos = ErMessageServiceHelper.getChannelNos(scene, entityNumber);
        }
        if (channelNos == null || channelNos.size() < 1) {
            return;
        }
        for (String channelNo : channelNos) {
            MessageInfo msg = new MessageInfo();
            msg.setBizDataId(billId);
            msg.setEntityNumber(entityNumber);
            msg.setTplScene(scene);
            msg.setTitle(ResManager.loadKDString((String)"\u8d39\u7528\u5355\u636e\u72b6\u6001\u63d0\u9192", (String)"ErMessageServiceHelper_0", (String)"fi-er-business", (Object[])new Object[0]));
            msg.setUserIds(userIds);
            msg.setType("message");
            msg.setPubaccNumber("flowassist");
            msg.setSource(ResManager.loadKDString((String)"\u4eba\u4eba\u8d39\u7528", (String)"ErMessageServiceHelper_1", (String)"fi-er-business", (Object[])new Object[0]));
            msg.setNotifyType(channelNo);
            logger.info("Send meassage info:" + msg);
            try {
                MessageCenterServiceHelper.sendMessage((MessageInfo)msg);
            }
            catch (KDException e) {
                logger.info("\u53d1\u9001\u6d88\u606f\u4e3a\uff1a" + msg + ",excepMessage:" + e.getMessage());
            }
        }
    }

    private static Set<String> getChannelNos(String scene, String entityNumber) {
        Map channelMap = BusinessDataServiceHelper.loadFromCache((String)"msg_channel", (String)"number", (QFilter[])new QFilter[]{new QFilter("enable", "=", (Object)true)});
        HashSet<String> channelNos = new HashSet<String>();
        channelMap.forEach((k, v) -> {
            String chNumber = v.getString("number");
            List templateList = MessageCenterServiceHelper.getMessageTemplateByFilters((String)"message", (String)chNumber, (String)scene, (String)entityNumber);
            if (!templateList.isEmpty()) {
                channelNos.add(chNumber);
            }
        });
        return channelNos;
    }

    @Deprecated
    public static void sendMessage(DynamicObject[] billArray, String entityNumber, String userPropertyName, String scene) {
        DynamicObject[] channels = (DynamicObject[])QueryServiceHelper.query((String)"msg_channel", (String)"number", (QFilter[])new QFilter[]{new QFilter("enable", "=", (Object)true)}).toArray((Object[])new DynamicObject[0]);
        Map<String, List<String>> msgTplGroupByChannel = ErMessageServiceHelper.getMessageTemplateGroupByChannel(entityNumber, scene, channels);
        if (msgTplGroupByChannel.size() > 0) {
            logger.info("Meassage tpl info:" + msgTplGroupByChannel);
            for (Map.Entry<String, List<String>> entry : msgTplGroupByChannel.entrySet()) {
                for (DynamicObject billObj : billArray) {
                    MessageInfo msg = new MessageInfo();
                    ArrayList<Long> userIds = new ArrayList<Long>();
                    Object user = billObj.get(userPropertyName);
                    IDataEntityProperty creatorDPT = (IDataEntityProperty)billObj.getDataEntityType().getProperties().get((Object)"creator");
                    if (creatorDPT != null) {
                        Object creator = billObj.get("creator");
                        if (creator instanceof Long) {
                            userIds.add((Long)creator);
                        } else if (creator instanceof DynamicObject) {
                            userIds.add((Long)((DynamicObject)creator).getPkValue());
                        } else {
                            logger.info("ErMessageServiceHelper>>>creator\u7c7b\u578b\u5339\u914d\u5931\u8d25" + creator);
                            continue;
                        }
                    }
                    if (user instanceof Long) {
                        userIds.add((Long)user);
                    } else if (user instanceof DynamicObject) {
                        userIds.add((Long)((DynamicObject)user).getPkValue());
                    } else {
                        logger.info("ErMessageServiceHelper>>>user\u7c7b\u578b\u5339\u914d\u5931\u8d25" + user);
                        continue;
                    }
                    msg.setBizDataId((Long)billObj.getPkValue());
                    msg.setEntityNumber(entityNumber);
                    msg.setTplScene(scene);
                    msg.setTitle(ResManager.loadKDString((String)"\u8d39\u7528\u5355\u636e\u72b6\u6001\u63d0\u9192", (String)"ErMessageServiceHelper_0", (String)"fi-er-business", (Object[])new Object[0]));
                    msg.setUserIds(userIds);
                    msg.setType("message");
                    msg.setPubaccNumber("flowassist");
                    msg.setSource(ResManager.loadKDString((String)"\u4eba\u4eba\u8d39\u7528", (String)"ErMessageServiceHelper_1", (String)"fi-er-business", (Object[])new Object[0]));
                    msg.setNotifyType(String.valueOf(entry.getKey()));
                    logger.info("Send meassage info:" + msg);
                    try {
                        MessageCenterServiceHelper.sendMessage((MessageInfo)msg);
                    }
                    catch (Exception e) {
                        logger.info("\u53d1\u9001\u6d88\u606f\u4e3a\uff1a" + msg + ",excepMessage:" + e.getMessage());
                    }
                }
            }
        }
    }

    @Deprecated
    private static Map<String, List<String>> getMessageTemplateGroupByChannel(String entityNumber, String scene, DynamicObject[] channels) {
        HashMap<String, List<String>> messageTemplGroupByChannel = new HashMap<String, List<String>>();
        for (DynamicObject channel : channels) {
            String chNumber = channel.getString("number");
            List templateList = MessageCenterServiceHelper.getMessageTemplateByFilters((String)"message", (String)chNumber, (String)scene, (String)entityNumber);
            if (templateList.isEmpty()) continue;
            messageTemplGroupByChannel.put(chNumber, templateList);
        }
        return messageTemplGroupByChannel;
    }

    public static List<MessageInfo> sendTripOrderConfrimMessage(DynamicObject[] billArray, String entityNumber, boolean check, boolean save) {
        Map<String, List<DynamicObject>> orderMap = Arrays.stream(billArray).collect(Collectors.groupingBy(e -> ErMessageServiceHelper.getSysParamKey(e) + ErCommonUtils.getPk(e.get("company"))));
        ArrayList<MessageInfo> messageInfoList = new ArrayList<MessageInfo>(billArray.length);
        HashMap<Long, DynamicObject> saveOrderMap = new HashMap<Long, DynamicObject>(billArray.length);
        logger.info("\u53d1\u9001\u8ba2\u5355\u786e\u8ba4\u6d88\u606forderMap {}", (Object)orderMap.size());
        for (Map.Entry<String, List<DynamicObject>> entry : orderMap.entrySet()) {
            Long companyId = ErCommonUtils.getPk(entry.getValue().get(0).get("company"));
            Boolean isautoSend = !ErMessageServiceHelper.autoSend(companyId, entry.getValue().get(0));
            if (check && isautoSend.booleanValue()) {
                logger.info("\u4e0d\u53d1\u9001\u6d88\u606f\u8fc7\u6ee4\uff1a{},{}", (Object)check, (Object)isautoSend);
                continue;
            }
            for (DynamicObject d : entry.getValue()) {
                if (save) {
                    DynamicObject saved = new DynamicObject(d.getDynamicObjectType());
                    saved.set("id", (Object)d.getLong("id"));
                    saved.set("noticetimes", (Object)d.getLong("noticetimes"));
                    saveOrderMap.put(Long.valueOf(d.getPkValue().toString()), saved);
                }
                MessageInfo message = new MessageInfo();
                LocaleString title = new LocaleString();
                String titleName = ResManager.loadKDString((String)"\u8ba2\u5355\u9700\u8981\u8fdb\u884c\u786e\u8ba4\uff0c\u8bf7\u5c3d\u5feb\u5904\u7406\u3002", (String)"ErMessageServiceHelper_3", (String)"fi-er-business", (Object[])new Object[0]);
                title.setLocaleValue_en(titleName);
                title.setLocaleValue_zh_CN(titleName);
                title.setLocaleValue_zh_TW("");
                message.setMessageTitle((ILocaleString)title);
                LocaleString content = new LocaleString();
                String contentName = ResManager.loadKDString((String)"\u8ba2\u5355\u9700\u8981\u8fdb\u884c\u786e\u8ba4\uff0c\u8bf7\u5c3d\u5feb\u5904\u7406\u3002", (String)"ErMessageServiceHelper_3", (String)"fi-er-business", (Object[])new Object[0]);
                content.setLocaleValue_en(contentName);
                content.setLocaleValue_zh_CN(contentName);
                content.setLocaleValue_zh_TW("");
                message.setMessageContent((ILocaleString)content);
                LocaleString tag = new LocaleString();
                tag.setLocaleValue(ResManager.loadKDString((String)"\u8ba2\u5355\u786e\u8ba4\u901a\u77e5", (String)"ErMessageServiceHelper_2", (String)"fi-er-business", (Object[])new Object[0]));
                message.setMessageTag((ILocaleString)tag);
                ArrayList<Long> userIds = new ArrayList<Long>(1);
                userIds.add(ErCommonUtils.getPk(d.get("sourcebookedid")));
                message.setUserIds(userIds);
                message.setSendTime(new Date(System.currentTimeMillis()));
                HashMap<String, String> param = new HashMap<String, String>(1);
                param.put("app", "tra");
                Map urlMap = MessageCenterServiceHelper.builMessageUrl((String)entityNumber, (String)(entityNumber + "_mob"), (Long)Long.valueOf(d.getPkValue().toString()), param);
                logger.info("\u6784\u5efa\u6d88\u606f\u5e73\u53f0url :{}", (Object)JSON.toJSONString((Object)urlMap));
                String url = "";
                if (null == urlMap || null == urlMap.get("code") || null == urlMap.get("data")) {
                    String accountId = RequestContext.get().getAccountId();
                    url = String.format("%s/mobile.html?accountId=%s#/form/%s_mob?pkId=%s&app=tra", UrlService.getDomainContextUrl(), accountId, entityNumber, d.getPkValue());
                } else {
                    url = urlMap.get("data").toString();
                }
                message.setContentUrl(url);
                message.setMobContentUrl(url);
                message.setBizDataId(Long.valueOf(d.getPkValue().toString()));
                message.setEntityNumber(entityNumber);
                message.setOperation("view");
                messageInfoList.add(message);
            }
        }
        Set<String> channelNos = ErMessageServiceHelper.getChannelNos(map.get(entityNumber), entityNumber);
        if (null == channelNos || null == messageInfoList) {
            logger.info("\u8ba2\u5355\u901a\u77e5\u6d88\u606f,\u6d88\u606f\u6e20\u9053\u4e3a\u7a7a\uff1a{} \u6216\u6d88\u606f\u4e3a\u7a7a\uff1a{}", (Object)(null == channelNos ? 1 : 0), (Object)(null == messageInfoList ? 1 : 0));
            return messageInfoList;
        }
        channelNos.stream().forEach(e -> messageInfoList.forEach(m -> {
            m.setNotifyType(e);
            m.setTplScene(map.get(entityNumber));
            try {
                MessageCenterServiceHelper.sendMessage((MessageInfo)m);
                logger.info("\u8ba2\u5355\u901a\u77e5\u6d88\u606f\uff1a{}", (Object)JSON.toJSONString((Object)m));
                DynamicObject order = (DynamicObject)saveOrderMap.get(m.getBizDataId());
                if (null != order) {
                    order.set("noticetimes", (Object)(order.getInt("noticetimes") + 1));
                }
            }
            catch (Exception ex) {
                logger.info("\u53d1\u9001\u6d88\u606f\u4e3a\uff1a" + JSON.toJSONString((Object)m) + ",excepMessage:" + ex.getMessage());
                return;
            }
        }));
        if (saveOrderMap.size() > 0) {
            SaveServiceHelper.update((DynamicObject[])saveOrderMap.values().toArray(new DynamicObject[0]));
        }
        return messageInfoList;
    }

    public static List<MessageInfo> sendMsgOfcheckingExpList(DynamicObject[] billArray, String entityNumber) {
        ArrayList<MessageInfo> messageInfoList = new ArrayList<MessageInfo>(billArray.length);
        for (DynamicObject dynamicObject : billArray) {
            logger.info("\u90e8\u95e8\u8d39\u7528\u6d88\u606f\u63a8\u9001:{}", (Object)dynamicObject.getString("billno"));
            if (!dynamicObject.getBoolean("needsend")) {
                logger.info("\u90e8\u95e8\u8d39\u7528\u6d88\u606f\u63a8\u9001\uff0c\u8be5\u5355\u636e\u5173\u95ed\u4e86\u662f\u5426\u9700\u8981\u63a8\u9001\u6309\u94ae\uff0c{}", (Object)dynamicObject.getString("billno"));
                continue;
            }
            DynamicObjectCollection users = dynamicObject.getDynamicObjectCollection("user");
            String costdeptName = dynamicObject.getDynamicObject("costdept").getString("name");
            Date period = dynamicObject.getDate("period");
            String formid = dynamicObject.getString("formid");
            String formname = ResManager.loadKDString((String)"\u673a\u7968", (String)"ErMessageServiceHelper_10", (String)"fi-er-business", (Object[])new Object[0]);
            switch (formid) {
                case "er_vehiclecheckingbill": {
                    formname = ResManager.loadKDString((String)"\u7528\u8f66", (String)"ErMessageServiceHelper_11", (String)"fi-er-business", (Object[])new Object[0]);
                    break;
                }
                case "er_hotelcheckingbill": {
                    formname = ResManager.loadKDString((String)"\u9152\u5e97", (String)"ErMessageServiceHelper_12", (String)"fi-er-business", (Object[])new Object[0]);
                    break;
                }
                case "er_traincheckingbill": {
                    formname = ResManager.loadKDString((String)"\u706b\u8f66", (String)"ErMessageServiceHelper_13", (String)"fi-er-business", (Object[])new Object[0]);
                    break;
                }
                case "er_planecheckingbill": {
                    formname = ResManager.loadKDString((String)"\u673a\u7968", (String)"ErMessageServiceHelper_10", (String)"fi-er-business", (Object[])new Object[0]);
                }
            }
            Long id = dynamicObject.getLong("id");
            ArrayList<Long> userIds = new ArrayList<Long>(users.size());
            for (DynamicObject user : users) {
                userIds.add(Long.parseLong(user.getDynamicObject("fbasedataid").getPkValue().toString()));
            }
            MessageInfo message = new MessageInfo();
            LocaleString title = new LocaleString();
            String titleName = String.format("%1$s%2$s%3$s%4$s", TripCommonUtil.date2TimeStamp(period, "yyyy-MM"), costdeptName, formname, ResManager.loadKDString((String)"\u8d39\u7528\u6e05\u5355", (String)"ErMessageServiceHelper_15", (String)"fi-er-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u8bf7\u5c3d\u5feb\u67e5\u9605\u3002", (String)"ErMessageServiceHelper_16", (String)"fi-er-business", (Object[])new Object[0]));
            title.setLocaleValue_en(titleName);
            title.setLocaleValue_zh_CN(titleName);
            title.setLocaleValue_zh_TW("");
            message.setMessageTitle((ILocaleString)title);
            LocaleString content = new LocaleString();
            content.setLocaleValue_en(ResManager.loadKDString((String)"\u8bf7\u5c3d\u5feb\u67e5\u9605\u3002", (String)"ErMessageServiceHelper_16", (String)"fi-er-business", (Object[])new Object[0]));
            content.setLocaleValue_zh_CN(ResManager.loadKDString((String)"\u8bf7\u5c3d\u5feb\u67e5\u9605\u3002", (String)"ErMessageServiceHelper_16", (String)"fi-er-business", (Object[])new Object[0]));
            content.setLocaleValue_zh_TW("");
            message.setMessageContent((ILocaleString)content);
            LocaleString tag = new LocaleString();
            tag.setLocaleValue(titleName);
            message.setMessageTag((ILocaleString)tag);
            message.setUserIds(userIds);
            message.setSendTime(new Date(System.currentTimeMillis()));
            HashMap<String, String> param = new HashMap<String, String>(1);
            param.put("app", "tra");
            Map urlMap = MessageCenterServiceHelper.builMessageUrl((String)entityNumber, (String)(entityNumber + "_mob"), (Long)id, param);
            logger.info("\u6784\u5efa\u6d88\u606f\u5e73\u53f0url :{}", (Object)JSON.toJSONString((Object)urlMap));
            String url = "";
            if (null == urlMap || null == urlMap.get("code") || null == urlMap.get("data")) {
                String accountId = RequestContext.get().getAccountId();
                url = String.format("%s/mobile.html?accountId=%s#/form/%s_mob?pkId=%s&app=tra", UrlService.getDomainContextUrl(), accountId, entityNumber, id);
            } else {
                url = urlMap.get("data").toString();
            }
            message.setContentUrl(url);
            message.setMobContentUrl(url);
            message.setBizDataId(id);
            message.setType("message");
            message.setEntityNumber(entityNumber);
            message.setOperation("view");
            messageInfoList.add(message);
        }
        logger.info("\u90e8\u95e8\u8d39\u7528\u6d88\u606f\u63a8\u9001 messageInfoList:{}", (Object)JSON.toJSONString(messageInfoList));
        Set<String> channelNos = ErMessageServiceHelper.getChannelNos(ER_CHECKING_EXP_LIST_MSG, entityNumber);
        channelNos.stream().forEach(e -> messageInfoList.forEach(m -> {
            m.setNotifyType(e);
            m.setTplScene(ER_CHECKING_EXP_LIST_MSG);
            try {
                MessageCenterServiceHelper.sendMessage((MessageInfo)m);
                logger.info(String.format("\u5f53\u524d\u767b\u5f55\u4eba%1$s,\u90e8\u95e8\u8d39\u7528\u6e05\u5355\u6d88\u606f\uff1a%2$s", RequestContext.get().getUserId(), JSON.toJSONString((Object)m)));
                for (DynamicObject dynamicObject : billArray) {
                    if (!m.getBizDataId().equals(dynamicObject.getLong("id"))) continue;
                    dynamicObject.set("msgcount", (Object)(dynamicObject.getInt("msgcount") + 1));
                    SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
                }
            }
            catch (Exception ex) {
                logger.info("\u53d1\u9001\u6d88\u606f\u4e3a\uff1a" + JSON.toJSONString((Object)m) + ",excepMessage:" + ex.getMessage());
            }
        }));
        return messageInfoList;
    }

    public static boolean autoSend(Long companyId, DynamicObject dynamicObject) {
        String paramKey = "";
        paramKey = ErMessageServiceHelper.getSysParamKey(dynamicObject);
        if (StringUtils.isBlank((String)paramKey) || companyId == null) {
            return false;
        }
        Object value = ErCommonUtils.getEMParameter(companyId, paramKey);
        return "1".equals(value);
    }

    public static String getSysParamKey(DynamicObject dynamicObject) {
        String type = dynamicObject.getDataEntityType().getName();
        String paramKey = "";
        if (Arrays.asList("er_hotelbill", "er_planebill", "er_trainbill").contains(type)) {
            paramKey = "phtautosend";
        } else if ("er_vehiclebill".equals(type) && CarTypeEnum.TRAVEL.getCode().equals(dynamicObject.getString("vehicletype"))) {
            paramKey = "tripvehicleautosend";
        } else if ("er_vehiclebill".equals(type)) {
            paramKey = "dailyvehicleautosend";
        } else if ("er_mealbill".equals(type)) {
            paramKey = "mealeautosend";
        }
        return paramKey;
    }

    public static List<MessageInfo> sendMsgById(List<Long> userIds, String entityNumber) {
        ArrayList<MessageInfo> messageInfoList = new ArrayList<MessageInfo>(1);
        MessageInfo message = new MessageInfo();
        LocaleString title = new LocaleString();
        String titleName = ResManager.loadKDString((String)"\u5546\u65c5\u96c6\u6210\u65e5\u5fd7\u5f02\u5e38\u4fe1\u606f", (String)"ErMessageServiceHelper_17", (String)"fi-er-business", (Object[])new Object[0]);
        title.setLocaleValue_en(titleName);
        title.setLocaleValue_zh_CN(titleName);
        title.setLocaleValue_zh_TW(titleName);
        message.setMessageTitle((ILocaleString)title);
        String contents = ResManager.loadKDString((String)"\u5546\u65c5\u96c6\u6210\u65e5\u5fd7\u5b58\u5728\u5931\u8d25\u8bb0\u5f55\uff0c\u8bf7\u767b\u5f55\u7cfb\u7edf\u8fdb\u884c\u67e5\u9605\u3002", (String)"ErMessageServiceHelper_18", (String)"fi-er-business", (Object[])new Object[0]);
        LocaleString content = new LocaleString();
        content.setLocaleValue_en(contents);
        content.setLocaleValue_zh_CN(contents);
        content.setLocaleValue_zh_TW(contents);
        message.setMessageContent((ILocaleString)content);
        LocaleString tag = new LocaleString();
        tag.setLocaleValue(titleName);
        message.setContentUrl("");
        message.setMobContentUrl("");
        message.setMessageTag((ILocaleString)tag);
        message.setUserIds(userIds);
        message.setSendTime(new Date(System.currentTimeMillis()));
        message.setBizDataId(Long.valueOf(System.currentTimeMillis()));
        message.setType("message");
        message.setEntityNumber(entityNumber);
        message.setOperation("view");
        messageInfoList.add(message);
        Set<String> channelNos = ErMessageServiceHelper.getChannelNos(ER_TRIPSYNC_LOG_YZJ, entityNumber);
        channelNos.stream().forEach(e -> messageInfoList.forEach(m -> {
            m.setNotifyType(e);
            m.setTplScene(ER_TRIPSYNC_LOG_YZJ);
            try {
                MessageCenterServiceHelper.sendMessage((MessageInfo)m);
            }
            catch (Exception ex) {
                logger.info("\u53d1\u9001\u6d88\u606f\u4e3a\uff1a" + JSON.toJSONString((Object)m) + ",excepMessage:" + ex.getMessage());
            }
        }));
        return messageInfoList;
    }

    static {
        map.put("er_vehiclebill", "trip_order_notice_confrim_vehicle");
        map.put("er_hotelbill", "trip_order_notice_confrim_hotel");
        map.put("er_planebill", "trip_order_notice_confrim_plane");
        map.put("er_trainbill", "trip_order_notice_confrim_train");
        map.put("er_mealbill", "trip_order_notice_confrim_meal");
    }
}

