/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.pool;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.property.SubEntryProp;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.fi.er.business.invoicecloud.ItemFrom;
import kd.fi.er.business.servicehelper.CommonServiceHelper;
import kd.fi.er.business.servicehelper.CoreBaseBillServiceHelper;
import kd.fi.er.business.servicehelper.ExpenseItemServiceHelper;
import kd.fi.er.business.utils.AmountChangeUtil;
import kd.fi.er.business.utils.AmountUtils;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.business.utils.ErStdConfig;
import kd.fi.er.business.utils.InvoiceOffsetUtils;
import kd.fi.er.business.utils.SystemParamterUtil;
import kd.fi.er.business.utils.model.ChangeField;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

public class ExpensePoolUtil {
    private static final String TRIP_REIMBURSE_BILL_GRID_MB = "er_tripreim_grid_mb";
    private static final String EXPENSE_POOL_SELECT_LIST_MB = "er_expense_list_card_mb";

    public static void afterPushRefreshBillInfo(IFormView view) {
        if (!ExpensePoolUtil.isExpensePoolPush(view)) {
            return;
        }
        IDataModel model = view.getModel();
        ExpensePoolUtil.expensePoolPushHandleDetailEntryAmount(view);
        ExpensePoolUtil.expensePoolPushHandleTripEntryAmount(model);
        ExpensePoolUtil.expensePoolPushInitAccEntry(view);
    }

    public static void afterDrawRefreshBillInfo(IFormView view) {
        IDataModel model = view.getModel();
        ExpensePoolUtil.expensePoolPushHandleDetailEntryAmount(view);
        ExpensePoolUtil.expensePoolPushHandleTripEntryAmount(model);
        ExpensePoolUtil.expensePoolPushInitAccEntry(view);
    }

    private static void expensePoolPushHandleTripEntryAmount(IDataModel model) {
        Object amount;
        Object oriAmount = amount = model.getValue("amount");
        Object tripCurrency = model.getValue("currency");
        BigDecimal tripExchangeRate = BigDecimal.ONE;
        DynamicObjectCollection detailEntry = ((DynamicObject)model.getDataEntity(true).getDynamicObjectCollection("tripentry").get(0)).getDynamicObjectCollection("entryentity");
        Set entryCurrencySet = detailEntry.stream().map(row -> ErCommonUtils.getPk(row.get("entrycurrency"))).collect(Collectors.toSet());
        if (entryCurrencySet.size() == 1) {
            tripCurrency = ((DynamicObject)detailEntry.get(0)).getDynamicObject("entrycurrency");
            tripExchangeRate = ((DynamicObject)detailEntry.get(0)).getBigDecimal("exchangerate");
            oriAmount = detailEntry.stream().map(row -> row.getBigDecimal("orientryamount")).reduce((a, b) -> a.add((BigDecimal)b)).get();
        }
        if ((entryCurrencySet.size() > 1 || entryCurrencySet.add(ErCommonUtils.getPk(model.getValue("currency")))) && !((Boolean)model.getValue("iscurrency")).booleanValue()) {
            model.setValue("iscurrency", (Object)Boolean.TRUE);
        }
        model.setValue("tripcurrency", tripCurrency);
        model.setValue("tripexchangerate", (Object)tripExchangeRate);
        model.setValue("triporiamount", oriAmount, 0);
        model.setValue("tripamount", amount, 0);
        model.setValue("tripapporiamount", oriAmount, 0);
        model.setValue("tripappamount", amount, 0);
    }

    private static void expensePoolPushHandleDetailEntryAmount(IFormView view) {
        IDataModel model = view.getModel();
        DynamicObjectCollection detailEntry = ((DynamicObject)model.getDataEntity(true).getDynamicObjectCollection("tripentry").get(0)).getDynamicObjectCollection("entryentity");
        BigDecimal amount = BigDecimal.ZERO;
        for (int i = 0; i < detailEntry.size(); ++i) {
            amount = amount.add(ExpensePoolUtil.afterPushHandleDetailEntryAmountByRow(view, i, 0));
        }
        model.setValue("amount", (Object)amount);
    }

    public static BigDecimal afterPushHandleDetailEntryAmountByRow(IFormView view, int rowIndex, int parentIndex) {
        IDataModel model = view.getModel();
        Long currnecy = ErCommonUtils.getPk(model.getValue("currency"));
        Long company = ErCommonUtils.getPk(model.getValue("company"));
        Long costCompany = ErCommonUtils.getPk(model.getValue("costcompany"));
        Long detailCurrency = ErCommonUtils.getPk(model.getValue("entrycurrency", rowIndex, parentIndex));
        Map<String, Object> exchangeRateAndQuoteType = CommonServiceHelper.getExchangeRateFromSysParams(company, costCompany, detailCurrency, currnecy, model);
        model.setValue("detailquotetype", exchangeRateAndQuoteType.get("quoteType"), rowIndex, parentIndex);
        model.setValue("exchangerate", exchangeRateAndQuoteType.get("exchangeRate"), rowIndex, parentIndex);
        AmountUtils.refreshCurrAmount(model, (BigDecimal)model.getValue("orientryamount", rowIndex, parentIndex), "entryamount", "exchangerate", "detailquotetype", rowIndex, parentIndex);
        model.setValue("entryappamount", model.getValue("entryamount", rowIndex, parentIndex), rowIndex, parentIndex);
        model.setValue("orientryappamount", model.getValue("orientryamount", rowIndex, parentIndex), rowIndex, parentIndex);
        ExpensePoolUtil.expensePoolPushRefreshTaxAmount(view, rowIndex, parentIndex, false);
        return (BigDecimal)model.getValue("entryamount", rowIndex, parentIndex);
    }

    private static void expensePoolPushRefreshTaxAmount(IFormView view, int index, int parentIndex, boolean needRecalculate) {
        IDataModel model = view.getModel();
        BigDecimal expenseAmountOri = (BigDecimal)model.getValue("orientryamount", index, 0);
        BigDecimal taxAmount = (BigDecimal)model.getValue("taxamount", index, parentIndex);
        model.setValue("taxamount", (Object)BigDecimal.ZERO, index, parentIndex);
        model.setValue("taxamount", (Object)taxAmount, index, parentIndex);
        model.setValue("approvetax", (Object)taxAmount, index, parentIndex);
        BigDecimal noTaxAmount = expenseAmountOri.subtract(taxAmount);
        model.setValue("notaxamount", (Object)noTaxAmount, index, parentIndex);
        DynamicObject expenseItem = (DynamicObject)model.getValue("expenseitem", index, parentIndex);
        boolean deductibleOfTaxPayer = InvoiceOffsetUtils.deductibleOfTaxPayer(ErCommonUtils.getPk(model.getValue("company")), ErCommonUtils.getPk(model.getValue("costcompany")));
        String itemFrom = (String)model.getValue("itemfrom", index, parentIndex);
        if (expenseItem != null) {
            boolean tripItemOffset = expenseItem.getBoolean("isoffset");
            if (StringUtils.equals((CharSequence)itemFrom, (CharSequence)ItemFrom.Manual.getValue())) {
                Boolean isOrgOffset = InvoiceOffsetUtils.deductibleOfTaxPayer(model);
                Boolean offset = SystemParamterUtil.manuallyaddexpenseoffset(ErCommonUtils.getPk(model.getValue("company")));
                model.setValue("offset", (Object)(isOrgOffset & offset ? tripItemOffset : false), index, parentIndex);
                model.setValue("deductibletax", (Object)(tripItemOffset & offset ? taxAmount : BigDecimal.ZERO), index, parentIndex);
                AmountChangeUtil.updateInOutAmount(model, index, parentIndex, ChangeField.All);
            } else if (StringUtils.equals((CharSequence)itemFrom, (CharSequence)ItemFrom.InvoiceCloud.getValue()) && deductibleOfTaxPayer) {
                Long rowID = (Long)((DynamicObject)((DynamicObject)model.getDataEntity(true).getDynamicObjectCollection("tripentry").get(parentIndex)).getDynamicObjectCollection("entryentity").get(index)).getPkValue();
                boolean invoiceOffset = InvoiceOffsetUtils.getExpenseRowMapInvoicesOffset(model.getDataEntity(), rowID, view);
                boolean isOffset = tripItemOffset && invoiceOffset;
                model.setValue("offset", (Object)isOffset, index, parentIndex);
                model.setValue("deductibletax", (Object)(tripItemOffset & isOffset ? taxAmount : BigDecimal.ZERO), index, parentIndex);
                InvoiceOffsetUtils.refreshInvoiceOffsetAndOutAmount(view, index, parentIndex);
            }
        }
        BigDecimal price = StringUtils.equals((CharSequence)ErStdConfig.getApproveTaxFormulaType(), (CharSequence)"1") ? expenseAmountOri.subtract((BigDecimal)model.getValue("deductibletax", index, parentIndex)) : noTaxAmount;
        model.beginInit();
        model.setValue("price", (Object)price, index, parentIndex);
        model.setValue("curprice", (Object)ExpensePoolUtil.getCurPrice(model, index, parentIndex), index, parentIndex);
        model.endInit();
        view.updateView("price", index, parentIndex);
        view.updateView("curprice", index, parentIndex);
    }

    public static void expensePoolPushInitAccEntry(IFormView view) {
        IDataModel model = view.getModel();
        DynamicObjectCollection accEntry = model.getDataEntity(true).getDynamicObjectCollection("accountentry");
        if (accEntry.size() < 2) {
            if (accEntry.isEmpty()) {
                CoreBaseBillServiceHelper.initDefaultAccountEntry(model);
            }
            Long companyId = ErCommonUtils.getPk(model.getValue("company"));
            String loanType = (String)ErCommonUtils.getLoanCheckType(companyId);
            model.setValue("loanchecktype", (Object)loanType);
            AmountChangeUtil.refreshPayAmount(view, model, loanType);
            AmountChangeUtil.refreshReceiveAmount(view, model, (BigDecimal)model.getValue("encashamount"), loanType);
        }
    }

    private static boolean isExpensePoolPush(IFormView view) {
        String formId = view.getFormShowParameter().getFormId();
        String sourceFormId = ExpensePoolUtil.getParentViewFormId(view);
        DynamicObject dataEntity = view.getModel().getDataEntity(true);
        return dataEntity.getDataEntityState().isPushChanged() && StringUtils.equals((CharSequence)TRIP_REIMBURSE_BILL_GRID_MB, (CharSequence)formId) && StringUtils.equals((CharSequence)EXPENSE_POOL_SELECT_LIST_MB, (CharSequence)sourceFormId);
    }

    public static String getParentViewFormId(IFormView view) {
        FormShowParameter formShowParameter;
        String sourceFormId = "";
        if (view.getParentView() == null || (formShowParameter = view.getParentView().getFormShowParameter()) == null) {
            return sourceFormId;
        }
        sourceFormId = formShowParameter instanceof ListShowParameter ? ((ListShowParameter)formShowParameter).getBillFormId() : formShowParameter.getFormId();
        return sourceFormId;
    }

    public static DynamicObjectCollection generateMultiPropValues(DynamicObject entity, DynamicObject subEntity, String propName, List<Long> pkValueList) {
        DynamicObjectCollection generateCollection = ExpensePoolUtil.generateMultiPropValue(entity, subEntity, propName, pkValueList.get(0));
        DynamicObjectType dynamicType = generateCollection.getDynamicObjectType();
        IntStream.range(1, pkValueList.size()).forEach(idx -> {
            DynamicObject newObj = new DynamicObject(dynamicType);
            newObj.set("fbasedataid", pkValueList.get(idx));
            newObj.set("fbasedataid_id", pkValueList.get(idx));
            generateCollection.add((Object)newObj);
        });
        return generateCollection;
    }

    private static DynamicObjectCollection generateMultiPropValue(DynamicObject entity, DynamicObject subEntity, String propName, long pkValue) {
        IDataEntityProperty currentProperty;
        String formID = entity.getDataEntityType().getParent().getName();
        String entityName = entity.getDataEntityType().getName();
        if (subEntity != null) {
            IDataEntityProperty subEntry = (IDataEntityProperty)((EntryProp)EntityMetadataCache.getDataEntityType((String)formID).getProperties().get((Object)entityName)).getDynamicCollectionItemPropertyType().getProperties().get((Object)"entryentity");
            currentProperty = (IDataEntityProperty)((SubEntryProp)subEntry).getDynamicCollectionItemPropertyType().getProperties().get((Object)propName);
        } else {
            currentProperty = (IDataEntityProperty)((EntryProp)EntityMetadataCache.getDataEntityType((String)formID).getProperties().get((Object)entityName)).getDynamicCollectionItemPropertyType().getProperties().get((Object)propName);
        }
        DynamicObjectType currentProType = ((MulBasedataProp)currentProperty).getDynamicCollectionItemPropertyType();
        HashMap<Long, DynamicObject> finalUserIDSet = new HashMap<Long, DynamicObject>();
        DynamicObject newObj = new DynamicObject(currentProType);
        newObj.set("fbasedataid", (Object)pkValue);
        newObj.set("fbasedataid_id", (Object)pkValue);
        finalUserIDSet.put(pkValue, newObj);
        DynamicObjectCollection collection = new DynamicObjectCollection(currentProType, (Object)entity);
        for (Map.Entry entry : finalUserIDSet.entrySet()) {
            collection.add(entry.getValue());
        }
        return collection;
    }

    public static Set<Long> validateTripExpenseitem(Long companyId, Set<Long> tripExpenseItem) {
        QFilter bdFilter = BaseDataServiceHelper.getBaseDataFilter((String)"er_tripexpenseitem", (Long)companyId);
        QFilter qFilter = new QFilter("id", "in", tripExpenseItem);
        qFilter.and(new QFilter("enable", "=", (Object)Boolean.TRUE));
        DynamicObject[] expenseItems = (DynamicObject[])QueryServiceHelper.query((String)"er_tripexpenseitem", (String)"id", (QFilter[])new QFilter[]{qFilter, bdFilter}).toArray((Object[])new DynamicObject[0]);
        return Arrays.stream(expenseItems).map(item -> item.getLong("id")).collect(Collectors.toSet());
    }

    public static void convertPreHandleDate(List<DynamicObject> srcBills, Map<String, DynamicProperty> fldProperties) {
        srcBills.stream().filter(record -> ((DynamicProperty)fldProperties.get("expenseitem")).getValue(record) != null).forEach(record -> {
            DynamicObject item = BusinessDataServiceHelper.loadSingleFromCache((String)"er_tripexpenseitem", (String)"id,attribute", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)((Long)((DynamicProperty)fldProperties.get("expenseitem")).getValue(record)))});
            if (item != null && StringUtils.equalsAny((CharSequence)item.getString("attribute"), (CharSequence[])new CharSequence[]{"2", "3", "4", "7"})) {
                ((DynamicProperty)fldProperties.get("tripcheckindate")).setValue(record, ((DynamicProperty)fldProperties.get("startdate")).getValue(record));
                ((DynamicProperty)fldProperties.get("tripdeparturedate")).setValue(record, ((DynamicProperty)fldProperties.get("startdate")).getValue(record));
            } else if (item == null || StringUtils.equalsAny((CharSequence)item.getString("attribute"), (CharSequence[])new CharSequence[]{"0", "1", "6"})) {
                ((DynamicProperty)fldProperties.get("tripcheckindate")).setValue(record, ((DynamicProperty)fldProperties.get("happendate")).getValue(record));
                ((DynamicProperty)fldProperties.get("tripdeparturedate")).setValue(record, ((DynamicProperty)fldProperties.get("happendate")).getValue(record));
            }
        });
    }

    public static boolean validExpenseItem(Object expenseItem, Long companyId, Long costDept, String billType) {
        String amountCtlBill;
        Long itemId = ErCommonUtils.getPk(expenseItem);
        if (itemId == null || companyId == null || costDept == null) {
            return false;
        }
        QFilter qFilter = new QFilter("id", "=", (Object)itemId);
        qFilter.and("enable", "=", (Object)Boolean.TRUE);
        List<String> empCltList = SystemParamterUtil.getEmpCltBillList(companyId);
        List<String> deptCltList = SystemParamterUtil.getDeptCltBillList(companyId);
        String string = amountCtlBill = StringUtils.equals((CharSequence)billType, (CharSequence)"er_tripreimbursebill") ? "2" : "1";
        if (!empCltList.contains(amountCtlBill)) {
            qFilter.and("isreimburseamountctl", "!=", (Object)"1");
        }
        if (!deptCltList.contains(amountCtlBill)) {
            qFilter.and("isreimburseamountctl", "!=", (Object)"2");
        }
        QFilter q = ExpenseItemServiceHelper.getExpItemFiltersExcludeBizitemAndProjecttype(billType, companyId, costDept, true);
        qFilter.and(q);
        DynamicObject item = BusinessDataServiceHelper.loadSingle((String)"er_expenseitemedit", (String)"id", (QFilter[])new QFilter[]{qFilter});
        return item != null;
    }

    private static BigDecimal getCurPrice(IDataModel model, int rowIndex, int parentIndex) {
        BigDecimal price = (BigDecimal)model.getValue("price", rowIndex, parentIndex);
        BigDecimal exchangeRate = (BigDecimal)model.getValue("exchangerate", rowIndex, parentIndex);
        String quoteType = (String)ObjectUtils.defaultIfNull((Object)((String)model.getValue("detailquotetype", rowIndex, parentIndex)), (Object)"0");
        return StringUtils.equals((CharSequence)"1", (CharSequence)quoteType) ? price.divide(exchangeRate, AmountUtils.getCurrencyPrecision(model, "currency"), RoundingMode.HALF_UP) : price.multiply(exchangeRate).setScale(AmountUtils.getCurrencyPrecision(model, "currency"), RoundingMode.HALF_UP);
    }
}

