/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.pub;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.bos.form.container.AdvContainer;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.er.business.daily.reimburse.WriteOffTypeEnum;
import kd.fi.er.business.invoicecloud.cache.model.InvoiceCloudCfgBO;
import kd.fi.er.business.invoicecloud.kingdee.KingdeeInvoiceCloudConfig;
import kd.fi.er.business.pub.ContractUtil;
import kd.fi.er.business.servicehelper.CommonServiceHelper;
import kd.fi.er.business.servicehelper.CoreBaseBillServiceHelper;
import kd.fi.er.business.servicehelper.PayeeServiceHelper;
import kd.fi.er.business.utils.AmountUtils;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.business.utils.ErEntityTypeUtils;
import kd.fi.er.business.utils.ErStdConfig;
import kd.fi.er.business.utils.SystemParamterUtil;
import kd.fi.er.common.field.writeoffmoney.PrePayContractWriteOffFields;
import kd.fi.er.common.field.writeoffmoney.PublicContractWriteOffFields;
import kd.fi.er.common.field.writeoffmoney.WriteOffFields;
import kd.fi.er.common.sysparam.UnitShowTypeEnum;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.ObjectUtils;

public class PublicBillUtil {
    public static final Map<String, String> PAYERTYPE;
    private static Log logger;

    public static DynamicObject getSupplier(IDataModel model, String makeoutcompname) {
        DynamicObject applierCompany = (DynamicObject)model.getValue("company");
        Long companyId = (Long)applierCompany.getPkValue();
        String publicCurrentUnit = SystemParamterUtil.getPublicCurrentUnit(companyId);
        DynamicObject company = null;
        if ("1".equals(publicCurrentUnit)) {
            company = (DynamicObject)model.getValue("costcompany");
        } else if ("2".equals(publicCurrentUnit)) {
            company = applierCompany;
        }
        if (company == null) {
            return null;
        }
        QFilter qFilter1 = new QFilter("createorg", "=", company.getPkValue());
        qFilter1.and(new QFilter("name", "=", (Object)makeoutcompname));
        qFilter1.and(new QFilter("enable", "=", (Object)"1"));
        qFilter1.and(new QFilter("status", "=", (Object)"C"));
        DynamicObject bd_supplier = QueryServiceHelper.queryOne((String)"bd_supplier", (String)"id,number,name", (QFilter[])new QFilter[]{qFilter1});
        if (bd_supplier != null) {
            return bd_supplier;
        }
        QFilter qFilter2 = new QFilter("name", "=", (Object)makeoutcompname);
        qFilter2.and(new QFilter("enable", "=", (Object)"1"));
        qFilter2.and(BaseDataServiceHelper.getBaseDataFilter((String)"bd_supplier", (Long)((Long)company.getPkValue())));
        qFilter2.and(new QFilter("status", "=", (Object)"C"));
        bd_supplier = QueryServiceHelper.queryOne((String)"bd_supplier", (String)"id,number,name", (QFilter[])new QFilter[]{qFilter2});
        if (bd_supplier != null) {
            return bd_supplier;
        }
        return null;
    }

    public static void deleteBillpayerid(IDataModel model) {
        if (!org.apache.commons.lang3.StringUtils.equals((CharSequence)"bd_supplier", (CharSequence)model.getValue("billpayertype").toString())) {
            return;
        }
        DynamicObject billpayerid = (DynamicObject)model.getValue("billpayerid");
        if (billpayerid == null) {
            return;
        }
        String billpayeridName = billpayerid.getLocaleString("name").toString();
        DynamicObjectCollection invoiceentry = model.getEntryEntity("invoiceentry");
        for (int index = 0; index < invoiceentry.size(); ++index) {
            if (!org.apache.commons.lang3.StringUtils.equals((CharSequence)billpayeridName, (CharSequence)((String)model.getValue("makeoutcompname", index)))) continue;
            return;
        }
        model.setValue("billpayerid", null);
    }

    public static boolean isHeadUnit(IDataModel model) {
        DynamicObject company = (DynamicObject)model.getValue("company");
        UnitShowTypeEnum unitShowType = SystemParamterUtil.getUnitShowTypes(company == null ? Long.valueOf(0L) : (Long)company.getPkValue());
        return UnitShowTypeEnum.HEAD == unitShowType;
    }

    public static void setHeadUnit(int rowIndex, IFormView view, Object newValue, String key) {
        IDataModel model = view.getModel();
        model.beginInit();
        if (rowIndex == 0) {
            model.setValue(PublicBillUtil.getProp(key), newValue);
            view.updateView(PublicBillUtil.getProp(key));
        }
        model.endInit();
    }

    public static String getProp(String key) {
        String prop;
        switch (key) {
            case "entrywlunit": {
                prop = "wlunit";
                break;
            }
            case "entrywltype": {
                prop = "wltype";
                break;
            }
            case "wltype": {
                prop = "entrywltype";
                break;
            }
            case "wlunit": {
                prop = "entrywlunit";
                break;
            }
            default: {
                prop = "";
            }
        }
        return prop;
    }

    public static String checkProjecttype(Map<String, Object> dataMap) {
        JSONObject projectType = (JSONObject)dataMap.get("projecttype");
        if (projectType != null) {
            List entryExpItemNumbers;
            String projectTypeNumber = projectType.getString("number");
            DynamicObject projectTypeDy = BusinessDataServiceHelper.loadSingleFromCache((String)"er_projecttype", (String)"id,entryentity.expenseitem,enable", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)projectTypeNumber)});
            if (projectTypeDy == null) {
                return String.format(ResManager.loadKDString((String)"\u7f16\u7801\u4e3a%s\u7684\u4e1a\u52a1\u5206\u7c7b\u4e0d\u5b58\u5728\u3002", (String)"ErPubBillInitImportBaseHandle_16", (String)"fi-er-opplugin", (Object[])new Object[0]), projectTypeNumber);
            }
            if ("0".equals(projectTypeDy.get("enable"))) {
                return String.format(ResManager.loadKDString((String)"\u7f16\u7801\u4e3a%s\u7684\u4e1a\u52a1\u5206\u7c7b\u4e0d\u53ef\u7528\u3002", (String)"ErPubBillInitImportBaseHandle_23", (String)"fi-er-opplugin", (Object[])new Object[0]), projectTypeNumber);
            }
            DynamicObjectCollection entryentity = projectTypeDy.getDynamicObjectCollection("entryentity");
            if (!entryentity.isEmpty() && !(entryExpItemNumbers = entryentity.stream().map(e -> e.getString("expenseitem.number")).collect(Collectors.toList())).isEmpty()) {
                dataMap.put("projectTypeExpItemNumbers", entryExpItemNumbers);
            }
        }
        return null;
    }

    public static void writeOffContract(IDataModel model, PublicContractWriteOffFields fields) {
        Boolean frameworkcontract = (Boolean)model.getValue("frameworkcontract");
        String ispush = (String)model.getValue("ispush");
        if (frameworkcontract.booleanValue() && !"true".equals(ispush) && model.getEntryRowCount("contractentry") > 0) {
            DynamicObjectCollection expcoll = model.getEntryEntity("expenseentryentity");
            BigDecimal expeapprovecurramount = expcoll.stream().map(e -> (BigDecimal)e.get("expeapprovecurramount")).reduce((a, b) -> a.add((BigDecimal)b)).orElse(BigDecimal.ZERO);
            DynamicObject contractexpcurrency = (DynamicObject)model.getValue("contractexpcurrency");
            BigDecimal expeapproveamount = AmountUtils.getOriAmount(expeapprovecurramount, (BigDecimal)model.getValue("contractexpchangerate"), contractexpcurrency.getInt("amtprecision"), (String)model.getValue("contractexpquotetype"));
            model.beginInit();
            model.setValue("contractcurrwriteoff", (Object)expeapprovecurramount, 0);
            model.setValue("contractwriteoff", (Object)expeapproveamount, 0);
            DynamicObjectCollection accounts = model.getEntryEntity("accountentry");
            if (accounts.size() <= 0) {
                return;
            }
            BigDecimal currReceiveAmt = BigDecimal.ZERO;
            for (DynamicObject account : accounts) {
                currReceiveAmt = currReceiveAmt.add(account.getBigDecimal("receiveamount"));
            }
            BigDecimal receiveAmt = AmountUtils.getOriAmount(currReceiveAmt, (BigDecimal)model.getValue("contractexpchangerate"), contractexpcurrency.getInt("amtprecision"), (String)model.getValue("contractexpquotetype"));
            model.setValue("contractreimamount", (Object)receiveAmt, 0);
            model.setValue("contractcurrreimamhttount", (Object)currReceiveAmt, 0);
            model.endInit();
        } else {
            ContractUtil.refreshWriteOffAmount(model, (WriteOffFields)fields);
            DynamicObjectCollection contracts = model.getEntryEntity("contractentry");
            if (contracts.size() > 0) {
                PublicBillUtil.calContractInvoiceAmount(model);
                PublicBillUtil.calContractPayedAmount(model);
            }
        }
    }

    public static void refreshContractCurrWriteAmount(IDataModel model, BigDecimal oriAmount, int rowIndex) {
        int precision;
        BigDecimal changeRate = model.getValue("contractexpchangerate", rowIndex) == null ? BigDecimal.ZERO : (BigDecimal)model.getValue("contractexpchangerate", rowIndex);
        String quoteType = (String)ObjectUtils.defaultIfNull((Object)((String)model.getValue("contractexpquotetype", rowIndex)), (Object)"0");
        DynamicObject expCurrency = (DynamicObject)model.getValue("contractexpcurrency", rowIndex);
        if (null == expCurrency) {
            return;
        }
        int curPrecision = precision = AmountUtils.getCurrencyPrecision(ErCommonUtils.getPk(expCurrency));
        DynamicObject currency = (DynamicObject)model.getValue("currency");
        if (currency != null) {
            curPrecision = AmountUtils.getCurrencyPrecision(currency.getPkValue());
        }
        BigDecimal currencyAmount = AmountUtils.getCurrencyAmount(oriAmount, changeRate, curPrecision, quoteType);
        model.setValue("contractcurrwriteoff", (Object)currencyAmount, rowIndex);
    }

    public static void calContractInvoiceAmount(IDataModel model) {
        int index;
        DynamicObjectCollection contracts = model.getEntryEntity("contractentry");
        if (contracts.size() <= 0) {
            return;
        }
        for (int index2 = 0; index2 < contracts.size(); ++index2) {
            model.setValue("entryinvoiceamount", (Object)BigDecimal.ZERO, index2);
        }
        DynamicObject currency = (DynamicObject)model.getValue("currency");
        int precision = AmountUtils.getCurrencyPrecision(ErCommonUtils.getPk(currency));
        DynamicObjectCollection invoices = model.getEntryEntity("invoiceentry");
        BigDecimal invoiceCurrAmount = BigDecimal.ZERO;
        for (index = 0; index < invoices.size(); ++index) {
            DynamicObject invoice = (DynamicObject)invoices.get(index);
            DynamicObject entryCurr = invoice.getDynamicObject("invoicecurrency");
            BigDecimal entryAmount = invoice.getBigDecimal("totalamount");
            Map<String, Object> changeMap = PublicBillUtil.getChangeRate(model, entryCurr);
            String quoteType = (String)ObjectUtils.defaultIfNull((Object)((String)changeMap.get("quoteType")), (Object)"0");
            BigDecimal exchangeRate = (BigDecimal)ObjectUtils.defaultIfNull((Object)((BigDecimal)changeMap.get("exchangeRate")), (Object)BigDecimal.ONE);
            BigDecimal entryCurrAmount = AmountUtils.getCurrencyAmount(entryAmount, exchangeRate, precision, quoteType);
            invoiceCurrAmount = invoiceCurrAmount.add(entryCurrAmount);
        }
        if (invoiceCurrAmount.compareTo(BigDecimal.ZERO) <= 0) {
            return;
        }
        for (index = 0; index < contracts.size(); ++index) {
            DynamicObject contract = (DynamicObject)contracts.get(index);
            BigDecimal currWriteAmount = contract.getBigDecimal("contractcurrwriteoff");
            if (index == contracts.size() - 1) {
                model.setValue("entryinvoiceamount", (Object)invoiceCurrAmount, index);
                break;
            }
            if (currWriteAmount.compareTo(invoiceCurrAmount) > 0) {
                model.setValue("entryinvoiceamount", (Object)invoiceCurrAmount, index);
                break;
            }
            model.setValue("entryinvoiceamount", (Object)currWriteAmount, index);
            invoiceCurrAmount = invoiceCurrAmount.subtract(currWriteAmount);
        }
    }

    private static Map<String, Object> getChangeRate(IDataModel model, DynamicObject oriCurrency) {
        DynamicObject currency = (DynamicObject)model.getValue("currency");
        DynamicObject company = (DynamicObject)model.getValue("company");
        DynamicObject costCompany = (DynamicObject)model.getValue("costcompany");
        if (oriCurrency != null && currency != null && company != null) {
            Long srcCurrencyId = (Long)oriCurrency.getPkValue();
            Long targetCurrencyId = (Long)currency.getPkValue();
            return CommonServiceHelper.getExchangeRateFromSysParams(ErCommonUtils.getPk(company), costCompany, srcCurrencyId, targetCurrencyId, model);
        }
        return new HashMap<String, Object>(2);
    }

    public static void handlePrePayContract(IDataModel model, IFormView view) {
        DynamicObjectCollection entity = model.getEntryEntity("writeoffmoney");
        DynamicObjectCollection pres = new DynamicObjectCollection();
        for (int index = entity.size() - 1; index >= 0; --index) {
            DynamicObject pre = (DynamicObject)entity.get(index);
            if (!pre.getString("srcbilltype").equals("er_prepaybill")) continue;
            pres.add((Object)pre);
        }
        Set preIds = pres.stream().map(p -> p.getLong("sourcebillid")).filter(v -> v != null && v > 0L).collect(Collectors.toSet());
        Set preEntryIds = pres.stream().map(p -> p.getLong("srcofsrcentryid")).filter(v -> v != null && v > 0L).collect(Collectors.toSet());
        DynamicObjectCollection preEntries = new DynamicObjectCollection();
        for (Long billId : preIds) {
            DynamicObject bill = BusinessDataServiceHelper.loadSingle((Object)billId, (String)"er_prepaybill");
            DynamicObjectCollection entries = bill.getDynamicObjectCollection("expenseentryentity");
            for (DynamicObject entry : entries) {
                if (!preEntryIds.contains(entry.getPkValue())) continue;
                preEntries.add((Object)entry);
            }
        }
        DynamicObjectCollection contracts = model.getEntryEntity("contractentry");
        for (int index = 0; index < contracts.size(); ++index) {
            Long srcEntryId = (Long)model.getValue("contractsrcentryid", index);
            BigDecimal currPreAmount = BigDecimal.ZERO;
            for (DynamicObject preEntry : preEntries) {
                Long preSrcEntryId = preEntry.getLong("wbsrcentryid");
                if (srcEntryId.longValue() != preSrcEntryId.longValue()) continue;
                BigDecimal currAmount = preEntry.getBigDecimal("expeapprovecurramount");
                currPreAmount = currPreAmount.add(currAmount);
            }
            model.setValue("entrycurrprepayedamount", (Object)currPreAmount, index);
        }
        PublicBillUtil.calContractPayedAmount(model);
    }

    private static void calContractPayedAmount(IDataModel model) {
        DynamicObjectCollection accounts = model.getEntryEntity("accountentry");
        BigDecimal currReceiveAmt = BigDecimal.ZERO;
        BigDecimal receiveAmt = BigDecimal.ZERO;
        for (DynamicObject account : accounts) {
            currReceiveAmt = currReceiveAmt.add(account.getBigDecimal("receiveamount"));
            receiveAmt = receiveAmt.add(account.getBigDecimal("orireceiveamount"));
        }
        String writeofftype = (String)ErCommonUtils.getEMParameter(ErCommonUtils.getPk(model.getValue("company")), "er010");
        DynamicObjectCollection contracts = model.getEntryEntity("contractentry");
        if (WriteOffTypeEnum.ORGI_WO.getValue().equals(writeofftype)) {
            int curprecision = -1;
            DynamicObject currency = (DynamicObject)model.getValue("currency");
            if (currency != null) {
                curprecision = AmountUtils.getCurrencyPrecision(ErCommonUtils.getPk(currency));
            }
            for (int index = 0; index < contracts.size(); ++index) {
                DynamicObject contract = (DynamicObject)contracts.get(index);
                BigDecimal oricanReceive = contract.getBigDecimal("oricontractnotpayamount");
                if (oricanReceive.compareTo(BigDecimal.ZERO) <= 0) continue;
                BigDecimal oripayedAmount = BigDecimal.ZERO;
                oripayedAmount = oricanReceive.compareTo(receiveAmt) > 0 ? receiveAmt : oricanReceive;
                receiveAmt = receiveAmt.subtract(oripayedAmount);
                model.beginInit();
                model.setValue("contractreimamount", (Object)oripayedAmount, index);
                BigDecimal changeRate = model.getValue("contractexpchangerate", index) == null ? BigDecimal.ZERO : (BigDecimal)model.getValue("contractexpchangerate", index);
                String quoteType = (String)ObjectUtils.defaultIfNull((Object)((String)model.getValue("contractexpquotetype", index)), (Object)"0");
                DynamicObject expCurrency = (DynamicObject)model.getValue("contractexpcurrency", index);
                if (null == expCurrency) {
                    return;
                }
                int precision = AmountUtils.getCurrencyPrecision(ErCommonUtils.getPk(expCurrency));
                if (curprecision == -1) {
                    curprecision = precision;
                }
                model.setValue("contractcurrreimamhttount", (Object)AmountUtils.getCurrencyAmount(oripayedAmount, changeRate, curprecision, quoteType), index);
                model.endInit();
            }
        } else {
            for (int index = 0; index < contracts.size(); ++index) {
                DynamicObject contract = (DynamicObject)contracts.get(index);
                BigDecimal canReceive = contract.getBigDecimal("contractnotpayamount");
                if (canReceive.compareTo(BigDecimal.ZERO) <= 0) continue;
                BigDecimal payedAmount = BigDecimal.ZERO;
                payedAmount = canReceive.compareTo(currReceiveAmt) > 0 ? currReceiveAmt : canReceive;
                model.beginInit();
                currReceiveAmt = currReceiveAmt.subtract(payedAmount);
                model.setValue("contractcurrreimamhttount", (Object)payedAmount, index);
                BigDecimal changeRate = model.getValue("contractexpchangerate", index) == null ? BigDecimal.ZERO : (BigDecimal)model.getValue("contractexpchangerate", index);
                String quoteType = (String)ObjectUtils.defaultIfNull((Object)((String)model.getValue("contractexpquotetype", index)), (Object)"0");
                DynamicObject expCurrency = (DynamicObject)model.getValue("contractexpcurrency", index);
                if (null == expCurrency) {
                    return;
                }
                int precision = AmountUtils.getCurrencyPrecision(ErCommonUtils.getPk(expCurrency));
                model.setValue("contractreimamount", (Object)AmountUtils.getOriAmount(payedAmount, changeRate, precision, quoteType), index);
                model.endInit();
            }
        }
    }

    public static int compareWithTail(BigDecimal amountA, BigDecimal amountB, BigDecimal tail) {
        BigDecimal diff = amountA.subtract(amountB);
        if (diff.compareTo(BigDecimal.ZERO) >= 0) {
            if (diff.compareTo(tail) > 0) {
                return 1;
            }
            return 0;
        }
        diff = amountB.subtract(amountA);
        if (diff.compareTo(tail) > 0) {
            return -1;
        }
        return 0;
    }

    public static void calNonpayAmount(IDataModel model) {
        DynamicObjectCollection expcoll = model.getEntryEntity("expenseentryentity");
        DynamicObjectCollection writeoffcoll = model.getEntryEntity("writeoffmoney");
        DynamicObjectCollection contractentryList = model.getEntryEntity("contractentry");
        if (expcoll != null && expcoll.size() > 0) {
            DynamicObject expense = (DynamicObject)expcoll.get(0);
            Boolean frameworkcontract = (Boolean)model.getValue("frameworkcontract");
            if (expense.getLong("wbsrcbillid") != 0L && ("project".equals(expense.getString("wbsrcbilltype")) || "er_applyprojectbill".equals(expense.getString("wbsrcbilltype")))) {
                PublicBillUtil.calNonpayAmount(expcoll, writeoffcoll, "wbsrcbillno", "expnonpayamount", "loanprojectno", "wbcuramount", "curraccloanamount");
            } else if (frameworkcontract.booleanValue() && ("er_contractbill".equals(expense.getString("wbsrcbilltype")) || "contract".equals(expense.getString("wbsrcbilltype")))) {
                expense.set("expnonpayamount", (Object)((BigDecimal)model.getValue("payamount")));
                if (expcoll.size() > 1) {
                    for (int i = 1; i < expcoll.size(); ++i) {
                        ((DynamicObject)expcoll.get(i)).set("expnonpayamount", (Object)0);
                    }
                }
            }
        }
        if ("1".equals(model.getValue("relationcontract"))) {
            PublicBillUtil.calNonpayAmount(contractentryList, writeoffcoll, "contractcode", "contractnonpayamount", "loancontractno", "contractcurrwriteoff", "curraccloanamount");
            PublicBillUtil.calNonpayAmount(contractentryList, writeoffcoll, "contractcode", "oricontractnonpayamount", "loancontractno", "contractwriteoff", "accloanamount");
        }
    }

    public static void refreshWriteOffInfo(IDataModel model) {
        DynamicObjectCollection expColl;
        String detailtype = (String)model.getValue("detailtype");
        String applyprojectbillRelated = ErStdConfig.getApplyprojectbillRelated();
        if ("biztype_project".equals(detailtype) && (expColl = model.getEntryEntity("expenseentryentity")) != null && expColl.size() > 0) {
            DynamicObjectCollection writeoffColl = model.getEntryEntity("writeoffmoney");
            Set projectNoList = expColl.stream().map(exp -> exp.getString("wbsrcbillno")).collect(Collectors.toSet());
            if (projectNoList != null && projectNoList.size() > 0 && writeoffColl != null && writeoffColl.size() > 0) {
                for (String projectNo : projectNoList) {
                    for (int i = 0; i < writeoffColl.size(); ++i) {
                        String entityName = ((DynamicObject)writeoffColl.get(i)).getString("srcbilltype");
                        Boolean sourcesign = ((DynamicObject)writeoffColl.get(i)).getBoolean("sourcesign");
                        if (sourcesign.booleanValue()) continue;
                        QFilter selectedEntryQfilter = new QFilter("billno", "=", (Object)((DynamicObject)writeoffColl.get(i)).getString("loanbillnov1"));
                        if ("er_dailyloanbill".equals(entityName)) {
                            selectedEntryQfilter.and("expenseentryentity.applyprojectno", "=", (Object)projectNo);
                        } else if ("er_prepaybill".equals(entityName)) {
                            selectedEntryQfilter.and("expenseentryentity.wbsrcbilltype", "=", (Object)"er_applyprojectbill").and("expenseentryentity.wbsrcbillno", "=", (Object)projectNo);
                        }
                        if (!QueryServiceHelper.exists((String)entityName, (QFilter[])new QFilter[]{selectedEntryQfilter})) continue;
                        model.setValue("loanprojectno", (Object)projectNo, i);
                    }
                }
            }
        }
    }

    public static boolean checkProjectNo(IFormView view) {
        if (view != null) {
            DynamicObjectCollection dynamicObjectCollection = view.getModel().getEntryEntity("expenseentryentity");
            if (dynamicObjectCollection == null || dynamicObjectCollection.size() == 0) {
                view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u5728\u8d39\u7528\u660e\u7ec6\u4e2d\u9009\u62e9\u7acb\u9879\u3002", (String)"PublicReimBillEdit_3", (String)"fi-er-formplugin", (Object[])new Object[0]));
                return false;
            }
            for (DynamicObject dynamicObject : dynamicObjectCollection) {
                if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)dynamicObject.getString("entryprojectno"))) continue;
                return true;
            }
            view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u5728\u8d39\u7528\u660e\u7ec6\u4e2d\u9009\u62e9\u7acb\u9879\u3002", (String)"PublicReimBillEdit_3", (String)"fi-er-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    public static void setExpContactInfo(IDataModel model, IFormView view) {
        boolean ispush = false;
        if (ErEntityTypeUtils.isPublicReimburseBill(view.getEntityId())) {
            if ("true".equals(model.getValue("ispush"))) {
                ispush = true;
            }
        } else if (ErEntityTypeUtils.isPrePayBill(view.getEntityId())) {
            ispush = (Boolean)model.getValue("ispush");
        }
        if ("1".equals(model.getValue("relationcontract")) && !ispush) {
            if (model.getEntryEntity("contractentry").size() == 0) {
                return;
            }
            String contractcode = (String)model.getValue("contractcode", 0);
            String contractname = (String)model.getValue("contractname", 0);
            DynamicObjectCollection expsCol = model.getEntryEntity("expenseentryentity");
            if (expsCol != null && expsCol.size() > 0) {
                for (int i = 0; i < expsCol.size(); ++i) {
                    model.setValue("entrycontractno", (Object)contractcode, i);
                    model.setValue("entrycontractname", (Object)contractname, i);
                }
            }
        }
    }

    public static void calPreContractMoney(IDataModel model, PrePayContractWriteOffFields fields) {
        Boolean frameworkcontract = (Boolean)model.getValue("frameworkcontract");
        Boolean ispush = (Boolean)model.getValue("ispush");
        String writeOffType = (String)ErCommonUtils.getEMParameter(ErCommonUtils.getPk(model.getValue("company")), "er010");
        if (frameworkcontract.booleanValue() && !ispush.booleanValue() && model.getEntryRowCount("contractentry") > 0) {
            DynamicObjectCollection expcoll = model.getEntryEntity("expenseentryentity");
            DynamicObject contractexpcurrency = (DynamicObject)model.getValue("contractexpcurrency");
            int amtprecision = 4;
            if (contractexpcurrency != null) {
                amtprecision = contractexpcurrency.getInt("amtprecision");
            }
            if ("1".equals(writeOffType)) {
                BigDecimal expeapproveamount = BigDecimal.ZERO;
                if (expcoll != null && expcoll.size() > 0) {
                    for (DynamicObject exp : expcoll) {
                        if (exp == null || exp.getDynamicObject("entrycurrency") == null || contractexpcurrency == null || exp.getDynamicObject("entrycurrency").getPkValue() != contractexpcurrency.getPkValue()) continue;
                        expeapproveamount = expeapproveamount.add(exp.getBigDecimal("expeapproveamount"));
                    }
                }
                int curprecision = amtprecision;
                DynamicObject currency = (DynamicObject)model.getValue("currency");
                if (currency != null) {
                    curprecision = AmountUtils.getCurrencyPrecision(ErCommonUtils.getPk(currency));
                }
                BigDecimal expeapprovecurramount = AmountUtils.getCurrencyAmount(expeapproveamount, (BigDecimal)model.getValue("contractexpchangerate"), curprecision, (String)model.getValue("contractexpquotetype"));
                model.setValue("contractwriteoff", (Object)expeapproveamount, 0);
                model.setValue("contractcurrwriteoff", (Object)expeapprovecurramount, 0);
            } else {
                BigDecimal expeapprovecurramount = expcoll.stream().map(e -> (BigDecimal)e.get("expeapprovecurramount")).reduce((a, b) -> a.add((BigDecimal)b)).orElse(BigDecimal.ZERO);
                BigDecimal expeapproveamount = AmountUtils.getOriAmount(expeapprovecurramount, (BigDecimal)model.getValue("contractexpchangerate"), amtprecision, (String)model.getValue("contractexpquotetype"));
                model.setValue("contractcurrwriteoff", (Object)expeapprovecurramount, 0);
                model.setValue("contractwriteoff", (Object)expeapproveamount, 0);
            }
        } else {
            ContractUtil.refreshWriteOffAmount(model, (WriteOffFields)fields, writeOffType);
        }
    }

    public static void refreshWriteEntry(IDataModel model, IFormView view) {
        String detailtype;
        String applyprojectbillRelated = ErStdConfig.getApplyprojectbillRelated();
        if (ErEntityTypeUtils.isPublicReimburseBill(view.getEntityId()) && "biztype_project".equals(detailtype = (String)model.getValue("detailtype")) && model.getEntryRowCount("writeoffmoney") > 0) {
            DynamicObjectCollection expcoll = model.getEntryEntity("expenseentryentity");
            DynamicObjectCollection writeoffmoneycoll = model.getEntryEntity("writeoffmoney");
            if (expcoll != null && expcoll.size() > 0) {
                ArrayList deleteRows = Lists.newArrayList();
                Set itemset = expcoll.stream().map(v -> !org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)v.getString("entryprojectno")) ? v.getString("entryprojectno") : "").collect(Collectors.toSet());
                if (itemset != null && !itemset.isEmpty()) {
                    for (int i2 = 0; i2 < writeoffmoneycoll.size(); ++i2) {
                        if (itemset.contains(((DynamicObject)writeoffmoneycoll.get(i2)).get("loanprojectno"))) continue;
                        deleteRows.add(i2);
                    }
                }
                if (!deleteRows.isEmpty() && writeoffmoneycoll != null && writeoffmoneycoll.size() > 0) {
                    model.deleteEntryRows("writeoffmoney", deleteRows.stream().mapToInt(i -> i).toArray());
                }
            } else {
                model.deleteEntryData("writeoffmoney");
            }
        }
    }

    public static boolean upgradeApplyProjectData() {
        QFilter[] qFilters = new QFilter[]{new QFilter("billstatus", "in", (Object)Lists.newArrayList((Object[])new Character[]{Character.valueOf('A'), Character.valueOf('B'), Character.valueOf('C'), Character.valueOf('D'), Character.valueOf('E'), Character.valueOf('I')}))};
        DynamicObject[] bills = BusinessDataServiceHelper.load((String)"er_applyprojectbill", (String)"id,billno,billstatus,expenseentryentity.id,notpayamount,nonpayamount,payamount,acapproveamount,availableamount,expenseentryentity.currexpenseamount,expenseentryentity.expeapprovecurramount,contractamount,costimateamount", (QFilter[])qFilters);
        if (bills != null && bills.length > 0) {
            for (DynamicObject bill : bills) {
                PublicBillUtil.upgradeApplyProjectData(bill);
            }
            SaveServiceHelper.save((DynamicObject[])bills);
        }
        return true;
    }

    public static void refreshAccountEntry(IDataModel model) {
        DynamicObject billpayer = (DynamicObject)model.getValue("billpayerid");
        DynamicObjectCollection accountentry = model.getDataEntity(true).getDynamicObjectCollection("accountentry");
        if (billpayer != null && accountentry != null && accountentry.size() > 0) {
            List<DynamicObject> defaultAccts = PayeeServiceHelper.getOtherDefaultAccountByPayerID((Long)billpayer.getPkValue(), model.getDataEntity().getPkValue(), false);
            model.beginInit();
            model.setValue("payer", billpayer.getPkValue(), 0);
            model.setValue("payertype", (Object)PAYERTYPE.get((String)model.getValue("billpayertype")), 0);
            model.endInit();
            if (defaultAccts.size() > 0) {
                CoreBaseBillServiceHelper.fillAccountEntry(model, 0, defaultAccts.get(0));
            } else {
                model.setValue("payer", null, 0);
                model.setValue("payername", null, 0);
                model.setValue("payeraccount", null, 0);
                model.setValue("payeraccountname", null, 0);
                model.setValue("payerbank", null, 0);
            }
        }
    }

    private static BigDecimal[] getApplyProjectBillAmount(DynamicObject bill, String entityName) {
        BigDecimal[] nonAndNotPayAmountArr;
        block15: {
            QFilter[] qFilters;
            DynamicObject[] dailyloanbillList;
            block16: {
                block14: {
                    nonAndNotPayAmountArr = new BigDecimal[]{BigDecimal.ZERO, BigDecimal.ZERO};
                    if (!"er_prepaybill".equals(entityName)) break block14;
                    QFilter[] qFilters2 = new QFilter[]{new QFilter("billstatus", "in", (Object)Lists.newArrayList((Object[])new Character[]{Character.valueOf('B'), Character.valueOf('C'), Character.valueOf('E'), Character.valueOf('F'), Character.valueOf('G'), Character.valueOf('I')})), new QFilter("expenseentryentity.wbsrcbillid", "=", bill.getPkValue())};
                    DynamicObject[] prebillList = BusinessDataServiceHelper.load((String)entityName, (String)"id,billstatus,expenseentryentity.id,expenseentryentity.wbsrcbillid,expenseentryentity.currexpenseamount,expenseentryentity.expeapprovecurramount,expenseentryentity.experepayamount", (QFilter[])qFilters2);
                    if (prebillList == null || prebillList.length <= 0) break block15;
                    for (DynamicObject prebill : prebillList) {
                        String billstatus = prebill.getString("billstatus");
                        DynamicObjectCollection exps = prebill.getDynamicObjectCollection("expenseentryentity");
                        if ("G".equals(billstatus) || "I".equals(billstatus)) {
                            nonAndNotPayAmountArr[0] = nonAndNotPayAmountArr[0].add(exps.stream().filter(m -> m.getLong("wbsrcbillid") == ((Long)bill.getPkValue()).longValue()).map(n -> n.getBigDecimal("expeapprovecurramount")).reduce(BigDecimal.ZERO, BigDecimal::add)).subtract(exps.stream().filter(m -> m.getLong("wbsrcbillid") == ((Long)bill.getPkValue()).longValue()).map(n -> n.getBigDecimal("experepayamount")).reduce(BigDecimal.ZERO, BigDecimal::add));
                            continue;
                        }
                        nonAndNotPayAmountArr[1] = nonAndNotPayAmountArr[1].add(exps.stream().filter(m -> m.getLong("wbsrcbillid") == ((Long)bill.getPkValue()).longValue()).map(n -> n.getBigDecimal("expeapprovecurramount")).reduce(BigDecimal.ZERO, BigDecimal::add));
                    }
                    break block15;
                }
                if (!"er_publicreimbursebill".equals(entityName)) break block16;
                QFilter[] qFilters3 = new QFilter[]{new QFilter("billstatus", "in", (Object)Lists.newArrayList((Object[])new Character[]{Character.valueOf('B'), Character.valueOf('C'), Character.valueOf('E'), Character.valueOf('F'), Character.valueOf('G'), Character.valueOf('I')})), new QFilter("expenseentryentity.wbsrcbillid", "=", bill.getPkValue())};
                DynamicObject[] publicbillList = BusinessDataServiceHelper.load((String)"er_publicreimbursebill", (String)"id,billstatus,expenseentryentity.id,expenseentryentity.currexpenseamount,expenseentryentity.expeapprovecurramount,expenseentryentity.wbcuramount,expenseentryentity.wbsrcbillid,writeoffmoney.id,writeoffmoney.loanprojectno,writeoffmoney.sourcebillid,writeoffmoney.srcbilltype,writeoffmoney.curraccloanamount,writeoffmoney.accloanamount,writeoffmoney.loanbillnov1", (QFilter[])qFilters3);
                if (publicbillList == null || publicbillList.length <= 0) break block15;
                for (DynamicObject publicbill : publicbillList) {
                    String billstatus = publicbill.getString("billstatus");
                    BigDecimal totalApprovecurrAmount = BigDecimal.ZERO;
                    BigDecimal totalLoanAmount = BigDecimal.ZERO;
                    DynamicObjectCollection exps = publicbill.getDynamicObjectCollection("expenseentryentity");
                    DynamicObjectCollection writeoffcoll = publicbill.getDynamicObjectCollection("writeoffmoney");
                    if (exps != null && exps.size() > 0) {
                        totalApprovecurrAmount = exps.stream().filter(m -> m.getLong("wbsrcbillid") == ((Long)bill.getPkValue()).longValue()).map(n -> n.getBigDecimal("wbcuramount")).reduce(BigDecimal.ZERO, BigDecimal::add);
                    }
                    if (writeoffcoll != null && writeoffcoll.size() > 0) {
                        for (DynamicObject writeoff : writeoffcoll) {
                            String loanprojectno = writeoff.getString("loanprojectno");
                            if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)loanprojectno)) {
                                if (!loanprojectno.equals(bill.getString("billno"))) continue;
                                totalLoanAmount = totalLoanAmount.add(writeoff.getBigDecimal("curraccloanamount"));
                                continue;
                            }
                            String entityType = writeoff.getString("srcbilltype");
                            QFilter qfilter = new QFilter("billno", "=", (Object)writeoff.getString("loanbillnov1"));
                            if ("er_dailyloanbill".equals(entityType)) {
                                qfilter.and("expenseentryentity.sourcebillid", "=", bill.getPkValue());
                            } else if ("er_prepaybill".equals(entityType)) {
                                qfilter.and("expenseentryentity.wbsrcbilltype", "=", (Object)"er_applyprojectbill").and("expenseentryentity.wbsrcbillid", "=", bill.getPkValue());
                            }
                            if (!QueryServiceHelper.exists((String)entityType, (QFilter[])new QFilter[]{qfilter})) continue;
                            totalLoanAmount = totalLoanAmount.add(writeoff.getBigDecimal("curraccloanamount"));
                        }
                    }
                    if ("G".equals(billstatus) || "I".equals(billstatus)) {
                        nonAndNotPayAmountArr[0] = nonAndNotPayAmountArr[0].add(totalApprovecurrAmount.subtract(totalLoanAmount));
                        continue;
                    }
                    nonAndNotPayAmountArr[1] = nonAndNotPayAmountArr[1].add(totalApprovecurrAmount.subtract(totalLoanAmount));
                }
                break block15;
            }
            if ("er_dailyloanbill".equals(entityName) && (dailyloanbillList = BusinessDataServiceHelper.load((String)entityName, (String)"id,billstatus,expenseentryentity.id,expenseentryentity.sourcebillid,expenseentryentity.currexpenseamount,expenseentryentity.expeapprovecurramount,payamount,expenseentryentity.experepayamount", (QFilter[])(qFilters = new QFilter[]{new QFilter("billstatus", "in", (Object)Lists.newArrayList((Object[])new Character[]{Character.valueOf('B'), Character.valueOf('C'), Character.valueOf('E'), Character.valueOf('F'), Character.valueOf('G'), Character.valueOf('I')})), new QFilter("expenseentryentity.sourcebillid", "=", bill.getPkValue())}))) != null && dailyloanbillList.length > 0) {
                for (DynamicObject dailyloanbill : dailyloanbillList) {
                    String billstatus = dailyloanbill.getString("billstatus");
                    DynamicObjectCollection exps = dailyloanbill.getDynamicObjectCollection("expenseentryentity");
                    if ("G".equals(billstatus) || "I".equals(billstatus)) {
                        nonAndNotPayAmountArr[0] = nonAndNotPayAmountArr[0].add(exps.stream().filter(m -> m.getLong("sourcebillid") == ((Long)bill.getPkValue()).longValue()).map(n -> n.getBigDecimal("expeapprovecurramount")).reduce(BigDecimal.ZERO, BigDecimal::add)).subtract(exps.stream().filter(m -> m.getLong("sourcebillid") == ((Long)bill.getPkValue()).longValue()).map(n -> n.getBigDecimal("experepayamount")).reduce(BigDecimal.ZERO, BigDecimal::add));
                        continue;
                    }
                    nonAndNotPayAmountArr[1] = nonAndNotPayAmountArr[1].add(exps.stream().filter(m -> m.getLong("sourcebillid") == ((Long)bill.getPkValue()).longValue()).map(n -> n.getBigDecimal("expeapprovecurramount")).reduce(BigDecimal.ZERO, BigDecimal::add));
                }
            }
        }
        return nonAndNotPayAmountArr;
    }

    public static void calNonpayAmount(IDataModel model, IFormView view) {
        if (ErEntityTypeUtils.isPublicReimburseBill(view.getEntityId())) {
            PublicBillUtil.calNonpayAmount(model);
        }
    }

    public static DynamicObject upgradeApplyProjectData(DynamicObject bill) {
        BigDecimal applyAmount = bill.getBigDecimal("acapproveamount");
        BigDecimal approveamount = bill.getBigDecimal("approveamount");
        BigDecimal notPayAmount = BigDecimal.ZERO;
        BigDecimal nonPayAmount = BigDecimal.ZERO;
        BigDecimal payedAmount = BigDecimal.ZERO;
        BigDecimal availableAmount = BigDecimal.ZERO;
        BigDecimal costimateAmount = BigDecimal.ZERO;
        BigDecimal contractamount = bill.getBigDecimal("contractamount");
        String billstatus = bill.getString("billstatus");
        if ("A".equals(billstatus) || "B".equals(billstatus) || "C".equals(billstatus) || "D".equals(billstatus)) {
            if ("A".equals(billstatus)) {
                bill.set("notpayamount", (Object)approveamount);
                bill.set("availableamount", (Object)approveamount);
            } else {
                bill.set("notpayamount", (Object)applyAmount);
                bill.set("availableamount", (Object)applyAmount);
            }
            bill.set("nonpayamount", (Object)BigDecimal.ZERO);
            bill.set("payamount", (Object)BigDecimal.ZERO);
            return bill;
        }
        BigDecimal[] nonAndNotPayAmountArr = PublicBillUtil.getApplyProjectBillAmount(bill, "er_prepaybill");
        payedAmount = payedAmount.add(nonAndNotPayAmountArr[0]);
        nonPayAmount = nonPayAmount.add(nonAndNotPayAmountArr[1]);
        nonAndNotPayAmountArr = PublicBillUtil.getApplyProjectBillAmount(bill, "er_publicreimbursebill");
        payedAmount = payedAmount.add(nonAndNotPayAmountArr[0]);
        nonPayAmount = nonPayAmount.add(nonAndNotPayAmountArr[1]);
        nonAndNotPayAmountArr = PublicBillUtil.getApplyProjectBillAmount(bill, "er_dailyloanbill");
        payedAmount = payedAmount.add(nonAndNotPayAmountArr[0]);
        nonPayAmount = nonPayAmount.add(nonAndNotPayAmountArr[1]);
        costimateAmount = costimateAmount.add(PublicBillUtil.getCostimateAmount(bill));
        notPayAmount = applyAmount.subtract(payedAmount).subtract(contractamount).subtract(costimateAmount);
        availableAmount = notPayAmount.subtract(nonPayAmount);
        if ("E".equals(billstatus)) {
            bill.set("notpayamount", (Object)notPayAmount);
            bill.set("nonpayamount", (Object)nonPayAmount);
            bill.set("payamount", (Object)payedAmount);
            bill.set("availableamount", (Object)availableAmount);
        } else if ("I".equals(billstatus)) {
            bill.set("notpayamount", (Object)BigDecimal.ZERO);
            bill.set("nonpayamount", (Object)BigDecimal.ZERO);
            bill.set("payamount", (Object)payedAmount);
            bill.set("availableamount", (Object)BigDecimal.ZERO);
        }
        bill.set("costimateamount", (Object)costimateAmount);
        return bill;
    }

    public static void calNonpayAmount(DynamicObject bill) {
        DynamicObjectCollection expenseList = bill.getDynamicObjectCollection("expenseentryentity");
        if (ErEntityTypeUtils.isPrePayBill(bill.getDataEntityType().getName())) {
            if (expenseList != null && expenseList.size() > 0) {
                for (DynamicObject expenseEntry : expenseList) {
                    BigDecimal expeapprovecurramount = expenseEntry.getBigDecimal("expeapprovecurramount");
                    if (!expenseEntry.containsProperty("expnonpayamount")) continue;
                    expenseEntry.set("expnonpayamount", (Object)expeapprovecurramount);
                }
            }
        } else if (ErEntityTypeUtils.isPublicReimburseBill(bill.getDataEntityType().getName())) {
            DynamicObjectCollection writeoffcoll = bill.getDynamicObjectCollection("writeoffmoney");
            DynamicObjectCollection contractentryList = bill.getDynamicObjectCollection("contractentry");
            if (expenseList != null && expenseList.size() > 0) {
                DynamicObject expense = (DynamicObject)expenseList.get(0);
                Boolean frameworkcontract = bill.getBoolean("frameworkcontract");
                if (expense.getLong("wbsrcbillid") != 0L && ("project".equals(expense.getString("wbsrcbilltype")) || "er_applyprojectbill".equals(expense.getString("wbsrcbilltype")))) {
                    PublicBillUtil.calNonpayAmount(expenseList, writeoffcoll, "wbsrcbillno", "expnonpayamount", "loanprojectno", "wbcuramount", "curraccloanamount");
                } else if (frameworkcontract.booleanValue() && ("er_contractbill".equals(expense.getString("wbsrcbilltype")) || "contract".equals(expense.getString("wbsrcbilltype")))) {
                    expense.set("expnonpayamount", (Object)bill.getBigDecimal("payamount"));
                    if (expenseList.size() > 1) {
                        for (int i = 1; i < expenseList.size(); ++i) {
                            ((DynamicObject)expenseList.get(i)).set("expnonpayamount", (Object)0);
                        }
                    }
                }
            }
            if ("1".equals(bill.getString("relationcontract"))) {
                PublicBillUtil.calNonpayAmount(contractentryList, writeoffcoll, "contractcode", "contractnonpayamount", "loancontractno", "contractcurrwriteoff", "curraccloanamount");
                PublicBillUtil.calNonpayAmount(contractentryList, writeoffcoll, "contractcode", "oricontractnonpayamount", "loancontractno", "contractwriteoff", "accloanamount");
            }
        }
    }

    public static void contractcurAmountChange(IDataModel model, IFormView view, Object propValue, Object oldValue, int rowIndex) {
        model.beginInit();
        BigDecimal contractnotpayamount = (BigDecimal)model.getValue("contractnotpayamount", rowIndex);
        BigDecimal contractcurrreimamhttount = (BigDecimal)propValue;
        if (contractcurrreimamhttount.compareTo(contractnotpayamount) > 0) {
            contractcurrreimamhttount = (BigDecimal)oldValue;
        }
        model.setValue("contractcurrreimamhttount", (Object)contractcurrreimamhttount, rowIndex);
        String cnquotetype = (String)model.getValue("contractexpquotetype", rowIndex);
        BigDecimal cnexchangerate = (BigDecimal)model.getValue("contractexpchangerate", rowIndex);
        DynamicObject contractexpcurrency = (DynamicObject)model.getValue("contractexpcurrency", 0);
        int amountPrecision = AmountUtils.getCurrencyPrecision(ErCommonUtils.getPk(contractexpcurrency));
        BigDecimal contractreimamount = StringUtils.equals((String)"0", (String)cnquotetype) ? contractcurrreimamhttount.divide(cnexchangerate, amountPrecision, RoundingMode.HALF_UP) : contractcurrreimamhttount.multiply(cnexchangerate).setScale(amountPrecision, RoundingMode.HALF_UP);
        model.setValue("contractreimamount", (Object)contractreimamount, rowIndex);
        model.setValue("contractcurrreimamhttount", (Object)contractcurrreimamhttount, rowIndex);
        model.endInit();
        view.updateView("contractreimamount", rowIndex);
        view.updateView("contractcurrreimamhttount", rowIndex);
    }

    public static void contractreimAmountChange(IDataModel model, IFormView view, Object newpropValue, Object oldValue, int rowIndex) {
        BigDecimal contractcurrreimamhttount;
        model.beginInit();
        BigDecimal contractnotpayamount = (BigDecimal)model.getValue("contractnotpayamount", rowIndex);
        BigDecimal contractreimamount = (BigDecimal)newpropValue;
        BigDecimal cnexchangerate = (BigDecimal)model.getValue("contractexpchangerate", rowIndex);
        DynamicObject contractexpcurrency = (DynamicObject)model.getValue("contractexpcurrency", 0);
        int amountPrecision = AmountUtils.getCurrencyPrecision(ErCommonUtils.getPk(contractexpcurrency));
        String cnquotetype = (String)model.getValue("contractexpquotetype", rowIndex);
        BigDecimal bigDecimal = contractcurrreimamhttount = StringUtils.equals((String)"0", (String)cnquotetype) ? contractreimamount.multiply(cnexchangerate).setScale(amountPrecision, RoundingMode.HALF_UP) : contractreimamount.divide(cnexchangerate, amountPrecision, RoundingMode.HALF_UP);
        if (contractcurrreimamhttount.compareTo(contractnotpayamount) <= 0) {
            model.setValue("contractreimamount", (Object)contractreimamount, rowIndex);
            model.setValue("contractcurrreimamhttount", (Object)contractcurrreimamhttount, rowIndex);
        } else {
            model.setValue("contractreimamount", (Object)((BigDecimal)oldValue), rowIndex);
        }
        model.endInit();
        view.updateView("contractreimamount", rowIndex);
        view.updateView("contractcurrreimamhttount", rowIndex);
    }

    private static void calNonpayAmount(DynamicObjectCollection expenseList, DynamicObjectCollection writeoffcoll, String billnoField, String nonpayField, String projectOrcontractField, String totalPayField, String writeoffField) {
        if (expenseList != null && expenseList.size() > 0) {
            Map<String, List<DynamicObject>> expenseGroupByProjectNo = expenseList.stream().filter(t -> !org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)t.getString(billnoField))).collect(Collectors.groupingBy(v -> v.getString(billnoField)));
            block0: for (Map.Entry<String, List<DynamicObject>> entry : expenseGroupByProjectNo.entrySet()) {
                List<DynamicObject> expenseEntryList = entry.getValue();
                int size = expenseEntryList.size();
                String key = entry.getKey();
                BigDecimal expeapprovecurramount = expenseEntryList.stream().map(e -> (BigDecimal)e.get(totalPayField)).reduce((a, b) -> a.add((BigDecimal)b)).orElse(BigDecimal.ZERO);
                BigDecimal writeoffamount = BigDecimal.ZERO;
                if (writeoffcoll != null && writeoffcoll.size() > 0) {
                    Map<String, List<DynamicObject>> writeoffGroupByProjectNo = writeoffcoll.stream().filter(t -> !org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)t.getString(projectOrcontractField))).collect(Collectors.groupingBy(v -> v.getString(projectOrcontractField)));
                    Iterator<Map.Entry<String, List<DynamicObject>>> writeoffIterator = writeoffGroupByProjectNo.entrySet().iterator();
                    Set<String> keySet = writeoffGroupByProjectNo.keySet();
                    if (keySet.size() == 0 && size > 0) {
                        expenseEntryList.get(0).set(nonpayField, (Object)expeapprovecurramount);
                        if (size <= 1) continue;
                        for (int index = 1; index < size; ++index) {
                            expenseEntryList.get(index).set(nonpayField, (Object)0);
                        }
                        continue;
                    }
                    int i = 0;
                    while (writeoffIterator.hasNext()) {
                        ++i;
                        Map.Entry<String, List<DynamicObject>> writeoffentry = writeoffIterator.next();
                        if (writeoffentry != null && writeoffentry.getKey().equals(key)) {
                            List<DynamicObject> writeoffEntryList = writeoffentry.getValue();
                            if (writeoffEntryList != null && writeoffEntryList.size() > 0 && size > 0) {
                                writeoffamount = writeoffEntryList.stream().map(e -> (BigDecimal)e.get(writeoffField)).reduce((a, b) -> a.add((BigDecimal)b)).orElse(BigDecimal.ZERO);
                                expenseEntryList.get(0).set(nonpayField, (Object)expeapprovecurramount.subtract(writeoffamount));
                            }
                            if (size <= 1) continue block0;
                            for (int index = 1; index < size; ++index) {
                                expenseEntryList.get(index).set(nonpayField, (Object)0);
                            }
                            continue block0;
                        }
                        if (i != keySet.size() || size <= 0) continue;
                        expenseEntryList.get(0).set(nonpayField, (Object)expeapprovecurramount);
                        if (size <= 1) continue;
                        for (int index = 1; index < size; ++index) {
                            expenseEntryList.get(index).set(nonpayField, (Object)0);
                        }
                    }
                    continue;
                }
                if (size <= 0) continue;
                expenseEntryList.get(0).set(nonpayField, (Object)expeapprovecurramount);
                if (size <= 1) continue;
                for (int index = 1; index < size; ++index) {
                    expenseEntryList.get(index).set(nonpayField, (Object)0);
                }
            }
        }
    }

    public static boolean upgradeAllContractData() {
        QFilter[] qFilters = new QFilter[]{new QFilter("billstatus", "in", (Object)Lists.newArrayList((Object[])new Character[]{Character.valueOf('A'), Character.valueOf('B'), Character.valueOf('C'), Character.valueOf('D'), Character.valueOf('E'), Character.valueOf('F'), Character.valueOf('J')})), new QFilter("frameworkcontract", "=", (Object)Boolean.FALSE)};
        DynamicObject[] bills = BusinessDataServiceHelper.load((String)"er_contractbill", (String)"id,billno,billstatus,notpayamount,nonpayamount,availableamount,contractcode,orinonpayamount,oriavailableamount,orinotpayamount", (QFilter[])qFilters);
        if (bills != null && bills.length > 0) {
            for (DynamicObject bill : bills) {
                PublicBillUtil.upgradeContractData(bill);
            }
            SaveServiceHelper.save((DynamicObject[])bills);
        }
        return true;
    }

    public static DynamicObject upgradeContractData(DynamicObject bill) {
        BigDecimal notPayAmount = bill.getBigDecimal("notpayamount");
        BigDecimal orinotPayAmount = bill.getBigDecimal("orinotpayamount");
        BigDecimal nonPayAmount = BigDecimal.ZERO;
        BigDecimal availableAmount = notPayAmount;
        BigDecimal orinonPayAmount = BigDecimal.ZERO;
        BigDecimal oriavailableAmount = orinotPayAmount;
        String billstatus = bill.getString("billstatus");
        if ("A".equals(billstatus) || "B".equals(billstatus) || "C".equals(billstatus) || "D".equals(billstatus)) {
            bill.set("nonpayamount", (Object)BigDecimal.ZERO);
            bill.set("availableamount", (Object)notPayAmount);
            bill.set("orinonpayamount", (Object)BigDecimal.ZERO);
            bill.set("oriavailableamount", (Object)orinotPayAmount);
            return bill;
        }
        BigDecimal[] nonPayAmountArr = PublicBillUtil.getContractBillAmount(bill, "er_prepaybill");
        nonPayAmount = nonPayAmount.add(nonPayAmountArr[0]);
        orinonPayAmount = orinonPayAmount.add(nonPayAmountArr[1]);
        nonPayAmountArr = PublicBillUtil.getContractBillAmount(bill, "er_publicreimbursebill");
        nonPayAmount = nonPayAmount.add(nonPayAmountArr[0]);
        orinonPayAmount = orinonPayAmount.add(nonPayAmountArr[1]);
        availableAmount = notPayAmount.subtract(nonPayAmount);
        oriavailableAmount = orinotPayAmount.subtract(orinonPayAmount);
        bill.set("nonpayamount", (Object)nonPayAmount);
        bill.set("availableamount", (Object)availableAmount);
        bill.set("orinonpayamount", (Object)orinonPayAmount);
        bill.set("oriavailableamount", (Object)oriavailableAmount);
        return bill;
    }

    private static BigDecimal[] getContractBillAmount(DynamicObject bill, String entityName) {
        BigDecimal[] nonPayAmountArr;
        block10: {
            QFilter[] qFilters;
            DynamicObject[] publicbillList;
            block9: {
                nonPayAmountArr = new BigDecimal[]{BigDecimal.ZERO, BigDecimal.ZERO};
                if (!"er_prepaybill".equals(entityName)) break block9;
                QFilter[] qFilters2 = new QFilter[]{new QFilter("billstatus", "in", (Object)Lists.newArrayList((Object[])new Character[]{Character.valueOf('B'), Character.valueOf('C'), Character.valueOf('E'), Character.valueOf('F')})), new QFilter("expenseentryentity.wbsrcbillid", "=", bill.getPkValue())};
                DynamicObject[] prebillList = BusinessDataServiceHelper.load((String)entityName, (String)"id,billstatus,expenseentryentity.id,expenseentryentity.wbsrcbillid,expenseentryentity.currexpenseamount,expenseentryentity.expeapprovecurramount,expenseentryentity.expeapproveamount", (QFilter[])qFilters2);
                if (prebillList != null && prebillList.length > 0) {
                    for (DynamicObject prebill : prebillList) {
                        DynamicObjectCollection exps = prebill.getDynamicObjectCollection("expenseentryentity");
                        nonPayAmountArr[0] = nonPayAmountArr[0].add(exps.stream().filter(m -> m.getLong("wbsrcbillid") == ((Long)bill.getPkValue()).longValue()).map(n -> n.getBigDecimal("expeapprovecurramount")).reduce(BigDecimal.ZERO, BigDecimal::add));
                        nonPayAmountArr[1] = nonPayAmountArr[1].add(exps.stream().filter(m -> m.getLong("wbsrcbillid") == ((Long)bill.getPkValue()).longValue()).map(n -> n.getBigDecimal("expeapproveamount")).reduce(BigDecimal.ZERO, BigDecimal::add));
                    }
                } else {
                    qFilters2 = new QFilter[]{new QFilter("billstatus", "in", (Object)Lists.newArrayList((Object[])new Character[]{Character.valueOf('B'), Character.valueOf('C'), Character.valueOf('E'), Character.valueOf('F')})), new QFilter("contractentry.contractsid", "=", bill.getPkValue())};
                    for (DynamicObject prebill : prebillList = BusinessDataServiceHelper.load((String)entityName, (String)"id,billstatus,contractentry.id,contractentry.contractsid,contractentry.contractcurrwriteoff,contractentry.contractwriteoff", (QFilter[])qFilters2)) {
                        DynamicObjectCollection exps = prebill.getDynamicObjectCollection("contractentry");
                        nonPayAmountArr[0] = nonPayAmountArr[0].add(exps.stream().filter(m -> m.getLong("contractsid") == ((Long)bill.getPkValue()).longValue()).map(n -> n.getBigDecimal("contractcurrwriteoff")).reduce(BigDecimal.ZERO, BigDecimal::add));
                        nonPayAmountArr[1] = nonPayAmountArr[1].add(exps.stream().filter(m -> m.getLong("contractsid") == ((Long)bill.getPkValue()).longValue()).map(n -> n.getBigDecimal("contractwriteoff")).reduce(BigDecimal.ZERO, BigDecimal::add));
                    }
                }
                break block10;
            }
            if (!"er_publicreimbursebill".equals(entityName) || (publicbillList = BusinessDataServiceHelper.load((String)"er_publicreimbursebill", (String)"id,billstatus,contractentry.id,contractentry.contractcurrwriteoff,contractentry.contractwriteoff,contractentry.contractsid,writeoffmoney.id,writeoffmoney.loancontractno,writeoffmoney.sourcebillid,writeoffmoney.srcbilltype,writeoffmoney.curraccloanamount,writeoffmoney.accloanamount,writeoffmoney.loanbillnov1", (QFilter[])(qFilters = new QFilter[]{new QFilter("billstatus", "in", (Object)Lists.newArrayList((Object[])new Character[]{Character.valueOf('B'), Character.valueOf('C'), Character.valueOf('E'), Character.valueOf('F')})), new QFilter("contractentry.contractsid", "=", bill.getPkValue())}))) == null || publicbillList.length <= 0) break block10;
            for (DynamicObject publicbill : publicbillList) {
                BigDecimal totalContractcurrwriteoff = BigDecimal.ZERO;
                BigDecimal totalLoanAmount = BigDecimal.ZERO;
                BigDecimal oritotalLoanAmount = BigDecimal.ZERO;
                BigDecimal totalContractwriteoff = BigDecimal.ZERO;
                DynamicObjectCollection exps = publicbill.getDynamicObjectCollection("contractentry");
                DynamicObjectCollection writeoffcoll = publicbill.getDynamicObjectCollection("writeoffmoney");
                if (exps != null && exps.size() > 0) {
                    totalContractcurrwriteoff = exps.stream().filter(m -> m.getLong("contractsid") == ((Long)bill.getPkValue()).longValue()).map(n -> n.getBigDecimal("contractcurrwriteoff")).reduce(BigDecimal.ZERO, BigDecimal::add);
                    totalContractwriteoff = exps.stream().filter(m -> m.getLong("contractsid") == ((Long)bill.getPkValue()).longValue()).map(n -> n.getBigDecimal("contractwriteoff")).reduce(BigDecimal.ZERO, BigDecimal::add);
                }
                if (writeoffcoll != null && writeoffcoll.size() > 0) {
                    for (DynamicObject writeoff : writeoffcoll) {
                        String loancontractno = writeoff.getString("loancontractno");
                        if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)loancontractno)) {
                            if (!loancontractno.equals(bill.getString("contractcode"))) continue;
                            totalLoanAmount = totalLoanAmount.add(writeoff.getBigDecimal("curraccloanamount"));
                            oritotalLoanAmount = oritotalLoanAmount.add(writeoff.getBigDecimal("accloanamount"));
                            continue;
                        }
                        QFilter qfilter = new QFilter("billno", "=", (Object)writeoff.getString("loanbillnov1")).and("contractentry.contractsid", "=", bill.getPkValue());
                        if (!QueryServiceHelper.exists((String)"er_prepaybill", (QFilter[])new QFilter[]{qfilter})) continue;
                        totalLoanAmount = totalLoanAmount.add(writeoff.getBigDecimal("curraccloanamount"));
                        oritotalLoanAmount = oritotalLoanAmount.add(writeoff.getBigDecimal("accloanamount"));
                    }
                }
                nonPayAmountArr[0] = nonPayAmountArr[0].add(totalContractcurrwriteoff.subtract(totalLoanAmount));
                nonPayAmountArr[1] = nonPayAmountArr[1].add(totalContractwriteoff.subtract(oritotalLoanAmount));
            }
        }
        return nonPayAmountArr;
    }

    public static boolean deleteExpEntryBypayerChanged(IDataModel model, IFormView view) {
        Boolean isDelete = Boolean.TRUE;
        if (ErEntityTypeUtils.isPublicReimburseBill(view.getEntityId())) {
            String relationContract = (String)model.getValue("relationcontract");
            String ispush = (String)model.getValue("ispush");
            if ("1".equals(relationContract) && !"true".equals(ispush)) {
                isDelete = Boolean.FALSE;
            }
        } else if (ErEntityTypeUtils.isPrePayBill(view.getEntityId())) {
            String relationContract = (String)model.getValue("relationcontract");
            Boolean ispush = (Boolean)model.getValue("ispush");
            if ("1".equals(relationContract) && !ispush.booleanValue()) {
                isDelete = Boolean.FALSE;
            }
            if (ispush.booleanValue()) {
                HashSet setparts = new HashSet();
                Long wbsrcbillid = (Long)model.getValue("wbsrcbillid", 0);
                DynamicObject supplierOrCustomer = BusinessDataServiceHelper.loadSingle((String)"er_contractbill", (String)"contractpartyentry.contractparty", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)wbsrcbillid)});
                if (supplierOrCustomer != null) {
                    setparts.addAll(supplierOrCustomer.getDynamicObjectCollection("contractpartyentry").stream().map(v -> ((DynamicObject)v.get("contractparty")).getPkValue()).collect(Collectors.toSet()));
                    DynamicObject billpayerid = (DynamicObject)model.getValue("billpayerid");
                    if (billpayerid != null && setparts.contains(billpayerid.getPkValue())) {
                        isDelete = Boolean.FALSE;
                    }
                }
            }
        }
        return isDelete;
    }

    private static BigDecimal getCostimateAmount(DynamicObject bill) {
        BigDecimal costimateAmount = BigDecimal.ZERO;
        QFilter[] qFilters = new QFilter[]{new QFilter("billstatus", "in", (Object)Lists.newArrayList((Object[])new Character[]{Character.valueOf('B'), Character.valueOf('C'), Character.valueOf('E'), Character.valueOf('I')})), new QFilter("expenseentryentity.wbsrcbillid", "=", bill.getPkValue())};
        DynamicObject[] costestimatebillList = BusinessDataServiceHelper.load((String)"er_costestimatebill", (String)"id,expenseentryentity.id,expenseentryentity.wbsrcbillid,expenseentryentity.currexpenseamount,expenseentryentity.expeapprovecurramount", (QFilter[])qFilters);
        if (costestimatebillList != null && costestimatebillList.length > 0) {
            for (DynamicObject costestimatebill : costestimatebillList) {
                DynamicObjectCollection exps = costestimatebill.getDynamicObjectCollection("expenseentryentity");
                costimateAmount = costimateAmount.add(exps.stream().filter(m -> m.getLong("wbsrcbillid") == ((Long)bill.getPkValue()).longValue()).map(n -> n.getBigDecimal("expeapprovecurramount")).reduce(BigDecimal.ZERO, BigDecimal::add));
            }
        }
        return costimateAmount;
    }

    public static void showInvoiceEntry(IFormView view) {
        String entityId = view.getEntityId();
        if (!(ErEntityTypeUtils.isDailyReimburseBill(entityId) || ErEntityTypeUtils.isPublicReimburseBill(entityId) || ErEntityTypeUtils.isTripReimburseBill(entityId))) {
            return;
        }
        IDataModel model = view.getModel();
        String billstatus = (String)model.getValue("billstatus");
        if (!"A".equals(billstatus)) {
            return;
        }
        DynamicObject costcompany = (DynamicObject)model.getValue("costcompany");
        if (costcompany == null) {
            return;
        }
        InvoiceCloudCfgBO config = KingdeeInvoiceCloudConfig.getConfig((Long)costcompany.getPkValue());
        if (config != null && !((Boolean)model.getValue("automapinvoice")).booleanValue()) {
            AdvContainer invoiceAdvContainer = (AdvContainer)view.getControl("invoice_entry_container");
            invoiceAdvContainer.setCollapse(false);
        }
    }

    public static void updateContractWriteoffView(IDataModel model, IFormView view) {
        DynamicObjectCollection contractentryList = model.getEntryEntity("contractentry");
        if (contractentryList != null && contractentryList.size() > 0) {
            for (int i = 0; i < contractentryList.size(); ++i) {
                view.updateView("contractwriteoff", i);
                view.updateView("contractcurrwriteoff", i);
            }
        }
    }

    public static void refreshSuplier(IDataModel model, String prop, Long companyId) {
        String unitType;
        if (model.getProperty("billpayerid") == null) {
            return;
        }
        if (model.getProperty("billpayertype") != null && !(unitType = (String)model.getValue("billpayertype")).equals("bd_supplier") && !unitType.equals("bd_customer")) {
            return;
        }
        String type = SystemParamterUtil.getPublicCurrentUnit(companyId);
        if (type == null) {
            type = "1";
        }
        switch (type) {
            case "1": {
                if (!org.apache.commons.lang3.StringUtils.equals((CharSequence)prop, (CharSequence)"costcompany")) {
                    return;
                }
                model.setValue("billpayerid", null);
                break;
            }
            case "2": {
                if (!org.apache.commons.lang3.StringUtils.equals((CharSequence)prop, (CharSequence)"company")) {
                    return;
                }
                model.setValue("billpayerid", null);
            }
        }
    }

    public static void closebill(DynamicObject[] dataEntities) {
        if (dataEntities != null && dataEntities.length > 0) {
            for (int i = 0; i < dataEntities.length; ++i) {
                DynamicObject[] applyprojectList;
                Set idList;
                BigDecimal availableamount;
                DynamicObject dataEntity = dataEntities[i];
                String billstatus = dataEntity.getString("billstatus");
                DynamicObjectCollection expenseCollection = dataEntity.getDynamicObjectCollection("expenseentryentity");
                if (ErEntityTypeUtils.isPrePayBill(dataEntity.getDataEntityType().getName()) || ErEntityTypeUtils.isPublicReimburseBill(dataEntity.getDataEntityType().getName())) {
                    Object contractIdList;
                    Boolean frameworkcontract = dataEntity.getBoolean("frameworkcontract");
                    DynamicObjectCollection contractCollection = dataEntity.getDynamicObjectCollection("contractentry");
                    if ("B".equals(billstatus) || "C".equals(billstatus) || "E".equals(billstatus) || "F".equals(billstatus)) {
                        DynamicObject[] contractList;
                        String billno;
                        if (expenseCollection != null && !expenseCollection.isEmpty()) {
                            DynamicObject[] contractList2;
                            BigDecimal availableamount2;
                            Long wbsrcbillid = ((DynamicObject)expenseCollection.get(0)).getLong("wbsrcbillid");
                            String wbsrcbilltype = ((DynamicObject)expenseCollection.get(0)).getString("wbsrcbilltype");
                            Set idList2 = expenseCollection.stream().map(exp -> exp.getLong("wbsrcbillid")).collect(Collectors.toSet());
                            if (wbsrcbillid != 0L && ("er_applyprojectbill".equals(wbsrcbilltype) || "project".equals(wbsrcbilltype))) {
                                DynamicObject[] applyprojectList2;
                                if (idList2 != null && idList2.size() > 0 && (applyprojectList2 = BusinessDataServiceHelper.load((String)"er_applyprojectbill", (String)"id,payamount,acapproveamount,nonpayamount,notpayamount,availableamount,billno", (QFilter[])new QFilter[]{new QFilter("id", "in", idList2)})) != null && applyprojectList2.length > 0) {
                                    for (DynamicObject applyproject : applyprojectList2) {
                                        BigDecimal nonPayAmount = applyproject.getBigDecimal("nonpayamount");
                                        BigDecimal notPayAmount = applyproject.getBigDecimal("notpayamount");
                                        availableamount2 = applyproject.getBigDecimal("availableamount");
                                        BigDecimal payamount = applyproject.getBigDecimal("payamount");
                                        billno = applyproject.getString("billno");
                                        BigDecimal expnonpayamount = expenseCollection.stream().filter(m -> m.getLong("wbsrcbillid") == ((Long)applyproject.getPkValue()).longValue()).map(n -> n.getBigDecimal("expnonpayamount")).reduce(BigDecimal.ZERO, BigDecimal::add);
                                        logger.info(billno + "\u5173\u95ed\u524d---nonPayAmount---" + nonPayAmount + "---notPayAmount---" + notPayAmount + "---availableamount---" + availableamount2 + "---expnonpayamount---" + expnonpayamount);
                                        nonPayAmount = nonPayAmount.subtract(expnonpayamount);
                                        payamount = payamount.add(expnonpayamount);
                                        notPayAmount = notPayAmount.subtract(expnonpayamount);
                                        applyproject.set("nonpayamount", (Object)nonPayAmount);
                                        applyproject.set("payamount", (Object)payamount);
                                        applyproject.set("notPayAmount", (Object)notPayAmount);
                                    }
                                    SaveServiceHelper.save((DynamicObject[])applyprojectList2);
                                }
                            } else if (wbsrcbillid != 0L && ("er_contractbill".equals(wbsrcbilltype) || "contract".equals(wbsrcbilltype)) && !frameworkcontract.booleanValue() && ErEntityTypeUtils.isPrePayBill(dataEntity.getDataEntityType().getName()) && idList2 != null && idList2.size() > 0 && (contractList2 = BusinessDataServiceHelper.load((String)"er_contractbill", (String)"id,notpayamount,nonpayamount,availableamount,billno,orinotpayamount,orinonpayamount,oriavailableamount", (QFilter[])new QFilter[]{new QFilter("id", "in", idList2)})) != null && contractList2.length > 0) {
                                for (DynamicObject contract : contractList2) {
                                    BigDecimal notpayamount = contract.getBigDecimal("notpayamount");
                                    BigDecimal nonPayAmount = contract.getBigDecimal("nonpayamount");
                                    availableamount2 = contract.getBigDecimal("availableamount");
                                    BigDecimal orinotpayamount = contract.getBigDecimal("orinotpayamount");
                                    BigDecimal orinonpayAmount = contract.getBigDecimal("orinonpayamount");
                                    BigDecimal oriavailableamount = contract.getBigDecimal("oriavailableamount");
                                    String billno2 = contract.getString("billno");
                                    BigDecimal expnonpayamount = expenseCollection.stream().filter(m -> m.getLong("wbsrcbillid") == ((Long)contract.getPkValue()).longValue()).map(n -> n.getBigDecimal("expnonpayamount")).reduce(BigDecimal.ZERO, BigDecimal::add);
                                    BigDecimal expeapproveamount = expenseCollection.stream().filter(m -> m.getLong("wbsrcbillid") == ((Long)contract.getPkValue()).longValue()).map(n -> n.getBigDecimal("expeapproveamount")).reduce(BigDecimal.ZERO, BigDecimal::add);
                                    logger.info(billno2 + "\u5173\u95ed\u524d---nonPayAmount---" + nonPayAmount + "---availableamount---" + availableamount2 + "---expnonpayamount---" + expnonpayamount + "---expeapproveamount---" + expeapproveamount);
                                    nonPayAmount = nonPayAmount.subtract(expnonpayamount);
                                    availableamount2 = notpayamount.subtract(nonPayAmount);
                                    orinonpayAmount = orinonpayAmount.subtract(expeapproveamount);
                                    oriavailableamount = orinotpayamount.subtract(orinonpayAmount);
                                    contract.set("nonpayamount", (Object)nonPayAmount);
                                    contract.set("availableamount", (Object)availableamount2);
                                    contract.set("orinonpayAmount", (Object)orinonpayAmount);
                                    contract.set("oriavailableamount", (Object)oriavailableamount);
                                }
                                SaveServiceHelper.save((DynamicObject[])contractList2);
                            }
                        }
                        if (contractCollection != null && !contractCollection.isEmpty() && !frameworkcontract.booleanValue() && (contractIdList = contractCollection.stream().map(exp -> exp.getLong("contractsid")).collect(Collectors.toSet())) != null && contractIdList.size() > 0 && (contractList = BusinessDataServiceHelper.load((String)"er_contractbill", (String)"id,notpayamount,nonpayamount,availableamount,billno,orinotpayamount,orinonpayamount,oriavailableamount", (QFilter[])new QFilter[]{new QFilter("id", "in", contractIdList)})) != null && contractList.length > 0) {
                            for (DynamicObject contract : contractList) {
                                BigDecimal notpayamount = contract.getBigDecimal("notpayamount");
                                BigDecimal nonPayAmount = contract.getBigDecimal("nonpayamount");
                                availableamount = contract.getBigDecimal("availableamount");
                                BigDecimal orinotpayamount = contract.getBigDecimal("orinotpayamount");
                                BigDecimal orinonpayamount = contract.getBigDecimal("orinonpayamount");
                                BigDecimal oriavailableamount = contract.getBigDecimal("oriavailableamount");
                                billno = contract.getString("billno");
                                BigDecimal contractnonpayamount = BigDecimal.ZERO;
                                BigDecimal oricontractnonpayamount = BigDecimal.ZERO;
                                if (ErEntityTypeUtils.isPublicReimburseBill(dataEntity.getDataEntityType().getName())) {
                                    contractnonpayamount = contractCollection.stream().filter(m -> m.getLong("contractsid") == ((Long)contract.getPkValue()).longValue()).map(n -> n.getBigDecimal("contractnonpayamount")).reduce(BigDecimal.ZERO, BigDecimal::add);
                                    oricontractnonpayamount = contractCollection.stream().filter(m -> m.getLong("contractsid") == ((Long)contract.getPkValue()).longValue()).map(n -> n.getBigDecimal("oricontractnonpayamount")).reduce(BigDecimal.ZERO, BigDecimal::add);
                                } else {
                                    contractnonpayamount = contractCollection.stream().filter(m -> m.getLong("contractsid") == ((Long)contract.getPkValue()).longValue()).map(n -> n.getBigDecimal("contractcurrwriteoff")).reduce(BigDecimal.ZERO, BigDecimal::add);
                                    oricontractnonpayamount = contractCollection.stream().filter(m -> m.getLong("contractsid") == ((Long)contract.getPkValue()).longValue()).map(n -> n.getBigDecimal("contractwriteoff")).reduce(BigDecimal.ZERO, BigDecimal::add);
                                }
                                logger.info(billno + "\u5173\u95ed\u524d---nonPayAmount---" + nonPayAmount + "---availableamount---" + availableamount + "---contractnonpayamount---" + contractnonpayamount);
                                nonPayAmount = nonPayAmount.subtract(contractnonpayamount);
                                availableamount = notpayamount.subtract(nonPayAmount);
                                orinonpayamount = orinonpayamount.subtract(oricontractnonpayamount);
                                oriavailableamount = orinotpayamount.subtract(orinonpayamount);
                                contract.set("nonpayamount", (Object)nonPayAmount);
                                contract.set("availableamount", (Object)availableamount);
                                contract.set("orinonpayamount", (Object)orinonpayamount);
                                contract.set("oriavailableamount", (Object)oriavailableamount);
                            }
                            SaveServiceHelper.save((DynamicObject[])contractList);
                        }
                    }
                    if (expenseCollection != null && !expenseCollection.isEmpty() && !frameworkcontract.booleanValue()) {
                        contractIdList = expenseCollection.iterator();
                        while (contractIdList.hasNext()) {
                            DynamicObject expense = (DynamicObject)contractIdList.next();
                            expense.set("expnonpayamount", (Object)BigDecimal.ZERO);
                        }
                    }
                    if (contractCollection == null || contractCollection.isEmpty() || frameworkcontract.booleanValue() || !ErEntityTypeUtils.isPublicReimburseBill(dataEntity.getDataEntityType().getName())) continue;
                    contractIdList = contractCollection.iterator();
                    while (contractIdList.hasNext()) {
                        DynamicObject contract = (DynamicObject)contractIdList.next();
                        contract.set("contractnonpayamount", (Object)BigDecimal.ZERO);
                        contract.set("oricontractnonpayamount", (Object)BigDecimal.ZERO);
                    }
                    continue;
                }
                if (!ErEntityTypeUtils.isDailyLoanBill(dataEntity.getDataEntityType().getName()) || expenseCollection == null || expenseCollection.isEmpty()) continue;
                Long wbsrcbillid = ((DynamicObject)expenseCollection.get(0)).getLong("sourcebillid");
                String applyprojectno = ((DynamicObject)expenseCollection.get(0)).getString("applyprojectno");
                if (wbsrcbillid == 0L || org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)applyprojectno) || !"B".equals(billstatus) && !"C".equals(billstatus) && !"E".equals(billstatus) && !"F".equals(billstatus) || (idList = expenseCollection.stream().map(exp -> exp.getLong("sourcebillid")).collect(Collectors.toSet())) == null || idList.size() <= 0 || (applyprojectList = BusinessDataServiceHelper.load((String)"er_applyprojectbill", (String)"id,payamount,acapproveamount,nonpayamount,notpayamount,availableamount,billno", (QFilter[])new QFilter[]{new QFilter("id", "in", idList)})) == null || applyprojectList.length <= 0) continue;
                for (DynamicObject applyproject : applyprojectList) {
                    BigDecimal nonPayAmount = applyproject.getBigDecimal("nonpayamount");
                    BigDecimal notPayAmount = applyproject.getBigDecimal("notpayamount");
                    availableamount = applyproject.getBigDecimal("availableamount");
                    BigDecimal payamount = applyproject.getBigDecimal("payamount");
                    String billno = applyproject.getString("billno");
                    BigDecimal expnonpayamount = expenseCollection.stream().filter(m -> m.getLong("sourcebillid") == ((Long)applyproject.getPkValue()).longValue()).map(n -> n.getBigDecimal("expeapprovecurramount")).reduce(BigDecimal.ZERO, BigDecimal::add);
                    logger.info(billno + "----\u5173\u95ed\u524d---nonPayAmount---" + nonPayAmount + "---notPayAmount---" + notPayAmount + "---availableamount---" + availableamount + "---expnonpayamount---" + expnonpayamount);
                    nonPayAmount = nonPayAmount.subtract(expnonpayamount);
                    payamount = payamount.add(expnonpayamount);
                    notPayAmount = notPayAmount.subtract(expnonpayamount);
                    applyproject.set("nonpayamount", (Object)nonPayAmount);
                    applyproject.set("payamount", (Object)payamount);
                    applyproject.set("notPayAmount", (Object)notPayAmount);
                    logger.info(billno + "----\u5173\u95ed\u540e---nonPayAmount---" + nonPayAmount + "---notPayAmount---" + notPayAmount + "---availableamount---" + availableamount);
                }
                SaveServiceHelper.save((DynamicObject[])applyprojectList);
            }
        }
    }

    public static void calPreContractRefundMoney(DynamicObject bill) {
        Boolean frameworkcontract = bill.getBoolean("frameworkcontract");
        Boolean ispush = bill.getBoolean("ispush");
        String writeOffType = (String)ErCommonUtils.getEMParameter(ErCommonUtils.getPk(bill.get("company")), "er010");
        DynamicObjectCollection contractentry = bill.getDynamicObjectCollection("contractentry");
        if (ispush.booleanValue() || contractentry == null || contractentry.size() == 0) {
            return;
        }
        int curprecision = -1;
        DynamicObject currency = bill.getDynamicObject("currency");
        if (currency != null) {
            curprecision = AmountUtils.getCurrencyPrecision(ErCommonUtils.getPk(currency));
        }
        if (frameworkcontract.booleanValue()) {
            DynamicObjectCollection expcoll = bill.getDynamicObjectCollection("expenseentryentity");
            DynamicObject contractexpcurrency = ((DynamicObject)contractentry.get(0)).getDynamicObject("contractexpcurrency");
            int amtprecision = 4;
            if (contractexpcurrency != null) {
                amtprecision = contractexpcurrency.getInt("amtprecision");
            }
            if ("1".equals(writeOffType)) {
                BigDecimal expeorirepayamount = BigDecimal.ZERO;
                if (expcoll != null && expcoll.size() > 0) {
                    for (DynamicObject exp : expcoll) {
                        if (exp == null || exp.getDynamicObject("entrycurrency") == null || contractexpcurrency == null || exp.getDynamicObject("entrycurrency").getPkValue() != contractexpcurrency.getPkValue()) continue;
                        expeorirepayamount = expeorirepayamount.add(exp.getBigDecimal("expeorirepayamount"));
                    }
                }
                if (curprecision == -1) {
                    curprecision = amtprecision;
                }
                BigDecimal experepayamount = AmountUtils.getCurrencyAmount(expeorirepayamount, ((DynamicObject)contractentry.get(0)).getBigDecimal("contractexpchangerate"), curprecision, ((DynamicObject)contractentry.get(0)).getString("contractexpquotetype"));
                ((DynamicObject)contractentry.get(0)).set("oriconrepayamount", (Object)expeorirepayamount);
                ((DynamicObject)contractentry.get(0)).set("conrepayamount", (Object)experepayamount);
            } else {
                BigDecimal experepayamount = expcoll.stream().map(e -> (BigDecimal)e.get("experepayamount")).reduce((a, b) -> a.add((BigDecimal)b)).orElse(BigDecimal.ZERO);
                BigDecimal expeorirepayamount = AmountUtils.getOriAmount(experepayamount, ((DynamicObject)contractentry.get(0)).getBigDecimal("contractexpchangerate"), amtprecision, ((DynamicObject)contractentry.get(0)).getString("contractexpquotetype"));
                ((DynamicObject)contractentry.get(0)).set("oriconrepayamount", (Object)expeorirepayamount);
                ((DynamicObject)contractentry.get(0)).set("conrepayamount", (Object)experepayamount);
            }
        } else if ("1".equals(writeOffType)) {
            Set<Long> expeIds = AmountUtils.getCurrencyIdSet(bill, "expenseentryentity", "entrycurrency");
            Set<Long> woIds = AmountUtils.getCurrencyIdSet(bill, "contractentry", "contractexpcurrency");
            HashSet totalIds = Sets.newHashSet();
            totalIds.addAll(woIds);
            totalIds.addAll(expeIds);
            int len = expeIds.size() + woIds.size();
            if (totalIds.size() == len) {
                for (int i = 0; i < contractentry.size(); ++i) {
                    ((DynamicObject)contractentry.get(i)).set("oriconrepayamount", (Object)BigDecimal.ZERO);
                    ((DynamicObject)contractentry.get(i)).set("conrepayamount", (Object)BigDecimal.ZERO);
                }
            } else {
                DynamicObjectCollection expeColl = bill.getDynamicObjectCollection("expenseentryentity");
                Map<String, BigDecimal> expeCurrcyAmount = AmountUtils.groupByCurrency(expeColl, "entrycurrency", "expeorirepayamount");
                for (Map.Entry<String, BigDecimal> entry : expeCurrcyAmount.entrySet()) {
                    if (entry.getValue().compareTo(BigDecimal.ZERO) < 0) continue;
                    for (int i = 0; i < contractentry.size(); ++i) {
                        DynamicObject woDynamicObject = (DynamicObject)contractentry.get(i);
                        String currcyId = "";
                        if (woDynamicObject.get("contractexpcurrency") != null) {
                            currcyId = ((DynamicObject)woDynamicObject.get("contractexpcurrency")).getPkValue().toString();
                        }
                        if (entry.getKey().equals(currcyId)) {
                            if (entry.getValue().compareTo(woDynamicObject.getBigDecimal("contractwriteoff")) > 0) {
                                woDynamicObject.set("oriconrepayamount", (Object)woDynamicObject.getBigDecimal("contractwriteoff"));
                                woDynamicObject.set("conrepayamount", (Object)woDynamicObject.getBigDecimal("contractcurrwriteoff"));
                                entry.setValue(entry.getValue().subtract(woDynamicObject.getBigDecimal("contractwriteoff")));
                            } else {
                                woDynamicObject.set("oriconrepayamount", (Object)entry.getValue());
                                BigDecimal woExchageRate = woDynamicObject.getBigDecimal("contractexpchangerate");
                                if (woExchageRate == null || woExchageRate.compareTo(BigDecimal.ZERO) == 0) {
                                    woExchageRate = BigDecimal.ONE;
                                }
                                String quoteType = woDynamicObject.getString("contractexpquotetype") == null ? "0" : (String)woDynamicObject.get("contractexpquotetype");
                                int precision = AmountUtils.getAmountFieldPrecision(woDynamicObject, "conrepayamount");
                                if (curprecision == -1) {
                                    curprecision = precision;
                                }
                                woDynamicObject.set("conrepayamount", (Object)AmountUtils.getCurrencyAmount(entry.getValue(), woExchageRate, curprecision, quoteType));
                                entry.setValue(BigDecimal.ZERO);
                            }
                        }
                        if (expeCurrcyAmount.containsKey(currcyId)) continue;
                        woDynamicObject.set("oriconrepayamount", (Object)BigDecimal.ZERO);
                        woDynamicObject.set("conrepayamount", (Object)BigDecimal.ZERO);
                    }
                }
            }
        } else {
            DynamicObjectCollection expEntrys = bill.getDynamicObjectCollection("expenseentryentity");
            BigDecimal experepayamount = AmountUtils.getEntryAmount(expEntrys, "experepayamount");
            for (int i = 0; i < contractentry.size(); ++i) {
                DynamicObject woEntry = (DynamicObject)contractentry.get(i);
                if (experepayamount.compareTo(BigDecimal.ZERO) > 0) {
                    BigDecimal contractcurrwriteoff = woEntry.getBigDecimal("contractcurrwriteoff");
                    BigDecimal conrepayamount = BigDecimal.ZERO;
                    conrepayamount = contractcurrwriteoff.compareTo(experepayamount) > 0 ? experepayamount : contractcurrwriteoff;
                    woEntry.set("conrepayamount", (Object)conrepayamount);
                    BigDecimal woExchageRate = woEntry.getBigDecimal("contractexpchangerate");
                    if (woExchageRate == null || woExchageRate.compareTo(BigDecimal.ZERO) == 0) {
                        woExchageRate = BigDecimal.ONE;
                    }
                    String quoteType = woEntry.getString("contractexpquotetype") == null ? "0" : (String)woEntry.get("contractexpquotetype");
                    int precision = AmountUtils.getAmountFieldPrecision(woEntry, "conrepayamount");
                    if ("0".equals(quoteType)) {
                        woEntry.set("oriconrepayamount", (Object)conrepayamount.divide(woExchageRate, precision, RoundingMode.HALF_UP));
                    } else {
                        woEntry.set("oriconrepayamount", (Object)conrepayamount.multiply(woExchageRate).setScale(precision, RoundingMode.HALF_UP));
                    }
                    experepayamount = experepayamount.subtract(conrepayamount);
                    continue;
                }
                woEntry.set("oriconrepayamount", (Object)BigDecimal.ZERO);
                woEntry.set("conrepayamount", (Object)BigDecimal.ZERO);
            }
        }
    }

    static {
        logger = LogFactory.getLog(PublicBillUtil.class);
        HashMap<String, String> temp = new HashMap<String, String>();
        temp.put("bd_supplier", "bd_supplier");
        temp.put("bd_customer", "bd_customer");
        temp.put("bos_user", "er_payeer");
        PAYERTYPE = Collections.unmodifiableMap(temp);
    }
}

