/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.pub;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.dataentity.RefObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.script.annotations.KSMethod;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.fi.er.business.utils.ActionLocalCache;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.business.utils.ErEntityTypeUtils;
import kd.fi.er.business.utils.SystemParamterUtil;
import kd.fi.er.model.EntityInfo;
import kd.sdk.annotation.SdkPublic;
import org.apache.commons.lang3.StringUtils;

@SdkPublic
public class PublicUpBillUtil {
    private static Log logger = LogFactory.getLog(PublicUpBillUtil.class);

    public static QFilter getPublicUpBill(String formId, Long wlunit, Long applier, Long companyId, Long costCompanyId, String detailtype, String reimbursetype, boolean filterSup) {
        QFilter q;
        QFilter unitQF;
        QFilter qFilter = null;
        String sourceCostCompanyName = "expenseentryentity.entrycostcompany";
        String costCompanyName = "costcompany";
        if (ErEntityTypeUtils.isPrePayBill(formId)) {
            qFilter = new QFilter("expenseentryentity.canloanamount", ">", (Object)BigDecimal.ZERO).and("billstatus", "=", (Object)"E");
            if (wlunit != null) {
                if (!filterSup) {
                    unitQF = new QFilter("expenseentryentity.entrywlunit", "=", (Object)wlunit);
                    unitQF.or(new QFilter("expenseentryentity.entrywlunit", "=", (Object)0));
                    qFilter.and(unitQF);
                } else {
                    qFilter.and("expenseentryentity.entrywlunit", "=", (Object)wlunit);
                }
            }
        } else if (ErEntityTypeUtils.isCostEstimateBill(formId)) {
            qFilter = new QFilter("expenseentryentity.orgiexpebalanceamount", ">", (Object)BigDecimal.ZERO).and("billstatus", "=", (Object)"E").and("detailtype", "=", (Object)"biztype_applybill");
        } else if (ErEntityTypeUtils.isPublicReimburseBill(formId)) {
            qFilter = new QFilter("1", "=", (Object)1);
            if (wlunit != null) {
                if (!filterSup) {
                    unitQF = new QFilter("expenseentryentity.entrywlunit", "=", (Object)wlunit);
                    unitQF.or(new QFilter("expenseentryentity.entrywlunit", "=", (Object)0));
                    qFilter.and(unitQF);
                } else {
                    qFilter.and("expenseentryentity.entrywlunit", "=", (Object)wlunit);
                }
            }
            if (detailtype.equals("biztype_project")) {
                qFilter = qFilter.and(new QFilter("expenseentryentity.orgiexpebalanceamount", ">", (Object)BigDecimal.ZERO).and("billstatus", "=", (Object)"E").and("detailtype", "=", (Object)"biztype_applybill"));
            }
            if (detailtype.equals("biztype_estimate") || detailtype.equals("biztype_contractestimate")) {
                qFilter = StringUtils.equalsIgnoreCase((CharSequence)reimbursetype, (CharSequence)"asset") ? qFilter.and(new QFilter("detailtype", "=", (Object)"biztype_applyassetbill")) : qFilter.and(new QFilter("detailtype", "=", (Object)"biztype_applybill"));
                String relationContract = SystemParamterUtil.getRelationContract(companyId);
                if ("0".equals(relationContract)) {
                    qFilter = detailtype.equals("biztype_contractestimate") ? qFilter.and(new QFilter("relatedbiz", "=", (Object)"biztype_contract")) : qFilter.and(new QFilter("relatedbiz", "!=", (Object)"biztype_contract"));
                }
            }
        }
        if ((q = PublicUpBillUtil.getPublicUpBillQfilter(applier, companyId, costCompanyId, sourceCostCompanyName)) != null && qFilter != null) {
            qFilter.and(q);
        }
        return qFilter;
    }

    public static QFilter getPublicUpBillQfilter(Long applier, Long companyId, Long costCompanyId, String sourceCostCompanyName) {
        QFilter qFilter = null;
        RefObject refObject = new RefObject();
        String entityId = (String)ActionLocalCache.get().getDefaultIfNull("setFilter.entityId", "");
        if (StringUtils.isNotBlank((CharSequence)entityId) && ErEntityTypeUtils.isCheckingpayBill(entityId)) {
            Optional.ofNullable(companyId).ifPresent(t -> refObject.setValue((Object)SystemParamterUtil.getTripUpBillRange(companyId)));
        } else {
            Optional.ofNullable(companyId).ifPresent(t -> refObject.setValue((Object)SystemParamterUtil.getPublicupbillrange(companyId)));
        }
        String sysParamValue = (String)refObject.getValue();
        if (StringUtils.isBlank((CharSequence)sysParamValue)) {
            return qFilter;
        }
        switch (sysParamValue) {
            case "1": {
                qFilter = new QFilter("projectower.FBASEDATAID_id", "in", Collections.singletonList(applier));
                qFilter.or("applier", "=", (Object)applier);
                qFilter.and(sourceCostCompanyName, "=", (Object)costCompanyId);
                break;
            }
            case "2": {
                qFilter = new QFilter("projectower.FBASEDATAID_id", "in", Collections.singletonList(applier));
                qFilter.or("applier", "=", (Object)applier);
                qFilter.and("company", "=", (Object)companyId);
                break;
            }
            case "3": {
                qFilter = new QFilter("company", "=", (Object)companyId);
                break;
            }
            case "4": {
                qFilter = new QFilter(sourceCostCompanyName, "=", (Object)costCompanyId);
                break;
            }
            case "5": {
                qFilter = new QFilter("projectower.FBASEDATAID_id", "in", Collections.singletonList(applier));
                qFilter.or("applier", "=", (Object)applier);
                break;
            }
        }
        return qFilter;
    }

    public static void deleteEntryByBillpayerChanged(IFormView view) {
        Object billpayeridObj;
        IDataModel model = view.getModel();
        DynamicObjectCollection expenseEntry = model.getDataEntity().getDynamicObjectCollection("expenseentryentity");
        if (model.getValue("detailtype") != null && "biztype_project".equals(model.getValue("detailtype").toString())) {
            model.deleteEntryData("writeoffapply");
        }
        if ((billpayeridObj = model.getValue("billpayerid")) != null) {
            Object billpayerid = ((DynamicObject)billpayeridObj).getPkValue();
            DynamicObjectCollection writeOffMoneyEntries = model.getDataEntity().getDynamicObjectCollection("writeoffmoney");
            ArrayList<Integer> indexToRemoveLst = new ArrayList<Integer>(writeOffMoneyEntries.size());
            for (int i = 0; i < writeOffMoneyEntries.size(); ++i) {
                DynamicObject entry = (DynamicObject)writeOffMoneyEntries.get(i);
                Object srcentrywlunit_id = entry.get("srcentrywlunit_id");
                if (billpayerid.equals(srcentrywlunit_id)) continue;
                indexToRemoveLst.add(i);
            }
            int[] array = indexToRemoveLst.stream().mapToInt(v -> v).toArray();
            view.getModel().deleteEntryRows("writeoffmoney", array);
        }
    }

    public static QFilter getContractCostCompanyFilter(Long costCompany, Long company) {
        String sysParamValue;
        QFilter qFilter = null;
        switch (sysParamValue = SystemParamterUtil.getPublicupbillrange(company)) {
            case "1": {
                qFilter = new QFilter("contract.fiaccountorg.id", "=", (Object)costCompany);
                break;
            }
            case "2": {
                qFilter = new QFilter("contract.org.id", "=", (Object)costCompany);
                break;
            }
            case "3": {
                qFilter = new QFilter("contract.org.id", "=", (Object)costCompany);
                break;
            }
            case "4": {
                qFilter = new QFilter("contract.fiaccountorg.id", "=", (Object)costCompany);
            }
        }
        return qFilter;
    }

    public static List<Long> getProjectHasOnWayBills(Long[] billsId, EntityInfo info) {
        logger.info("\u83b7\u53d6\u4e0b\u6e38\u5355\u636e\u65b9\u6cd5\u5165\u53c2\uff1a{}", (Object)info.toString());
        String selectedProperties = String.join((CharSequence)",", "id", "billstatus", info.entryName + ".id", info.entryName + "." + info.sourceName);
        DynamicObject[] onwayBills = null;
        List<Object> collect = Lists.newArrayList();
        String OnWayCondition = "A,B,C,D,E,F";
        if ("er_contractbill".equals(info.entityName)) {
            OnWayCondition = "B,C";
        }
        if ("er_publicreimbursebill".equals(info.entityName)) {
            onwayBills = BusinessDataServiceHelper.load((String)info.entityName, (String)(selectedProperties + ",payamount"), (QFilter[])new QFilter[]{new QFilter(info.entryName + "." + info.sourceName, "in", (Object)billsId), new QFilter("billstatus", "in", Arrays.asList("A", "B", "C", "D", "F")).or(new QFilter("billstatus", "=", (Object)"E").and(QFilter.of((String)"payamount > 0", (Object[])new Object[0])))});
            collect = Arrays.stream(onwayBills).flatMap(onWayBill -> onWayBill.getDynamicObjectCollection(info.entryName).stream().map(OnWayBillEntry -> OnWayBillEntry.getLong(info.sourceName))).collect(Collectors.toList());
        } else {
            onwayBills = BusinessDataServiceHelper.load((String)info.entityName, (String)selectedProperties, (QFilter[])new QFilter[]{new QFilter(info.entryName + "." + info.sourceName, "in", (Object)billsId)});
            String finalOnWayCondition = OnWayCondition;
            collect = Arrays.stream(onwayBills).filter(prepayBillOnWay -> finalOnWayCondition.contains(prepayBillOnWay.getString("billstatus"))).flatMap(onWayBill -> onWayBill.getDynamicObjectCollection(info.entryName).stream().map(OnWayBillEntry -> OnWayBillEntry.getLong(info.sourceName))).collect(Collectors.toList());
        }
        return collect;
    }

    public static QFilter getOnWayLoanBillFilter() {
        String selectedProperties = String.join((CharSequence)",", "id", "billstatus", "expenseentryentity.id", "expenseentryentity.wbsrcentryid", "expenseentryentity.wbsrcbillid");
        DynamicObject[] conBills = BusinessDataServiceHelper.load((String)"er_contractbill", (String)selectedProperties, (QFilter[])new QFilter[]{new QFilter("expenseentryentity.wbsrcentryid", ">", (Object)0)});
        String OnWayCondition = "A,B,C,D";
        List collect = Arrays.stream(conBills).filter(loanBillOnWay -> OnWayCondition.contains(loanBillOnWay.getString("billstatus"))).flatMap(onWayBill -> onWayBill.getDynamicObjectCollection("expenseentryentity").stream().map(OnWayBillEntry -> OnWayBillEntry.getLong("wbsrcentryid"))).distinct().collect(Collectors.toList());
        QFilter filter = null;
        if (!collect.isEmpty()) {
            filter = new QFilter("expenseentryentity.id", "not in", collect);
        }
        return filter;
    }

    public static QFilter getBusinessFilter(IDataModel parentModel) {
        String sourceCostCompanyName;
        Long company = ErCommonUtils.getPk(parentModel.getValue("company"));
        QFilter qFilter = new QFilter("expenseentryentity.oriexpcancontractamount", ">", (Object)BigDecimal.ZERO).and("billstatus", "=", (Object)"E").and("availableamount", ">", (Object)BigDecimal.ZERO);
        QFilter unitFilter = PublicUpBillUtil.getSuplierFilter(parentModel);
        qFilter.and(unitFilter);
        String writeType = (String)ErCommonUtils.getEMParameter(ErCommonUtils.getPk(company), "er010");
        if (writeType.equals("1")) {
            Long currency = ErCommonUtils.getPk(parentModel.getValue("contractcurrency"));
            QFilter currencyQFilter = new QFilter("expenseentryentity.entrycurrency", "=", (Object)currency);
            qFilter.and(currencyQFilter);
        }
        Long costCompany = ErCommonUtils.getPk(parentModel.getValue("costcompany"));
        Long applierId = ErCommonUtils.getPk(parentModel.getValue("applier"));
        QFilter q = PublicUpBillUtil.getPublicUpBillQfilter(applierId, company, costCompany, sourceCostCompanyName = "expenseentryentity.entrycostcompany");
        if (q != null) {
            qFilter.and(q);
        }
        qFilter.and("detailtype", "=", (Object)"biztype_applybill");
        return qFilter;
    }

    public static QFilter getSuplierFilter(IDataModel parentModel) {
        DynamicObjectCollection dynamicObjectCollection = parentModel.getDataEntity(true).getDynamicObjectCollection("contractpartyentry");
        HashSet<Long> partids = new HashSet<Long>();
        dynamicObjectCollection.forEach(v -> {
            DynamicObject contractparty = (DynamicObject)v.get("contractparty");
            if (contractparty != null) {
                partids.add((Long)contractparty.getPkValue());
            }
        });
        QFilter unitQF = new QFilter("1", "=", (Object)1);
        if (partids.size() > 0) {
            partids.add(0L);
            unitQF = new QFilter("expenseentryentity.entrywlunit", "in", partids);
        }
        return unitQF;
    }

    public static QFilter getSelectedFilter(IDataModel parentModel) {
        DynamicObjectCollection expCollection = parentModel.getEntryEntity("projectentryentity");
        Long[] entrySourceIds = null;
        String finalEntrySourceId = "sourceentryid";
        if (expCollection != null) {
            entrySourceIds = (Long[])expCollection.stream().map(row -> row.getLong(finalEntrySourceId)).distinct().toArray(Long[]::new);
        }
        return new QFilter("expenseentryentity.id", "not in", entrySourceIds);
    }

    public static QFilter getOnWayContractBillFilter(String OnWayCondition) {
        String selectedProperties = String.join((CharSequence)",", "id", "billstatus", "projectentryentity.id", "projectentryentity.sourcebillid");
        DynamicObject[] prepayBills = BusinessDataServiceHelper.load((String)"er_contractbill", (String)selectedProperties, (QFilter[])new QFilter[]{new QFilter("projectentryentity.sourcebillid", ">", (Object)0)});
        List<Object> collect = new ArrayList();
        collect = !StringUtils.isEmpty((CharSequence)OnWayCondition) ? Arrays.stream(prepayBills).filter(prepayBillOnWay -> OnWayCondition.contains(prepayBillOnWay.getString("billstatus"))).flatMap(onWayBill -> onWayBill.getDynamicObjectCollection("projectentryentity").stream().map(OnWayBillEntry -> OnWayBillEntry.getLong("sourcebillid"))).distinct().collect(Collectors.toList()) : Arrays.stream(prepayBills).flatMap(onWayBill -> onWayBill.getDynamicObjectCollection("projectentryentity").stream().map(OnWayBillEntry -> OnWayBillEntry.getLong("sourcebillid"))).distinct().collect(Collectors.toList());
        QFilter filter = null;
        if (!collect.isEmpty()) {
            filter = new QFilter("id", "not in", collect);
        }
        return filter;
    }

    public static QFilter getOnWayPrepayBillFilter(String OnWayCondition) {
        String selectedProperties = String.join((CharSequence)",", "id", "billstatus", "expenseentryentity.id", "expenseentryentity.wbsrcbillid", "expenseentryentity.wbsrcentryid", "expenseentryentity.wbsrcbilltype");
        DynamicObject[] prepayBills = BusinessDataServiceHelper.load((String)"er_prepaybill", (String)selectedProperties, (QFilter[])new QFilter[]{new QFilter("expenseentryentity.wbsrcbilltype", "=", (Object)"er_applyprojectbill"), new QFilter("expenseentryentity.wbsrcbillid", ">", (Object)0)});
        List<Object> collect = new ArrayList();
        collect = !StringUtils.isEmpty((CharSequence)OnWayCondition) ? Arrays.stream(prepayBills).filter(prepayBillOnWay -> OnWayCondition.contains(prepayBillOnWay.getString("billstatus"))).flatMap(onWayBill -> onWayBill.getDynamicObjectCollection("expenseentryentity").stream().map(OnWayBillEntry -> OnWayBillEntry.getLong("wbsrcentryid"))).distinct().collect(Collectors.toList()) : Arrays.stream(prepayBills).flatMap(onWayBill -> onWayBill.getDynamicObjectCollection("expenseentryentity").stream().map(OnWayBillEntry -> OnWayBillEntry.getLong("wbsrcentryid"))).distinct().collect(Collectors.toList());
        QFilter filter = null;
        if (!collect.isEmpty()) {
            filter = new QFilter("expenseentryentity.id", "not in", collect);
        }
        return filter;
    }

    public static QFilter getOnWayLoanBillFilter(String OnWayCondition) {
        String selectedProperties = String.join((CharSequence)",", "id", "billstatus", "expenseentryentity.id", "expenseentryentity.sourceentryid", "expenseentryentity.sourcebillid");
        DynamicObject[] loanBills = BusinessDataServiceHelper.load((String)"er_dailyloanbill", (String)selectedProperties, (QFilter[])new QFilter[]{new QFilter("expenseentryentity.sourcebillid", ">", (Object)0)});
        List<Object> collect = new ArrayList();
        collect = !StringUtils.isEmpty((CharSequence)OnWayCondition) ? Arrays.stream(loanBills).filter(loanBillOnWay -> OnWayCondition.contains(loanBillOnWay.getString("billstatus"))).flatMap(onWayBill -> onWayBill.getDynamicObjectCollection("expenseentryentity").stream().map(OnWayBillEntry -> OnWayBillEntry.getLong("sourceentryid"))).distinct().collect(Collectors.toList()) : Arrays.stream(loanBills).flatMap(onWayBill -> onWayBill.getDynamicObjectCollection("expenseentryentity").stream().map(OnWayBillEntry -> OnWayBillEntry.getLong("sourceentryid"))).distinct().collect(Collectors.toList());
        QFilter filter = null;
        if (!collect.isEmpty()) {
            filter = new QFilter("expenseentryentity.id", "not in", collect);
        }
        return filter;
    }

    public static QFilter getOnWayPublicReimBillFilter(String OnWayCondition) {
        String selectedProperties = String.join((CharSequence)",", "id", "billstatus", "expenseentryentity.id", "expenseentryentity.wbsrcbillid", "expenseentryentity.wbsrcentryid", "expenseentryentity.wbsrcbilltype", "payamount");
        DynamicObject[] publicreimBills = BusinessDataServiceHelper.load((String)"er_publicreimbursebill", (String)selectedProperties, (QFilter[])new QFilter[]{new QFilter("expenseentryentity.wbsrcbilltype", "in", (Object)new String[]{"er_applyprojectbill", "project"}), new QFilter("expenseentryentity.wbsrcbillid", ">", (Object)0), new QFilter("billstatus", "in", Arrays.asList("A", "B", "C", "D", "F")).or(new QFilter("billstatus", "=", (Object)"E").and(QFilter.of((String)"payamount > 0", (Object[])new Object[0])))});
        List collect = Arrays.stream(publicreimBills).flatMap(onWayBill -> onWayBill.getDynamicObjectCollection("expenseentryentity").stream().map(OnWayBillEntry -> OnWayBillEntry.getLong("wbsrcentryid"))).distinct().collect(Collectors.toList());
        QFilter filter = null;
        if (collect != null && !collect.isEmpty()) {
            filter = new QFilter("expenseentryentity.id", "not in", collect);
        }
        return filter;
    }

    @KSMethod
    public static QFilter getUpDrawCasBillFilter(IDataModel parentModel) {
        BigDecimal approveamount;
        QFilter qFilter;
        List selectedEntryIDs;
        Long companyId;
        DynamicObject[] dynamicObjectList = BusinessDataServiceHelper.load((String)"er_repaymentbill", (String)"id,recentry.recbillno", (QFilter[])new QFilter[]{new QFilter("id", ">", (Object)0)});
        QFilter selectedEntryQfilter = new QFilter("1", "=", (Object)1);
        if (dynamicObjectList != null && dynamicObjectList.length > 0) {
            ArrayList billnoList = Lists.newArrayList();
            for (DynamicObject repaymentbill : dynamicObjectList) {
                DynamicObjectCollection recentryColletion = repaymentbill.getDynamicObjectCollection("recentry");
                if (recentryColletion == null || recentryColletion.size() <= 0) continue;
                billnoList.addAll(recentryColletion.stream().map(e -> e.getString("recbillno")).collect(Collectors.toList()));
            }
            if (!billnoList.isEmpty()) {
                selectedEntryQfilter = new QFilter("billno", "not in", (Object)billnoList);
            }
        }
        if ((companyId = ErCommonUtils.getPk(parentModel.getValue("company"))) != null) {
            selectedEntryQfilter.and("org", "=", (Object)companyId);
        }
        if (!(selectedEntryIDs = parentModel.getEntryEntity("recentry").stream().map(r -> r.getLong("recbillid")).collect(Collectors.toList())).isEmpty()) {
            selectedEntryQfilter = selectedEntryQfilter.and("id", "not in", selectedEntryIDs);
        }
        if ((qFilter = PublicUpBillUtil.getPayerFilter(parentModel)) != null) {
            selectedEntryQfilter.and(qFilter);
        }
        if ((approveamount = (BigDecimal)parentModel.getValue("approveamount")) != null) {
            selectedEntryQfilter.and("localamt", "<=", (Object)approveamount);
        }
        return selectedEntryQfilter;
    }

    public static QFilter getPayerFilter(IDataModel parentModel) {
        QFilter qFilter = null;
        String billPayerType = (String)parentModel.getValue("payertype");
        if (!StringUtils.isEmpty((CharSequence)billPayerType)) {
            switch (billPayerType) {
                case "bd_supplier": {
                    DynamicObject supplier = (DynamicObject)parentModel.getValue("supplier");
                    if (supplier == null) break;
                    Long id = (Long)supplier.getPkValue();
                    qFilter = new QFilter("payer", "=", (Object)id);
                    break;
                }
                case "bd_customer": {
                    DynamicObject customer = (DynamicObject)parentModel.getValue("customer");
                    if (customer == null) break;
                    Long id = (Long)customer.getPkValue();
                    qFilter = new QFilter("payer", "=", (Object)id);
                    break;
                }
                case "bos_org": {
                    DynamicObject casorg = (DynamicObject)parentModel.getValue("casorg");
                    if (casorg == null) break;
                    Long id = (Long)casorg.getPkValue();
                    qFilter = new QFilter("payer", "=", (Object)id);
                    break;
                }
                case "er_payeer": {
                    DynamicObject payer1;
                    DynamicObject payer = (DynamicObject)parentModel.getValue("payer");
                    if (payer == null || (payer1 = (DynamicObject)payer.get("payer")) == null || payer1.getPkValue() == null) break;
                    qFilter = new QFilter("payer", "=", payer1.getPkValue());
                    break;
                }
                case "other": {
                    break;
                }
            }
        }
        return qFilter;
    }

    public static void clearLoanEntry(IDataModel model) {
        List<Integer> needDelIndexs;
        String publicupbillrange;
        List<Integer> needDelIndexs2;
        DynamicObject company = (DynamicObject)model.getValue("company");
        Long companyId = company == null ? 0L : company.getLong("id");
        DynamicObject costcompany = (DynamicObject)model.getValue("costcompany");
        long costcompanyId = costcompany == null ? 0L : costcompany.getLong("id");
        String loaRangeType = SystemParamterUtil.getLoanDrawRange(companyId);
        DynamicObjectCollection collection = model.getDataEntity(true).getDynamicObjectCollection("writeoffmoney");
        if (StringUtils.equals((CharSequence)loaRangeType, (CharSequence)"1") && (needDelIndexs2 = PublicUpBillUtil.getIndexs(collection, Arrays.asList("er_dailyloanbill", "er_tripreqbill"), costcompanyId)) != null && needDelIndexs2.size() > 0) {
            model.deleteEntryRows("writeoffmoney", needDelIndexs2.stream().mapToInt(Integer::intValue).toArray());
        }
        if (("1".equals(publicupbillrange = SystemParamterUtil.getPublicupbillrange(companyId)) || "4".equals(publicupbillrange)) && (needDelIndexs = PublicUpBillUtil.getIndexs(collection, Collections.singletonList("er_prepaybill"), costcompanyId)) != null && needDelIndexs.size() > 0) {
            model.deleteEntryRows("writeoffmoney", needDelIndexs.stream().mapToInt(Integer::intValue).toArray());
        }
    }

    public static boolean hasDownOnwayRepayBills(String entityNumber, ListSelectedRow row) {
        DynamicObject[] downBills;
        HashSet tagertBillIds;
        Long[] billIds = new Long[]{(Long)row.getPrimaryKeyValue()};
        Map targetBills = BFTrackerServiceHelper.findTargetBills((String)entityNumber, (Long[])billIds);
        return targetBills.containsKey("er_repaymentbill") && (tagertBillIds = (HashSet)targetBills.get("er_repaymentbill")) != null && tagertBillIds.size() > 0 && (downBills = BusinessDataServiceHelper.load((String)"er_repaymentbill", (String)"id,billstatus", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)tagertBillIds.stream().mapToLong(Long::longValue).toArray()), new QFilter("billstatus", "in", (Object)Lists.newArrayList((Object[])new Character[]{Character.valueOf('A'), Character.valueOf('B'), Character.valueOf('C'), Character.valueOf('D'), Character.valueOf('E')}))})) != null && downBills.length > 0;
    }

    private static List<Integer> getIndexs(DynamicObjectCollection collection, List list, long costcompanyId) {
        ArrayList arr = Lists.newArrayList();
        for (int i = 0; i < collection.size(); ++i) {
            if (!list.contains(((DynamicObject)collection.get(i)).get("srcbilltype")) || ((DynamicObject)collection.get(i)).getDynamicObject("sourceentrycostcompany") == null || costcompanyId == (Long)((DynamicObject)collection.get(i)).getDynamicObject("sourceentrycostcompany").getPkValue()) continue;
            arr.add(i);
        }
        return arr;
    }

    public static QFilter getUpDrawCasBillFilter(HashMap map) {
        BigDecimal approveamount;
        Long payerId;
        List allToOrg2;
        Long costcompanyId;
        List allToOrg1;
        DynamicObject[] dynamicObjectList = BusinessDataServiceHelper.load((String)"er_repaymentbill", (String)"id,recentry.recbillno", (QFilter[])new QFilter[]{new QFilter("id", ">", (Object)0)});
        QFilter selectedEntryQfilter = new QFilter("1", "=", (Object)1);
        if (dynamicObjectList != null && dynamicObjectList.length > 0) {
            ArrayList billnoList = Lists.newArrayList();
            for (DynamicObject repaymentbill : dynamicObjectList) {
                DynamicObjectCollection recentryColletion = repaymentbill.getDynamicObjectCollection("recentry");
                if (recentryColletion == null || recentryColletion.size() <= 0) continue;
                billnoList.addAll(recentryColletion.stream().map(e -> e.getString("recbillno")).collect(Collectors.toList()));
            }
            if (!billnoList.isEmpty()) {
                selectedEntryQfilter = new QFilter("billno", "not in", (Object)billnoList);
            }
        }
        QFilter qfilter = null;
        Long companyId = (Long)map.get("company");
        if (companyId != null && companyId != 0L) {
            qfilter = new QFilter("org", "=", (Object)companyId);
        }
        if ((allToOrg1 = OrgUnitServiceHelper.getAllToOrg((String)"10", (String)"08", (Long)companyId, (boolean)Boolean.FALSE)) != null && allToOrg1.size() > 0) {
            if (qfilter == null) {
                qfilter = new QFilter("org", "in", (Object)allToOrg1);
            } else {
                qfilter.or("org", "in", (Object)allToOrg1);
            }
        }
        if ((costcompanyId = (Long)map.get("costcompany")) != null && costcompanyId != 0L) {
            if (qfilter == null) {
                qfilter = new QFilter("org", "=", (Object)costcompanyId);
            } else {
                qfilter.or("org", "=", (Object)costcompanyId);
            }
        }
        if ((allToOrg2 = OrgUnitServiceHelper.getAllToOrg((String)"10", (String)"08", (Long)costcompanyId, (boolean)Boolean.FALSE)) != null && allToOrg2.size() > 0) {
            if (qfilter == null) {
                qfilter = new QFilter("org", "in", (Object)allToOrg2);
            } else {
                qfilter.or("org", "in", (Object)allToOrg2);
            }
        }
        selectedEntryQfilter.and(qfilter);
        List selectedEntryIDs = (List)map.get("selectedEntryIDs");
        if (selectedEntryIDs != null && !selectedEntryIDs.isEmpty()) {
            selectedEntryQfilter = selectedEntryQfilter.and("id", "not in", (Object)selectedEntryIDs);
        }
        if ((payerId = (Long)map.get("payer")) != null && payerId != 0L) {
            selectedEntryQfilter.and("payer", "=", (Object)payerId);
        }
        if ((approveamount = (BigDecimal)map.get("approveamount")) != null) {
            selectedEntryQfilter.and("localamt", "<=", (Object)approveamount);
        }
        return selectedEntryQfilter;
    }
}

