/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.reimamountctl.reimed;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.er.business.daily.service.model.ReimburseAmountDetailBean;
import kd.fi.er.business.reimamountctl.method.QuotaCtlMethodFactory;
import kd.fi.er.business.reimamountctl.method.QuotaCtlMethodService;
import kd.fi.er.business.reimamountctl.model.QuotaAmountBO;
import kd.fi.er.business.reimamountctl.model.ReimAmountQuotaAmountBO;
import kd.fi.er.business.reimamountctl.reimed.ReimedQueryService;
import kd.fi.er.business.reimamountctl.utils.QuotaCtrlUtil;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.business.utils.ErStdConfig;
import kd.fi.er.business.utils.ReimburseControlUtils;
import kd.fi.er.model.WrappedObject;

public class PublicExpenseReimedQueryServiceImpl
implements ReimedQueryService {
    @Override
    public BigDecimal queryEmpReimedAmount(QuotaAmountBO reimAmountBO) {
        QFilter empQueryFilter = this.getEmpQueryFilter(reimAmountBO);
        return this.getReimedAmount(reimAmountBO, empQueryFilter);
    }

    @Override
    public BigDecimal queryDeptReimedAmount(QuotaAmountBO reimAmountBO) {
        QFilter deptQueryFilter = this.getDeptQueryFilter(reimAmountBO);
        return this.getReimedAmount(reimAmountBO, deptQueryFilter);
    }

    private BigDecimal getReimedAmount(QuotaAmountBO reimAmountBO, QFilter qFilter) {
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)PublicExpenseReimedQueryServiceImpl.class.getCanonicalName(), (String)"er_publicreimbursebill", (String)("id,expenseentryentity," + reimAmountBO.getExpenseAmountKey()), (QFilter[])new QFilter[]{qFilter}, null);
        WrappedObject wo = new WrappedObject((Object)BigDecimal.ZERO);
        dataSet.forEach(data -> {
            BigDecimal amount = data.getBigDecimal(reimAmountBO.getExpenseAmountKey());
            wo.setValue((Object)((BigDecimal)wo.getValue()).add(amount));
        });
        dataSet.close();
        return (BigDecimal)wo.getValue();
    }

    @Override
    public List<ReimburseAmountDetailBean> queryEmpReimedBill(QuotaAmountBO quotaAmountBO) {
        QFilter empQueryFilter = this.getEmpQueryFilter(quotaAmountBO);
        return this.getReimedBill(quotaAmountBO, empQueryFilter);
    }

    @Override
    public List<ReimburseAmountDetailBean> queryDeptReimedBill(QuotaAmountBO quotaAmountBO) {
        QFilter deptQueryFilter = this.getDeptQueryFilter(quotaAmountBO);
        return this.getReimedBill(quotaAmountBO, deptQueryFilter);
    }

    private List<ReimburseAmountDetailBean> getReimedBill(QuotaAmountBO quotaAmountBO, QFilter queryFilter) {
        String formName = MetadataServiceHelper.getDataEntityType((String)"er_publicreimbursebill").getDisplayName().getLocaleValue();
        String quotaDateField = ErStdConfig.getQuotaDateField();
        ArrayList<ReimburseAmountDetailBean> deptExpenseReimedBills = new ArrayList<ReimburseAmountDetailBean>(16);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)PublicExpenseReimedQueryServiceImpl.class.getCanonicalName(), (String)"er_publicreimbursebill", (String)("id,billno,bizdate,expenseentryentity,expenseentryentity.happendate," + quotaAmountBO.getExpenseAmountKey()), (QFilter[])new QFilter[]{queryFilter}, null);){
            for (Row data : dataSet) {
                ReimburseAmountDetailBean reimburseAmountDetailBean = new ReimburseAmountDetailBean();
                reimburseAmountDetailBean.setMetaKey("er_publicreimbursebill");
                reimburseAmountDetailBean.setMobFormKey("er_publicreimbursebill_mob");
                reimburseAmountDetailBean.setBillName(formName);
                reimburseAmountDetailBean.setBillId(data.getLong("id"));
                reimburseAmountDetailBean.setBillno(data.getString("billno"));
                reimburseAmountDetailBean.setHappenedDate(ErCommonUtils.getLocalDateFromDate(data.getDate(quotaDateField)));
                reimburseAmountDetailBean.setReimburseAmount(data.getBigDecimal(quotaAmountBO.getExpenseAmountKey()));
                deptExpenseReimedBills.add(reimburseAmountDetailBean);
            }
        }
        return deptExpenseReimedBills;
    }

    @Override
    public QFilter getEmpQueryFilter(QuotaAmountBO quotaAmountBO) {
        QFilter otherFilter = QFilter.of((String)"expenseentryentity.pubreimburser=?", (Object[])new Object[]{quotaAmountBO.getUserOrDeptId()});
        otherFilter = otherFilter.and(ReimburseControlUtils.getPersonReimCtlCompanyQFilter(quotaAmountBO.getCompanyId()));
        List<Long> notInIds = quotaAmountBO.getNotInIds();
        if (notInIds != null && !notInIds.isEmpty()) {
            otherFilter.and(new QFilter("id", "not in", notInIds));
        }
        QFilter qFilter = QFilter.of((String)"expenseentryentity.expenseitem = ? ", (Object[])new Object[]{quotaAmountBO.getExpenseItemId()});
        QFilter billStatusFilter = new QFilter("billstatus", "in", (Object)BILL_STATUS_WITH_REIMBURSE);
        QuotaCtlMethodService quotaCtlMethodService = QuotaCtlMethodFactory.get(quotaAmountBO.getCtrlMethod());
        Map<String, LocalDate> happenDatePeriod = quotaCtlMethodService.genHappenDatePeriod(quotaAmountBO);
        if (happenDatePeriod != null) {
            String quotaDateField = ErStdConfig.getQuotaDateField();
            String filterStr = "%s >= ? and %s <= ?";
            filterStr = String.format(filterStr, quotaDateField, quotaDateField);
            otherFilter.and(QFilter.of((String)filterStr, (Object[])new Object[]{ErCommonUtils.getDateFromLocalDate(happenDatePeriod.get("start")), ErCommonUtils.getDateFromLocalDate(happenDatePeriod.get("end"))}));
        }
        QFilter keyQFilter = qFilter.and(billStatusFilter).and(otherFilter).and(new QFilter(quotaAmountBO.getExpenseCurrencyKey(), "=", (Object)quotaAmountBO.getCurrencyId()));
        return keyQFilter;
    }

    @Override
    public QFilter getDeptQueryFilter(QuotaAmountBO quotaAmountBO) {
        QuotaCtlMethodService quotaCtlMethodService;
        Map<String, LocalDate> happenDatePeriod;
        QFilter qFilter = QFilter.of((String)"expenseentryentity.expenseitem = ?", (Object[])new Object[]{quotaAmountBO.getExpenseItemId()});
        if (quotaAmountBO.getUserOrDeptId() != null) {
            qFilter.and(QFilter.of((String)"expenseentryentity.reimctldept=? ", (Object[])new Object[]{quotaAmountBO.getUserOrDeptId()}));
        }
        qFilter.and(new QFilter("billstatus", "in", (Object)BILL_STATUS_WITH_REIMBURSE));
        List<Long> notInIds = quotaAmountBO.getNotInIds();
        if (notInIds != null && !notInIds.isEmpty()) {
            qFilter.and(new QFilter("id", "not in", notInIds));
        }
        if ((happenDatePeriod = (quotaCtlMethodService = QuotaCtlMethodFactory.get(quotaAmountBO.getCtrlMethod())).genHappenDatePeriod(quotaAmountBO)) != null) {
            String quotaDateField = ErStdConfig.getQuotaDateField();
            String filterStr = "%s >= ? and %s <= ?";
            filterStr = String.format(filterStr, quotaDateField, quotaDateField);
            qFilter.and(QFilter.of((String)filterStr, (Object[])new Object[]{ErCommonUtils.getDateFromLocalDate(happenDatePeriod.get("start")), ErCommonUtils.getDateFromLocalDate(happenDatePeriod.get("end"))}));
        }
        qFilter.and(new QFilter(quotaAmountBO.getExpenseCurrencyKey(), "=", (Object)quotaAmountBO.getCurrencyId()));
        return qFilter;
    }

    @Override
    public List<ReimAmountQuotaAmountBO> queryEmpReimedAmount(List<QuotaAmountBO> expenseReimedQueryList) {
        if (expenseReimedQueryList == null || expenseReimedQueryList.isEmpty()) {
            return new ArrayList<ReimAmountQuotaAmountBO>(1);
        }
        QFilter empQueryFilter = this.getEmpQueryFilter(expenseReimedQueryList);
        return this.getReimedAmount(expenseReimedQueryList, empQueryFilter);
    }

    private List<ReimAmountQuotaAmountBO> getReimedAmount(List<QuotaAmountBO> expenseReimedQueryList, QFilter qFilter) {
        Set ExpenseCurrencyKeys = expenseReimedQueryList.stream().map(er -> er.getExpenseCurrencyKey()).collect(Collectors.toSet());
        String currencyFields = ExpenseCurrencyKeys.stream().collect(Collectors.joining(","));
        Set expenseAmountKeys = expenseReimedQueryList.stream().map(er -> er.getExpenseAmountKey()).collect(Collectors.toSet());
        String expenseAmountFields = expenseAmountKeys.stream().collect(Collectors.joining(","));
        String companyField = ReimburseControlUtils.getPersonReimCtlCompanyField();
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)PublicExpenseReimedQueryServiceImpl.class.getCanonicalName(), (String)"er_publicreimbursebill", (String)("id,expenseentryentity,expenseentryentity.pubreimburser," + companyField + "," + ErStdConfig.getQuotaDateField() + ",expenseentryentity.expenseitem," + currencyFields + "," + expenseAmountFields), (QFilter[])new QFilter[]{qFilter}, null);
        String employeeKey = "expenseentryentity.pubreimburser";
        String expenseitem = "expenseentryentity.expenseitem";
        String quotaDateField = ErStdConfig.getQuotaDateField();
        return QuotaCtrlUtil.buildReimedAmount(dataSet, expenseReimedQueryList, "er_publicreimbursebill", companyField, employeeKey, expenseitem, quotaDateField);
    }

    private void buildAmount(List<ReimAmountQuotaAmountBO> resultList, Row data, QuotaAmountBO quotaAmountBO, Set<Long> billIDS) {
        String employeeKey = "expenseentryentity.pubreimburser";
        Long dataEmployee = data.getLong(employeeKey) == null ? Long.valueOf(0L) : data.getLong(employeeKey);
        Long employee = quotaAmountBO.getUserOrDeptId() == null ? Long.valueOf(0L) : quotaAmountBO.getUserOrDeptId();
        String currencyKey = quotaAmountBO.getExpenseCurrencyKey();
        Long dataCurrency = data.getLong(currencyKey) == null ? Long.valueOf(0L) : data.getLong(currencyKey);
        Long currency = quotaAmountBO.getCurrencyId() == null ? Long.valueOf(0L) : quotaAmountBO.getCurrencyId();
        String companyField = ReimburseControlUtils.getPersonReimCtlCompanyField();
        Long dataCompanyId = data.getLong(companyField) == null ? Long.valueOf(0L) : data.getLong(companyField);
        Long companyId = quotaAmountBO.getCompanyId() == null ? Long.valueOf(0L) : quotaAmountBO.getCompanyId();
        String expenseitem = "expenseentryentity.expenseitem";
        Long dataExpenseitemId = data.getLong(expenseitem) == null ? Long.valueOf(0L) : data.getLong(expenseitem);
        Long expenseItemId = quotaAmountBO.getExpenseItemId() == null ? Long.valueOf(0L) : quotaAmountBO.getExpenseItemId();
        String quotaDateField = ErStdConfig.getQuotaDateField();
        QuotaCtlMethodService quotaCtlMethodService = QuotaCtlMethodFactory.get(quotaAmountBO.getCtrlMethod());
        Map<String, LocalDate> happenDatePeriod = quotaCtlMethodService.genHappenDatePeriod(quotaAmountBO);
        Date startDate = ErCommonUtils.getDateFromLocalDate(happenDatePeriod.get("start")) == null ? new Date(Long.MAX_VALUE) : ErCommonUtils.getDateFromLocalDate(happenDatePeriod.get("start"));
        Date endDate = ErCommonUtils.getDateFromLocalDate(happenDatePeriod.get("end")) == null ? new Date(Long.MIN_VALUE) : ErCommonUtils.getDateFromLocalDate(happenDatePeriod.get("end"));
        Date dataSetDate = data.getDate(quotaDateField) == null ? new Date() : data.getDate(quotaDateField);
        String expenseAmountKey = quotaAmountBO.getExpenseAmountKey();
        BigDecimal amount = data.getBigDecimal(expenseAmountKey);
        if (employee.compareTo(dataEmployee) == 0 && currency.compareTo(dataCurrency) == 0 && companyId.compareTo(dataCompanyId) == 0 && expenseItemId.compareTo(dataExpenseitemId) == 0 && startDate.compareTo(dataSetDate) <= 0 && endDate.compareTo(dataSetDate) >= 0) {
            billIDS.add(data.getLong("id"));
            ReimAmountQuotaAmountBO newReimAmountQuotaAmountBO = new ReimAmountQuotaAmountBO(quotaAmountBO, amount);
            int existIndex = resultList.indexOf(newReimAmountQuotaAmountBO);
            if (existIndex >= 0) {
                ReimAmountQuotaAmountBO existReimAmountQuotaAmountBO = resultList.get(existIndex);
                WrappedObject wo = new WrappedObject((Object)existReimAmountQuotaAmountBO.getReimAmount());
                wo.setValue((Object)((BigDecimal)wo.getValue()).add(amount));
                existReimAmountQuotaAmountBO.setReimAmount((BigDecimal)wo.getValue());
            } else {
                resultList.add(newReimAmountQuotaAmountBO);
            }
        }
    }

    public QFilter getEmpQueryFilter(List<QuotaAmountBO> expenseReimedQueryList) {
        Set appliers = expenseReimedQueryList.stream().map(er -> er.getUserOrDeptId()).collect(Collectors.toSet());
        QFilter otherFilter = new QFilter("expenseentryentity.pubreimburser", "in", appliers);
        Set<Long> companyIds = expenseReimedQueryList.stream().map(er -> er.getCompanyId()).collect(Collectors.toSet());
        otherFilter = otherFilter.and(ReimburseControlUtils.getPersonReimCtlCompanyQFilter(companyIds));
        ArrayList notInIds = new ArrayList();
        expenseReimedQueryList.stream().forEach(er -> notInIds.addAll(er.getNotInIds() == null ? new ArrayList() : er.getNotInIds()));
        if (!notInIds.isEmpty()) {
            otherFilter.and(new QFilter("id", "not in", notInIds));
        }
        Set expenseItemIdSet = expenseReimedQueryList.stream().map(er -> er.getExpenseItemId()).collect(Collectors.toSet());
        QFilter qFilter = new QFilter("expenseentryentity.expenseitem ", "in", expenseItemIdSet);
        QFilter billStatusFilter = new QFilter("billstatus", "in", (Object)BILL_STATUS_WITH_REIMBURSE);
        Date minStartDate = null;
        Date maxEndDate = null;
        for (QuotaAmountBO quotaAmountBO : expenseReimedQueryList) {
            QuotaCtlMethodService quotaCtlMethodService = QuotaCtlMethodFactory.get(quotaAmountBO.getCtrlMethod());
            Map<String, LocalDate> happenDatePeriod = quotaCtlMethodService.genHappenDatePeriod(quotaAmountBO);
            Date currentMinStartDate = ErCommonUtils.getDateFromLocalDate(happenDatePeriod.get("start"));
            Date currentMaxEndDate = ErCommonUtils.getDateFromLocalDate(happenDatePeriod.get("end"));
            if (minStartDate == null || currentMinStartDate.compareTo(minStartDate) < 0) {
                minStartDate = currentMinStartDate;
            }
            if (maxEndDate != null && currentMaxEndDate.compareTo(maxEndDate) <= 0) continue;
            maxEndDate = currentMaxEndDate;
        }
        if (minStartDate != null && maxEndDate != null) {
            String quotaDateField = ErStdConfig.getQuotaDateField();
            String filterStr = "%s >= ? and %s <= ?";
            filterStr = String.format(filterStr, quotaDateField, quotaDateField);
            otherFilter.and(QFilter.of((String)filterStr, (Object[])new Object[]{minStartDate, maxEndDate}));
        }
        QFilter currencyFilter = null;
        Set ExpenseCurrencyKeys = expenseReimedQueryList.stream().map(er -> er.getExpenseCurrencyKey()).collect(Collectors.toSet());
        Set currencyIds = expenseReimedQueryList.stream().filter(er -> er.getCurrencyId() != null).map(er -> er.getCurrencyId()).collect(Collectors.toSet());
        for (String expenseCurrencyKey : ExpenseCurrencyKeys) {
            if (currencyFilter == null) {
                currencyFilter = new QFilter(expenseCurrencyKey, "in", currencyIds);
                continue;
            }
            currencyFilter = currencyFilter.or(new QFilter(expenseCurrencyKey, "in", currencyIds));
        }
        QFilter keyQFilter = qFilter.and(billStatusFilter).and(otherFilter).and(currencyFilter);
        return keyQFilter;
    }
}

