/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.reimamountctl.utils;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.Month;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.field.DateEdit;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.er.business.reimamountctl.method.QuotaCtlMethodFactory;
import kd.fi.er.business.reimamountctl.method.QuotaCtlMethodService;
import kd.fi.er.business.reimamountctl.model.QuotaAmountBO;
import kd.fi.er.business.reimamountctl.model.ReimAmountQuotaAmountBO;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.business.utils.ErEntityTypeUtils;
import kd.fi.er.business.utils.ErStdConfig;
import kd.fi.er.business.utils.ReimburseControlUtils;
import kd.fi.er.model.WrappedObject;

public class QuotaCtrlUtil {
    private static final Log log = LogFactory.getLog(QuotaCtrlUtil.class);

    public static void genQuotaExpItem(QuotaAmountBO quotaAmountBO, Long expItemId) {
        DynamicObject expItem = BusinessDataServiceHelper.loadSingleFromCache((Object)expItemId, (String)"er_expenseitemedit", (String)"isreimburseamountctl,reimctltype,reimburseamountctlmethod,name,reimburseamountctlcount");
        quotaAmountBO.setExpenseItemId(expItemId);
        quotaAmountBO.setCtrlMode(expItem.getString("isreimburseamountctl"));
        quotaAmountBO.setCtrlType(expItem.getString("reimctltype"));
        quotaAmountBO.setCtrlMethod(expItem.getString("reimburseamountctlmethod"));
        quotaAmountBO.setCtrlCount(expItem.getInt("reimburseamountctlcount"));
    }

    public static void genQuotaCurrency(QuotaAmountBO quotaAmountBO, String ctrlCurrency, Long oriCurrencyId, Long baseCurrencyId) {
        if ("0".equals(ctrlCurrency)) {
            quotaAmountBO.setCurrencyId(oriCurrencyId);
            quotaAmountBO.setExpenseCurrencyKey("expenseentryentity.entrycurrency");
            quotaAmountBO.setExpenseAmountKey("expenseentryentity.expeapproveamount");
            quotaAmountBO.setTripCurrencyKey("tripentry.entryentity.entrycurrency");
            quotaAmountBO.setTripAmountKey("tripentry.entryentity.orientryappamount");
        } else {
            quotaAmountBO.setCurrencyId(baseCurrencyId);
            quotaAmountBO.setExpenseCurrencyKey("currency");
            quotaAmountBO.setExpenseAmountKey("expenseentryentity.expeapprovecurramount");
            quotaAmountBO.setTripCurrencyKey("currency");
            quotaAmountBO.setTripAmountKey("tripentry.entryentity.entryappamount");
        }
    }

    public static Long getQuotaCtrlDeptId(DynamicObject expItem, DynamicObject entryCostOrg, IDataModel model) {
        return QuotaCtrlUtil.getQuotaCtrlDeptId(expItem, (DynamicObject)model.getValue("company"), (DynamicObject)model.getValue("org"), entryCostOrg);
    }

    public static Long getQuotaCtrlDeptId(DynamicObject expItem, DynamicObject company, DynamicObject dept, DynamicObject entryCostOrg) {
        DynamicObject queryOne;
        if (expItem == null) {
            return 0L;
        }
        if (company == null) {
            return 0L;
        }
        Long companyId = (Long)company.getPkValue();
        Long deptId = 0L;
        if (dept != null) {
            deptId = (Long)dept.getPkValue();
        }
        Long costorgId = 0L;
        if (entryCostOrg != null) {
            costorgId = (Long)entryCostOrg.getPkValue();
        }
        String amountCtrlField = "isreimburseamountctl";
        String isreimburseamountctl = null;
        isreimburseamountctl = expItem.getDynamicObjectType().getProperty(amountCtrlField) == null ? ((queryOne = BusinessDataServiceHelper.loadSingleFromCache((String)expItem.getDataEntityType().getName(), (String)amountCtrlField, (QFilter[])new QFilter[]{new QFilter("id", "=", expItem.getPkValue())})) == null ? "" : queryOne.getString(amountCtrlField)) : expItem.getString(amountCtrlField);
        Long quotaCtrlDeptId = null;
        if ("2".equals(isreimburseamountctl)) {
            String reimcontrolorgname = (String)ErCommonUtils.getEMParameter(companyId, "reimcontrolorgname");
            quotaCtrlDeptId = "1".equals(reimcontrolorgname) ? deptId : costorgId;
            QFilter quotaCtrlRelationFilter = new QFilter("expenseitems.fbasedataId", "=", expItem.getPkValue()).and(new QFilter("deptrelation.dept", "=", (Object)quotaCtrlDeptId)).and(new QFilter("enable", "=", (Object)"1"));
            DynamicObject quotaCtrlRelation = BusinessDataServiceHelper.loadSingleFromCache((String)"er_reimctldept_relation", (String)"id,deptrelation,deptrelation.dept,deptrelation.reimdept,dept,reimdept", (QFilter[])new QFilter[]{quotaCtrlRelationFilter});
            if (quotaCtrlRelation != null) {
                DynamicObjectCollection deptrelation = quotaCtrlRelation.getDynamicObjectCollection("deptrelation");
                for (DynamicObject deptRelation : deptrelation) {
                    if (!quotaCtrlDeptId.equals(deptRelation.getDynamicObject("dept").getPkValue())) continue;
                    quotaCtrlDeptId = (Long)deptRelation.getDynamicObject("reimdept").getPkValue();
                    break;
                }
            }
        }
        return quotaCtrlDeptId;
    }

    public static void setHappenDateSelectedRange(IDataModel model, DateEdit ... dateEdits) {
        Map<String, LocalDate> datePeriod = QuotaCtrlUtil.getHappenDateSelectedRange(model);
        if (datePeriod == null || datePeriod.size() < 1) {
            return;
        }
        LocalDate currentLocalDate = datePeriod.get("start");
        LocalDate minLocalDate = datePeriod.get("end");
        for (DateEdit dateEdit : dateEdits) {
            boolean isFuture = ErStdConfig.getBoolean("happendate_future_permission");
            if (!isFuture || !ErEntityTypeUtils.isDailyReimburseBill(model.getDataEntityType().getName()) && !ErEntityTypeUtils.isPublicReimburseBill(model.getDataEntityType().getName())) {
                dateEdit.setMaxDate(ErCommonUtils.getDateFromLocalDate(currentLocalDate));
            }
            dateEdit.setMinDate(ErCommonUtils.getDateFromLocalDate(minLocalDate));
        }
        log.info(String.format("\u8bbe\u7f6e\u8d39\u7528\u53d1\u751f\u65e5\u671f\u7684\u533a\u95f4\u4e3a:%s~%s", minLocalDate.toString(), currentLocalDate.toString()));
    }

    public static Map<String, LocalDate> getHappenDateSelectedRange(IDataModel model) {
        DynamicObject paramSettingCompanyDO = ReimburseControlUtils.getReimburseControlCompany(model.getDataEntity(true));
        if (paramSettingCompanyDO == null) {
            return new HashMap<String, LocalDate>();
        }
        Long paramSettingCompanyId = (Long)paramSettingCompanyDO.getPkValue();
        LocalDate currentLocalDate = ReimburseControlUtils.currentLocalDate();
        LocalDate minLocalDate = LocalDate.of(currentLocalDate.getYear(), 1, 1);
        boolean allowPreviousYear = ReimburseControlUtils.isAllowPreviousYear(paramSettingCompanyId);
        if (allowPreviousYear) {
            Month deadlineMonth = ReimburseControlUtils.deadlineMonthOfAllowPreviousYes(paramSettingCompanyId);
            if (currentLocalDate.getMonthValue() <= deadlineMonth.getValue()) {
                minLocalDate = LocalDate.of(currentLocalDate.getYear() - 1, 1, 1);
            }
        }
        HashMap<String, LocalDate> datePeriod = new HashMap<String, LocalDate>(2);
        datePeriod.put("start", currentLocalDate);
        datePeriod.put("end", minLocalDate);
        return datePeriod;
    }

    public static List<ReimAmountQuotaAmountBO> buildReimedAmount(DataSet dataSet, List<QuotaAmountBO> reimAmountBOList, String billFormId, String companyField, String employeeKey, String expenseitem, String quotaDateField) {
        long start = System.currentTimeMillis();
        boolean isTripReimsBill = "er_tripreimbursebill".equals(billFormId);
        ArrayList<ReimAmountQuotaAmountBO> resultList = new ArrayList<ReimAmountQuotaAmountBO>();
        HashMap quotaMap = new HashMap(reimAmountBOList.size());
        HashMap quotaIdMap = new HashMap(reimAmountBOList.size());
        reimAmountBOList.forEach(quotaAmountBO -> {
            quotaIdMap.put(quotaAmountBO.getReimburseamountrowID(), quotaAmountBO);
            Long employee = quotaAmountBO.getUserOrDeptId() == null ? Long.valueOf(0L) : quotaAmountBO.getUserOrDeptId();
            Long expenseItemId = quotaAmountBO.getExpenseItemId() == null ? Long.valueOf(0L) : quotaAmountBO.getExpenseItemId();
            Long companyId = quotaAmountBO.getCompanyId() == null ? Long.valueOf(0L) : quotaAmountBO.getCompanyId();
            String key = String.valueOf(employee) + expenseItemId + companyId;
            List boList = quotaMap.getOrDefault(key, new ArrayList());
            boList.add(quotaAmountBO);
            quotaMap.put(key, boList);
        });
        HashMap<Long, BigDecimal> amountMap = new HashMap<Long, BigDecimal>(16);
        WrappedObject dataSize = new WrappedObject((Object)0);
        dataSet.forEach(data -> {
            dataSize.setValue((Object)((Integer)dataSize.getValue() + 1));
            Long dataEmployee = data.getLong(employeeKey) == null ? Long.valueOf(0L) : data.getLong(employeeKey);
            Long dataExpenseitemId = data.getLong(expenseitem) == null ? Long.valueOf(0L) : data.getLong(expenseitem);
            Long dataCompanyId = data.getLong(companyField) == null ? Long.valueOf(0L) : data.getLong(companyField);
            String matchKey = String.valueOf(dataEmployee) + dataExpenseitemId + dataCompanyId;
            List quotaAmountBOList = (List)quotaMap.get(matchKey);
            if (quotaAmountBOList != null) {
                Date dataSetDate = data.getDate(quotaDateField) == null ? new Date() : data.getDate(quotaDateField);
                quotaAmountBOList.forEach(quotaAmountBO -> {
                    String currencyKey = isTripReimsBill ? quotaAmountBO.getTripCurrencyKey() : quotaAmountBO.getExpenseCurrencyKey();
                    Long dataCurrency = data.getLong(currencyKey) == null ? Long.valueOf(0L) : data.getLong(currencyKey);
                    Long currency = quotaAmountBO.getCurrencyId() == null ? Long.valueOf(0L) : quotaAmountBO.getCurrencyId();
                    QuotaCtlMethodService quotaCtlMethodService = QuotaCtlMethodFactory.get(quotaAmountBO.getCtrlMethod());
                    Map<String, LocalDate> happenDatePeriod = quotaCtlMethodService.genHappenDatePeriod((QuotaAmountBO)quotaAmountBO);
                    Date startDate = ErCommonUtils.getDateFromLocalDate(happenDatePeriod.get("start")) == null ? new Date(Long.MAX_VALUE) : ErCommonUtils.getDateFromLocalDate(happenDatePeriod.get("start"));
                    Date endDate = ErCommonUtils.getDateFromLocalDate(happenDatePeriod.get("end")) == null ? new Date(Long.MIN_VALUE) : ErCommonUtils.getDateFromLocalDate(happenDatePeriod.get("end"));
                    String expenseAmountKey = isTripReimsBill ? quotaAmountBO.getTripAmountKey() : quotaAmountBO.getExpenseAmountKey();
                    BigDecimal amount = data.getBigDecimal(expenseAmountKey);
                    if (currency.compareTo(dataCurrency) == 0 && startDate.compareTo(dataSetDate) <= 0 && endDate.compareTo(dataSetDate) >= 0) {
                        BigDecimal decimal = amountMap.getOrDefault(quotaAmountBO.getReimburseamountrowID(), BigDecimal.ZERO);
                        amountMap.put(quotaAmountBO.getReimburseamountrowID(), decimal.add(amount));
                    }
                });
            }
        });
        dataSet.close();
        amountMap.forEach((k, v) -> resultList.add(new ReimAmountQuotaAmountBO((QuotaAmountBO)quotaIdMap.get(k), (BigDecimal)v)));
        long cost = System.currentTimeMillis() - start;
        log.info(String.format("kd.fi.er.business.reimamountctl.utils.QuotaCtrlUtil.buildReimedAmount: billFormId:%s dataSize:%s cost:%s", billFormId, dataSize.getValue(), cost));
        return resultList;
    }
}

