/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.reimamountctl.utils;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.fi.er.business.daily.service.model.ReimburseAmountControlResultBO;
import kd.fi.er.business.reimamountctl.mode.QuotaCtrlMode;
import kd.fi.er.business.reimamountctl.mode.QuotaCtrlModeFactory;
import kd.fi.er.business.reimamountctl.model.ExpItemAmountBO;
import kd.fi.er.business.reimamountctl.model.ExpItemCurrencyReimerBO;
import kd.fi.er.business.reimamountctl.model.QuotaAmountBO;
import kd.fi.er.business.reimamountctl.utils.QuotaCtrlUtil;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.business.utils.ReimburseControlUtils;
import kd.fi.er.business.utils.SystemParamterUtil;
import org.apache.commons.lang3.StringUtils;

public class TripReimQuotaValidate {
    public static void genQuotaAmount(QuotaAmountBO quotaAmountBO, DynamicObject expItem) {
    }

    public static void genExpenseQuotaAmount(Long companyId, DynamicObject expenseDO) {
    }

    public static List<String> validTripReimQuota(DynamicObject dataEntity, ExtendedDataEntity[] dataEntities) {
        ArrayList result = Lists.newArrayListWithExpectedSize((int)0);
        List longSet = Arrays.stream(dataEntities).map(ite -> ite.getDataEntity()).filter(entity -> ErCommonUtils.getPk(ReimburseControlUtils.getReimburseControlCompany(dataEntity)).equals(ErCommonUtils.getPk(ReimburseControlUtils.getReimburseControlCompany(dataEntity)))).collect(Collectors.toList());
        Long currBillId = (Long)dataEntity.getPkValue();
        DynamicObject quotaCtrlCompany = ReimburseControlUtils.getReimburseControlCompany(dataEntity);
        if (quotaCtrlCompany == null) {
            return result;
        }
        Long quotaCtrlCompanyId = ErCommonUtils.getPk(quotaCtrlCompany);
        DynamicObject company = ReimburseControlUtils.getParameterSettingCompany(dataEntity);
        Long companyId = ErCommonUtils.getPk(company);
        Long baseCurrencyId = ErCommonUtils.getPk(dataEntity.getDynamicObject("currency"));
        String personCtrlCurrency = (String)ErCommonUtils.getEMParameter(companyId, "personctlcurrency");
        String deptCtrlCurrency = (String)ErCommonUtils.getEMParameter(companyId, "deptctlcurrency");
        ArrayList tripSeg = new ArrayList();
        DynamicObjectCollection travelList = new DynamicObjectCollection();
        DynamicObjectCollection tripEntries = new DynamicObjectCollection();
        for (DynamicObject item : longSet) {
            DynamicObjectCollection tripEntry = item.getDynamicObjectCollection("tripentry");
            tripEntries.addAll((Collection)tripEntry);
            int tripSegIdx = 1;
            for (DynamicObject trip : tripEntry) {
                DynamicObjectCollection travelEntries = trip.getDynamicObjectCollection("entryentity");
                int finalTripSegIdx = tripSegIdx++;
                IntStream.rangeClosed(1, travelEntries.size()).forEach(ind -> tripSeg.add(finalTripSegIdx * 100000 + ind));
                travelList.addAll((Collection)travelEntries);
                if (trip.getDynamicObject("tripexpenseitem") != null) continue;
                result.add(ResManager.loadKDString((String)"\u8d39\u7528\u9879\u76ee\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"TripReimQuotaValidate_0", (String)"fi-er-business", (Object[])new Object[0]));
            }
        }
        if (result.size() > 0) {
            return result;
        }
        if (travelList.isEmpty()) {
            return null;
        }
        HashMap<ExpItemCurrencyReimerBO, List> empExpItemAmount = new HashMap<ExpItemCurrencyReimerBO, List>(travelList.size());
        HashMap<ExpItemCurrencyReimerBO, List> deptExpItemAmount = new HashMap<ExpItemCurrencyReimerBO, List>(travelList.size());
        Map<Object, List<DynamicObject>> collect = tripEntries.stream().collect(Collectors.groupingBy(new Function<DynamicObject, Object>(){

            @Override
            public Object apply(DynamicObject dynamicObject) {
                return dynamicObject.getDynamicObject("tripexpenseitem") != null ? dynamicObject.getDynamicObject("tripexpenseitem").getPkValue() : null;
            }
        }));
        Map<Object, List<DynamicObject>> second = tripEntries.stream().filter(ite -> ite.getDynamicObject("tripexpenseitem") != null && "B".equals(ite.getDynamicObject("tripexpenseitem").get("reimburseamountctlmethod"))).collect(Collectors.groupingBy(new Function<DynamicObject, Object>(){

            @Override
            public Object apply(DynamicObject dynamicObject) {
                Date date = dynamicObject.getDate("triphappendate");
                LocalDate happenDate = ErCommonUtils.getLocalDateFromDate(date);
                StringBuilder builder = new StringBuilder();
                builder.append(dynamicObject.getDynamicObject("tripexpenseitem").getPkValue());
                builder.append(happenDate != null ? Integer.valueOf(happenDate.getYear()) : "");
                builder.append(happenDate != null ? Integer.valueOf(happenDate.getMonth().getValue()) : "");
                return builder.toString();
            }
        }));
        if (tripEntries.size() < 2) {
            tripSeg.clear();
            IntStream.rangeClosed(1, travelList.size()).forEach(ind -> tripSeg.add(ind));
        }
        int index = 0;
        for (DynamicObject travel : travelList) {
            ExpItemCurrencyReimerBO deptKey;
            StringBuilder builder;
            Integer size;
            BigDecimal reimedAmount;
            Long currencyId;
            DynamicObject travelexpenseitem = travel.getDynamicObject("travelexpenseitem");
            if (travelexpenseitem == null) continue;
            Long expItemId = (Long)travelexpenseitem.getPkValue();
            Long oriCurrency = (Long)travel.getDynamicObject("entrycurrency").getPkValue();
            LocalDate happenDate = ErCommonUtils.getLocalDateFromDate(travel.getDate("travelhappendate"));
            String ctrlMode = travelexpenseitem.getString("isreimburseamountctl");
            if ("1".equals(ctrlMode)) {
                ExpItemCurrencyReimerBO empKey;
                if ("0".equals(personCtrlCurrency)) {
                    currencyId = oriCurrency;
                    reimedAmount = travel.getBigDecimal("orientryappamount");
                } else {
                    currencyId = baseCurrencyId;
                    reimedAmount = travel.getBigDecimal("entryappamount");
                }
                Long travelerId = (Long)((DynamicObject)travel.getDynamicObjectCollection("trip2travelers").get(0)).get("fbasedataid.id");
                if (travelerId == null) {
                    Integer integer = (Integer)tripSeg.get(index);
                    result.add(ResManager.loadKDString((String)"\u8d39\u7528\u9879\u76ee\u4e3a\u5458\u5de5\u989d\u5ea6\u63a7\u5236\u65f6\uff0c\u5dee\u65c5\u660e\u7ec6\u884c\u51fa\u5dee\u4eba\u5fc5\u586b\uff0c\u7b2c%1$s\u884c\u7a0b\u7b2c%2$s\u5dee\u65c5\u660e\u7ec6\u4e2d\u51fa\u5dee\u4eba\u4e3a\u7a7a\uff0c\u8bf7\u91cd\u65b0\u7ef4\u62a4", (String)"TripReimQuotaValidate_1", (String)"fi-er-business", (Object[])new Object[]{integer / 100000 + 1, integer % 100000}));
                }
                size = 1;
                if (travel.getDynamicObject("travelexpenseitem") != null && collect.get(travel.getDynamicObject("travelexpenseitem").getPkValue()) != null) {
                    size = collect.get(travel.getDynamicObject("travelexpenseitem").getPkValue()).size();
                }
                if (travel.getDynamicObject("travelexpenseitem") != null && happenDate != null) {
                    int year = happenDate.getYear();
                    int month = happenDate.getMonth().getValue();
                    builder = new StringBuilder();
                    builder.append(travel.getDynamicObject("travelexpenseitem").getPkValue());
                    builder.append(year);
                    builder.append(month);
                    if (second.get(builder.toString()) != null) {
                        size = second.get(builder.toString()).size();
                    }
                }
                if (!empExpItemAmount.containsKey(empKey = new ExpItemCurrencyReimerBO(expItemId, currencyId, travelerId, size))) {
                    empExpItemAmount.put(empKey, new ArrayList());
                }
                List reimburseAmountBOs = (List)empExpItemAmount.get(empKey);
                reimburseAmountBOs.add(new ExpItemAmountBO(happenDate, reimedAmount, currencyId, (Integer)tripSeg.get(index++)));
                continue;
            }
            if (!"2".equals(ctrlMode)) continue;
            if ("0".equals(deptCtrlCurrency)) {
                currencyId = oriCurrency;
                reimedAmount = travel.getBigDecimal("orientryappamount");
            } else {
                currencyId = baseCurrencyId;
                reimedAmount = travel.getBigDecimal("entryappamount");
            }
            Long deptId = (Long)travel.getDynamicObject("travelquotactldept").getPkValue();
            size = 1;
            if (travel.getDynamicObject("travelexpenseitem") != null && collect.get(travel.getDynamicObject("travelexpenseitem").getPkValue()) != null) {
                size = collect.get(travel.getDynamicObject("travelexpenseitem").getPkValue()).size();
            }
            if (travel.getDynamicObject("travelexpenseitem") != null && happenDate != null) {
                int year = happenDate.getYear();
                int month = happenDate.getMonth().getValue();
                builder = new StringBuilder();
                builder.append(travel.getDynamicObject("travelexpenseitem").getPkValue());
                builder.append(year);
                builder.append(month);
                if (second.get(builder.toString()) != null) {
                    size = second.get(builder.toString()).size();
                }
            }
            if (!deptExpItemAmount.containsKey(deptKey = new ExpItemCurrencyReimerBO(expItemId, currencyId, deptId, size))) {
                deptExpItemAmount.put(deptKey, new ArrayList());
            }
            List deptReimburseAmountBOs = (List)deptExpItemAmount.get(deptKey);
            deptReimburseAmountBOs.add(new ExpItemAmountBO(happenDate, reimedAmount, currencyId, (Integer)tripSeg.get(index++)));
        }
        if (result.size() > 0) {
            return result;
        }
        List<String> empCltList = SystemParamterUtil.getEmpCltBillList(companyId);
        List<String> deptCltList = SystemParamterUtil.getDeptCltBillList(companyId);
        AtomicBoolean isHaveEmpQuota = new AtomicBoolean(false);
        AtomicBoolean isOverEmpQuota = new AtomicBoolean(false);
        if (empCltList.contains("2")) {
            empExpItemAmount.forEach((expItemCurrencyReimerBO, expItemAmountBOs) -> {
                isHaveEmpQuota.set(true);
                QuotaAmountBO quotaAmountBO = new QuotaAmountBO();
                quotaAmountBO.setCompanyId(quotaCtrlCompanyId);
                quotaAmountBO.setEmpCtlBill(empCltList);
                quotaAmountBO.setDeptCtlBill(deptCltList);
                quotaAmountBO.setNotInIds(Lists.newArrayList((Object[])new Long[]{currBillId}));
                quotaAmountBO.setUserOrDeptId(expItemCurrencyReimerBO.getUserOrDeptId());
                QuotaCtrlUtil.genQuotaExpItem(quotaAmountBO, expItemCurrencyReimerBO.getExpItemId());
                QuotaCtrlUtil.genQuotaCurrency(quotaAmountBO, personCtrlCurrency, expItemCurrencyReimerBO.getCurrencyId(), expItemCurrencyReimerBO.getCurrencyId());
                QuotaCtrlMode quotaCtrlMode = QuotaCtrlModeFactory.getQuotaCtrlMode(quotaAmountBO);
                ReimburseAmountControlResultBO res = quotaCtrlMode.validate((List<ExpItemAmountBO>)expItemAmountBOs, quotaAmountBO, expItemCurrencyReimerBO.getExpItemSize());
                if (res.isOver()) {
                    isOverEmpQuota.set(true);
                    if (StringUtils.isNotEmpty((CharSequence)res.getSelfMsg())) {
                        result.add(res.getSelfMsg());
                    } else {
                        result.add(res.getOverDesc());
                    }
                }
            });
            if (!isHaveEmpQuota.get()) {
                dataEntity.set("abovequotaemp", (Object)"0");
            } else if (isOverEmpQuota.get()) {
                dataEntity.set("abovequotaemp", (Object)"1");
            } else {
                dataEntity.set("abovequotaemp", (Object)"2");
            }
        }
        AtomicBoolean isHaveDeptQuota = new AtomicBoolean(false);
        AtomicBoolean isOverDeptQuota = new AtomicBoolean(false);
        if (deptCltList.contains("2")) {
            deptExpItemAmount.forEach((expItemCurrencyReimerBO, expItemAmountBOs) -> {
                isHaveDeptQuota.set(true);
                QuotaAmountBO quotaAmountBO = new QuotaAmountBO();
                quotaAmountBO.setCompanyId(quotaCtrlCompanyId);
                quotaAmountBO.setEmpCtlBill(empCltList);
                quotaAmountBO.setDeptCtlBill(deptCltList);
                quotaAmountBO.setNotInIds(Lists.newArrayList((Object[])new Long[]{currBillId}));
                quotaAmountBO.setUserOrDeptId(expItemCurrencyReimerBO.getUserOrDeptId());
                QuotaCtrlUtil.genQuotaExpItem(quotaAmountBO, expItemCurrencyReimerBO.getExpItemId());
                QuotaCtrlUtil.genQuotaCurrency(quotaAmountBO, deptCtrlCurrency, expItemCurrencyReimerBO.getCurrencyId(), expItemCurrencyReimerBO.getCurrencyId());
                QuotaCtrlMode quotaCtrlMode = QuotaCtrlModeFactory.getQuotaCtrlMode(quotaAmountBO);
                ReimburseAmountControlResultBO res = quotaCtrlMode.validate((List<ExpItemAmountBO>)expItemAmountBOs, quotaAmountBO, expItemCurrencyReimerBO.getExpItemSize());
                if (res.isOver()) {
                    isOverDeptQuota.set(true);
                    if (StringUtils.isNotEmpty((CharSequence)res.getSelfMsg())) {
                        result.add(res.getSelfMsg());
                    } else {
                        result.add(res.getOverDesc());
                    }
                }
            });
            if (!isHaveDeptQuota.get()) {
                dataEntity.set("abovequotadept", (Object)"0");
            } else if (isOverDeptQuota.get()) {
                dataEntity.set("abovequotadept", (Object)"1");
            } else {
                dataEntity.set("abovequotadept", (Object)"2");
            }
        }
        if (null != result && result.size() > 0) {
            return result.stream().sorted().collect(Collectors.toList());
        }
        return result;
    }
}

