/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.reportmb.core;

import java.util.List;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.fi.er.business.reportmb.core.CollIndex;
import kd.fi.er.business.reportmb.core.FieldDO;
import org.apache.curator.shaded.com.google.common.collect.Lists;

public class TableDO {
    private List<FieldDO> fields;
    private CollIndex collIndex;
    private String tableName;
    private String billType;
    private List<QFilter> qFilters = Lists.newArrayListWithExpectedSize((int)16);

    public String getSelectSQL() {
        StringBuilder sb = new StringBuilder();
        this.fields.stream().forEach(f -> {
            if (StringUtils.isNotBlank((CharSequence)f.getEntryKey())) {
                sb.append(f.getEntryKey()).append(".");
            }
            sb.append(f.getName()).append(" ").append(f.getAlias()).append(",");
        });
        return sb.length() > 0 ? sb.substring(0, sb.length() - 1) : "";
    }

    public List<QFilter> getQFilters() {
        return this.qFilters;
    }

    public TableDO(List<FieldDO> fields, String tableName, String billtype) {
        this.fields = fields;
        this.tableName = tableName;
        this.collIndex = new CollIndex(fields);
        this.billType = billtype;
    }

    public List<FieldDO> getFields() {
        return this.fields;
    }

    public String getTableName() {
        return this.tableName;
    }

    public Integer getFieldIndex(String name) {
        return this.collIndex.getFieldIndex(name);
    }

    public List<FieldDO> getSumField() {
        return this.collIndex.getSumField();
    }

    public List<FieldDO> getGroupField() {
        return this.collIndex.getGroupField();
    }

    public String getBillType() {
        return this.billType;
    }
}

