/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.reportmb.datahandler.analysis.dept;

import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import kd.fi.er.business.reportmb.context.AbstractReportContext;
import kd.fi.er.business.reportmb.core.FieldDO;
import kd.fi.er.business.reportmb.core.TableDO;
import kd.fi.er.business.reportmb.datahandler.IMBReportDataHandler;

public class Group2ListHandler
implements IMBReportDataHandler<Map<String, Map<String, Map<String, BigDecimal>>>> {
    private Map<TableDO, List<Object[]>> data;

    public Group2ListHandler(Map<TableDO, List<Object[]>> data) {
        this.data = data;
    }

    @Override
    public Map<String, Map<String, Map<String, BigDecimal>>> doHandler(AbstractReportContext context) {
        HashMap groupMap = Maps.newHashMapWithExpectedSize((int)8);
        for (Map.Entry<TableDO, List<Object[]>> entry : this.data.entrySet()) {
            List<Object[]> rows = entry.getValue();
            TableDO tableDO = entry.getKey();
            this.groupByField(tableDO, rows, groupMap);
        }
        return groupMap;
    }

    private void groupByField(TableDO tableDO, List<Object[]> rows, Map<String, Map<String, Map<String, BigDecimal>>> groupMap) {
        List<FieldDO> sumFields = tableDO.getSumField();
        List<FieldDO> groupFields = tableDO.getGroupField();
        for (Object[] row : rows) {
            groupFields.forEach(groupf -> this.groupByField(tableDO, groupMap, sumFields, row, (FieldDO)groupf));
        }
    }

    private void groupByField(TableDO tableDO, Map<String, Map<String, Map<String, BigDecimal>>> groupMap, List<FieldDO> sumFields, Object[] row, FieldDO groupf) {
        Object groupElement;
        String groupElementStr;
        Map sumMap;
        TreeMap map = groupMap.get(groupf.getAlias());
        if (map == null) {
            map = Maps.newTreeMap();
            groupMap.put(groupf.getAlias(), map);
        }
        if ((sumMap = (Map)map.get(groupElementStr = Objects.toString(groupElement = row[tableDO.getFieldIndex(groupf.getAlias())]))) == null) {
            sumMap = Maps.newHashMapWithExpectedSize((int)sumFields.size());
            map.put(groupElementStr, sumMap);
        }
        for (FieldDO sumf : sumFields) {
            this.sumAmount(tableDO, row, sumMap, sumf);
        }
    }

    private void sumAmount(TableDO tableDO, Object[] row, Map<String, BigDecimal> sumMap, FieldDO sumf) {
        BigDecimal decimal = (BigDecimal)row[tableDO.getFieldIndex(sumf.getAlias())];
        decimal = decimal == null ? BigDecimal.ZERO : decimal;
        BigDecimal sumDecimal = sumMap.get(sumf.getAlias());
        sumDecimal = sumDecimal == null ? decimal : sumDecimal.add(decimal);
        sumMap.put(sumf.getAlias(), sumDecimal);
    }
}

