/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.reportmb.datahandler.analysis.dept;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.fi.er.business.reportmb.context.AbstractReportContext;
import kd.fi.er.business.reportmb.context.DeptReimAnalysisContext;
import kd.fi.er.business.reportmb.core.FieldDO;
import kd.fi.er.business.reportmb.core.TableDO;
import kd.fi.er.business.reportmb.datahandler.IMBReportDataHandler;
import org.apache.commons.lang3.StringUtils;
import org.apache.curator.shaded.com.google.common.collect.Sets;

public class SumAmountByStatusAndMonthDataHandler
implements IMBReportDataHandler<List<Map<String, Object>>> {
    private Map<TableDO, List<Object[]>> data;

    public SumAmountByStatusAndMonthDataHandler(Map<TableDO, List<Object[]>> data) {
        this.data = data;
    }

    @Override
    public List<Map<String, Object>> doHandler(AbstractReportContext context) {
        IFormView view = context.getView();
        IDataModel model = view.getModel();
        Set<String> doneVal = this.getStatusSet((String)model.getValue("doneval"));
        Set<String> inprocessVal = this.getStatusSet((String)model.getValue("inprocessval"));
        Date enddate = (Date)model.getValue("bizdate");
        Integer monthRange = ((DeptReimAnalysisContext)context).getMonthrange();
        HashMap groupMap = Maps.newHashMapWithExpectedSize((int)monthRange);
        for (Map.Entry<TableDO, List<Object[]>> entry : this.data.entrySet()) {
            List<Object[]> rows = entry.getValue();
            TableDO tableDO = entry.getKey();
            List<FieldDO> sumFields = tableDO.getSumField();
            FieldDO sumField = sumFields.get(0);
            Integer bizDateIndex = tableDO.getFieldIndex(FieldDO.dateField.getAlias());
            for (Object[] row : rows) {
                Object amount;
                String billstatus;
                String groupKey;
                BigDecimal decimal;
                String dateFormat = this.getDateStr((Date)row[bizDateIndex]);
                Map map = (Map)groupMap.get(dateFormat);
                if (map == null) {
                    map = Maps.newHashMapWithExpectedSize((int)sumFields.size());
                    groupMap.put(dateFormat, map);
                }
                if ((decimal = (BigDecimal)map.get(groupKey = this.getGroupKey(billstatus = (String)row[tableDO.getFieldIndex(FieldDO.billStatusField.getAlias())], doneVal, inprocessVal, row, tableDO))) == null) {
                    decimal = BigDecimal.ZERO;
                }
                decimal = decimal.add((amount = row[tableDO.getFieldIndex(sumField.getAlias())]) == null ? BigDecimal.ZERO : (BigDecimal)amount);
                map.put(groupKey, decimal);
            }
        }
        return this.createList(groupMap, enddate, monthRange);
    }

    private Set<String> getStatusSet(String value) {
        if (StringUtils.isNotBlank((CharSequence)value)) {
            return Sets.newHashSet((Object[])value.split(","));
        }
        throw new KDBizException("status is empty");
    }

    private List<Map<String, Object>> createList(Map<String, Map<String, BigDecimal>> groupMap, Date enddate, Integer monthRange) {
        ArrayList list = Lists.newArrayListWithExpectedSize((int)monthRange);
        for (int i = 0; i < monthRange; ++i) {
            String bizDateStr = this.getDateStr(enddate, i);
            HashMap map = Maps.newHashMapWithExpectedSize((int)4);
            list.add(map);
            map.put("bizdate", bizDateStr);
            Map<String, BigDecimal> entryValue = groupMap.get(bizDateStr);
            BigDecimal inprocessVal = this.getValue(entryValue, "inprocessval");
            BigDecimal doneVal = this.getValue(entryValue, "doneval");
            BigDecimal inprocessValformat = inprocessVal.setScale(2, RoundingMode.HALF_EVEN);
            map.put("inprocessval", inprocessValformat);
            BigDecimal doneValFormat = doneVal.setScale(2, RoundingMode.HALF_EVEN);
            map.put("doneval", doneValFormat);
            map.put("totalamt", inprocessValformat.add(doneValFormat));
        }
        return list;
    }

    private BigDecimal getValue(Map<String, BigDecimal> entryValue, String key) {
        BigDecimal bigDecimal;
        if (entryValue != null && (bigDecimal = entryValue.get(key)) != null) {
            return bigDecimal;
        }
        return BigDecimal.ZERO;
    }

    private String getDateStr(Date date, int preMonth) {
        Calendar instance = Calendar.getInstance();
        instance.setTime(date);
        if (preMonth != 0) {
            instance.add(2, 0 - preMonth);
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM");
        return sdf.format(instance.getTime());
    }

    private String getGroupKey(String billstatus, Set<String> doneVal, Set<String> inprocessVal, Object[] row, TableDO tableDO) {
        if ("E".equalsIgnoreCase(billstatus)) {
            BigDecimal encashedAmt = (BigDecimal)row[tableDO.getFieldIndex(FieldDO.encashedAmtField.getAlias())];
            if (BigDecimal.ZERO.compareTo(encashedAmt) < 0) {
                return "inprocessval";
            }
            return "doneval";
        }
        if (doneVal.contains(billstatus)) {
            return "doneval";
        }
        if (inprocessVal.contains(billstatus)) {
            return "inprocessval";
        }
        return null;
    }

    private String getDateStr(Date date) {
        return this.getDateStr(date, 0);
    }
}

