/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.servicehelper;

import java.time.Instant;
import java.time.LocalDate;
import java.time.Month;
import java.time.ZoneId;
import java.time.temporal.ChronoField;
import java.util.ArrayList;
import java.util.Date;
import java.util.TimeZone;
import kd.bos.algo.DataSet;
import kd.bos.algo.JoinType;
import kd.bos.entity.report.FilterInfo;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.time.TimeService;
import kd.fi.er.business.servicehelper.CommonServiceHelper;

public abstract class AbstractBalanceServiceHelper {
    private static final String BEGIN_DATE = "begindate";
    private static final String END_DATE = "enddate";
    private static final String ER_REPORT_KEY = "fi.er.report";
    private static final String BIZDATE = "bizdate";
    private static final String APPLIER = "applier";
    private String selectFieldStr = null;

    public QFilter getBaseFilter(FilterInfo reportObject) {
        Long userId = CommonServiceHelper.getCurrentUserID();
        QFilter qA = new QFilter("applier.id", "=", (Object)userId);
        if (reportObject.getValue("org") != null) {
            Long orgUnitId = (long)((Integer)reportObject.getValue("org"));
            QFilter qB = new QFilter("org.id", "=", (Object)orgUnitId);
            qA = qA.and(qB);
        }
        return qA;
    }

    public QFilter getBeginFilter(FilterInfo reportQueryParam) {
        Date startDate = reportQueryParam.getDate(BEGIN_DATE);
        QFilter qA = this.getBaseFilter(reportQueryParam);
        QFilter qB = new QFilter(BIZDATE, "<=", (Object)startDate);
        return qA.and(qB);
    }

    public QFilter getHappenFilter(FilterInfo reportQueryParam) {
        Date startDate = reportQueryParam.getDate(BEGIN_DATE);
        Date endDate = reportQueryParam.getDate(END_DATE);
        QFilter qA = this.getBaseFilter(reportQueryParam);
        QFilter qB = new QFilter(BIZDATE, ">=", (Object)startDate);
        QFilter qC = new QFilter(BIZDATE, "<=", (Object)endDate);
        return qA.and(qB).and(qC);
    }

    public QFilter getEndFilter(FilterInfo reportQueryParam) {
        Date endDate = reportQueryParam.getDate(END_DATE);
        QFilter qA = this.getBaseFilter(reportQueryParam);
        QFilter qB = new QFilter(BIZDATE, ">=", (Object)endDate);
        return qA.and(qB);
    }

    public DataSet getApplierSet() {
        ArrayList<QFilter> filterList = new ArrayList<QFilter>();
        Long userId = CommonServiceHelper.getCurrentUserID();
        filterList.add(new QFilter("id", "=", (Object)userId));
        QFilter[] qFilters = filterList.toArray(new QFilter[filterList.size()]);
        ORM orm = ORM.create();
        this.selectFieldStr = APPLIER;
        return orm.queryDataSet(ER_REPORT_KEY, "bos_user", "id applier", qFilters);
    }

    public DataSet getSumAmount(QFilter qFilter, String entityName, String amountPropName, String aliasName, DataSet beforeSet) {
        ORM orm = ORM.create();
        QFilter[] qFilters = new QFilter[]{qFilter};
        String selectStr = "applier.id applier,%s %s";
        DataSet dataSet = orm.queryDataSet(ER_REPORT_KEY, entityName, String.format(selectStr, amountPropName, aliasName), qFilters);
        dataSet = dataSet.groupBy(new String[]{APPLIER}).sum(aliasName).finish();
        if (beforeSet != null) {
            dataSet = beforeSet.join(dataSet, JoinType.LEFT).on(APPLIER, APPLIER).select(this.selectFieldStr.split(","), new String[]{aliasName}).finish();
        }
        this.selectFieldStr = this.selectFieldStr + "," + aliasName;
        return dataSet;
    }

    public DataSet calcSumAmount(DataSet beforeSet, String endProp, String endPropAlias) {
        this.selectFieldStr = this.selectFieldStr + "," + endProp + " " + endPropAlias;
        return beforeSet.select(this.selectFieldStr.split(","));
    }

    public FilterInfo initFilterMap(FilterInfo filterMap) {
        TimeService timeService = new TimeService();
        TimeZone systemTimeZone = timeService.getSystemTimeZone();
        ZoneId zoneId = systemTimeZone.toZoneId();
        LocalDate localDate = LocalDate.now(zoneId);
        Boolean withDaycheck = filterMap.getBoolean("withdaycheck");
        Boolean withMonthCheck = filterMap.getBoolean("withmonthcheck");
        Boolean withSeasonCheck = filterMap.getBoolean("withseasoncheck");
        LocalDate startLocalDate = null;
        LocalDate endLocalDate = null;
        if (withDaycheck.booleanValue() || withMonthCheck.booleanValue() || withSeasonCheck.booleanValue()) {
            if (withDaycheck.booleanValue()) {
                startLocalDate = localDate;
                endLocalDate = localDate.plusDays(1L);
            } else if (withMonthCheck.booleanValue()) {
                startLocalDate = localDate.withDayOfMonth(1);
                endLocalDate = localDate.withDayOfMonth(localDate.lengthOfMonth());
            } else {
                startLocalDate = AbstractBalanceServiceHelper.beginOfSeason(localDate);
                endLocalDate = this.endOfSeason(localDate);
            }
            Instant instant = startLocalDate.atStartOfDay(zoneId).toInstant();
            Date beginDate = Date.from(instant);
            filterMap.addFilterItem(BEGIN_DATE, (Object)beginDate);
            instant = endLocalDate.atStartOfDay(zoneId).toInstant();
            Date endDate = Date.from(instant);
            filterMap.addFilterItem(END_DATE, (Object)endDate);
        } else {
            Date beginDate = filterMap.getDate(BEGIN_DATE);
            Date enddate = filterMap.getDate(END_DATE);
            if (beginDate == null) {
                beginDate = enddate;
            }
            if (enddate == null) {
                enddate = beginDate;
            }
            if (beginDate != null) {
                filterMap.addFilterItem(BEGIN_DATE, (Object)beginDate);
            }
            if (enddate != null) {
                filterMap.addFilterItem(END_DATE, (Object)enddate);
            }
        }
        return filterMap;
    }

    public static LocalDate beginOfSeason(LocalDate date) {
        int nMonth = date.get(ChronoField.MONTH_OF_YEAR);
        switch (Month.of(nMonth)) {
            case JANUARY: 
            case FEBRUARY: 
            case MARCH: {
                return date.minusMonths((long)nMonth + (long)Month.DECEMBER.getValue() - (long)Month.OCTOBER.getValue()).withDayOfMonth(1);
            }
            case APRIL: 
            case MAY: 
            case JUNE: 
            case JULY: 
            case AUGUST: 
            case SEPTEMBER: {
                return date.minusMonths((long)nMonth - (long)Month.APRIL.getValue()).withDayOfMonth(1);
            }
        }
        return date.minusMonths((long)nMonth - (long)Month.OCTOBER.getValue()).withDayOfMonth(1);
    }

    private LocalDate endOfSeason(LocalDate date) {
        LocalDate result = AbstractBalanceServiceHelper.beginOfSeason(date);
        LocalDate tmpDate = result.plusMonths(2L);
        return tmpDate.withDayOfMonth(date.lengthOfMonth());
    }
}

