/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.servicehelper;

import com.google.common.base.Objects;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.temporal.TemporalAdjusters;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.algo.DataSet;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.control.SplitContainer;
import kd.bos.form.control.SplitDirection;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.script.annotations.KSMethod;
import kd.bos.script.annotations.KSObject;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.fi.er.business.dao.IErDao;
import kd.fi.er.business.dao.factory.ErDaoFactory;
import kd.fi.er.business.servicehelper.BaseCurrencyServiceHelper;
import kd.fi.er.business.servicehelper.CoreBaseBillServiceHelper;
import kd.fi.er.business.servicehelper.TrialOrgServiceHelper;
import kd.fi.er.business.trip.service.factory.TripServiceFactory;
import kd.fi.er.business.trip.service.iservice.ITripService;
import kd.fi.er.business.trip.supplier.Supplier;
import kd.fi.er.business.trip.supplier.ctrip.invoke.convert.ConvertUtil;
import kd.fi.er.business.trip.util.TripCommonUtil;
import kd.fi.er.business.trip.v2.server.gtrip.GtripFieldMappingInvoke;
import kd.fi.er.business.trip.v2.server.number.TripMappingNumber;
import kd.fi.er.business.tripstd.context.StdPreCalContext;
import kd.fi.er.business.tripstd.service.imp.ErTripStdControlServiceImpl;
import kd.fi.er.business.utils.ActionLocalCache;
import kd.fi.er.business.utils.AmountUtils;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.business.utils.ErEntityTypeUtils;
import kd.fi.er.business.utils.ErStdConfig;
import kd.fi.er.business.utils.InvoiceUtils;
import kd.fi.er.business.utils.SystemParamterUtil;
import kd.fi.er.common.ErBillStatusEnum;
import kd.fi.er.common.PayerTypeEnum;
import kd.fi.er.common.utils.MD5;
import org.apache.commons.lang.StringUtils;

@KSObject
public class CommonServiceHelper {
    public static final String USER_DYNAMIC_OBJECT_MAP = "kd.fi.er.business.servicehelper.CommonServiceHelper.USER_DYNAMIC_OBJECT_MAP";
    private static Log logger = LogFactory.getLog(CommonServiceHelper.class);
    protected static String[] outStandingState = new String[]{"B", "C", "E", "F"};
    protected static String[] orderTypeArr = new String[]{"er_planebill", "er_trainbill", "er_vehiclebill", "er_hotelbill"};

    private CommonServiceHelper() {
    }

    public static Long getCurrentUserID() {
        return Long.valueOf(RequestContext.get().getUserId());
    }

    public static String getCurrentUserName() {
        return RequestContext.get().getUserName();
    }

    public static Map<String, Object> getUserMap(Long userId) {
        return CommonServiceHelper.getUserMap(userId, null, false);
    }

    public static Map<String, Object> getUserMap(Long userId, Long dptId) {
        return CommonServiceHelper.getUserMap(userId, dptId, false);
    }

    public static Map<String, Object> getUserMap(Long userId, Long dptId, boolean forceMainDept) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        DynamicObject user = (DynamicObject)ActionLocalCache.get().get(USER_DYNAMIC_OBJECT_MAP, userId, () -> CommonServiceHelper.getUser(userId));
        DynamicObject mainDpt = null;
        String position = null;
        if (user != null) {
            resultMap.put("tel", user.get("phone"));
            resultMap.put("name", user.get("name"));
            resultMap.put("number", user.get("number"));
            resultMap.put("id", user.get("id"));
            DynamicObjectCollection userEntrys = user.getDynamicObjectCollection("entryentity");
            String companySelection = null;
            companySelection = forceMainDept ? "1" : ((companySelection = ErStdConfig.get("companySelection")) == null || companySelection.isEmpty() ? "1" : companySelection);
            long orgId = RequestContext.get().getOrgId();
            for (DynamicObject userEntry : userEntrys) {
                DynamicObject dept = userEntry.getDynamicObject("dpt");
                if (!companySelection.equals("2")) {
                    resultMap.put("applierpositionstr", userEntry.getString("position"));
                    if (dptId == null || dptId == 0L) {
                        boolean isPartjob = userEntry.getBoolean("ispartjob");
                        resultMap.put("org", dept);
                        if (isPartjob) continue;
                        break;
                    }
                    resultMap.put("org", dept);
                    if (!Objects.equal((Object)dptId, (Object)ErCommonUtils.getPk(dept))) continue;
                    break;
                }
                if (dptId == null || dptId == 0L) {
                    Long companyPk = CoreBaseBillServiceHelper.initCompanyByDept(ErCommonUtils.getPk(dept));
                    if (companyPk == null || companyPk == 0L) continue;
                    if (companyPk.compareTo(orgId) == 0) {
                        resultMap.put("org", dept);
                        resultMap.put("applierpositionstr", userEntry.getString("position"));
                        break;
                    }
                    if (userEntry.getBoolean("ispartjob")) continue;
                    mainDpt = dept;
                    position = userEntry.getString("position");
                    continue;
                }
                resultMap.put("org", dept);
                if (!Objects.equal((Object)dptId, (Object)ErCommonUtils.getPk(dept))) continue;
                break;
            }
            resultMap.putIfAbsent("org", mainDpt);
            resultMap.putIfAbsent("applierpositionstr", position);
        }
        return resultMap;
    }

    public static Map<String, Object> getUserMap(Long userId, Long dptId, boolean forceMainDept, StdPreCalContext stdPreCalContext) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        DynamicObject user = null;
        user = stdPreCalContext != null ? stdPreCalContext.getUserDynamicObj().getUserObjByUserId(userId) : (DynamicObject)ActionLocalCache.get().get(USER_DYNAMIC_OBJECT_MAP, userId, () -> CommonServiceHelper.getUser(userId));
        DynamicObject mainDpt = null;
        String position = null;
        if (user != null) {
            resultMap.put("tel", user.get("phone"));
            resultMap.put("name", user.get("name"));
            resultMap.put("number", user.get("number"));
            resultMap.put("id", user.get("id"));
            DynamicObjectCollection userEntrys = user.getDynamicObjectCollection("entryentity");
            String companySelection = null;
            companySelection = forceMainDept ? "1" : ((companySelection = ErStdConfig.get("companySelection")) == null || companySelection.isEmpty() ? "1" : companySelection);
            long orgId = RequestContext.get().getOrgId();
            for (DynamicObject userEntry : userEntrys) {
                DynamicObject dept = userEntry.getDynamicObject("dpt");
                if (!companySelection.equals("2")) {
                    resultMap.put("applierpositionstr", userEntry.getString("position"));
                    if (dptId == null || dptId == 0L) {
                        boolean isPartjob = userEntry.getBoolean("ispartjob");
                        resultMap.put("org", dept);
                        if (isPartjob) continue;
                        break;
                    }
                    resultMap.put("org", dept);
                    if (!Objects.equal((Object)dptId, (Object)ErCommonUtils.getPk(dept))) continue;
                    break;
                }
                if (dptId == null || dptId == 0L) {
                    Long companyPk = CoreBaseBillServiceHelper.initCompanyByDept(ErCommonUtils.getPk(dept));
                    if (companyPk == null || companyPk == 0L) continue;
                    if (companyPk.compareTo(orgId) == 0) {
                        resultMap.put("org", dept);
                        resultMap.put("applierpositionstr", userEntry.getString("position"));
                        break;
                    }
                    if (userEntry.getBoolean("ispartjob")) continue;
                    mainDpt = dept;
                    position = userEntry.getString("position");
                    continue;
                }
                resultMap.put("org", dept);
                if (!Objects.equal((Object)dptId, (Object)ErCommonUtils.getPk(dept))) continue;
                break;
            }
            resultMap.putIfAbsent("org", mainDpt);
            resultMap.putIfAbsent("applierpositionstr", position);
        }
        return resultMap;
    }

    public static DynamicObject getUser(Long userId) {
        QFilter qFilter = new QFilter("id", "=", (Object)userId);
        QFilter[] qFilters = new QFilter[]{qFilter};
        String selectFields = "id,name,number,email,phone,entryentity.id,entryentity.position,entryentity.dpt,entryentity.ispartjob";
        return BusinessDataServiceHelper.loadSingleFromCache((String)"bos_user", (String)selectFields, (QFilter[])qFilters);
    }

    public static Map<Object, DynamicObject> getUsers(Set<Long> allUserIds) {
        QFilter qFilter = new QFilter("id", "in", allUserIds);
        QFilter[] qFilters = new QFilter[]{qFilter};
        String selectFields = "id,name,number,email,phone,entryentity.id,entryentity.position,entryentity.dpt,entryentity.ispartjob";
        return BusinessDataServiceHelper.loadFromCache((String)"bos_user", (String)selectFields, (QFilter[])qFilters);
    }

    public static int getPayerCount(Long currentUser, Long applierId) {
        DynamicObjectCollection payerAccount;
        QFilter qFilter = new QFilter("creator", "=", (Object)currentUser);
        qFilter = qFilter.or("payer", "=", (Object)currentUser);
        qFilter = qFilter.or("userid.FBASEDATAID", "=", (Object)currentUser);
        if (applierId != null && applierId.compareTo(currentUser) != 0) {
            qFilter = qFilter.or("creator", "=", (Object)applierId);
            qFilter = qFilter.or("payer", "=", (Object)applierId);
            qFilter = qFilter.or("userid.FBASEDATAID", "=", (Object)applierId);
        }
        if ((payerAccount = QueryServiceHelper.query((String)"er_payeer", (String)"id", (QFilter[])new QFilter[]{qFilter = qFilter.and("enable", "=", (Object)"1")})) == null) {
            return 0;
        }
        return payerAccount.size();
    }

    public static BigDecimal getTripReimburseOutStandingAmount(Long userId) {
        BigDecimal amount = BigDecimal.ZERO;
        QFilter userFilter = new QFilter("applier", "=", (Object)userId);
        QFilter qFilter = userFilter.and("billstatus", "in", Arrays.asList(outStandingState));
        QFilter[] qFilters = new QFilter[]{qFilter};
        DynamicObjectCollection objs = QueryServiceHelper.query((String)"er_tripreimbursebill", (String)"id,notpayamount", (QFilter[])qFilters);
        for (DynamicObject obj : objs) {
            BigDecimal notpayamount = obj.getBigDecimal("notpayamount");
            amount = amount.add(notpayamount);
        }
        return amount;
    }

    public static Map<String, Object> getNotReimburseCountUsedByEmPage(Long userId) {
        ORM orm = ORM.create();
        QFilter userFilter = new QFilter("applier", "=", (Object)userId);
        userFilter.or("creator", "=", (Object)userId);
        QFilter[] dailyApplybillFilter = new QFilter[]{QFilter.of((String)"billstatus='E' and balanceamount>0", (Object[])new Object[0]), userFilter};
        int dailyApplyBill_count = orm.count("fi.er.dailyapplybill", "er_dailyapplybill", dailyApplybillFilter);
        QFilter[] dailyLoanbillFilter = new QFilter[]{QFilter.of((String)"billstatus='G' and balanceamount>0", (Object[])new Object[0]), userFilter};
        int dailyLoanBill_count = orm.count("fi.er.dailyloanbill", "er_dailyloanbill", dailyLoanbillFilter);
        QFilter[] tripReqbillFilter = new QFilter[]{QFilter.of((String)"isloan='0' and billstatus='E'", (Object[])new Object[0]), userFilter};
        int auditTripReqBill_count = orm.count("fi.er.tripreqbill", "er_tripreqbill", tripReqbillFilter);
        QFilter[] tripReqLoanbillFilter = new QFilter[]{QFilter.of((String)"isloan='1' and billstatus='G' and loanamount>0", (Object[])new Object[0]), userFilter};
        int loanTripReqBill_count = orm.count("fi.er.tripReqLoanbill", "er_tripreqbill", tripReqLoanbillFilter);
        logger.info(String.format("\u5f53\u524d\u7528\u6237(%d)\u5404\u7c7b\u5f85\u62a5\u9500\u7684\u5355\u636e\u6570\u636e\u60c5\u51b5\u5982\u4e0b:\u8d39\u7528\u7533\u8bf7\u5355:%d,\u501f\u6b3e\u5355:%d, \u51fa\u5dee\u7533\u8bf7\u5355:%d, \u51fa\u5dee\u7533\u8bf7\u5355\u501f\u6b3e\u5355:%d", userId, dailyApplyBill_count, dailyLoanBill_count, auditTripReqBill_count, loanTripReqBill_count));
        long totalCount = 0L + (long)dailyApplyBill_count + (long)dailyLoanBill_count + (long)auditTripReqBill_count + (long)loanTripReqBill_count;
        HashMap<String, Object> countMap = new HashMap<String, Object>();
        countMap.put("dailyApplyCount", dailyApplyBill_count);
        countMap.put("dailyLoanCount", dailyLoanBill_count);
        countMap.put("tripReqCount", auditTripReqBill_count);
        countMap.put("loanTripReqCount", loanTripReqBill_count);
        countMap.put("tripNotReimburseCount", CommonServiceHelper.getNoReimburseCount());
        countMap.put("totalCount", totalCount);
        return countMap;
    }

    private static int getNoReimburseCount() {
        Long userId = Long.valueOf(RequestContext.get().getUserId());
        QFilter specialFilter = new QFilter("creator", "=", (Object)userId).or(new QFilter("applier", "=", (Object)userId));
        ORM orm = ORM.create();
        return orm.count("fi.er.tripreqbill", "er_tripreqbill", new QFilter[]{CommonServiceHelper.getNoReimburseFilter(specialFilter), specialFilter});
    }

    public static QFilter getNoReimburseFilter(QFilter specialFilter) {
        QFilter statusFilter = QFilter.of((String)"isloan='0' and billstatus='E'", (Object[])new Object[0]).or(QFilter.of((String)"isloan='1' and billstatus='G' and balanceamount>0", (Object[])new Object[0]));
        DynamicObject[] reqBills = BusinessDataServiceHelper.load((String)"er_tripreqbill", (String)"id,isloan", (QFilter[])new QFilter[]{statusFilter, specialFilter});
        if (reqBills.length > 0) {
            Map<Boolean, List<DynamicObject>> map = Stream.of(reqBills).collect(Collectors.groupingBy(v -> v.getBoolean("isloan")));
            List<DynamicObject> tripReqLoanList = map.get(Boolean.TRUE);
            QFilter notValidTripLoanIdFilter = CommonServiceHelper.getNotValidReqBillIdFilter(tripReqLoanList, Lists.newArrayList((Object[])new String[]{"A", "B", "C"}), "er_repaymentbill");
            List<DynamicObject> tripReqList = map.get(Boolean.FALSE);
            QFilter notValidTripIdFilter = CommonServiceHelper.getNotValidReqBillIdFilter(tripReqList, Lists.newArrayList((Object[])new String[]{"B", "C"}), "er_tripreimbursebill");
            return statusFilter.and(notValidTripLoanIdFilter).and(notValidTripIdFilter);
        }
        return statusFilter;
    }

    private static QFilter getNotValidReqBillIdFilter(List<DynamicObject> billList, List<String> notValidStatusList, String targetBill) {
        Set notValidIds = new HashSet();
        if (billList != null && !billList.isEmpty()) {
            Long[] tripLoanIds = billList.stream().map(DataEntityBase::getPkValue).collect(Collectors.toList()).toArray(new Long[0]);
            Map targetBills = BFTrackerServiceHelper.findTargetBills((String)"er_tripreqbill", (Long[])tripLoanIds);
            HashSet targetBillIds = (HashSet)targetBills.get(targetBill);
            QFilter repaymentIdFilter = new QFilter("id", "in", (Object)targetBillIds);
            QFilter repaymentStatusFilter = new QFilter("billstatus", "in", notValidStatusList);
            DynamicObject[] notValidRepayment = (DynamicObject[])QueryServiceHelper.query((String)targetBill, (String)"id", (QFilter[])new QFilter[]{repaymentIdFilter, repaymentStatusFilter}).toArray((Object[])new DynamicObject[0]);
            Map sourceBills = BFTrackerServiceHelper.findSourceBills((String)targetBill, (Long[])Stream.of(notValidRepayment).map(e -> e.getLong("id")).collect(Collectors.toList()).toArray(new Long[0]));
            notValidIds = (Set)sourceBills.get("er_tripreqbill");
        }
        return new QFilter("id", "not in", notValidIds);
    }

    @KSMethod
    public static DynamicObject getObjById(String formId, Long id) {
        Map dataFromCache = BusinessDataServiceHelper.loadFromCache((String)formId, (QFilter[])new QFilter[]{QFilter.of((String)"id = ?", (Object[])new Object[]{id})});
        return dataFromCache.isEmpty() ? null : (DynamicObject)dataFromCache.values().iterator().next();
    }

    @KSMethod
    public static DynamicObject getObjByProp(String formId, String propName, Object propValue) {
        HashMap<String, Object> columAndValue = new HashMap<String, Object>();
        columAndValue.put(propName, propValue);
        return CommonServiceHelper.getObjByProps(formId, columAndValue);
    }

    private static DynamicObject getObjByProps(String entityId, Map<String, Object> columAndValue) {
        DynamicObject dynamicObject = null;
        if (StringUtils.isEmpty((String)entityId) || columAndValue == null || columAndValue.size() == 0) {
            return dynamicObject;
        }
        QFilter[] qFilters = new QFilter[columAndValue.size()];
        int i = 0;
        for (Map.Entry<String, Object> entry : columAndValue.entrySet()) {
            String colum = entry.getKey();
            Object value = entry.getValue();
            QFilter qTemper = new QFilter(colum, "=", value);
            qFilters[i++] = qTemper;
        }
        DynamicObject[] dynamicObjects = (DynamicObject[])QueryServiceHelper.query((String)entityId, (String)"id,name,number", (QFilter[])qFilters).toArray((Object[])new DynamicObject[0]);
        if (dynamicObjects != null && dynamicObjects.length > 0) {
            dynamicObject = dynamicObjects[0];
        }
        return dynamicObject;
    }

    public static String getMD5(String message) {
        return MD5.md5crypt((String)message);
    }

    public static DynamicObject executeRedundancyField(DynamicObject dynamicObject) {
        DynamicObjectCollection tripentry = dynamicObject.getDynamicObjectCollection("tripentry");
        int size = tripentry.size();
        if (size == 0) {
            return null;
        }
        DynamicObject fromObject = (DynamicObject)((DynamicObject)tripentry.get(0)).get("from");
        DynamicObject firstToObject = (DynamicObject)((DynamicObject)tripentry.get(0)).get("to");
        String vehicle = (String)((DynamicObject)tripentry.get(0)).get("vehicle");
        DynamicObject toObject = (DynamicObject)((DynamicObject)tripentry.get(size - 1)).get("to");
        Date rstartdate = tripentry.stream().sorted(Comparator.comparing(e -> e.getDate("startdate"))).findFirst().get().getDate("startdate");
        Date rfirstenddate = ((DynamicObject)tripentry.get(0)).getDate("enddate");
        Date renddate = ((DynamicObject)tripentry.stream().sorted((e1, e2) -> e2.getDate("enddate").compareTo(e1.getDate("enddate"))).findFirst().get()).getDate("enddate");
        dynamicObject.set("rstartdate", (Object)rstartdate);
        dynamicObject.set("rfirstenddate", (Object)rfirstenddate);
        dynamicObject.set("renddate", (Object)renddate);
        dynamicObject.set("rvehicle", (Object)vehicle);
        if (size > 1) {
            dynamicObject.set("rvehicle", (Object)6);
        }
        if (fromObject == null || toObject == null) {
            return dynamicObject;
        }
        String fromName = fromObject.getString("name").trim();
        String toName = toObject.getString("name").trim();
        String firstToName = firstToObject.getString("name").trim();
        if (fromName.equals(toName)) {
            toObject = (DynamicObject)((DynamicObject)tripentry.get(size - 1)).get("from");
            toName = toObject.getString("name");
        }
        dynamicObject.set("rfrom", (Object)fromName);
        dynamicObject.set("rto", (Object)toName);
        dynamicObject.set("rfirstto", (Object)firstToName);
        return dynamicObject;
    }

    public static void handlePayerDeptAndCompInfo(DynamicObject dynamicObject) {
        Map<Long, Object> userDeptMap;
        HashSet<Long> userIdSet = new HashSet<Long>();
        HashMap<Long, Long> payerUserMap = new HashMap<Long, Long>();
        DynamicObjectCollection accountEntries = dynamicObject.getDynamicObjectCollection("accountentry");
        for (DynamicObject accountEntry : accountEntries) {
            DynamicObject payer = accountEntry.getDynamicObject("payer");
            if (payer == null) continue;
            Long payerInfoId = (Long)payer.getPkValue();
            Long userId = 0L;
            userId = accountEntry.getDynamicObject("payer").getBoolean("isemployee") ? (Long)accountEntry.getDynamicObject("payer").getDynamicObject("payer").getPkValue() : (Long)accountEntry.getDynamicObject("payer").getDynamicObject("creator").getPkValue();
            userIdSet.add(userId);
            payerUserMap.put(payerInfoId, userId);
        }
        if (userIdSet.size() > 0 && null != (userDeptMap = CommonServiceHelper.getUserMapInfo(userIdSet))) {
            for (DynamicObject accountEntry : accountEntries) {
                Long payerId;
                Long userId;
                DynamicObject dept;
                DynamicObject payer = accountEntry.getDynamicObject("payer");
                if (payer == null || null == (dept = (DynamicObject)userDeptMap.get(userId = (Long)payerUserMap.get(payerId = Long.valueOf(accountEntry.getLong("payer.id")))))) continue;
                accountEntry.set("payerdeptid", (Object)dept);
                Long deptId = (Long)dept.getPkValue();
                Map company = OrgUnitServiceHelper.getCompanyfromOrg((Long)deptId);
                if (null == company) continue;
                Long companyId = (Long)company.get("id");
                accountEntry.set("payercompid_id", (Object)companyId);
            }
        }
    }

    private static Map<Long, Object> getUserMapInfo(Set<Long> userIdSet) {
        DynamicObject[] dynamicObjects;
        HashMap<Long, Object> resultMap = new HashMap<Long, Object>();
        IErDao userDao = ErDaoFactory.getInstance("bos_user");
        QFilter qfilter = new QFilter("id", "in", userIdSet);
        String seletFields = "id,entryentity.dpt,entryentity.ispartjob";
        block0: for (DynamicObject userObject : dynamicObjects = userDao.query(seletFields, qfilter)) {
            Long userId = userObject.getLong("id");
            DynamicObjectCollection userEntrys = userObject.getDynamicObjectCollection("entryentity");
            for (DynamicObject userEntry : userEntrys) {
                boolean isPartjob = userEntry.getBoolean("ispartjob");
                DynamicObject dept = userEntry.getDynamicObject("dpt");
                if (dept == null) continue;
                resultMap.put(userId, dept);
                if (isPartjob) continue;
                continue block0;
            }
        }
        return resultMap;
    }

    @Deprecated
    public static BigDecimal getExchangeRate(Long sourceCurrencyId, Long targetCurrencyId, Long companyId) {
        return CommonServiceHelper.getExchangeRate(sourceCurrencyId, targetCurrencyId, companyId, new Date());
    }

    @Deprecated
    public static BigDecimal getExchangeRateFromSysParams(Long sourceCurrencyId, Long targetCurrencyId, Long companyId, Object bill) {
        DynamicObject dynamicObject;
        int exchangeRateFrom = SystemParamterUtil.getExchangeRateFrom(companyId);
        if (0 == exchangeRateFrom) {
            return CommonServiceHelper.getExchangeRate(sourceCurrencyId, targetCurrencyId, companyId, new Date());
        }
        if (bill instanceof IDataModel) {
            dynamicObject = ((IDataModel)bill).getDataEntity();
        } else if (bill instanceof IFormView) {
            dynamicObject = ((IFormView)bill).getModel().getDataEntity();
        } else if (bill instanceof DynamicObject) {
            dynamicObject = (DynamicObject)bill;
        } else {
            if (bill instanceof Date) {
                return CommonServiceHelper.getExchangeRate(sourceCurrencyId, targetCurrencyId, companyId, (Date)bill);
            }
            return CommonServiceHelper.getExchangeRate(sourceCurrencyId, targetCurrencyId, companyId, new Date());
        }
        Date bizDate = null;
        bizDate = dynamicObject.getDate("bizdate");
        if (bizDate == null) {
            bizDate = new Date();
        }
        return CommonServiceHelper.getExchangeRate(sourceCurrencyId, targetCurrencyId, companyId, bizDate);
    }

    @Deprecated
    public static BigDecimal getExchangeRate(Long sourceCurrencyId, Long targetCurrencyId, Object companyId, Object costCompany) {
        Long exrateTableId = BaseCurrencyServiceHelper.getExrateTableId(companyId, costCompany);
        BigDecimal exchangeRate = BaseDataServiceHelper.getExchangeRate((Long)exrateTableId, (Long)sourceCurrencyId, (Long)targetCurrencyId, (Date)new Date());
        return exchangeRate == null ? BigDecimal.ONE : exchangeRate;
    }

    @Deprecated
    private static BigDecimal getExchangeRate(Long sourceCurrencyId, Long targetCurrencyId, Long companyId, Date date) {
        BigDecimal exchangeRate = BigDecimal.ONE;
        if (date == null) {
            date = new Date();
        }
        if (sourceCurrencyId == null || targetCurrencyId == null || sourceCurrencyId.compareTo(0L) == 0 || targetCurrencyId.compareTo(0L) == 0 || sourceCurrencyId.compareTo(targetCurrencyId) == 0) {
            return exchangeRate;
        }
        Long exchangeRateTableId = BaseCurrencyServiceHelper.getExrateTableId(companyId);
        if (exchangeRateTableId == null) {
            return exchangeRate;
        }
        exchangeRate = BaseDataServiceHelper.getExchangeRate((Long)exchangeRateTableId, (Long)sourceCurrencyId, (Long)targetCurrencyId, (Date)date);
        if (exchangeRate == null) {
            exchangeRate = BigDecimal.ONE;
        }
        return exchangeRate;
    }

    @Deprecated
    public static BigDecimal getExchangeRate(Long sourceCurrencyId, Long targetCurrencyId, Long orgId, Boolean isTrust, Date date) {
        BigDecimal exchangeRate = BigDecimal.ONE;
        return exchangeRate;
    }

    @Deprecated
    public static Map<String, Object> getExchangeRateAndQuoteType(Object companyId, Object costCompany, Long sourceCurrencyId, Long targetCurrencyId) {
        return CommonServiceHelper.getExchangeRateAndQuoteType(companyId, costCompany, sourceCurrencyId, targetCurrencyId, new Date());
    }

    public static Map<String, Object> getExchangeRateFromSysParams(Object company, Object costCompany, Long sourceCurrencyId, Long targetCurrencyId, Object bill) {
        DynamicObject dynamicObject;
        Long companyId = 0L;
        Long costCompanyId = 0L;
        companyId = company instanceof DynamicObject ? ErCommonUtils.getPk(company) : (Long)company;
        costCompanyId = costCompany instanceof DynamicObject ? ErCommonUtils.getPk(costCompany) : (costCompany instanceof String ? Long.valueOf(Long.parseLong((String)costCompany)) : (Long)costCompany);
        int exchangeRateFrom = SystemParamterUtil.getExchangeRateFrom(companyId);
        if (0 == exchangeRateFrom) {
            return CommonServiceHelper.getExchangeRateAndQuoteType(companyId, costCompanyId, sourceCurrencyId, targetCurrencyId, new Date());
        }
        if (bill instanceof IDataModel) {
            dynamicObject = ((IDataModel)bill).getDataEntity();
        } else if (bill instanceof IFormView) {
            dynamicObject = ((IFormView)bill).getModel().getDataEntity();
        } else if (bill instanceof DynamicObject) {
            dynamicObject = (DynamicObject)bill;
        } else {
            if (bill instanceof Date) {
                return CommonServiceHelper.getExchangeRateAndQuoteType(companyId, costCompanyId, sourceCurrencyId, targetCurrencyId, (Date)bill);
            }
            return CommonServiceHelper.getExchangeRateAndQuoteType(companyId, costCompanyId, sourceCurrencyId, targetCurrencyId, new Date());
        }
        Date bizDate = null;
        bizDate = dynamicObject.getDate("bizdate");
        if (bizDate == null) {
            if (ErEntityTypeUtils.isRepaymentBill(dynamicObject.getDataEntityType().getName())) {
                bizDate = dynamicObject.getDate("repaymentdate");
            }
            if (bizDate == null) {
                bizDate = new Date();
            }
        }
        return CommonServiceHelper.getExchangeRateAndQuoteType(companyId, costCompanyId, sourceCurrencyId, targetCurrencyId, bizDate);
    }

    public static Map<String, Object> getExchangeRateAndQuoteTypeNoDefault(Object companyId, Object costCompany, Long sourceCurrencyId, Long targetCurrencyId, Date date) {
        Long exrateTableId = BaseCurrencyServiceHelper.getExrateTableId(companyId, costCompany);
        if (exrateTableId == null) {
            logger.info(String.format("CommonServiceHelper>>> exrateTableId not configured, companydId = %s, costCompanyId = %s", companyId, costCompany));
            return new HashMap<String, Object>(2);
        }
        Map exchangeRateMap = BaseDataServiceHelper.getExchangeRateMap((Long)sourceCurrencyId, (Long)targetCurrencyId, (Long)exrateTableId, (Date)date);
        logger.info(String.format("CommonServiceHelper>>> quoteType = %s, exchangeRate = %s", exchangeRateMap.get("quoteType"), exchangeRateMap.get("exchangeRate")));
        if (exchangeRateMap.get("quoteType") == null || !((Boolean)exchangeRateMap.get("quoteType")).booleanValue()) {
            exchangeRateMap.put("quoteType", "0");
        } else {
            exchangeRateMap.put("quoteType", "1");
        }
        return exchangeRateMap;
    }

    public static Map<String, Object> getExchangeRateAndQuoteType(Object companyId, Object costCompany, Long sourceCurrencyId, Long targetCurrencyId, Date date) {
        Map<String, Object> exchangeRateMap = CommonServiceHelper.getExchangeRateAndQuoteTypeNoDefault(companyId, costCompany, sourceCurrencyId, targetCurrencyId, date);
        if (exchangeRateMap.get("exchangeRate") == null) {
            exchangeRateMap.put("exchangeRate", BigDecimal.ONE);
        }
        return exchangeRateMap;
    }

    public static boolean requireValidate(DynamicObject dobjet, String[] requireProps, AbstractFormPlugin formPlugin) {
        return CommonServiceHelper.requireValidate(dobjet, requireProps, formPlugin, null);
    }

    public static boolean requireValidate(DynamicObject dobjet, String[] requireProps, AbstractFormPlugin formPlugin, String message) {
        for (String propName : requireProps) {
            IDataEntityProperty property = (IDataEntityProperty)dobjet.getDynamicObjectType().getProperties().get((Object)propName);
            Object propValue = dobjet.get(propName);
            if (propValue != null && propValue != BigDecimal.ZERO && !StringUtils.isBlank((String)String.valueOf(propValue))) continue;
            if (StringUtils.isEmpty((String)message)) {
                String displayNameStr = propName;
                try {
                    Object result;
                    Method method = property.getClass().getMethod("getDisplayName", new Class[0]);
                    if (method != null && (result = method.invoke((Object)property, new Object[0])) != null) {
                        displayNameStr = ((LocaleString)result).getLocaleValue();
                    }
                }
                catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                    logger.error((Throwable)e);
                }
                formPlugin.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c%s\u201d\u3002", (String)"CommonServiceHelper_0", (String)"fi-er-business", (Object[])new Object[0]), displayNameStr));
            } else {
                formPlugin.getView().showTipNotification(message);
            }
            return false;
        }
        return true;
    }

    public static boolean requireValidate(IDataModel model, String[] requireProps, AbstractFormPlugin formPlugin, String message) {
        for (String propName : requireProps) {
            Object propValue = model.getValue(propName);
            if (propValue != null && propValue != BigDecimal.ZERO && !StringUtils.isBlank((String)String.valueOf(propValue))) continue;
            formPlugin.getView().showErrorNotification(message);
            return false;
        }
        return true;
    }

    public static Long calcHotelNightDays(Date startDate, Date endDate) {
        Long dayCount = 0L;
        if (startDate != null && endDate != null) {
            Long oneDayM = 86400000L;
            if (endDate.before(startDate)) {
                return dayCount;
            }
            Long diff = endDate.getTime() - startDate.getTime();
            if (diff == 0L) {
                return dayCount;
            }
            if (diff <= oneDayM) {
                return 1L;
            }
            Date start = TripCommonUtil.strToDate(TripCommonUtil.DateToStr(startDate), "yyyy-MM-dd");
            Date end = TripCommonUtil.strToDate(TripCommonUtil.DateToStr(endDate), "yyyy-MM-dd");
            dayCount = (end.getTime() - start.getTime()) / oneDayM;
        }
        return dayCount;
    }

    public static Long calcVehicleDays(Date startDate, Date endDate) {
        Long dayCount = 1L;
        if (startDate != null && endDate != null) {
            Long oneDayM = 86400000L;
            if (endDate.before(startDate)) {
                return dayCount;
            }
            Long diff = endDate.getTime() - startDate.getTime();
            if (diff == 0L) {
                return dayCount;
            }
            if (diff < oneDayM) {
                return dayCount;
            }
            Date start = TripCommonUtil.strToDate(TripCommonUtil.DateToStr(startDate), "yyyy-MM-dd");
            Date end = TripCommonUtil.strToDate(TripCommonUtil.DateToStr(endDate), "yyyy-MM-dd");
            dayCount = (end.getTime() - start.getTime()) / oneDayM;
        }
        return dayCount + 1L;
    }

    public static Long calcDays(Date startDate, Date endDate) {
        Long dayCount = 0L;
        if (startDate == null || endDate == null) {
            return dayCount;
        }
        Long oneDayM = 86400000L;
        if (endDate.before(startDate)) {
            return dayCount;
        }
        Long diff = endDate.getTime() - startDate.getTime();
        String s = ErStdConfig.get("calcdays");
        if ("old".equals(s)) {
            if (diff == 0L) {
                return dayCount;
            }
            if (diff <= oneDayM) {
                return 1L;
            }
            Date start = TripCommonUtil.strToDate(TripCommonUtil.DateToStr(startDate), "yyyy-MM-dd");
            Date end = TripCommonUtil.strToDate(TripCommonUtil.DateToStr(endDate), "yyyy-MM-dd");
            dayCount = (end.getTime() - start.getTime()) / oneDayM;
        } else {
            Date start = TripCommonUtil.strToDate(TripCommonUtil.DateToStr(startDate), "yyyy-MM-dd");
            Date end = TripCommonUtil.strToDate(TripCommonUtil.DateToStr(endDate), "yyyy-MM-dd");
            if (diff == 0L || start.getTime() == end.getTime() && diff < oneDayM) {
                return dayCount;
            }
            if (diff <= oneDayM) {
                return 1L;
            }
            dayCount = (end.getTime() - start.getTime()) / oneDayM;
        }
        return dayCount;
    }

    public static String getCurUserAmountFormatValueByCurrency(BigDecimal amount, DynamicObject currency) {
        int amtprecision = 2;
        String sign = "";
        if (currency != null) {
            amtprecision = currency.getInt("amtprecision");
            sign = currency.getString("sign");
        }
        amount = amount == null ? BigDecimal.ZERO.setScale(amtprecision) : amount.setScale(amtprecision, 5);
        return AmountUtils.formatMoneyByUser(Long.valueOf(RequestContext.get().getUserId()), sign, amtprecision, amount);
    }

    public static DynamicObjectCollection getTripOrderByNumber(String orderformid, String oabillNum, boolean isReimburse) {
        QFilter qFilter = new QFilter("oaBillNum", "=", (Object)oabillNum);
        qFilter = qFilter.and("isreimburse", "=", (Object)isReimburse);
        qFilter = qFilter.and("totalamount", "!=", (Object)ConvertUtil.getOrderAmountInit());
        QFilter[] qFilters = new QFilter[]{qFilter};
        String selectProps = CommonServiceHelper.getSelectProps(orderformid);
        return QueryServiceHelper.query((String)orderformid, (String)selectProps, (QFilter[])qFilters);
    }

    public static DynamicObjectCollection getTripOrderNotReimburse(String orderformid, QFilter[] qFilters) {
        String selectProps = CommonServiceHelper.getSelectProps(orderformid);
        DynamicObjectCollection orderInfos = QueryServiceHelper.query((String)orderformid, (String)selectProps, (QFilter[])qFilters);
        orderInfos.removeIf(next -> StringUtils.isNotEmpty((String)next.getString("oabillnum")));
        return orderInfos;
    }

    private static String getSelectProps(String orderformid) {
        String commonSelectProps = "totalamount,orderNum,orderstatus,server,parentordernum,oabillnum";
        String otherSelectProps = "";
        switch (orderformid) {
            case "er_planebill": {
                otherSelectProps = "takeofftime,landingtime,fromcityname,tocityname,airlinename,flightno";
                break;
            }
            case "er_hotelbill": {
                otherSelectProps = "hotelname,roomcount,checkindate,checkoutdate,hoteladdress";
                break;
            }
            case "er_vehiclebill": {
                otherSelectProps = "usetime,departaddress,arriveaddress,cityname";
            }
        }
        return commonSelectProps + "," + otherSelectProps;
    }

    public static DynamicObject[] getTripOrderByNumber(Set<String> oabillNum, boolean isReimburse) {
        QFilter qFilter = new QFilter("oaBillNum", "in", oabillNum);
        qFilter = qFilter.and("isreimburse", "=", (Object)isReimburse);
        qFilter = qFilter.and("totalamount", "!=", (Object)ConvertUtil.getOrderAmountInit());
        QFilter[] qFilters = new QFilter[]{qFilter};
        return (DynamicObject[])QueryServiceHelper.query((String)"er_allorderbill", (String)"id,totalamount,isreimburse,orderformid,isconfirm,oabillnum", (QFilter[])qFilters).toArray((Object[])new DynamicObject[0]);
    }

    public static DynamicObjectCollection getTripOrderObj(Long userId, String orderType) {
        ORM orm = ORM.create();
        QFilter qFilter = new QFilter("sourceBookedId", "=", (Object)userId);
        QFilter[] qFilters = new QFilter[]{qFilter};
        return orm.query(orderType, "id,orderdate,orderNum,oaBillNum,isConfirm,isReimburse,orderformid, totalamount", qFilters);
    }

    @Deprecated
    public static Date getMonthLastDay(Calendar calendar, Integer month) {
        calendar.clear(5);
        calendar.clear(2);
        calendar.set(2, month - 1);
        if (month == 2) {
            calendar.set(5, calendar.getLeastMaximum(5));
        } else {
            calendar.set(5, calendar.getActualMaximum(5));
        }
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    public static Date getLastDayOfLastMonthBy(Date date) {
        LocalDate localDate = ErCommonUtils.getLocalDateFromDate(date);
        LocalDate lastDayOfLastMonth = localDate.with(TemporalAdjusters.firstDayOfMonth()).plusDays(-1L).with(TemporalAdjusters.lastDayOfMonth());
        return ErCommonUtils.getDateFromLocalDate(lastDayOfLastMonth);
    }

    public static Date getLastDayOfMonthBy(Date date) {
        LocalDate localDate = ErCommonUtils.getLocalDateFromDate(date);
        LocalDate lastDay = localDate.with(TemporalAdjusters.lastDayOfMonth());
        return ErCommonUtils.getDateFromLocalDate(lastDay);
    }

    public static DynamicObject[] getTripPersonalSetting(long userid) {
        QFilter qA = new QFilter("user", "=", (Object)userid);
        QFilter[] qFilters = new QFilter[]{qA};
        return BusinessDataServiceHelper.load((String)"er_tripsettingdata", (String)"id,date,remaincyc,iscurrency,ispush,iscalendar,remaintime,ispartner, ismultireimburser", (QFilter[])qFilters);
    }

    @KSMethod
    public static void changeReqBillInfo(IDataModel model, String billNo) {
        QFilter qA = new QFilter("billNo", "=", (Object)billNo);
        QFilter[] qFilters = new QFilter[]{qA};
        DynamicObject[] reqTripInfos = BusinessDataServiceHelper.load((String)"er_tripreqbill", (String)"id,billNo,description,costdept", (QFilter[])qFilters);
        if (reqTripInfos.length == 0) {
            return;
        }
        for (DynamicObject reqTripInfo : reqTripInfos) {
            reqTripInfo.set("description", model.getValue("description"));
            reqTripInfo.set("costdept", model.getValue("costdept"));
        }
        SaveServiceHelper.save((DynamicObject[])reqTripInfos);
    }

    public static Tuple<Date, Date> getDateRange(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(5, 1);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        Date startDate = calendar.getTime();
        calendar.add(2, 1);
        calendar.add(13, -1);
        Date endDate = calendar.getTime();
        return Tuple.create((Object)startDate, (Object)endDate);
    }

    public static Boolean initCurrency() {
        DynamicObject[] personalSettingInfos;
        boolean iscurrency = false;
        for (DynamicObject personalSettingInfo : personalSettingInfos = CommonServiceHelper.getTripPersonalSetting(CommonServiceHelper.getCurrentUserID())) {
            iscurrency = personalSettingInfo.getBoolean("iscurrency");
        }
        return iscurrency;
    }

    public static boolean noApprovaWhiteList(Long userID, String enble) {
        boolean flag = false;
        QFilter qFilter = new QFilter("user", "=", (Object)userID);
        QFilter qFilter1 = new QFilter("enble", "=", (Object)enble);
        QFilter[] qFilters = new QFilter[]{qFilter, qFilter1};
        DynamicObject objs = BusinessDataServiceHelper.loadSingle((String)"er_businesswhitelist", (String)"id", (QFilter[])qFilters);
        if (objs != null) {
            flag = true;
        }
        return flag;
    }

    public static void noApprovalPush(Long applierUserId, String billNo, String billId, String server, String status) {
        if (applierUserId == null || applierUserId.intValue() == 0) {
            return;
        }
        Boolean isNoApprova = CommonServiceHelper.noApprovaWhiteList(applierUserId, "1");
        if (isNoApprova.booleanValue()) {
            try {
                logger.info(String.format("\u5546\u65c5\u96c6\u6210,\u51fa\u5dee\u7533\u8bf7\u5355\u540c\u6b65,\u514d\u5ba1\u540c\u6b65\u5f00\u59cb,\u670d\u52a1\u5546:%s,\u51fa\u5dee\u5355\u7f16\u53f7:%s", server, billNo));
                if (TripCommonUtil.reqPush(billNo, billId, server, status)) {
                    return;
                }
                logger.info(String.format("\u5546\u65c5\u96c6\u6210,\u51fa\u5dee\u7533\u8bf7\u5355\u540c\u6b65,\u514d\u5ba1\u540c\u6b65\u7ed3\u675f,\u670d\u52a1\u5546:%s,\u51fa\u5dee\u5355\u7f16\u53f7:%s", server, billNo));
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }
    }

    public static void approvalAndCloseBillPush(Long applierUserId, String billNo, String billId, String server, String status) {
        if (applierUserId == null || applierUserId.intValue() == 0) {
            return;
        }
        if (TrialOrgServiceHelper.isHaveFunction(applierUserId, "book")) {
            logger.info(String.format("\u5546\u65c5\u96c6\u6210,\u51fa\u5dee\u7533\u8bf7\u5355\u540c\u6b65,\u5f00\u59cb,\u670d\u52a1\u5546:%s,\u51fa\u5dee\u5355\u7f16\u53f7:%s", server, billNo));
            if (TripCommonUtil.reqPush(billNo, billId, server, status)) {
                return;
            }
            logger.info(String.format("\u5546\u65c5\u96c6\u6210,\u51fa\u5dee\u7533\u8bf7\u5355\u540c\u6b65,\u7ed3\u675f,\u670d\u52a1\u5546:%s,\u51fa\u5dee\u5355\u7f16\u53f7:%s", server, billNo));
        } else {
            logger.info(String.format("\u5546\u65c5\u96c6\u6210,\u51fa\u5dee\u7533\u8bf7\u5355\u540c\u6b65,\u7533\u8bf7\u4eba\u4e0d\u5728\u8bd5\u70b9\u7ec4\u7ec7\u4e2d,\u672a\u8fdb\u884c\u540c\u6b65,\u670d\u52a1\u5546:%s,\u51fa\u5dee\u5355\u7f16\u53f7:%s,", server, billNo));
        }
    }

    public static void dailyVehicleBillPush(Long applierUserId, String billNo, String billId, String server, String status) {
        if (applierUserId == null || applierUserId.intValue() == 0) {
            return;
        }
        if (TrialOrgServiceHelper.isHaveFunction(applierUserId, "book")) {
            logger.info(String.format("\u5546\u65c5\u96c6\u6210,\u7528\u8f66\u540c\u6b65,\u5f00\u59cb,\u670d\u52a1\u5546:%s,\u7528\u8f66\u5355\u7f16\u53f7:%s", server, billNo));
            if (Supplier.GAODE.getValue().equals(server)) {
                DynamicObjectCollection dataMapping = QueryServiceHelper.query((String)"er_tripsync_datamapping", (String)"outdataid", (QFilter[])new QFilter[]{new QFilter("innerdataid", "=", (Object)Long.parseLong(billId))});
                HashMap<String, Object> params = new HashMap<String, Object>();
                params.put("id", billId);
                params.put("billno", billNo);
                params.put("status", "1");
                if (status.equals("2")) {
                    params.put("status", "0");
                }
                if (null == dataMapping || dataMapping.size() == 0) {
                    GtripFieldMappingInvoke.syncDailyVehicleBill(null, "1", params);
                } else {
                    GtripFieldMappingInvoke.syncDailyVehicleBill(null, "2", params);
                }
            } else if (Supplier.TONGCHENG.name().equals(server)) {
                HashMap params = Maps.newHashMapWithExpectedSize((int)16);
                params.put("id", billId);
                params.put("billno", billNo);
                params.put("status", "1");
                if (status.equals("2")) {
                    params.put("status", "2");
                }
                TripCommonUtil.invoke(server, "er_dailyvehiclebill", null, TripMappingNumber.DTG_SYNC_VEHICLE.getCode(), params);
            } else {
                String tripServiceName = TripCommonUtil.getStandtripname().get(server);
                ITripService iTripService = TripServiceFactory.getTripService(tripServiceName);
                iTripService.synDilyVehicleToTrip(billId, String.valueOf(status));
            }
            logger.info(String.format("\u5546\u65c5\u96c6\u6210,\u7528\u8f66\u540c\u6b65,\u7ed3\u675f,\u670d\u52a1\u5546:%s,\u7528\u8f66\u5355\u7f16\u53f7:%s", server, billNo));
        } else {
            logger.info(String.format("\u5546\u65c5\u96c6\u6210,\u7528\u8f66\u540c\u6b65,\u7533\u8bf7\u4eba\u4e0d\u5728\u8bd5\u70b9\u7ec4\u7ec7\u4e2d,\u672a\u8fdb\u884c\u540c\u6b65,\u670d\u52a1\u5546:%s,\u7528\u8f66\u5355\u7f16\u53f7:%s,", server, billNo));
        }
    }

    public static Long getCompanyIdByUserId(Long userId) {
        Long companyId = null;
        Map<String, Object> company = CommonServiceHelper.getCompanyByUserId(userId);
        if (company != null) {
            companyId = (Long)company.get("id");
        }
        return companyId;
    }

    public static Long getCompanyIdByUserId(Long userId, StdPreCalContext stdPreCalContext) {
        Long companyId = null;
        Map<String, Object> company = CommonServiceHelper.getCompanyByUserId(userId, stdPreCalContext);
        if (company != null) {
            companyId = (Long)company.get("id");
        }
        return companyId;
    }

    public static Map<String, Object> getCompanyByUserId(Long userId) {
        Map company = null;
        Map<String, Object> userMap = CommonServiceHelper.getUserMap(userId);
        DynamicObject dept = (DynamicObject)userMap.get("org");
        if (dept != null) {
            Long deptId = (Long)dept.getPkValue();
            company = OrgUnitServiceHelper.getCompanyfromOrg((Long)deptId);
        }
        return company;
    }

    public static Map<String, Object> getCompanyByUserId(Long userId, StdPreCalContext stdPreCalContext) {
        Map<String, Object> company = null;
        Map<String, Object> userMap = CommonServiceHelper.getUserMap(userId, null, false, stdPreCalContext);
        DynamicObject dept = (DynamicObject)userMap.get("org");
        if (dept != null) {
            Long deptId = (Long)dept.getPkValue();
            company = stdPreCalContext != null ? stdPreCalContext.getDepCompanyObj().getComByOrgs(deptId) : OrgUnitServiceHelper.getCompanyfromOrg((Long)deptId);
        }
        return company;
    }

    public static List<Long> getRelatedExpenseItemByBillType(String billType) {
        ArrayList<Long> relatedExpenseItem = new ArrayList<Long>();
        logger.info("CommonServiceHelper.getRelatedExpenseItemByBillType.billType.arg = " + billType);
        if (StringUtils.isNotBlank((String)billType)) {
            if (billType.indexOf("ssc") != -1) {
                billType = "er_dailyreimbursebil_ssc".equals(billType) ? "er_dailyreimbursebill" : ("er_publicreimburse_ssc".equals(billType) ? "er_publicreimbursebill" : billType.replace("_ssc", ""));
            } else if ("er_tripitem_edit_mb".equals(billType)) {
                billType = "er_tripreimbursebill";
            }
        }
        logger.info("CommonServiceHelper.getRelatedExpenseItemByBillType.billType.query = " + billType);
        QFilter filter = new QFilter("number", "=", (Object)billType);
        Map billTypeMap = BusinessDataServiceHelper.loadFromCache((String)"er_billtype", (String)"id,number", (QFilter[])new QFilter[]{filter});
        ArrayList billTypeIdList = new ArrayList();
        billTypeMap.keySet().forEach(key -> {
            Long fid = (Long)key;
            billTypeIdList.add(fid);
        });
        if (!billTypeIdList.isEmpty()) {
            DynamicObject[] objects;
            QFilter typeFilter = new QFilter("billtype", "=", billTypeIdList.get(0));
            for (DynamicObject obj : objects = (DynamicObject[])QueryServiceHelper.query((String)"er_expenseitembill", (String)"expenseitem", (QFilter[])new QFilter[]{typeFilter}).toArray((Object[])new DynamicObject[0])) {
                Long expenseitemId = obj.getLong("expenseitem");
                relatedExpenseItem.add(expenseitemId);
            }
        }
        return relatedExpenseItem;
    }

    public static List<Long> getRelatedExpenseItemForBillType(String billType, Set<Long> expenseItemIdSet) {
        ArrayList<Long> relatedExpenseItem = new ArrayList<Long>();
        logger.info("CommonServiceHelper.getRelatedExpenseItemForBillType.billType:" + billType + " , expenseItemIdSet:" + expenseItemIdSet);
        if (StringUtils.isNotBlank((String)billType)) {
            if (billType.indexOf("ssc") != -1) {
                billType = "er_dailyreimbursebil_ssc".equals(billType) ? "er_dailyreimbursebill" : ("er_publicreimburse_ssc".equals(billType) ? "er_publicreimbursebill" : billType.replace("_ssc", ""));
            } else if ("er_tripitem_edit_mb".equals(billType)) {
                billType = "er_tripreimbursebill";
            }
        }
        logger.info("CommonServiceHelper.getRelatedExpenseItemForBillType.billType:" + billType);
        QFilter filter = new QFilter("number", "=", (Object)billType);
        Map billTypeMap = BusinessDataServiceHelper.loadFromCache((String)"er_billtype", (String)"id,number", (QFilter[])new QFilter[]{filter});
        ArrayList billTypeIdList = new ArrayList();
        billTypeMap.keySet().forEach(key -> {
            Long fid = (Long)key;
            billTypeIdList.add(fid);
        });
        if (!billTypeIdList.isEmpty()) {
            DynamicObject[] objects;
            QFilter typeFilter = new QFilter("billtype", "=", billTypeIdList.get(0));
            QFilter qFilter = typeFilter.and("expenseitem", "in", expenseItemIdSet);
            for (DynamicObject obj : objects = BusinessDataServiceHelper.load((String)"er_expenseitembill", (String)"expenseitem", (QFilter[])new QFilter[]{qFilter})) {
                Long expenseitemId = (Long)obj.get("expenseitem.id");
                relatedExpenseItem.add(expenseitemId);
            }
        }
        return relatedExpenseItem;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BigDecimal getReceivableInDailyReimburse(Long userId) {
        BigDecimal amount = BigDecimal.ZERO;
        ORM orm = ORM.create();
        QFilter userFilter = new QFilter("applier", "=", (Object)userId);
        QFilter qFilter = userFilter.and("billstatus", "in", Arrays.asList(outStandingState));
        QFilter[] qFilters = new QFilter[]{qFilter};
        try (DataSet ds = orm.queryDataSet("fi.er.dailyreimbursebill", "er_dailyreimbursebill", "id,notpayamount", qFilters);){
            DynamicObjectCollection dynamicObjects = orm.toPlainDynamicObjectCollection(ds);
            if (!dynamicObjects.isEmpty()) {
                for (DynamicObject tripreimburOutstanding : dynamicObjects) {
                    BigDecimal notpayamount = tripreimburOutstanding.getBigDecimal("notpayamount");
                    amount = amount.add(notpayamount);
                }
            }
        }
        return amount;
    }

    public static void isHiddenApprovalFlex(IFormView view, Boolean falg) {
        SplitContainer splitContainer = (SplitContainer)view.getControl("hasrecordorder");
        if (null != splitContainer) {
            splitContainer.changeFlexStatus(SplitDirection.right, falg.booleanValue());
        }
    }

    public static boolean isSSC(IFormView view) {
        Map customParams;
        FormShowParameter parameter;
        String fromId;
        return view != null && (fromId = (parameter = view.getFormShowParameter()).getParentFormId()) != null && fromId.contains("task_") && parameter.getAppId().equals("ssc") && (customParams = parameter.getCustomParams()) != null && customParams.containsKey("taskID");
    }

    public static String getEntityfromSSC(String billType) {
        if (billType != null && billType.indexOf("ssc") != -1) {
            billType = "er_dailyreimbursebil_ssc".equals(billType) ? "er_dailyreimbursebill" : billType.replace("_ssc", "");
        }
        return billType;
    }

    public static boolean isSCENE(IFormView view) {
        if (view == null) {
            return false;
        }
        FormShowParameter formShowParameter = view.getFormShowParameter();
        if (formShowParameter == null) {
            return false;
        }
        Map customParams = formShowParameter.getCustomParams();
        String sceneSign = "SCENE";
        if (customParams == null || customParams.size() < 1 || customParams.get(sceneSign) == null) {
            return false;
        }
        return StringUtils.equalsIgnoreCase((String)"AUDITFLOW", (String)customParams.get(sceneSign).toString());
    }

    public static boolean isFullApp(String appId) {
        if (appId == null) {
            return false;
        }
        return BizAppServiceHelp.isAllUserApp((String)appId);
    }

    public static void setMulWayToVisible(IDataModel model, IFormView view) {
        DynamicObject compay = (DynamicObject)model.getValue("company");
        long compayId = compay == null ? 0L : (Long)compay.getPkValue();
        logger.info(view.getClass().getName() + "setMulWayToVisible compayId:" + compayId);
        boolean ischanged = model.getDataChanged();
        model.setValue("ismulwayto", (Object)SystemParamterUtil.getTripEntryMulWayTo(compayId));
        model.setDataChanged(ischanged);
    }

    public static void setIsMulTravelers(IDataModel model, IFormView view) {
        boolean ischanged = model.getDataChanged();
        Object value = model.getValue("company");
        if (value == null) {
            logger.info("setIsMulTravelers\u7533\u8bf7\u4eba\u516c\u53f8\u4e3a\u7a7a");
            return;
        }
        Long compayId = ErCommonUtils.getPk(value);
        boolean ismultravelers = SystemParamterUtil.getIsMulTravelers(compayId == null ? 0L : compayId);
        model.setValue("ismultravelers", (Object)ismultravelers);
        model.setDataChanged(ischanged);
    }

    public static void getDeductibleTaxShowType(IDataModel model, IFormView view) {
        DynamicObject compay = (DynamicObject)model.getValue("company");
        long compayId = compay == null ? 0L : (Long)compay.getPkValue();
        logger.info(view.getClass().getName() + "getDeductibleTaxShowType compayId:" + compayId);
        int deductibleTaxShowType = SystemParamterUtil.getloancheckparam(compayId, "deductibletaxshowtype");
        boolean ischanged = model.getDataChanged();
        switch (deductibleTaxShowType) {
            case 1: {
                model.setValue("deductibletaxshowtype", (Object)"1");
                break;
            }
            case 2: {
                model.setValue("deductibletaxshowtype", (Object)"2");
            }
        }
        model.setDataChanged(ischanged);
    }

    public static void setPayerNameInEditStatus(IDataModel model) {
        String billStatus = (String)model.getValue("billstatus");
        DynamicObjectCollection receiveEntry = model.getEntryEntity("accountentry");
        if (ErBillStatusEnum.A.toString().equals(billStatus) || ErBillStatusEnum.D.toString().equals(billStatus)) {
            IDataEntityProperty payerTypeProperty = (IDataEntityProperty)receiveEntry.getDynamicObjectType().getProperties().get((Object)"payertype");
            for (int i = 0; i < receiveEntry.size(); ++i) {
                String outPayer;
                DynamicObject accountEntry = (DynamicObject)receiveEntry.get(i);
                DynamicObject payerObj = accountEntry.getDynamicObject("payer");
                if (payerObj == null || payerTypeProperty != null && !PayerTypeEnum.PAYER.getType().equalsIgnoreCase(accountEntry.getString("payertype"))) {
                    return;
                }
                String payerName = accountEntry.getString("payername");
                if (payerName.equals(outPayer = payerObj.getString("outpayer"))) continue;
                accountEntry.set("payername", (Object)outPayer);
            }
        }
    }

    public static BigDecimal getSubsidyDaysByDate(Date startDate, Date endDate, Long companyId) {
        BigDecimal subsidyDays = new BigDecimal(0);
        if (startDate != null && endDate != null) {
            Long diff = endDate.getTime() - startDate.getTime();
            Long dayCount = diff / 86400000L;
            ErTripStdControlServiceImpl erTripStdControlService = new ErTripStdControlServiceImpl();
            subsidyDays = erTripStdControlService.calDaycount(dayCount, companyId);
        }
        return subsidyDays;
    }

    public static BigDecimal getLiveDaysByDate(Date startDate, Date endDate) {
        Long dayCount = 0L;
        if (startDate != null && endDate != null) {
            Long oneDayM = 86400000L;
            if (endDate.before(startDate)) {
                return new BigDecimal(dayCount);
            }
            Long diff = endDate.getTime() - startDate.getTime();
            if (diff == 0L) {
                return new BigDecimal(dayCount);
            }
            if (diff <= oneDayM) {
                return new BigDecimal(1L);
            }
            Date start = TripCommonUtil.strToDate(TripCommonUtil.DateToStr(startDate), "yyyy-MM-dd");
            Date end = TripCommonUtil.strToDate(TripCommonUtil.DateToStr(endDate), "yyyy-MM-dd");
            dayCount = (end.getTime() - start.getTime()) / oneDayM;
        }
        return new BigDecimal(dayCount);
    }

    public static void setUnsubmitToVisible(IDataModel model, IFormView view, String unsumbit) {
        String billstatus = (String)model.getValue("billstatus");
        boolean isAuditRevocationBill = SystemParamterUtil.getIsAuditRevocationBill(model.getDataEntity().getLong("company.id"));
        if (Objects.equal((Object)"C", (Object)billstatus)) {
            if (isAuditRevocationBill) {
                view.setVisible(Boolean.TRUE, new String[]{unsumbit});
            } else {
                view.setVisible(Boolean.FALSE, new String[]{unsumbit});
            }
        }
    }

    public static <E> List<E> transferArrayToList(E[] array) {
        ArrayList transferedList = new ArrayList();
        Arrays.stream(array).forEach(arr -> transferedList.add(arr));
        return transferedList;
    }

    public static void updateRelateCount(List<String> billNumbers, DynamicObjectCollection writeOffApplyEntity) {
        if (!billNumbers.isEmpty()) {
            QFilter qFilter = new QFilter("billno", "in", billNumbers);
            DynamicObject[] bills = (DynamicObject[])QueryServiceHelper.query((String)"er_tripreqbill", (String)"billno,id", (QFilter[])new QFilter[]{qFilter}).toArray((Object[])new DynamicObject[0]);
            HashMap<Long, String> idToNumberMap = new HashMap<Long, String>(bills.length);
            for (DynamicObject bill : bills) {
                idToNumberMap.put(bill.getLong("id"), bill.getString("billno"));
            }
            List ids = idToNumberMap.entrySet().stream().map(it -> (Long)it.getKey()).collect(Collectors.toList());
            HashMap numberCount = new HashMap(ids.size());
            ORM orm = ORM.create();
            for (int i = 0; i < ids.size(); ++i) {
                int count;
                Map targetBills = BFTrackerServiceHelper.findTargetBills((String)"er_tripreqbill", (Long[])new Long[]{(Long)ids.get(i)});
                int n = count = targetBills.isEmpty() || targetBills.get("er_tripreimbursebill") == null ? 0 : ((HashSet)targetBills.get("er_tripreimbursebill")).size();
                if (count != 0) {
                    QFilter discardFilter = new QFilter("id", "in", targetBills.get("er_tripreimbursebill"));
                    discardFilter.and("billstatus", "=", (Object)"H");
                    int discardCount = orm.count("kd.fi.er.business.servicehelper.CommonServiceHelper.updateRelateCount", "er_tripreimbursebill", new QFilter[]{discardFilter});
                    count -= discardCount;
                }
                numberCount.put(idToNumberMap.get(ids.get(i)), count);
            }
            DynamicProperty relCountProp = writeOffApplyEntity.getDynamicObjectType().getProperty("relatecount");
            for (DynamicObject row : writeOffApplyEntity) {
                String billNumebr = row.getString("applybillno");
                row.set("relatecount", (Object)numberCount.getOrDefault(billNumebr, 0).toString());
                row.getDataEntityState().setBizChanged(relCountProp.getOrdinal(), false);
            }
        }
    }

    public static void tripReimburseDelWriteOffApply(IDataModel model, IFormView view, int[] rowIndexs) {
        DynamicObjectCollection tripEntry = model.getDataEntity(true).getDynamicObjectCollection("tripentry");
        Boolean isNewTripReimburse = false;
        if (tripEntry.size() == 1 && ((DynamicObject)tripEntry.get(0)).getLong("tripentrysourceid") == 0L) {
            isNewTripReimburse = true;
        }
        DynamicObjectCollection writeOffEntry = model.getDataEntity(true).getDynamicObjectCollection("writeoffapply");
        HashSet<String> deleteNumber = new HashSet<String>(3);
        for (int i = 0; i < rowIndexs.length; ++i) {
            DynamicObject row = (DynamicObject)writeOffEntry.get(rowIndexs[i]);
            deleteNumber.add(row.getString("applybillno"));
        }
        if (!isNewTripReimburse.booleanValue()) {
            DynamicObject[] bills = BusinessDataServiceHelper.load((String)"er_tripreqbill", (String)"tripentry.id", (QFilter[])new QFilter[]{new QFilter("billno", "in", deleteNumber)});
            HashSet deleteTripSourceIDs = new HashSet();
            for (DynamicObject bill : bills) {
                DynamicObjectCollection reqTripEntry = bill.getDynamicObjectCollection("tripentry");
                List tripEntryIds = reqTripEntry.stream().map(v -> (Long)v.getPkValue()).collect(Collectors.toList());
                deleteTripSourceIDs.addAll(tripEntryIds);
            }
            LinkedList<Integer> deleteTripEntryIndex = new LinkedList<Integer>();
            model.beginInit();
            DynamicObjectCollection deletes = model.getDataEntity(true).getDynamicObjectCollection("tripentry");
            for (int i = 0; i < deletes.size(); ++i) {
                Long sourceEntryId = ((DynamicObject)deletes.get(i)).getLong("tripentrysourceid");
                if (!deleteTripSourceIDs.contains(sourceEntryId)) continue;
                deleteTripEntryIndex.add(i);
            }
            int[] indexs = deleteTripEntryIndex.stream().mapToInt(Integer::valueOf).toArray();
            InvoiceUtils.outLog(model, "tripentry", indexs);
            model.endInit();
            model.deleteEntryRows("tripentry", indexs);
            return;
        }
        HashSet<Long> deleteRowId = new HashSet<Long>(rowIndexs.length);
        for (int i = 0; i < rowIndexs.length; ++i) {
            deleteRowId.add((Long)((DynamicObject)writeOffEntry.get(rowIndexs[i])).getPkValue());
        }
        DynamicObjectCollection writeOffTripRelate = model.getDataEntity(true).getDynamicObjectCollection("writeofftriprelate");
        HashSet<Long> deleteEntryRowIds = new HashSet<Long>();
        LinkedList<Integer> delRelateIndex = new LinkedList<Integer>();
        for (int i = 0; i < writeOffTripRelate.size(); ++i) {
            DynamicObject row = (DynamicObject)writeOffTripRelate.get(i);
            if (!deleteRowId.contains(row.getLong("writeoffentryid"))) continue;
            deleteEntryRowIds.add(row.getLong("expenseid"));
            delRelateIndex.add(i);
        }
        int[] delRelateIndexArr = delRelateIndex.stream().mapToInt(Integer::valueOf).toArray();
        model.deleteEntryRows("writeofftriprelate", delRelateIndexArr);
        ArrayList<Integer> delExpenseItems = new ArrayList<Integer>(1);
        LinkedList<String> delOrderNums = new LinkedList<String>();
        Map ordernumMap = ((DynamicObject)tripEntry.get(0)).getDynamicObjectCollection("entryentity").stream().filter(v -> StringUtils.isNotBlank((String)v.getString("ordernum")) && StringUtils.isNotBlank((String)v.getString("orderformid"))).collect(Collectors.groupingBy(v -> v.getString("orderformid"), Collectors.mapping(v -> v.getString("ordernum"), Collectors.toList())));
        for (Map.Entry entry : ordernumMap.entrySet()) {
            DynamicObject[] orders;
            String orderFormId = entry.getKey();
            List ordernums = entry.getValue();
            QFilter qFilter = new QFilter("ordernum", "in", ordernums);
            qFilter.and(new QFilter("oabillnum", "in", deleteNumber));
            for (DynamicObject order : orders = BusinessDataServiceHelper.load((String)orderFormId, (String)"oabillnum,ordernum", (QFilter[])new QFilter[]{qFilter})) {
                if (!deleteNumber.contains(order.getString("oabillnum"))) continue;
                delOrderNums.add(order.getString("ordernum"));
            }
        }
        model.beginInit();
        DynamicObjectCollection entryOne = ((DynamicObject)model.getDataEntity(true).getDynamicObjectCollection("tripentry").get(0)).getDynamicObjectCollection("entryentity");
        for (int i = 0; i < entryOne.size(); ++i) {
            if (!deleteEntryRowIds.contains(((DynamicObject)entryOne.get(i)).getPkValue()) && !delOrderNums.contains(((DynamicObject)entryOne.get(i)).getString("ordernum"))) continue;
            delExpenseItems.add(i);
        }
        model.endInit();
        if (!delExpenseItems.isEmpty()) {
            model.deleteEntryRows("entryentity", delExpenseItems.stream().mapToInt(Integer::valueOf).toArray());
            view.updateView("entryentity");
            view.updateView("tripentry");
        }
    }

    public static String getParentViewFormId(IFormView view) {
        FormShowParameter formShowParameter;
        String sourceFormId = "";
        IFormView parentView = view.getViewNoPlugin(view.getFormShowParameter().getParentPageId());
        if (parentView == null || (formShowParameter = parentView.getFormShowParameter()) == null) {
            return sourceFormId;
        }
        sourceFormId = formShowParameter instanceof ListShowParameter ? ((ListShowParameter)formShowParameter).getBillFormId() : formShowParameter.getFormId();
        return sourceFormId;
    }

    public static String getBillCostOrgShowType(IFormView view) {
        String showTypes;
        IDataModel model = view.getModel();
        if (model != null && model.getProperty("expensesassumeshowtypes") != null && (showTypes = (String)model.getValue("expensesassumeshowtypes")) != null) {
            return StringUtils.strip((String)showTypes, (String)",").split(",")[0];
        }
        return "1";
    }
}

