/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.servicehelper;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.fi.er.business.amount.control.feestandard.FeeStandardHelper;
import kd.fi.er.business.servicehelper.CommonServiceHelper;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.business.utils.ErEntityTypeUtils;
import kd.fi.er.business.utils.SystemParamterUtil;

public class ExpenseItemServiceHelper {
    private static final String ALGO = ExpenseItemServiceHelper.class.getName();
    private static Log logger = LogFactory.getLog(ExpenseItemServiceHelper.class);

    public static QFilter getRelExpItemsFilter(String billType, Long costDeptId) {
        logger.info("---costDeptId---" + costDeptId);
        QFilter relBillFilter = ExpenseItemServiceHelper.getRelBillFilter(billType);
        QFilter relDeptFilter = ExpenseItemServiceHelper.getRelDeptFilter(costDeptId);
        return relBillFilter.and(relDeptFilter);
    }

    public static QFilter getRelBillFilter(String billType) {
        QFilter qFilter = new QFilter("enable", "=", (Object)Boolean.TRUE);
        List<Long> relatedBillExpenseItem = CommonServiceHelper.getRelatedExpenseItemByBillType(billType);
        if (relatedBillExpenseItem != null) {
            QFilter treeFilter = new QFilter("id", "in", relatedBillExpenseItem);
            qFilter.and(treeFilter);
        }
        return qFilter;
    }

    public static QFilter getRelDeptFilter(Long costDeptId) {
        QFilter qFilter = new QFilter("enable", "=", (Object)Boolean.TRUE);
        Set<Long> notRelatedDeptExpenseItem = ExpenseItemServiceHelper.getNotRelOrgExpItemIds(costDeptId);
        if (notRelatedDeptExpenseItem != null && notRelatedDeptExpenseItem.size() > 0) {
            QFilter treeFilter = new QFilter("id", "not in", notRelatedDeptExpenseItem);
            qFilter.and(treeFilter);
        }
        return qFilter;
    }

    public static Set<Long> getNotRelOrgExpItemIds(Long costDeptId) {
        ArrayList<Long> orgList = new ArrayList<Long>();
        List<Long> allOrgs = new ArrayList();
        orgList.add(costDeptId);
        if (ThreadCache.exists((Object)"costDepAdminOrgRelationMap")) {
            Map costDepAdminOrgRelationMap = (Map)ThreadCache.get((Object)"costDepAdminOrgRelationMap");
            Set costDepAdminOrgRelation = (Set)costDepAdminOrgRelationMap.get(costDeptId);
            ArrayList depIdLists = costDepAdminOrgRelation == null ? new ArrayList() : new ArrayList(costDepAdminOrgRelation);
            allOrgs.addAll(depIdLists);
        } else {
            allOrgs = OrgUnitServiceHelper.getAdminOrgRelation(orgList, (boolean)true);
        }
        allOrgs.add(costDeptId);
        allOrgs.removeIf(v -> v == null);
        Set<Long> allExpIdsHaveDept = new HashSet<Long>(10000);
        if (!allOrgs.isEmpty()) {
            if (ThreadCache.exists((Object)"allExpIdsHaveDeptMap")) {
                allExpIdsHaveDept = (Set)ThreadCache.get((Object)"allExpIdsHaveDeptMap");
            } else {
                String sql = "select distinct fexpitemid from t_bd_expitemreldept where 1=1;";
                try (DataSet ds = DB.queryDataSet((String)ALGO, (DBRoute)DBRoute.basedata, (String)sql);){
                    for (Row row : ds) {
                        allExpIdsHaveDept.add(row.getLong("fexpitemid"));
                    }
                }
                ThreadCache.put((Object)"allExpIdsHaveDeptMap", allExpIdsHaveDept);
            }
            HashSet<Long> expIdsHaveThisDept = new HashSet<Long>(100);
            if (!ThreadCache.exists((Object)"costDepExpItemRelationMap")) {
                SqlBuilder sb = new SqlBuilder();
                sb.append("select distinct fexpitemid from t_bd_expitemreldept where ", new Object[0]).appendIn("frelorgid", allOrgs.toArray());
                DataSet ds = DB.queryDataSet((String)ALGO, (DBRoute)DBRoute.basedata, (SqlBuilder)sb);
                Object object = null;
                try {
                    for (Row row : ds) {
                        expIdsHaveThisDept.add(row.getLong("fexpitemid"));
                    }
                }
                catch (Throwable throwable) {
                    object = throwable;
                    throw throwable;
                }
                finally {
                    if (ds != null) {
                        if (object != null) {
                            try {
                                ds.close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)object).addSuppressed(throwable);
                            }
                        } else {
                            ds.close();
                        }
                    }
                }
            } else {
                Map depExpItemRelationMap = (Map)ThreadCache.get((Object)"costDepExpItemRelationMap");
                Set expIds = (Set)depExpItemRelationMap.get(costDeptId);
                expIdsHaveThisDept.addAll(expIds == null ? new HashSet() : expIds);
            }
            allExpIdsHaveDept.removeAll(expIdsHaveThisDept);
        }
        return allExpIdsHaveDept;
    }

    public static List<Long> getUpBillExpItemId(DynamicObject bill) {
        ArrayList<Long> result;
        block10: {
            DynamicObject expenseitem;
            String billType;
            block9: {
                boolean isNeed;
                result = new ArrayList<Long>();
                billType = bill.getDynamicObjectType().getName();
                boolean bl = isNeed = ErEntityTypeUtils.isDailyReimburseBill(billType) || ErEntityTypeUtils.isPublicReimburseBill(billType) || ErEntityTypeUtils.isShareBill(billType) || ErEntityTypeUtils.isDailyLoanBill(billType);
                if (!isNeed) {
                    return result;
                }
                DynamicObject company = bill.getDynamicObject("company");
                if (company == null) {
                    return result;
                }
                if (!SystemParamterUtil.isShowParentbillExpenseitem(ErCommonUtils.getPk(company))) {
                    return result;
                }
                if (!ErEntityTypeUtils.isShareBill(billType)) break block9;
                DynamicObjectCollection expenseEntryCollction = bill.getDynamicObjectCollection("expenseentryentity_wait");
                if (expenseEntryCollction == null || expenseEntryCollction.size() <= 0) break block10;
                for (DynamicObject entry2 : expenseEntryCollction) {
                    DynamicObject expenseitem2 = entry2.getDynamicObject("expenseitem_wait");
                    if (expenseitem2 == null) continue;
                    result.add((Long)expenseitem2.getPkValue());
                }
                break block10;
            }
            if (ErEntityTypeUtils.isDailyLoanBill(billType)) {
                Map tableMapBill = bill.getDynamicObjectCollection("billhead_lk").stream().collect(Collectors.groupingBy(item -> item.getLong("billhead_lk_stableid"), Collectors.mapping(item -> item.getLong("billhead_lk_sbillid"), Collectors.toList())));
                bill.getDynamicObjectCollection("expenseentryentity").stream().flatMap(row -> row.getDynamicObjectCollection("expenseentryentity_lk").stream()).collect(Collectors.groupingBy(item -> item.getLong("expenseentryentity_lk_stableid"), Collectors.mapping(item -> item.getLong("expenseentryentity_lk_sbillid"), Collectors.toList()))).entrySet().forEach(entry -> {
                    tableMapBill.computeIfPresent((Long)entry.getKey(), (k, v) -> {
                        v.addAll((Collection)entry.getValue());
                        return v;
                    });
                    tableMapBill.computeIfAbsent((Long)entry.getKey(), k -> (List)entry.getValue());
                });
                QFilter[] qFilters = new QFilter[2];
                qFilters[1] = new QFilter("expenseentryentity.expenseitem.enable", "=", (Object)Boolean.TRUE);
                HashSet resultSet = new HashSet(tableMapBill.size());
                tableMapBill.entrySet().forEach(entry -> {
                    String entryNumber = EntityMetadataCache.loadTableDefine((Long)((Long)entry.getKey())).getEntityNumber();
                    if (ErEntityTypeUtils.isDailyApplyBill(entryNumber) || ErEntityTypeUtils.isApplyProjectBill(entryNumber)) {
                        qFilters[0] = new QFilter("id", "in", entry.getValue());
                        DynamicObjectCollection sourceBills = QueryServiceHelper.query((String)entryNumber, (String)"expenseentryentity,expenseentryentity.expenseitem.id", (QFilter[])qFilters);
                        Set expenseItemIds = sourceBills.stream().map(row -> row.getLong("expenseentryentity.expenseitem.id")).filter(Objects::nonNull).collect(Collectors.toSet());
                        resultSet.addAll(expenseItemIds);
                    }
                });
                result.addAll(resultSet);
                return result;
            }
            DynamicObjectCollection loanEntryCollction = bill.getDynamicObjectCollection("writeoffmoney");
            DynamicObjectCollection applyEntryCollction = bill.getDynamicObjectCollection("writeoffapply");
            if (loanEntryCollction != null && loanEntryCollction.size() > 0) {
                for (DynamicObject entry3 : loanEntryCollction) {
                    expenseitem = entry3.getDynamicObject("sourceexpenseitem");
                    if (expenseitem == null) continue;
                    result.add((Long)expenseitem.getPkValue());
                }
            }
            if (applyEntryCollction != null && applyEntryCollction.size() > 0) {
                for (DynamicObject entry3 : applyEntryCollction) {
                    expenseitem = entry3.getDynamicObject("expenseitemfield");
                    if (expenseitem == null) continue;
                    result.add((Long)expenseitem.getPkValue());
                }
            }
        }
        return result;
    }

    @Deprecated
    public static boolean checkExpenseItem(Long sysParamCompanyId, Long userOrgId, Long costDeptId, String billType, List<Long> includesExpenseItemIds, Long sourceId) {
        return false;
    }

    @Deprecated
    public static QFilter getUseOrgFilter(Long useId) {
        return new QFilter("ctrlstrategy", "=", (Object)"5");
    }

    public static List<Long> getAllEnableExpItemNoLeaf(DynamicObject entry) {
        return ExpenseItemServiceHelper.getAllEnableExpItemIds((DynamicObject)entry.getParent(), entry, true, false);
    }

    private static List<QFilter> getAllEnableExpItem(DynamicObject bill, Long costCompany, Long entrycostdept, boolean includeSourceBillExpenseItem, boolean isleaf) {
        List<Long> upBillExpItemId;
        List numbers;
        Set<String> nums;
        DynamicObject bizitem;
        QFilter relExpItemsFilter = ExpenseItemServiceHelper.getExpItemFiltersExcludeBizitemAndProjecttype(bill.getDynamicObjectType().getName(), costCompany, entrycostdept, isleaf);
        if (bill.getDataEntityType().getProperties().containsKey((Object)"bizitem") && (bizitem = bill.getDynamicObject("bizitem")) != null && !(nums = FeeStandardHelper.getStandardTypeFilterInExpenseItem(bizitem)).isEmpty()) {
            QFilter bizItemFilter = new QFilter("number", "in", nums);
            relExpItemsFilter = relExpItemsFilter.and(bizItemFilter);
        }
        DynamicObject projectType = null;
        if (bill.getDynamicObjectType().getProperty("projecttype") != null && (projectType = bill.getDynamicObject("projecttype")) != null && (numbers = projectType.getDynamicObjectCollection("entryentity").stream().map(a -> a.getLong("expenseitem.id")).collect(Collectors.toList())).size() > 0) {
            QFilter projectTypeFilter = new QFilter("id", "in", numbers);
            relExpItemsFilter = relExpItemsFilter.and(projectTypeFilter);
        }
        if (includeSourceBillExpenseItem && !(upBillExpItemId = ExpenseItemServiceHelper.getUpBillExpItemId(bill)).isEmpty()) {
            relExpItemsFilter = relExpItemsFilter.or(new QFilter("id", "in", upBillExpItemId));
        }
        return Collections.singletonList(relExpItemsFilter);
    }

    public static QFilter getExpItemFiltersExcludeBizitemAndProjecttype(String entityId, Long costCompany, Long entrycostdept, boolean isleaf) {
        QFilter baseDataFilter = BaseDataServiceHelper.getBaseDataFilter((String)"er_expenseitemedit", (Long)costCompany);
        QFilter leaf = new QFilter("isleaf", "=", (Object)Boolean.TRUE);
        QFilter relExpItemsFilter = ExpenseItemServiceHelper.getRelExpItemsFilter(entityId, entrycostdept);
        relExpItemsFilter.and(baseDataFilter);
        if (isleaf) {
            relExpItemsFilter.and(leaf);
        }
        return relExpItemsFilter;
    }

    private static List<Long> getAllEnableExpItemIds(DynamicObject bill, DynamicObject entry, boolean includeSourceBillExpenseItem, boolean isleaf) {
        Long costCompany = ErCommonUtils.getPk(entry.getDynamicObject("entrycostcompany"));
        Long entrycostdept = ErCommonUtils.getPk(entry.getDynamicObject("entrycostdept"));
        List<QFilter> list = ExpenseItemServiceHelper.getAllEnableExpItem(bill, costCompany, entrycostdept, includeSourceBillExpenseItem, isleaf);
        List<Long> relExpItems = QueryServiceHelper.query((String)"er_expenseitemedit", (String)"id", (QFilter[])list.toArray(new QFilter[0])).stream().map(e -> e.getLong("id")).collect(Collectors.toList());
        return relExpItems;
    }

    public static boolean checkExpenseItem(IDataModel dataModel, int rowIndex, Long expItemId) {
        DynamicObject bill = dataModel.getDataEntity(true);
        DynamicObjectCollection expenseentryentity = bill.getDynamicObjectCollection("expenseentryentity");
        if (expenseentryentity.size() <= rowIndex) {
            return true;
        }
        DynamicObject entry = (DynamicObject)expenseentryentity.get(rowIndex);
        DataEntityPropertyCollection properties = entry.getDynamicObjectType().getProperties();
        if (!properties.containsKey((Object)"entrycostcompany") || !properties.containsKey((Object)"entrycostdept")) {
            return true;
        }
        Long costCompany = ErCommonUtils.getPk(entry.getDynamicObject("entrycostcompany"));
        Long entrycostdept = ErCommonUtils.getPk(entry.getDynamicObject("entrycostdept"));
        QFilter qFilter = ExpenseItemServiceHelper.getExpItemFiltersExcludeBizitemAndProjecttype(bill.getDynamicObjectType().getName(), costCompany, entrycostdept, true);
        List<Long> upBillExpItemId = ExpenseItemServiceHelper.getUpBillExpItemId(bill);
        if (!upBillExpItemId.isEmpty()) {
            qFilter = qFilter.or(new QFilter("id", "in", upBillExpItemId));
        }
        List relExpItems = QueryServiceHelper.query((String)"er_expenseitemedit", (String)"id", (QFilter[])new QFilter[]{qFilter}).stream().map(e -> e.getLong("id")).collect(Collectors.toList());
        return relExpItems.contains(expItemId);
    }
}

