/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.servicehelper.pay;

import java.math.BigDecimal;
import java.util.ArrayList;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.OperationResult;
import kd.fi.er.business.utils.ErCommonUtils;

public class GeneratePayAssistant {
    private final OperationResult operationResult = new OperationResult();
    private final DynamicObject[] payDynamics;

    private GeneratePayAssistant(DynamicObject[] payDynamics) {
        this.payDynamics = payDynamics;
    }

    public static GeneratePayAssistant getInstance(DynamicObject[] payDynamics) {
        return new GeneratePayAssistant(payDynamics);
    }

    public void doExecute() {
        this.filter();
    }

    private void filter() {
        ArrayList<String> balanceCount = new ArrayList<String>();
        ArrayList<String> statusCount = new ArrayList<String>();
        ArrayList<String> varCount = new ArrayList<String>();
        BigDecimal totalAmount = BigDecimal.ZERO;
        for (DynamicObject dynamicObject : this.payDynamics) {
            Boolean hasInvoice;
            if (!"1".equals(dynamicObject.getString("isbalance"))) {
                balanceCount.add(String.format(ResManager.loadKDString((String)"%s\uff1a\u672a\u5bf9\u5e73\uff0c\u65e0\u6cd5\u5b8c\u6210\u4ed8\u6b3e\u3002", (String)"GeneratePayAssistant_0", (String)"fi-er-business", (Object[])new Object[0]), dynamicObject.getString("orderNum")));
                this.operationResult.setSuccess(false);
                continue;
            }
            if (!"C".equals(dynamicObject.getString("billstatus"))) {
                statusCount.add(String.format(ResManager.loadKDString((String)"%s\uff1a\u672a\u5ba1\u6838\uff0c\u65e0\u6cd5\u5b8c\u6210\u4ed8\u6b3e\u3002", (String)"GeneratePayAssistant_1", (String)"fi-er-business", (Object[])new Object[0]), dynamicObject.getString("orderNum")));
                this.operationResult.setSuccess(false);
                continue;
            }
            Long companyId = ErCommonUtils.getPk(dynamicObject.get("settlemain"));
            if (null == companyId) {
                statusCount.add(String.format(ResManager.loadKDString((String)"%s\uff1a\u8d39\u7528\u627f\u62c5\u516c\u53f8\u5f02\u5e38\uff0c\u65e0\u6cd5\u5b8c\u6210\u4ed8\u6b3e\u3002", (String)"GeneratePayAssistant_7", (String)"fi-er-business", (Object[])new Object[0]), dynamicObject.getString("orderNum")));
                this.operationResult.setSuccess(false);
                continue;
            }
            int enablePayAfterInvoice = ErCommonUtils.getEnablePayAfterInvoice(companyId);
            if (enablePayAfterInvoice == 1 && !(hasInvoice = Boolean.valueOf(dynamicObject.getBoolean("hasInvoice"))).booleanValue()) {
                varCount.add(String.format(ResManager.loadKDString((String)"%s\uff1a\u672a\u5f00\u7968\uff0c\u65e0\u6cd5\u5b8c\u6210\u4ed8\u6b3e\u3002", (String)"GeneratePayAssistant_2", (String)"fi-er-business", (Object[])new Object[0]), dynamicObject.getString("orderNum")));
                this.operationResult.setSuccess(false);
                continue;
            }
            BigDecimal checkingAmount = dynamicObject.getBigDecimal("totalamount");
            totalAmount = checkingAmount == null ? totalAmount : totalAmount.add(checkingAmount);
        }
        if (!this.operationResult.isSuccess()) {
            StringBuilder errMsg = new StringBuilder();
            if (balanceCount.size() > 0) {
                errMsg.append(String.format(ResManager.loadKDString((String)"\u9009\u4e2d\u8bb0\u5f55\u5b58\u5728%s\u6761\u672a\u5bf9\u5e73\u3002", (String)"GeneratePayAssistant_3", (String)"fi-er-business", (Object[])new Object[0]), balanceCount.size())).append(balanceCount);
            }
            if (statusCount.size() > 0) {
                errMsg.append(String.format(ResManager.loadKDString((String)"\u9009\u4e2d\u8bb0\u5f55\u5b58\u5728%s\u6761\u672a\u5ba1\u6838\u3002", (String)"GeneratePayAssistant_4", (String)"fi-er-business", (Object[])new Object[0]), statusCount.size())).append(statusCount);
            }
            if (varCount.size() > 0) {
                errMsg.append(String.format(ResManager.loadKDString((String)"\u9009\u4e2d\u8bb0\u5f55\u5b58\u5728%s\u6761\u672a\u5f00\u7968\u3002", (String)"GeneratePayAssistant_5", (String)"fi-er-business", (Object[])new Object[0]), varCount.size())).append(varCount);
            }
            this.operationResult.setMessage(errMsg.toString());
        }
        if (this.operationResult.isSuccess() && totalAmount.compareTo(BigDecimal.ZERO) <= 0) {
            this.operationResult.setMessage(ResManager.loadKDString((String)"\u9009\u4e2d\u8bb0\u5f55\u4ed8\u6b3e\u603b\u91d1\u989d\u5c0f\u4e8e\u6216\u7b49\u4e8e0\uff0c\u65e0\u6cd5\u5b8c\u6210\u4ed8\u6b3e\u3002", (String)"GeneratePayAssistant_6", (String)"fi-er-business", (Object[])new Object[0]));
            this.operationResult.setSuccess(false);
        }
    }

    public OperationResult getOperationResult() {
        String msg = "";
        String operationMsg = this.operationResult.getMessage();
        if (operationMsg == null) {
            operationMsg = "";
        }
        this.operationResult.setMessage(msg + operationMsg);
        return this.operationResult;
    }
}

