/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.share.befshare;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.er.business.utils.ErStdConfig;

public abstract class AbstractBeforeShareBillGenerator {
    DynamicObjectType SHARE_BILL_DYNAMIC_OBJ_TYPE = EntityMetadataCache.getDataEntityType((String)"er_expensesharebill");
    String entityName = null;

    public AbstractBeforeShareBillGenerator(String entityName) {
        this.entityName = entityName;
    }

    public void genBeforeShareBill(Set<Object> reimBillIds) {
        boolean genBeforeShareBill = ErStdConfig.getBoolean("genBeforeShareBill");
        if (!genBeforeShareBill) {
            return;
        }
        QFilter[] filters = new QFilter[]{new QFilter("isbeforeshare", "=", (Object)true), new QFilter("autogenshare", "=", (Object)false), new QFilter("billstatus", "in", (Object)new String[]{"E", "F", "G"}), new QFilter("id", "in", reimBillIds)};
        DynamicObject[] dataEntities = BusinessDataServiceHelper.load((String)this.entityName, (String)this.getSelectProperties(), (QFilter[])filters);
        if (dataEntities.length == 0) {
            return;
        }
        ArrayList<DynamicObject> shareBillLst = new ArrayList<DynamicObject>(dataEntities.length);
        for (DynamicObject reimburseBill : dataEntities) {
            DynamicObject shareBill = (DynamicObject)this.SHARE_BILL_DYNAMIC_OBJ_TYPE.createInstance();
            this.setDefaultValue(shareBill, reimburseBill);
            this.fillFields(shareBill, reimburseBill);
            shareBillLst.add(shareBill);
            DynamicObjectCollection shareEntries = shareBill.getDynamicObjectCollection("expenseentryentity");
            if (CollectionUtils.isEmpty((Collection)shareEntries)) continue;
            DynamicObject costCompany = (DynamicObject)((DynamicObject)shareEntries.get(0)).get("entrycostcompany");
            shareBill.set("sharecompany", (Object)costCompany);
        }
        SaveServiceHelper.saveOperate((String)"er_expensesharebill", (DynamicObject[])shareBillLst.toArray(new DynamicObject[0]), (OperateOption)OperateOption.create());
        for (DynamicObject dataEntity : dataEntities) {
            dataEntity.set("autogenshare", (Object)true);
        }
        SaveServiceHelper.save((DynamicObject[])dataEntities);
    }

    private void setDefaultValue(DynamicObject shareBill, DynamicObject reimburseBill) {
        Date now = new Date();
        long currUserId = RequestContext.get().getCurrUserId();
        shareBill.set("billstatus", (Object)"E");
        shareBill.set("sharestatus", (Object)"C");
        shareBill.set("company", (Object)reimburseBill.getDynamicObject("company"));
        shareBill.set("applier", reimburseBill.get("applier"));
        shareBill.set("applierpositionstr", reimburseBill.get("applierpositionstr"));
        shareBill.set("org", reimburseBill.get("org"));
        shareBill.set("bizdate", (Object)now);
        shareBill.set("creator_id", (Object)currUserId);
        shareBill.set("modifier_id", (Object)currUserId);
        shareBill.set("auditor_id", (Object)currUserId);
        shareBill.set("description", (Object)(reimburseBill.getString("billno") + "-FT"));
        shareBill.set("shareway", (Object)"A");
    }

    abstract String getSelectProperties();

    abstract void fillFields(DynamicObject var1, DynamicObject var2);
}

