/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.task;

import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.fi.er.business.utils.ErEntityTypeUtils;
import kd.fi.er.business.utils.SystemParamterUtil;
import kd.fi.er.common.ErBillStatusEnum;
import kd.fi.er.common.constant.formproperties.mainbill.ErCoreBaseBill;

public class ErBillColseTask
extends AbstractTask {
    private static final String[] entityNameArray = new String[]{"er_tripreimbursebill", "er_dailyreimbursebill", "er_publicreimbursebill", "er_repaymentbill"};
    private static final Log logger = LogFactory.getLog(ErCoreBaseBill.class);

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        try {
            this.closeBill();
        }
        catch (ParseException e) {
            logger.error((Throwable)e);
            throw new KDException(new ErrorCode("ER_BillColseTask_Error", ResManager.loadKDString((String)"\u5b9a\u65f6\u4efb\u52a1\u5173\u95ed\u5355\u636e\uff0c\u65f6\u95f4\u89e3\u6790\u9519\u8bef\u3002", (String)"ErBillColseTask_0", (String)"fi-er-business", (Object[])new Object[0])), new Object[]{e});
        }
    }

    private Date getDelayLimitedDate() throws ParseException {
        Date currentDate = new Date();
        String pattern = "yyyy-MM-dd";
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern(pattern);
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(pattern);
        String lastDateStr = simpleDateFormat.format(currentDate);
        LocalDate lastLocalDate = LocalDate.parse(lastDateStr, dateTimeFormatter);
        int delayDay = SystemParamterUtil.getBilllCloseDelayDays(OrgUnitServiceHelper.getRootOrgId());
        lastLocalDate = lastLocalDate.plusDays(-delayDay);
        String dateStr = lastLocalDate.format(dateTimeFormatter);
        return simpleDateFormat.parse(dateStr);
    }

    private void closeBill() throws ParseException {
        String selectFileds = "id,billstatus,hasvoucher,modifytime";
        for (String entityName : entityNameArray) {
            QFilter[] qFilters = this.getBillQFilter(entityName);
            DynamicObject[] billArray = BusinessDataServiceHelper.load((String)entityName, (String)selectFileds, (QFilter[])qFilters);
            if (billArray == null || billArray.length == 0) continue;
            this.setBillStatusToClose(billArray);
        }
    }

    private void setBillStatusToClose(DynamicObject[] billArray) {
        if (billArray == null || billArray.length == 0) {
            return;
        }
        for (DynamicObject bill : billArray) {
            bill.set("billstatus", (Object)ErBillStatusEnum.I.name());
        }
        SaveServiceHelper.update((DynamicObject[])billArray);
    }

    private QFilter[] getBillQFilter(String entityName) throws ParseException {
        QFilter q1 = new QFilter("hasvoucher", "=", (Object)true);
        QFilter q2 = new QFilter("billstatus", "=", (Object)ErBillStatusEnum.G.name());
        if (ErEntityTypeUtils.isDailyReimburseBill(entityName) || ErEntityTypeUtils.isPublicReimburseBill(entityName)) {
            q2.or(new QFilter("billstatus", "=", (Object)ErBillStatusEnum.E.name()).and(new QFilter("payamount", "=", (Object)BigDecimal.ZERO)));
        } else if (ErEntityTypeUtils.isTripReimburseBill(entityName)) {
            q2.or(new QFilter("billstatus", "=", (Object)ErBillStatusEnum.E.name()).and(new QFilter("encashamount", "=", (Object)BigDecimal.ZERO)));
        }
        QFilter q3 = new QFilter("modifytime", "<", (Object)this.getDelayLimitedDate());
        return new QFilter[]{q1, q2, q3};
    }
}

