/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.task.datacheck.util;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.property.EntryProp;
import kd.bos.ext.fi.ai.FIDataCheckTask;
import kd.bos.ext.fi.util.FIDataCheckUtil;
import kd.bos.logging.Log;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.er.business.task.datacheck.common.ErDataCheckInfo;
import kd.fi.er.business.task.datacheck.framework.CheckSourceInfo;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.business.utils.ErStdConfig;
import kd.fi.er.common.field.head.ApplyPayBillHeadFields;
import kd.fi.er.common.field.head.DailyLoanBillHeadFields;
import kd.fi.er.common.field.head.DailyReimBillHeadFields;
import kd.fi.er.common.field.head.PrePayBillHeadFields;
import kd.fi.er.common.field.head.PublicReimBillHeadFields;
import kd.fi.er.common.field.head.TripReimBillHeadFields;
import kd.fi.er.common.field.head.TripReqBillHeadFields;
import kd.fi.er.common.field.writeoffmoney.DailyReimburseWriteOffFields;
import kd.fi.er.common.field.writeoffmoney.TripReimburseWriteOffFields;
import org.apache.commons.lang3.StringUtils;

public class ErDataCheckUtil {
    private static final String appId = "er";

    public static Set<String> getCancelValidators() {
        Set<Object> cancelValidators = Sets.newHashSetWithExpectedSize((int)2);
        String cancelValidatorStr = ErStdConfig.get("datacheck.cancel");
        if (StringUtils.isNotBlank((CharSequence)cancelValidatorStr)) {
            cancelValidators = Stream.of(StringUtils.split((String)cancelValidatorStr, (String)";")).collect(Collectors.toSet());
        }
        return cancelValidators;
    }

    public static boolean whetherExecuteValidator(String forbiddenValidatorId) {
        Set<String> cancelValidators = ErDataCheckUtil.getCancelValidators();
        return !cancelValidators.contains(forbiddenValidatorId);
    }

    public static boolean testFuncSwitch() {
        Set<String> cancelValidators = ErDataCheckUtil.getCancelValidators();
        return ErCommonUtils.isResearchEnvironment() || cancelValidators.contains("testFuncSwitch");
    }

    public static void saveResult(String taskName, boolean isPass, ErDataCheckInfo checkResult, FIDataCheckTask task) {
        FIDataCheckUtil.saveResult((String)taskName, (String)appId, (boolean)isPass, (String)checkResult.toString(), (String)task.getClass().getName());
    }

    public static QFilter getDateFilter(int days) {
        Date[] billCheckDate = ErDataCheckUtil.getBillCheckDate(days);
        return QFilter.of((String)"modifytime >= ? and modifytime <= ?", (Object[])new Object[]{billCheckDate[0], billCheckDate[1]});
    }

    public static Date[] getBillCheckDate(int days) {
        Calendar instance = Calendar.getInstance();
        instance.set(11, 0);
        instance.set(12, 0);
        instance.set(13, 0);
        Date endDate = instance.getTime();
        instance.add(5, 0 - days);
        Date startDate = instance.getTime();
        return new Date[]{startDate, endDate};
    }

    public static String assertCondition(DynamicObject bill, Function<DynamicObject, String> validator) {
        return validator.apply(bill);
    }

    public static DynamicObject[] getBillData(CheckSourceInfo checkSourceInfo) {
        DynamicObjectType subEntityType = EntityMetadataCache.getSubDataEntityType((String)checkSourceInfo.getEntityName(), checkSourceInfo.getPreparePropertys());
        ArrayList idList = new ArrayList();
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"ErDataCheckUtil.getBillData", (String)checkSourceInfo.getEntityName(), (String)"id", (QFilter[])checkSourceInfo.getqFitlers(), null);){
            ds.forEach(row -> idList.add(row.get(0)));
        }
        return BusinessDataServiceHelper.load((Object[])idList.toArray(), (DynamicObjectType)subEntityType);
    }

    public static void recordEntryCount(String operateKey, IDataModel model, Log logger) {
        Object billStatus = model.getValue("billstatus");
        if (!StringUtils.equals((CharSequence)operateKey, (CharSequence)"save") || !StringUtils.equalsAny((CharSequence)String.valueOf(billStatus), (CharSequence[])new CharSequence[]{"A", "D"})) {
            DataEntityPropertyCollection properties = model.getDataEntityType().getProperties();
            StringBuilder sb = new StringBuilder();
            sb.append("bill entityid\uff1a").append(model.getDataEntityType().getName()).append(",pk:").append(model.getValue("id")).append("\u3002invoke\uff1a").append(operateKey).append(",verify information\uff1a");
            for (int i = 0; i < properties.size(); ++i) {
                IDataEntityProperty iDataEntityProperty = (IDataEntityProperty)properties.get(i);
                if (!(iDataEntityProperty instanceof EntryProp)) continue;
                sb.append("ek:[").append(iDataEntityProperty.getName()).append("]:c{").append(model.getEntryRowCount(iDataEntityProperty.getName())).append("};");
            }
            logger.info(sb.toString());
        }
    }

    public static void addPreparePropertys(Collection<String> preparePropertys) {
        preparePropertys.addAll(TripReimBillHeadFields.getInstance().getAllFiedName());
        preparePropertys.addAll(TripReqBillHeadFields.getInstance().getAllFiedName());
        preparePropertys.addAll(DailyReimBillHeadFields.getInstance().getAllFiedName());
        preparePropertys.addAll(PublicReimBillHeadFields.getInstance().getAllFiedName());
        preparePropertys.addAll(DailyLoanBillHeadFields.getInstance().getAllFiedName());
        preparePropertys.addAll(PrePayBillHeadFields.getInstance().getAllFiedName());
        preparePropertys.addAll(ApplyPayBillHeadFields.getInstance().getAllFiedName());
        preparePropertys.addAll(TripReimburseWriteOffFields.getInstance().getAllFiedName());
        preparePropertys.addAll(DailyReimburseWriteOffFields.getInstance().getAllFiedName());
        preparePropertys.add("accountcurrency");
        preparePropertys.add("accexchangerate");
        preparePropertys.add("accquotetype");
        preparePropertys.add("receiveamount");
        preparePropertys.add("orireceiveamount");
        preparePropertys.add("notpayamount");
        preparePropertys.add("accnotpayamount");
        preparePropertys.add("payamount");
        preparePropertys.add("accpayedamount");
        preparePropertys.add("tripaccappamount");
        preparePropertys.add("entryappamount");
        preparePropertys.add("expebalanceamount");
        preparePropertys.add("accountentry");
        preparePropertys.add("tripaccappamount");
        preparePropertys.add("currexpenseamount");
        preparePropertys.add("monthsettleamount");
        preparePropertys.add("proxytax");
        preparePropertys.add("proxyamt");
        preparePropertys.add("curproxyamt");
        preparePropertys.add("detailquotetype");
        preparePropertys.add("expquotetype");
        preparePropertys.add("expeapproveamount");
        preparePropertys.add("expeapprovecurramount");
        preparePropertys.add("entrycurrency");
        preparePropertys.add("exchangerate");
        preparePropertys.add("loancurrency");
        preparePropertys.add("accloanamount");
        preparePropertys.add("curraccloanamount");
        preparePropertys.add("orientryappamount");
        preparePropertys.add("entryappamount");
        preparePropertys.add("exchangerate");
        preparePropertys.add("approveamount");
        preparePropertys.add("company");
        preparePropertys.add("billno");
        preparePropertys.add("encashamount");
        preparePropertys.add("payamount");
        preparePropertys.add("expquotetype");
        preparePropertys.add("curproxyamt");
        preparePropertys.add("isloan");
        preparePropertys.add("approveamount");
        preparePropertys.add("receiveamount");
        preparePropertys.add("orireceiveamount");
        preparePropertys.add("currency");
        preparePropertys.add("billstatus");
        preparePropertys.add("accexchangerate");
        preparePropertys.add("accountcurrency");
        preparePropertys.add("accquotetype");
        preparePropertys.add("exchangerate");
        preparePropertys.add("monthsettleamount");
        preparePropertys.add("tripbookamount");
        preparePropertys.add("tripbookcuramount");
        preparePropertys.add("isexistmonthly");
        preparePropertys.add("billkind");
    }
}

