/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.task.report;

import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.RefObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.dlock.DLock;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.ext.fi.thread.TaskType;
import kd.bos.ext.fi.thread.ThreadService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.er.business.utils.ErCommonUtils;
import org.apache.commons.lang.time.DateFormatUtils;

public abstract class AbstrackSyncData {
    private static Log logger = LogFactory.getLog(AbstrackSyncData.class);
    protected static final String ER_EXPENSEDATA_SYNC_TIME = "er_expensedata_sync_time";
    protected static final String ER_EXPENSEDATA_SYNCRECORD = "er_expensedata_syncrecord";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sync(Date inputBeginDate) {
        block13: {
            logger.info("\u5f53\u524d\u6b63\u5728\u540c\u6b65\u6570\u636e\uff1a " + this.getBillType());
            String lockKey = "fi.er.business.abstracksyncdata." + this.getBillType();
            ArrayList<RefObject> refObjects = new ArrayList<RefObject>(10);
            DLock dLock = DLock.create((String)lockKey);
            try {
                boolean isLock = dLock.tryLock(30000L);
                if (isLock) {
                    long sum;
                    if (!this.checkSyncStatus()) {
                        String message = String.format(ResManager.loadKDString((String)"%s\u5f53\u524d\u6b63\u5728\u6267\u884c\u540c\u6b65\u4efb\u52a1\uff0c\u524d\u7a0d\u540e\u518d\u8bd5\u3002", (String)"AbstrackSyncData_3", (String)"fi-er-business", (Object[])new Object[0]), this.getBillName());
                        logger.error(message);
                        return;
                    }
                    Date syncTime = new Date();
                    List<QFilter> list = null;
                    list = inputBeginDate == null ? this.splitTimeWhenAllSync(syncTime) : this.splitTimeWhenUpdatedSync(inputBeginDate, syncTime);
                    CountDownLatch countDownLatch = new CountDownLatch(list.size());
                    RefObject ex = new RefObject();
                    try {
                        this.saveExecStatus(true, syncTime, list.size());
                        AtomicInteger syncedTasks = new AtomicInteger(0);
                        RequestContext requestContext = RequestContext.get();
                        for (QFilter q : list) {
                            RefObject refObject = new RefObject((Object)new AtomicInteger(0));
                            refObjects.add(refObject);
                            ThreadService.execute(() -> {
                                try {
                                    this.syncData(this.getBillType(), new QFilter[]{q, this.getQfilter()}, this.getLengthPerQuery(), inputBeginDate == null ? "createtime" : "modifytime", (RefObject<AtomicInteger>)refObject);
                                }
                                catch (Exception e) {
                                    logger.error(e.getMessage(), (Throwable)e);
                                    ex.setValue((Object)e);
                                }
                                this.upateSyncing(syncedTasks.incrementAndGet());
                                countDownLatch.countDown();
                            }, (TaskType)TaskType.ER_REPORT_QUERY, (RequestContext)requestContext);
                        }
                        countDownLatch.await();
                        this.saveExecStatus(false, syncTime, list.size());
                        sum = refObjects.stream().mapToLong(e -> ((AtomicInteger)e.getValue()).get()).sum();
                    }
                    catch (Exception e2) {
                        long sum2;
                        try {
                            logger.error(e2.getMessage());
                            ex.setValue((Object)e2);
                            this.saveExecStatus(false, syncTime, list.size());
                            sum2 = refObjects.stream().mapToLong(e -> ((AtomicInteger)e.getValue()).get()).sum();
                        }
                        catch (Throwable throwable) {
                            this.saveExecStatus(false, syncTime, list.size());
                            long sum3 = refObjects.stream().mapToLong(e -> ((AtomicInteger)e.getValue()).get()).sum();
                            logger.info(String.format("\u672c\u6b21\u540c\u6b65%s\u6570\u636e\u540c\u6b65\u5b8c\u6210\u4e86%s\u6761\u6570\u636e", this.getBillName(), sum3));
                            this.saveSyncLog(inputBeginDate == null ? "1" : "0", syncTime, new Date(), sum3, (Throwable)ex.getValue());
                            throw throwable;
                        }
                        logger.info(String.format("\u672c\u6b21\u540c\u6b65%s\u6570\u636e\u540c\u6b65\u5b8c\u6210\u4e86%s\u6761\u6570\u636e", this.getBillName(), sum2));
                        this.saveSyncLog(inputBeginDate == null ? "1" : "0", syncTime, new Date(), sum2, (Throwable)ex.getValue());
                        break block13;
                    }
                    logger.info(String.format("\u672c\u6b21\u540c\u6b65%s\u6570\u636e\u540c\u6b65\u5b8c\u6210\u4e86%s\u6761\u6570\u636e", this.getBillName(), sum));
                    this.saveSyncLog(inputBeginDate == null ? "1" : "0", syncTime, new Date(), sum, (Throwable)ex.getValue());
                    break block13;
                }
                logger.error(ResManager.loadKDString((String)"\u5c1d\u8bd5\u83b7\u53d6\u9501\u5931\u8d25\u3002", (String)"AbstrackSyncData_2", (String)"fi-er-business", (Object[])new Object[0]) + lockKey);
            }
            catch (Exception e3) {
                logger.error("\u6570\u636e\u540c\u6b65\u5f02\u5e38", (Throwable)e3);
            }
            finally {
                dLock.unlock();
            }
        }
    }

    private List<QFilter> splitTimeWhenAllSync(Date date) {
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)this.getBillType(), (String)"min(id) as min, max(id) as max, count(id) as count", (QFilter[])new QFilter[0]);
        List<QFilter> lists = AbstrackSyncData.splitById("id", dynamicObject.getLong("min"), dynamicObject.getLong("max"), this.getTask());
        return lists;
    }

    private List<QFilter> splitTimeWhenUpdatedSync(Date inputBeginDate, Date date) {
        List<QFilter> lists = AbstrackSyncData.splitByTime("modifytime", inputBeginDate, date, this.getTask());
        return lists;
    }

    protected static List<QFilter> splitByTime(String field, Date begin, Date end, Long n) {
        Long start = begin.getTime();
        long d = (end.getTime() - start) / n;
        ArrayList<QFilter> list = new ArrayList<QFilter>(n.intValue());
        int i = 0;
        while ((long)i < n) {
            QFilter qFilterOne = null;
            if (i > 0 && (long)i < n - 1L) {
                qFilterOne = new QFilter(field, ">=", (Object)new Date(start + (long)i * d));
                qFilterOne.and(field, "<", (Object)new Date(start + (long)(i + 1) * d));
            } else if (i == 0) {
                qFilterOne = new QFilter(field, ">=", (Object)begin);
                qFilterOne.and(field, "<", (Object)new Date(start + (long)(i + 1) * d));
            } else if ((long)i == n - 1L) {
                qFilterOne = new QFilter(field, ">=", (Object)new Date(start + (long)i * d));
                qFilterOne.and(field, "<", (Object)end);
            }
            list.add(qFilterOne);
            ++i;
        }
        return list;
    }

    protected static List<QFilter> splitById(String field, Long min, Long max, Long n) {
        long d = (max - min) / n;
        ArrayList<QFilter> list = new ArrayList<QFilter>(2);
        int i = 0;
        while ((long)i < n) {
            QFilter qFilterOne = null;
            if (i > 0 && (long)i < n - 1L) {
                qFilterOne = new QFilter(field, ">=", (Object)(min + (long)i * d));
                qFilterOne.and(field, "<", (Object)(min + (long)(i + 1) * d));
            } else if (i == 0) {
                qFilterOne = new QFilter(field, ">=", (Object)min);
                qFilterOne.and(field, "<", (Object)(min + (long)(i + 1) * d));
            } else if ((long)i == n - 1L) {
                qFilterOne = new QFilter(field, ">=", (Object)(min + (long)i * d));
                qFilterOne.and(field, "<=", (Object)max);
            }
            list.add(qFilterOne);
            ++i;
        }
        return list;
    }

    private void saveExecStatus(boolean begin, Date syncTime, Integer tasks) {
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)ER_EXPENSEDATA_SYNC_TIME, (String)"billtype, createtime, modifytime, billstatus, lastsynctime,syncing, total", (QFilter[])new QFilter[]{new QFilter("billtype", "=", (Object)this.getBillType())});
        if (dynamicObject == null) {
            dynamicObject = new DynamicObject((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)ER_EXPENSEDATA_SYNC_TIME));
            dynamicObject.set("createtime", (Object)new Date());
        }
        if (begin) {
            dynamicObject.set("billtype", (Object)this.getBillType());
            dynamicObject.set("modifytime", (Object)new Date());
            dynamicObject.set("lastsynctime", (Object)syncTime);
            dynamicObject.set("billstatus", (Object)"A");
            dynamicObject.set("total", (Object)tasks);
            dynamicObject.set("syncing", (Object)0);
        } else {
            dynamicObject.set("syncing", (Object)tasks);
            dynamicObject.set("modifytime", (Object)new Date());
            dynamicObject.set("billstatus", (Object)"B");
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
    }

    private void upateSyncing(Integer syncing) {
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)ER_EXPENSEDATA_SYNC_TIME, (String)"billtype, createtime, modifytime, billstatus, lastsynctime, total, syncing", (QFilter[])new QFilter[]{new QFilter("billtype", "=", (Object)this.getBillType())});
        dynamicObject.set("syncing", (Object)syncing);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
    }

    private void saveSyncLog(String syncrange, Date begin, Date end, Long count, Throwable ex) {
        DynamicObject dynamicObject = new DynamicObject((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)ER_EXPENSEDATA_SYNCRECORD));
        dynamicObject.set("billtype", (Object)this.getBillType());
        dynamicObject.set("begintime", (Object)begin);
        dynamicObject.set("endtime", (Object)end);
        dynamicObject.set("message", (Object)this.getErrorMsg(ex));
        dynamicObject.set("count", (Object)count);
        dynamicObject.set("enable", (Object)"1");
        dynamicObject.set("status", (Object)"A");
        dynamicObject.set("syncrange", (Object)syncrange);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
    }

    private boolean checkSyncStatus() {
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)ER_EXPENSEDATA_SYNC_TIME, (String)"billstatus", (QFilter[])new QFilter[]{new QFilter("billtype", "=", (Object)this.getBillType())});
        return dynamicObject == null || !"A".equals(dynamicObject.get("billstatus"));
    }

    void deleteOldDataByBillIds(List<Long> ids) {
        this.deleteOldDataByField(ids, "fbillid");
    }

    private void deleteOldDataByField(List<Long> ids, String field) {
        MainEntityType dynamicObjectType = EntityMetadataCache.getDataEntityType((String)this.getTargetEntity());
        String tableName = dynamicObjectType.getAlias();
        String delete = null;
        String params = null;
        if (dynamicObjectType.getProperties().get((Object)"reimbursers") instanceof MulBasedataProp) {
            MulBasedataProp prop = (MulBasedataProp)dynamicObjectType.getProperties().get((Object)"reimbursers");
            delete = " delete FROM " + prop.getAlias() + "   WHERE fid in ( select fid from " + tableName + " where " + field + " IN (%s) )";
            params = Stream.generate(() -> "?").limit(ids.size()).collect(Collectors.joining(","));
            delete = String.format(delete, params);
            DB.execute((DBRoute)DBRoute.of((String)"fi"), (String)delete, (Object[])ids.toArray());
        }
        delete = " delete FROM " + tableName + "   WHERE " + field + " IN (%s) ";
        params = Stream.generate(() -> "?").limit(ids.size()).collect(Collectors.joining(","));
        delete = String.format(delete, params);
        DB.execute((DBRoute)DBRoute.of((String)"fi"), (String)delete, (Object[])ids.toArray());
    }

    protected DataSet syncData(String billType, QFilter[] qFilters, Long length, String orderby, RefObject<AtomicInteger> refObject) {
        ORM orm = ORM.create();
        DataSet dataSet = orm.queryDataSet(this.getClass().getName() + "." + billType, billType, this.getSql(), qFilters, orderby, ((AtomicInteger)refObject.getValue()).get(), length.intValue());
        if (this.saveData(dataSet, refObject)) {
            this.syncData(billType, qFilters, length, orderby, refObject);
        }
        return dataSet;
    }

    private boolean saveData(DataSet dataSet, RefObject<AtomicInteger> refObject) {
        MainEntityType dynamicObjectType = EntityMetadataCache.getDataEntityType((String)this.getTargetEntity());
        Iterator iterator = dataSet.iterator();
        int i = 0;
        ArrayList<DynamicObject> list = new ArrayList<DynamicObject>(this.getLengthPerQuery().intValue());
        while (iterator.hasNext()) {
            Row row = (Row)iterator.next();
            DynamicObject dynamicObject = new DynamicObject((DynamicObjectType)dynamicObjectType);
            if (row.get("entrycostcompany") != null && ErCommonUtils.getPk(row.get("entrycostcompany")) != 0L) {
                dynamicObject.set("costcompany", (Object)ErCommonUtils.getPk(row.get("entrycostcompany")));
                dynamicObject.set("costdept", (Object)ErCommonUtils.getPk(row.get("entrycostdept")));
            } else if (row.get("costcompany") != null && ErCommonUtils.getPk(row.get("costcompany")) != 0L) {
                dynamicObject.set("costcompany", (Object)ErCommonUtils.getPk(row.get("costcompany")));
                dynamicObject.set("costdept", (Object)ErCommonUtils.getPk(row.get("costdept")));
            }
            Map<String, String> fieldMap = this.getFieldMap();
            for (Map.Entry<String, String> entry : fieldMap.entrySet()) {
                dynamicObject.set(entry.getValue(), row.get(entry.getKey()));
            }
            this.dateConvertProcessor(row.getDate("bizdate"), dynamicObject);
            this.dataConvertPostProcessor(row, dynamicObject);
            list.add(dynamicObject);
            ++i;
        }
        ((AtomicInteger)refObject.getValue()).addAndGet(i);
        if (list.size() > 0) {
            try (TXHandle txHandle = TX.required();){
                this.deleteOldDataByBillIds(list.stream().map(e -> e.getLong("billid")).collect(Collectors.toList()));
                SaveServiceHelper.save((DynamicObject[])list.toArray(new DynamicObject[0]));
            }
            catch (Exception e2) {
                logger.error(e2.getMessage(), (Throwable)e2);
            }
        }
        return (long)i >= this.getLengthPerQuery();
    }

    protected void dateConvertProcessor(Date applyDate, DynamicObject dynamicObject) {
        if (applyDate == null) {
            return;
        }
        String year = DateFormatUtils.format((Date)applyDate, (String)"yyyy");
        dynamicObject.set("year", (Object)Integer.valueOf(year));
        dynamicObject.set("yearmonth", (Object)Integer.valueOf(DateFormatUtils.format((Date)applyDate, (String)"yyyyMM")));
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(applyDate);
        StringBuilder sb = new StringBuilder(year);
        int quarter = calendar.get(2) / 3 + 1;
        sb.append(quarter);
        dynamicObject.set("quarter", (Object)Integer.valueOf(sb.toString()));
    }

    protected void dataConvertPostProcessor(Row row, DynamicObject dynamicObject) {
        DynamicObjectCollection collection = dynamicObject.getDynamicObjectCollection("reimbursers");
        DynamicObject item = collection.addNew();
        item.set("fbasedataid_id", (Object)ErCommonUtils.getPk(row.get("applier")));
    }

    protected String getThreadPoolName() {
        return "ErExpenseSyncDetailData";
    }

    protected Long getLengthPerQuery() {
        return 1000L;
    }

    protected Long getTask() {
        return 10L;
    }

    protected Long getThreadNum() {
        return 10L;
    }

    protected String getTargetEntity() {
        return "er_expense_detaildata";
    }

    protected QFilter getQfilter() {
        return QFilter.isNotNull((String)"expenseentryentity.id");
    }

    protected abstract void deleteNotExist();

    protected abstract Map<String, String> getFieldMap();

    protected abstract String getBillType();

    protected abstract String getBillName();

    protected abstract String getSql();

    private String getErrorMsg(Throwable ex) {
        if (ex == null) {
            return null;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintWriter pw = new PrintWriter(baos);
        ex.printStackTrace(pw);
        pw.flush();
        String s = baos.toString();
        int i = s.indexOf(":") + 2;
        int j = s.indexOf("\r\n\tat ");
        return i > 0 && j > i ? s.substring(i, j) + "\r\n\r\n" + s : s;
    }
}

