/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.task.report;

import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.RefObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.ext.fi.thread.TaskType;
import kd.bos.ext.fi.thread.ThreadService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.er.business.task.report.AbstrackSyncData;
import kd.fi.er.business.task.report.DailyreimbursebillSyncData;
import kd.fi.er.business.task.report.PublicreimbursebillSyncData;
import kd.fi.er.business.task.report.TripreimbursebillSyncData;
import kd.fi.er.business.utils.ErCommonUtils;

public class SyncReimburseExpense {
    private static Log logger = LogFactory.getLog(SyncReimburseExpense.class);
    public static Map<String, AbstrackSyncData> billSyncDataMap = new ConcurrentHashMap<String, AbstrackSyncData>(4);

    public static void syncUpdated(Date inputBeginDate) {
        SyncReimburseExpense.sync(inputBeginDate);
    }

    public static void syncAll() {
        SyncReimburseExpense.sync(null);
    }

    private static void sync(Date inputBeginDate) {
        for (Map.Entry<String, AbstrackSyncData> entry : billSyncDataMap.entrySet()) {
            try {
                ThreadService.execute(() -> ((AbstrackSyncData)entry.getValue()).sync(inputBeginDate), (TaskType)TaskType.ER_REPORT_QUERY, (RequestContext)RequestContext.get());
            }
            catch (Exception ex1) {
                logger.error((Throwable)ex1);
            }
        }
    }

    public static void syncAfterOperation(String operate, String billType, DynamicObject[] dynamicObjects) {
        if (dynamicObjects == null || dynamicObjects.length == 0) {
            return;
        }
        String accountId = RequestContext.get().getAccountId();
        ThreadService.execute(() -> {
            try {
                AbstrackSyncData syncData = billSyncDataMap.get(accountId);
                if (syncData == null) {
                    syncData = billSyncDataMap.get(billType);
                }
                if (syncData == null) {
                    return;
                }
                List<Long> billIds = Arrays.stream(dynamicObjects).map(e -> ErCommonUtils.getPk(e.getPkValue())).collect(Collectors.toList());
                if ("delete".equals(operate)) {
                    syncData.deleteOldDataByBillIds(billIds);
                } else {
                    QFilter qFilter = new QFilter("id", "in", (Object)billIds.toArray(new Long[0]));
                    syncData.syncData(billType, new QFilter[]{qFilter}, 10000L, null, (RefObject<AtomicInteger>)new RefObject((Object)new AtomicInteger(0)));
                }
            }
            catch (Exception e2) {
                logger.error(e2.getMessage(), (Throwable)e2);
            }
        }, (TaskType)TaskType.ER_REPORT_QUERY, (RequestContext)RequestContext.get());
    }

    public static Integer syncedTasksPercent() {
        int total;
        DynamicObjectCollection collection = QueryServiceHelper.query((String)"er_expensedata_sync_time", (String)"syncing, total", (QFilter[])new QFilter[]{new QFilter("billtype", "in", billSyncDataMap.keySet())});
        if (collection == null || collection.size() == 0) {
            return 0;
        }
        int syncing = collection.stream().mapToInt(e -> e.getInt("syncing")).sum();
        if (syncing == (total = collection.stream().mapToInt(e -> e.getInt("total")).sum())) {
            return 100;
        }
        float f = 1.0f;
        return (int)((float)syncing * f / (float)total * 100.0f);
    }

    public static boolean existSyncTask() {
        QFilter[] qFilters = new QFilter[]{new QFilter("billstatus", "=", (Object)"A")};
        DynamicObjectCollection collection = QueryServiceHelper.query((String)"er_expensedata_sync_time", (String)"id", (QFilter[])qFilters);
        return collection.size() > 0;
    }

    static {
        billSyncDataMap.putIfAbsent("er_dailyreimbursebill", new DailyreimbursebillSyncData());
        billSyncDataMap.putIfAbsent("er_publicreimbursebill", new PublicreimbursebillSyncData());
        billSyncDataMap.putIfAbsent("er_tripreimbursebill", new TripreimbursebillSyncData());
    }
}

