/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.task.report;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.er.business.task.report.AbstrackSyncData;
import kd.fi.er.business.utils.ErCommonUtils;

public class TripreimbursebillSyncData
extends AbstrackSyncData {
    private static final String TRIP_REIMBURSE_SQL = "id as billid, creator, modifier, createtime, modifytime, auditdate,'er_tripreimbursebill' as billtype,billno, company, org, bizdate, applier, billstatus, currency, costdept, costcompany, tripentry.entrycostdept as entrycostdept, tripentry.entrycostcompany as entrycostcompany,tripentry.entryentity.id as id, tripentry.entryentity.travelcostcompany as travelcostcompany, tripentry.entryentity.travelcostdept as travelcostdept, headexpenseitem, headproject, tripentry.entryentity.entrycurrency as oricurrency, tripentry.entryentity.expenseitem as travelitem, tripentry.tripexpenseitem as cardexpenseitem, tripentry.std_project as stdproject, tripentry.entryentity.orientryamount as orientryamount, tripentry.entryentity.entryamount as entryamount, tripentry.entryentity.orientryappamount as orientryappamount, tripentry.entryentity.entryappamount as entryappamount, tripentry.entryentity, tripentry, null as happendate, encashamount, tripentry.entryentity.price as price, tripentry.entryentity.curprice as curprice, tripentry.entryentity.deductibletax as deductibletax, tripentry.entryentity.travelexpenseitem as expenseitem,description";

    @Override
    protected String getBillType() {
        return "er_tripreimbursebill";
    }

    @Override
    protected String getSql() {
        return TRIP_REIMBURSE_SQL;
    }

    @Override
    protected void dataConvertPostProcessor(Row row, DynamicObject dynamicObject) {
        DynamicObjectCollection collection = null;
        if (row.get("tripentry.entryentity") != null) {
            collection = QueryServiceHelper.query((String)(this.getBillType() + ".tripentry.entryentity.trip2travelers"), (String)"pkid,id,fbasedataid", (QFilter[])new QFilter[]{new QFilter("id", "=", row.get("tripentry.entryentity"))});
            if ((collection == null || collection.size() == 0) && row.get("tripentry") != null) {
                collection = QueryServiceHelper.query((String)(this.getBillType() + ".tripentry.travelers"), (String)"id,pkid,fbasedataid", (QFilter[])new QFilter[]{new QFilter("id", "=", row.get("tripentry"))});
            }
            if (collection == null || collection.size() == 0) {
                // empty if block
            }
        }
        if (collection != null) {
            for (DynamicObject d : collection) {
                DynamicObjectCollection dynamicObjects = dynamicObject.getDynamicObjectCollection("reimbursers");
                DynamicObject item = dynamicObjects.addNew();
                item.set("fbasedataid_id", (Object)ErCommonUtils.getPk(d.get("fbasedataid")));
            }
        }
        if (row.get("travelcostcompany") != null && ErCommonUtils.getPk(row.get("travelcostcompany")) != 0L) {
            dynamicObject.set("costcompany", (Object)ErCommonUtils.getPk(row.get("travelcostcompany")));
            dynamicObject.set("costdept", (Object)ErCommonUtils.getPk(row.get("travelcostdept")));
        }
        if (row.get("expenseitem") == null || ErCommonUtils.getPk(row.get("expenseitem")) == 0L) {
            if (row.get("cardexpenseitem") != null) {
                dynamicObject.set("expenseitem", (Object)ErCommonUtils.getPk(row.get("cardexpenseitem")));
            } else {
                dynamicObject.set("expenseitem", (Object)ErCommonUtils.getPk(row.get("headexpenseitem")));
            }
        }
        if (row.get("stdproject") == null || ErCommonUtils.getPk(row.get("stdproject")) == 0L) {
            dynamicObject.set("stdproject", (Object)ErCommonUtils.getPk(row.get("headproject")));
        }
    }

    @Override
    protected QFilter getQfilter() {
        return QFilter.isNotNull((String)"tripentry.entryentity.id");
    }

    @Override
    protected Map<String, String> getFieldMap() {
        HashMap<String, String> map = new HashMap<String, String>(32);
        List<String> list = Arrays.asList("billid", "creator", "modifier", "createtime", "modifytime", "auditdate", "id", "billno", "billstatus", "org", "billtype", "company", "bizdate", "applier", "expenseitem", "travelitem", "stdproject", "orientryamount", "entryamount", "orientryappamount", "entryappamount", "happendate", "oricurrency", "currency", "encashamount", "price", "curprice", "deductibletax", "description");
        for (String s : list) {
            map.put(s, s);
        }
        return map;
    }

    @Override
    protected String getBillName() {
        return ResManager.loadKDString((String)"\u5dee\u65c5\u62a5\u9500\u5355", (String)"TripreimbursebillSyncData_0", (String)"fi-er-business", (Object[])new Object[0]);
    }

    @Override
    protected void deleteNotExist() {
    }
}

