/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.trip.dao;

import java.math.BigDecimal;
import java.util.Date;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.er.business.servicehelper.invoice.Serviceitem;
import kd.fi.er.business.trip.dao.IDataHandleDao;
import kd.fi.er.business.trip.exception.TripException;
import kd.fi.er.business.trip.model.ExistDataModel;
import kd.fi.er.business.trip.model.IDataModel;
import kd.fi.er.business.trip.model.InvoiceExistDataModel;
import kd.fi.er.business.trip.model.InvoiceModel;
import kd.fi.er.business.trip.util.TripFieldSetValueUtil;
import org.apache.commons.lang3.ObjectUtils;

public class InvoiceDao
implements IDataHandleDao {
    private static final Log logger = LogFactory.getLog(InvoiceDao.class);
    private InvoiceExistDataModel existModel;

    @Override
    public void generateData(IDataModel dataModel) throws TripException {
        InvoiceModel invoice = (InvoiceModel)dataModel;
        String custInvSequence = this.existModel.getCustInvSequenceInvoiceidRelMap().get(invoice.getTrdInvoiceId());
        DynamicObject invoiceDyn = this.existModel.getInvoiceMapping().get(custInvSequence);
        if (invoiceDyn != null) {
            invoice.setModifyTime(new Date());
            String invoicestatus = invoiceDyn.getString("invoicestatus");
            TripFieldSetValueUtil.getInstance().HandleAllClassField(invoiceDyn, invoice, invoice.getClass());
            BigDecimal invoicetax = invoiceDyn.getBigDecimal("taxamount");
            String serviceitem = invoiceDyn.getString("serviceitem");
            if (Serviceitem.ITINERARY.getName().equals(serviceitem)) {
                invoicetax = invoiceDyn.getBigDecimal("settleamounttax");
                invoiceDyn.set("invoicetaxrate", (Object)invoiceDyn.getBigDecimal("systemtaxrate"));
                logger.info("\u5546\u65c5\u96c6\u6210,\u53d1\u7968\u63a5\u6536\u4fdd\u5b58,\u53ef\u62b5\u6263\u7a0e\u989d\uff1a" + invoicetax + "\uff0c\u53ef\u62b5\u6263\u53d1\u7968\u53f7\uff1a" + custInvSequence);
            }
            invoiceDyn.set("taxamount", (Object)invoicetax);
            invoiceDyn.set("invoicetax", (Object)invoicetax);
            BigDecimal diffTaxAmount = this.substract(invoicetax, invoiceDyn.getBigDecimal("settleamounttax"));
            invoiceDyn.set("difftaxamount", (Object)diffTaxAmount);
            BigDecimal diffAmount = this.substract(invoiceDyn.getBigDecimal("invoiceamount"), invoiceDyn.getBigDecimal("settleamountwithtax"));
            invoiceDyn.set("diffamountwithtax", (Object)diffAmount);
            DynamicObject invoiceSettleRelDyn = this.existModel.getInvoiceSettleRelMaxMapping().get(custInvSequence);
            if (diffTaxAmount.compareTo(BigDecimal.ZERO) != 0 && diffAmount.compareTo(BigDecimal.ZERO) == 0) {
                invoiceSettleRelDyn.set("totalamount", (Object)invoiceSettleRelDyn.getBigDecimal("totalamount").add(diffAmount));
                invoiceSettleRelDyn.set("taxamount", (Object)invoiceSettleRelDyn.getBigDecimal("taxamount").add(diffTaxAmount));
                String tempDiffKey = invoiceSettleRelDyn.getString("settleformid") + "&" + invoiceSettleRelDyn.getLong("settleid");
                BigDecimal tempDiff = this.existModel.getCheckingBillMapping_().get(tempDiffKey);
                tempDiff = tempDiff == null ? diffTaxAmount : tempDiff.add(diffTaxAmount);
                this.existModel.getCheckingBillMapping_().put(tempDiffKey, tempDiff);
            }
            if (diffAmount.compareTo(BigDecimal.ZERO) == 0) {
                invoiceDyn.set("invoicestatus", (Object)"3");
            } else if (diffAmount.compareTo(BigDecimal.ZERO) != 0) {
                invoiceDyn.set("invoicestatus", (Object)"7");
            }
            if (ObjectUtils.isEmpty((Object)invoiceDyn.getString("invoicecode")) || ObjectUtils.isEmpty((Object)invoiceDyn.getString("invoicenum"))) {
                invoiceDyn.set("invoicestatus", (Object)invoicestatus);
            }
        }
    }

    private BigDecimal substract(BigDecimal taxamount, BigDecimal systaxamount) {
        if (taxamount == null) {
            taxamount = BigDecimal.ZERO;
        }
        if (systaxamount == null) {
            systaxamount = BigDecimal.ZERO;
        }
        return taxamount.subtract(systaxamount);
    }

    @Override
    public void setExistDataModel(ExistDataModel existModel) {
        this.existModel = (InvoiceExistDataModel)existModel;
    }
}

