/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.trip.dao;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.fi.er.business.trip.model.UserModel;
import kd.fi.er.business.trip.util.UserHelper;
import kd.fi.er.business.utils.ErCommonUtils;
import org.apache.commons.lang.StringUtils;

public class UserDao {
    private static final Log logger = LogFactory.getLog(UserDao.class);
    public static final UserDao userDao = new UserDao();

    private UserDao() {
    }

    public static UserDao getInstance() {
        return userDao;
    }

    @Deprecated
    public Set<UserModel> getAllPeople() {
        Calendar cal = Calendar.getInstance();
        cal.set(1900, 0, 1);
        return this.getChargePeople(cal.getTimeInMillis() + "");
    }

    public Set<UserModel> getChargePeople(String timestamp) {
        return this.getChargePeople(1, 1000000, timestamp, new HashMap<String, Object>(1));
    }

    public Set<UserModel> getChargePeople(Integer pageIndex, Integer pageSize, String timestamp, Map<String, Object> map) {
        HashSet<UserModel> userModelSet = new HashSet<UserModel>();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date date = null;
        try {
            date = sdf.parse(timestamp);
        }
        catch (Exception exception) {
            logger.info("\u5546\u65c5\u96c6\u6210\uff0c\u83b7\u53d6\u53d8\u66f4\u4eba\u5458\u6570\u636e, \u65f6\u95f4\u8f6c\u6362\u5f02\u5e38 {}, {}\uff1a", (Object)timestamp, (Object)exception);
            throw new KDBizException(timestamp + exception.getMessage());
        }
        List<Map<String, Object>> userChangeInfos = UserHelper.getUserChangeInfosByTime(pageIndex, pageSize, date, map);
        this.buildUserChange(userModelSet, userChangeInfos);
        return userModelSet;
    }

    public Set<UserModel> getChargePeopleNew(Integer pageIndex, Integer pageSize, String timestamp, Map<String, Object> map) {
        HashSet<UserModel> userModelSet = new HashSet<UserModel>();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date date = null;
        try {
            date = sdf.parse(timestamp);
        }
        catch (Exception exception) {
            logger.info("\u5546\u65c5\u96c6\u6210\uff0c\u83b7\u53d6\u53d8\u66f4\u4eba\u5458\u6570\u636e", (Object)exception);
        }
        List<Map<String, Object>> userChangeInfos = UserHelper.getUserInfosByTimeNew(pageIndex, pageSize, date, map);
        this.buildUserChangeNew(userModelSet, userChangeInfos);
        return userModelSet;
    }

    public Set<UserModel> getChargePeopleTotal(Integer pageIndex, Integer pageSize, Map<String, Object> map) {
        HashSet<UserModel> userModelSet = new HashSet<UserModel>();
        List<Map<String, Object>> userChangeInfos = UserHelper.getAllUserChangeInfos(pageIndex, pageSize, map);
        this.buildUserChange(userModelSet, userChangeInfos);
        return userModelSet;
    }

    private void buildUserChange(Set<UserModel> userModelSet, List<Map<String, Object>> userChangeInfos) {
        HashSet<Long> userIDSet = new HashSet<Long>();
        if (userChangeInfos != null) {
            userIDSet = new HashSet(userChangeInfos.size());
            for (int i = 0; i < userChangeInfos.size(); ++i) {
                Map<String, Object> map = userChangeInfos.get(i);
                userIDSet.add(Long.valueOf(map.get("id").toString()));
            }
        }
        Map<Long, String> paraMap = UserDao.getReimburseLevel(userIDSet);
        Map<Long, String> accountMap = this.getSubAccountName(userIDSet);
        ArrayList maxTimeUserChangeInfos = new ArrayList();
        if (userChangeInfos != null) {
            userChangeInfos.stream().collect(Collectors.groupingBy(v -> v.get("id").toString())).forEach((key, valueList) -> {
                Map map = valueList.stream().filter(v -> v.get("changetime") != null).max(Comparator.comparing(v -> (Date)v.get("changetime"))).orElse(null);
                if (map != null) {
                    maxTimeUserChangeInfos.add(map);
                }
            });
        }
        maxTimeUserChangeInfos.forEach(v -> {
            UserModel user = new UserModel(ErCommonUtils.getPk(v.get("id")));
            user.setEmployeeID(String.valueOf(null == v.get("number") ? "" : v.get("number")));
            user.setSuperiorEID(String.valueOf(null == v.get("supernumber") ? "" : v.get("supernumber")));
            user.setName(String.valueOf(null == v.get("name") ? "" : v.get("name")));
            user.setMobilePhone(String.valueOf(null == v.get("phone") ? "" : v.get("phone")));
            user.setEmail(String.valueOf(null == v.get("email") ? "" : v.get("email")));
            user.setDept1(String.valueOf(null == v.get("dpt") ? "" : v.get("dpt")));
            user.setDeptId(String.valueOf(null == v.get("dptId") ? "" : v.get("dptId")));
            String type = String.valueOf(v.get("type"));
            user.setType(type);
            if ("4".equals(type) || "3".equals(type)) {
                user.setEnableFlag("N");
            } else {
                user.setEnableFlag("Y");
            }
            String reimburseleveName = (String)paraMap.get(Long.valueOf(String.valueOf(v.get("id"))));
            user.setReimburseleveName(reimburseleveName);
            String subaccountName = (String)accountMap.get(Long.valueOf(String.valueOf(v.get("id"))));
            user.setSubaccountName(subaccountName);
            userModelSet.add(user);
        });
    }

    private void buildUserChangeNew(Set<UserModel> userModelSet, List<Map<String, Object>> userChangeInfos) {
        HashSet<Long> userIDSet = new HashSet<Long>();
        if (userChangeInfos != null) {
            userIDSet = new HashSet(userChangeInfos.size());
            for (int i = 0; i < userChangeInfos.size(); ++i) {
                Map<String, Object> map = userChangeInfos.get(i);
                userIDSet.add(Long.valueOf(map.get("id").toString()));
            }
        }
        Map<Long, String> paraMap = UserDao.getReimburseLevel(userIDSet);
        Map<Long, String> accountMap = this.getSubAccountName(userIDSet);
        logger.info("\u5546\u65c5\u96c6\u6210,\u83b7\u53d6\u4eba\u5458\u5dee\u91cf\u8868\u6570\u636e: {}", (Object)(null == userChangeInfos ? 0 : userChangeInfos.size()));
        ArrayList maxTimeUserChangeInfos = new ArrayList();
        if (userChangeInfos != null) {
            userChangeInfos.stream().collect(Collectors.groupingBy(v -> v.get("id").toString())).forEach((key, valueList) -> {
                Map map = valueList.stream().filter(v -> v.get("modifytime") != null).max(Comparator.comparing(v -> (Date)v.get("modifytime"))).orElse(null);
                if (map != null) {
                    maxTimeUserChangeInfos.add(map);
                }
            });
        }
        maxTimeUserChangeInfos.forEach(v -> {
            UserModel user = new UserModel(ErCommonUtils.getPk(v.get("id")));
            user.setEmployeeID(String.valueOf(v.get("number")));
            user.setName(String.valueOf(v.get("name")));
            user.setMobilePhone(String.valueOf(v.get("phone")));
            user.setEmail(String.valueOf(v.get("email")));
            user.setDept1(String.valueOf(null == v.get("dptName") ? "" : v.get("dptName")));
            user.setDeptId(String.valueOf(null == v.get("dptId") ? "" : v.get("dptId")));
            user.setSuperiorEID(String.valueOf(null == v.get("supernumber") ? "" : v.get("supernumber")));
            user.setEnableFlag("Y");
            if (null != v.get("enable") && "0".equals(v.get("enable").toString()) || null != v.get("isforbidden") && "true".equals(v.get("isforbidden").toString())) {
                logger.info("\u5546\u65c5\u96c6\u6210\uff0c\u4eba\u5458\u7981\u7528\uff1a{}:{},{}", new Object[]{v.get("number"), v.get("enable"), v.get("isforbidden")});
                user.setEnableFlag("N");
            }
            String reimburseleveName = (String)paraMap.get(Long.valueOf(String.valueOf(v.get("id"))));
            user.setReimburseleveName(reimburseleveName);
            String subaccountName = (String)accountMap.get(Long.valueOf(String.valueOf(v.get("id"))));
            user.setSubaccountName(subaccountName);
            userModelSet.add(user);
        });
    }

    public Set<UserModel> getPeopleInfoByID(List<Long> userID) {
        HashSet<UserModel> userModelSet = new HashSet<UserModel>();
        HashSet<Long> userIDSet = new HashSet<Long>();
        List userInfos = UserServiceHelper.getUserInfoByID(userID);
        if (userInfos != null) {
            userIDSet = new HashSet(userInfos.size());
            for (int i = 0; i < userInfos.size(); ++i) {
                Map map = (Map)userInfos.get(i);
                userIDSet.add(Long.valueOf((String)map.get("id")));
            }
            Map<Long, String> paraMap = UserDao.getReimburseLevel(userIDSet);
            Map<Long, String> accountMap = this.getSubAccountName(userIDSet);
            userInfos.forEach(v -> {
                UserModel user = new UserModel(null);
                user.setEmployeeID(String.valueOf(v.get("number")));
                user.setName(String.valueOf(v.get("name")));
                user.setMobilePhone(String.valueOf(v.get("phone")));
                user.setEmail(String.valueOf(v.get("email")));
                String type = String.valueOf(v.get("type"));
                if ("3".equals(type)) {
                    user.setEnableFlag("N");
                } else {
                    user.setEnableFlag("Y");
                }
                String reimburseleveName = (String)paraMap.get(Long.valueOf(String.valueOf(v.get("id"))));
                user.setReimburseleveName(reimburseleveName);
                String subaccountName = (String)accountMap.get(Long.valueOf(String.valueOf(v.get("id"))));
                user.setSubaccountName(subaccountName);
                userModelSet.add(user);
            });
        }
        return userModelSet;
    }

    private Map<Long, String> getSubAccountName(Set<Long> userIDSet) {
        HashMap<Long, String> paraMap = new HashMap<Long, String>();
        QFilter filter = null;
        if (userIDSet != null && userIDSet.size() > 0) {
            filter = new QFilter("id", "in", userIDSet);
        }
        QFilter[] qFilters = new QFilter[]{filter};
        for (DynamicObject object : BusinessDataServiceHelper.load((String)"er_corpusersubaccount", (String)"id, subaccountname", (QFilter[])qFilters)) {
            Long userId = (Long)object.get("id");
            String subaccountname = object.getString("subaccountname");
            if (!StringUtils.isNotEmpty((String)subaccountname)) continue;
            paraMap.put(userId, subaccountname);
        }
        return paraMap;
    }

    private static Long getPk(Object entity) {
        if (entity instanceof DynamicObject) {
            return (Long)((DynamicObject)entity).getPkValue();
        }
        if (entity instanceof Long) {
            return (Long)entity;
        }
        return entity instanceof Integer ? Long.valueOf(entity.toString()) : null;
    }

    public static Map<Long, String> getReimburseLevel(Set<Long> userIDSet) {
        HashMap<Long, String> paraMap = new HashMap<Long, String>();
        for (Long user : userIDSet) {
            Long deptId;
            Map companyByOrg;
            Long companyId;
            Map<String, Object> userMap = UserDao.getUserMap(user);
            DynamicObject dept = (DynamicObject)userMap.get("org");
            if (dept == null || (companyId = (Long)(companyByOrg = OrgUnitServiceHelper.getCompanyfromOrg((Long)(deptId = (Long)dept.getPkValue()))).get("id")) == null) continue;
            QFilter filter = new QFilter("user", "=", (Object)user);
            filter.and(new QFilter("company", "=", (Object)companyId));
            DynamicObject relOb = BusinessDataServiceHelper.loadSingle((String)"er_reimbursesetting_rel", (String)"reimburselevel", (QFilter[])new QFilter[]{filter});
            if (relOb == null) continue;
            paraMap.put(user, relOb.getString("reimburselevel.name"));
        }
        return paraMap;
    }

    public static Map<Long, String> getReimburseLevelNew(List<Map<String, Object>> userChangeInfos) {
        HashMap<Long, String> paraMap = new HashMap<Long, String>();
        HashSet<Long> ids = new HashSet<Long>(userChangeInfos.size());
        for (Map<String, Object> userChangeDO : userChangeInfos) {
            Long id = Long.parseLong(userChangeDO.get("id").toString());
            ids.add(id);
        }
        QFilter filter = new QFilter("user", "in", ids);
        Map relObs = BusinessDataServiceHelper.loadFromCache((String)"er_reimbursesetting_rel", (String)"id,user,reimburselevel,company", (QFilter[])new QFilter[]{filter});
        if (null == relObs || relObs.size() == 0) {
            return paraMap;
        }
        for (Map<String, Object> userChangeDO : userChangeInfos) {
            Long companyId = Long.parseLong(userChangeDO.getOrDefault("companyId", "-1").toString());
            Long id = Long.parseLong(userChangeDO.getOrDefault("id", "0").toString());
            for (DynamicObject relOb : relObs.values()) {
                if (!id.equals(relOb.getDynamicObject("user").getLong("id")) || !companyId.equals(relOb.getDynamicObject("company").getLong("id"))) continue;
                paraMap.put(id, relOb.getString("reimburselevel.name"));
            }
        }
        return paraMap;
    }

    public static Map<Long, String> getReimburseLevelNumberNew(List<Map<String, Object>> userChangeInfos) {
        HashMap<Long, String> paraMap = new HashMap<Long, String>();
        HashSet<Long> ids = new HashSet<Long>(userChangeInfos.size());
        HashSet<Long> companyIds = new HashSet<Long>(userChangeInfos.size());
        for (Map<String, Object> userChangeDO : userChangeInfos) {
            Long id = Long.parseLong(userChangeDO.get("id").toString());
            ids.add(id);
            if (null == userChangeDO.get("companyId")) continue;
            companyIds.add(Long.parseLong(userChangeDO.get("companyId").toString()));
        }
        QFilter Afilter = new QFilter("user", "in", ids);
        QFilter Bfilter = new QFilter("company", "in", companyIds);
        Map reimbursesettingObs = BusinessDataServiceHelper.loadFromCache((String)"er_reimbursesetting_rel", (String)"id,user,company,reimburselevel", (QFilter[])new QFilter[]{Afilter, Bfilter});
        if (null == reimbursesettingObs || reimbursesettingObs.size() == 0) {
            return paraMap;
        }
        for (Map<String, Object> userChangeDO : userChangeInfos) {
            Long id = Long.parseLong(userChangeDO.getOrDefault("id", "0").toString());
            Long companyId = Long.parseLong(userChangeDO.getOrDefault("companyId", "-1").toString());
            for (DynamicObject relOb : reimbursesettingObs.values()) {
                if (!id.equals(relOb.getLong("user.id")) || !companyId.equals(relOb.getLong("company.id")) || null == relOb.get("reimburselevel.number")) continue;
                paraMap.put(id, relOb.getString("reimburselevel.number"));
            }
        }
        return paraMap;
    }

    private static Map<String, Object> getUserMap(Long userId) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        DynamicObject user = UserDao.getUser(userId);
        if (user != null) {
            resultMap.put("tel", user.get("phone"));
            resultMap.put("name", user.get("name"));
            resultMap.put("number", user.get("number"));
            DynamicObjectCollection userEntrys = user.getDynamicObjectCollection("entryentity");
            for (DynamicObject userEntry : userEntrys) {
                boolean isPartjob = userEntry.getBoolean("ispartjob");
                resultMap.put("applierpositionstr", userEntry.getString("position"));
                DynamicObject dept = userEntry.getDynamicObject("dpt");
                resultMap.put("org", dept);
                if (isPartjob) continue;
                break;
            }
        }
        return resultMap;
    }

    private static DynamicObject getUser(Long userId) {
        QFilter qFilter = new QFilter("id", "=", (Object)userId);
        QFilter[] qFilters = new QFilter[]{qFilter};
        String selectFields = "id,name,email,number,phone,entryentity.id,entryentity.position,entryentity.dpt,entryentity.ispartjob";
        return BusinessDataServiceHelper.loadSingleFromCache((String)"bos_user", (String)selectFields, (QFilter[])qFilters);
    }

    protected Date getChangeTime(String timestamp) {
        Date changetime = null;
        try {
            if (timestamp.length() == 10) {
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                changetime = sdf.parse(timestamp);
            } else if (timestamp.length() == 19) {
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                changetime = sdf.parse(timestamp);
            } else {
                changetime = new Date();
            }
        }
        catch (ParseException var21) {
            logger.info("\u65e5\u671f\u65f6\u95f4\u5b57\u7b26\u4e32" + timestamp + "\u89e3\u91ca\u5f02\u5e38 " + changetime);
        }
        return changetime;
    }
}

