/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.trip.dao;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.fi.er.business.trip.dao.AbstractCheckingDetailDao;
import kd.fi.er.business.trip.model.AbstractCheckingBillDetailModel;
import kd.fi.er.business.trip.model.AbstractOrderModel;
import kd.fi.er.business.trip.model.VehicleCheckingBillDetailModel;
import kd.fi.er.business.trip.util.TripCommonUtil;
import kd.fi.er.common.CarTypeEnum;
import org.apache.commons.lang.StringUtils;

public class VehicleCheckingDetailDao
extends AbstractCheckingDetailDao {
    private static final Log logger = LogFactory.getLog(VehicleCheckingDetailDao.class);

    @Override
    protected void calcCheckingTaxAndRate(DynamicObject checkingDynamic, AbstractCheckingBillDetailModel checkingBillModel, List<Map<String, String>> invoiceSetByOperation) {
    }

    @Override
    protected void handleIndividrualData(AbstractCheckingBillDetailModel checkingModel, DynamicObject checkingDynamic) {
        DynamicObject passegerUser;
        checkingDynamic.set("ordersort", (Object)AbstractOrderModel.OrderSort.A.getKey());
        VehicleCheckingBillDetailModel model = (VehicleCheckingBillDetailModel)checkingModel;
        DynamicObject sourceUser = this.existData.getUserMapping().get(model.getSourceBookedId());
        if (sourceUser != null) {
            checkingDynamic.set("sourcebookedid", sourceUser.getPkValue());
        }
        if ((passegerUser = this.existData.getTravelerMapping().get(model.getPasseger())) == null) {
            passegerUser = this.existData.getUserMapping().get(model.getPasseger());
        }
        if (passegerUser != null) {
            checkingDynamic.set("passeger", passegerUser.getPkValue());
            this.handleAccountOrg(passegerUser, checkingDynamic);
        } else {
            checkingDynamic.set("passeger", (Object)0L);
        }
        String oaBillNum = checkingModel.getOaBillNum();
        checkingDynamic.set("vehicletype", (Object)CarTypeEnum.OVERTIME.getCode());
        if (!StringUtils.isBlank((String)oaBillNum)) {
            DynamicObject dailyApplyBill = this.existData.getDailyApplybillMapping().get(oaBillNum);
            DynamicObject dynamicObject2 = this.existData.getReqbillMapping().get(oaBillNum);
            DynamicObject dailyvehiclebill = this.existData.getDailyVehicleBillMapping().get(oaBillNum);
            if (dynamicObject2 != null) {
                checkingDynamic.set("vehicletype", (Object)CarTypeEnum.TRAVEL.getCode());
                checkingDynamic.set("oabillformid", (Object)"er_tripreqbill");
                return;
            }
            if (dailyvehiclebill != null) {
                checkingDynamic.set("vehicletype", (Object)dailyvehiclebill.getString("vehicletype"));
                checkingDynamic.set("oabillformid", (Object)"er_dailyvehiclebill");
            }
            if (dailyApplyBill != null) {
                String vehicletype = TripCommonUtil.getReimburseType(dailyApplyBill.getString("reimbursetype"));
                checkingDynamic.set("vehicletype", (Object)vehicletype);
                checkingDynamic.set("oabillformid", (Object)"er_dailyapplybill");
            }
        } else {
            String server = checkingModel.getServer();
            QFilter qA = new QFilter("enable", "=", (Object)"1");
            DynamicObjectCollection dynamices = QueryServiceHelper.query((String)"er_trip_vehicle_setting", (String)"number,name,vehicletype", (QFilter[])new QFilter[]{qA});
            switch (server) {
                case "CHAILVYIHAO": {
                    String travelWays = model.getTravelWays();
                    List data = dynamices.stream().filter(dynamicObject -> dynamicObject.get("name").equals(travelWays)).collect(Collectors.toList());
                    if (CollectionUtils.isNotEmpty(data)) {
                        checkingDynamic.set("vehicletype", ((DynamicObject)data.get(0)).get("vehicletype"));
                        break;
                    }
                    checkingDynamic.set("vehicletype", (Object)CarTypeEnum.OVERTIME.getCode());
                    break;
                }
                case "XIECHENG": 
                case "DIDI": {
                    checkingDynamic.set("vehicletype", (Object)CarTypeEnum.OVERTIME.getCode());
                    break;
                }
            }
        }
    }
}

