/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.trip.dao;

import com.alibaba.druid.support.logging.Log;
import com.alibaba.druid.support.logging.LogFactory;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.fi.er.business.trip.dao.AbstractOrderDao;
import kd.fi.er.business.trip.model.AbstractOrderModel;
import kd.fi.er.business.trip.model.VehicleOrderModel;
import kd.fi.er.business.trip.util.TripCommonUtil;
import kd.fi.er.common.CarTypeEnum;
import org.apache.commons.lang.StringUtils;

public class VehicleOrderDao
extends AbstractOrderDao {
    private static final Log logger = LogFactory.getLog(VehicleOrderDao.class);

    @Override
    protected void handleIndividrualData(AbstractOrderModel orderModel, DynamicObject orderDynamic) {
        VehicleOrderModel.PaymentStatus paymentStatus;
        DynamicObject passegerUser;
        VehicleOrderModel vehicleOrderModel = (VehicleOrderModel)orderModel;
        DynamicObject sourceUser = this.existData.getUserMapping().get(vehicleOrderModel.getSourceBookedId());
        if (sourceUser != null) {
            orderDynamic.set("sourcebookedid", sourceUser.getPkValue());
        }
        if ((passegerUser = this.existData.getTravelerMapping().get(vehicleOrderModel.getPasseger())) == null) {
            passegerUser = this.existData.getUserMapping().get(vehicleOrderModel.getPasseger());
        }
        if (passegerUser != null) {
            orderDynamic.set("passeger", passegerUser.getPkValue());
            orderDynamic.set("passegerdept", (Object)this.getDept((Long)passegerUser.getPkValue()));
            this.handleAccountOrg(passegerUser, orderDynamic);
        }
        if (vehicleOrderModel.getExistOrder().booleanValue()) {
            if (!vehicleOrderModel.getChecking().booleanValue()) {
                orderDynamic.set("orderstatus", (Object)vehicleOrderModel.getOrderStatus().getKey());
            }
        } else {
            orderDynamic.set("orderstatus", (Object)vehicleOrderModel.getOrderStatus().getKey());
        }
        if ((paymentStatus = vehicleOrderModel.getPaymentStatus()) != null) {
            orderDynamic.set("paymentstatus", (Object)vehicleOrderModel.getPaymentStatus().getKey());
        }
        orderDynamic.set("vehicleid", (Object)vehicleOrderModel.getVehicleType().getKey());
        orderDynamic.set("ordersort", (Object)vehicleOrderModel.getOrderSort().getKey());
        String oaBillNum = vehicleOrderModel.getOaBillNum();
        orderDynamic.set("vehicletype", (Object)CarTypeEnum.OVERTIME.getCode());
        if (!StringUtils.isBlank((String)oaBillNum)) {
            DynamicObject dynamicObject2 = this.existData.getReqbillMapping().get(oaBillNum);
            DynamicObject dailyvehiclebill = this.existData.getDailyVehicleBillMapping().get(oaBillNum);
            DynamicObject dailyApplyBill = this.existData.getDailyApplybillMapping().get(oaBillNum);
            if (dynamicObject2 != null) {
                orderDynamic.set("oabillformid", (Object)"er_tripreqbill");
                orderDynamic.set("vehicletype", (Object)CarTypeEnum.TRAVEL.getCode());
            }
            if (dailyvehiclebill != null) {
                orderDynamic.set("oabillformid", (Object)"er_dailyvehiclebill");
                orderDynamic.set("vehicletype", (Object)dailyvehiclebill.getString("vehicletype"));
            }
            if (dailyApplyBill != null) {
                String vehicletype = TripCommonUtil.getReimburseType(dailyApplyBill.getString("reimbursetype"));
                orderDynamic.set("vehicletype", (Object)vehicletype);
                orderDynamic.set("oabillformid", (Object)"er_dailyapplybill");
            }
        } else {
            String server;
            QFilter qA = new QFilter("enable", "=", (Object)"1");
            DynamicObjectCollection dynamices = QueryServiceHelper.query((String)"er_trip_vehicle_setting", (String)"number,name,vehicletype", (QFilter[])new QFilter[]{qA});
            switch (server = orderModel.getServer()) {
                case "CHAILVYIHAO": {
                    String travelWays = vehicleOrderModel.getCarControlType();
                    List data = dynamices.stream().filter(dynamicObject -> dynamicObject.get("name").equals(travelWays)).collect(Collectors.toList());
                    if (CollectionUtils.isNotEmpty(data)) {
                        orderDynamic.set("vehicletype", ((DynamicObject)data.get(0)).get("vehicletype"));
                        break;
                    }
                    orderDynamic.set("vehicletype", (Object)CarTypeEnum.OVERTIME.getCode());
                    break;
                }
                case "XIECHENG": 
                case "DIDI": {
                    orderDynamic.set("vehicletype", (Object)CarTypeEnum.OVERTIME.getCode());
                    break;
                }
            }
        }
    }
}

