/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.trip.iscadmin;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.dc.api.model.Account;
import kd.bos.dc.api.model.DBInstance;
import kd.bos.dc.utils.AccountUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.container.Container;
import kd.bos.form.container.Tab;
import kd.bos.form.container.TabPage;
import kd.bos.form.control.CodeEdit;
import kd.bos.form.control.Control;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.SessionManager;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.util.ConfigurationUtil;
import kd.bos.util.HttpClientUtils;
import kd.bos.util.JSONUtils;
import kd.fi.er.business.servicehelper.CommonServiceHelper;
import org.apache.commons.lang3.StringUtils;

public class TripOtherFormPlugin
extends AbstractFormPlugin {
    private static final Log logger = LogFactory.getLog(TripOtherFormPlugin.class);
    private StringBuilder informationBuilder = new StringBuilder();

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btn_execute", "btn_querytable", "btn_querylk"});
    }

    public void initialize() {
        if (this.getView().getParentView() == null) {
            this.getView().showErrorNotification("param is error!");
            this.getView().close();
            return;
        }
        String entityId = this.getView().getParentView().getEntityId();
        String pw = CommonServiceHelper.getMD5(entityId);
        if (!"4589cfa9dabc5a646dc1e14bb20c9eab".equals(pw)) {
            this.getView().showErrorNotification("param is error!");
            this.getView().close();
            return;
        }
        if (StringUtils.isBlank((CharSequence)this.getPageCache().get("isFirst"))) {
            this.getPageCache().put("isFirst", "true");
            this.getView().showMessage(ResManager.loadKDString((String)"\u5bf9\u63a5\u6570\u636e\u5e93\u670d\u52a1\uff0c\u5f53\u524d\u7528\u6237\u6bcf\u6b21\u64cd\u4f5c\u90fd\u4f1a\u8fdb\u884c\u65e5\u5fd7\u8bb0\u5f55\uff0c\u8bf7\u8c28\u614e\u64cd\u4f5c\u3002", (String)"TripOtherFormPlugin_0", (String)"fi-er-business", (Object[])new Object[0]));
        }
    }

    private JSONArray getDbInstanceList() {
        HashMap<String, String> header = new HashMap<String, String>(1);
        header.put("Content-type", "application/json;charset=UTF-8");
        HashMap<String, String> params = new HashMap<String, String>(1);
        params.put("dataCenterId", RequestContext.get().getAccountId());
        String host = ConfigurationUtil.getString((String)"mc.server.url");
        JSONArray data = new JSONArray();
        if (StringUtils.isNotBlank((CharSequence)host)) {
            try {
                JSONObject resp;
                String param = JSONUtils.toString(params);
                String sHttpResponse = HttpClientUtils.postjson((String)(host + "/kapi/app/mc/GetDbInstanceListService"), header, (String)param);
                if (StringUtils.isNotBlank((CharSequence)sHttpResponse) && (resp = JSONObject.parseObject((String)sHttpResponse)).getInteger("errorcode") == 100) {
                    data = resp.getJSONArray("data");
                }
            }
            catch (IOException var7) {
                var7.printStackTrace();
            }
        }
        return data;
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        ComboEdit dbCombo = (ComboEdit)this.getView().getControl("dbroute");
        ArrayList<ComboItem> dbInstenceItem = new ArrayList<ComboItem>(10);
        JSONArray dbInstanceList = this.getDbInstanceList();
        String defDBValue = "fi";
        if (!dbInstanceList.isEmpty()) {
            for (Object instance : dbInstanceList) {
                JSONObject image = (JSONObject)instance;
                String backimage = image.getString("number");
                String bizAppNum = image.getString("name");
                ComboItem item = new ComboItem(new LocaleString(bizAppNum), backimage);
                dbInstenceItem.add(item);
            }
            dbCombo.setComboItems(dbInstenceItem);
            this.getModel().setValue("dbroute", (Object)defDBValue);
        }
    }

    public void click(EventObject evt) {
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if ("btn_querylk".equals(key)) {
            this.showDbInfo();
        }
        if ("btn_querytable".equals(key)) {
            this.showBillTables();
        }
        if ("btn_execute".equals(key)) {
            this.execute();
        }
    }

    private void showDbInfo() {
        IDataModel model = this.getModel();
        String dbRouteText = (String)model.getValue("dbroute");
        DBRoute route = DBRoute.basedata;
        if (StringUtils.isNotBlank((CharSequence)dbRouteText)) {
            route = DBRoute.of((String)dbRouteText);
        }
        RequestContext requestContext = RequestContext.get();
        String accountId = requestContext.getAccountId();
        String tenantId = requestContext.getTenantId();
        Account correctAccount = AccountUtils.getCorrectAccount((String)accountId, (String)tenantId);
        DBInstance dbInstance = correctAccount.getDBInstanceByRouteKey(route.getRouteKey());
        String routeKey = "routeKey>>>>>>>" + dbInstance.getRouteKey() + "\r\n";
        String serviceName = "serviceName >>>>" + dbInstance.getDBInsatnce() + "\r\n";
        String ip = "ip >>>>>>>>>>>" + dbInstance.getDbip() + "\r\n";
        String port = "port>>>>>>>>>>" + dbInstance.getDbport() + "\r\n";
        String user = "user>>>>>>>>>>" + dbInstance.getDbuser() + "\r\n";
        String pw = "pw >>>>>>>>>>>" + dbInstance.getDbpassword() + "\r\n";
        String msg = routeKey + serviceName + ip + port + user + pw;
        this.getModel().setValue("msg", (Object)(msg + "\r\n"));
    }

    private void showBillTables() {
        DynamicObject billType = (DynamicObject)this.getModel().getValue("billtype");
        if (billType == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5355\u636e\u7c7b\u578b\u3002", (String)"TripOtherFormPlugin_1", (String)"fi-er-business", (Object[])new Object[0]));
            return;
        }
        String entityNumber = billType.getString("number");
        MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)entityNumber);
        StringBuilder sb = new StringBuilder();
        dataEntityType.getAllEntities().forEach((number, entity) -> {
            String entryName = entity.getDisplayName().getLocaleValue();
            String tableName = entity.getAlias();
            sb.append(entryName).append(" - ").append(tableName).append("\r\n");
        });
        this.getModel().setValue("msg", (Object)(sb.toString() + "\r\n"));
    }

    private void execute() {
        CodeEdit sqlEditor;
        String sqlText;
        this.resetExcute();
        IDataModel model = this.getModel();
        String app = (String)model.getValue("dbroute");
        DBRoute rout = DBRoute.basedata;
        if (StringUtils.isNotBlank((CharSequence)app)) {
            rout = DBRoute.of((String)app);
        }
        if (StringUtils.isBlank((CharSequence)(sqlText = (sqlEditor = (CodeEdit)this.getControl("sqlarea")).getText()))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"sql\u4e3a\u7a7a\u3002", (String)"TripOtherFormPlugin_2", (String)"fi-er-business", (Object[])new Object[0]));
            return;
        }
        this.resetResultArea();
        boolean isPwdFalse = this.verifyPwd(app);
        String[] ts = sqlText.split(";");
        for (int i = 0; i < ts.length; ++i) {
            String t = ts[i].trim();
            if (StringUtils.isBlank((CharSequence)t) || t.trim().startsWith("--") || t.trim().startsWith("//")) continue;
            String lt = t.trim();
            String llt = lt.toLowerCase(Locale.ENGLISH);
            if (llt.startsWith("select ")) {
                this.executeQuery(i, rout, lt);
                continue;
            }
            if (llt.startsWith("insert ") || llt.startsWith("delete ") || llt.startsWith("update ") || llt.startsWith("alter ")) {
                if (isPwdFalse) {
                    this.informationBuilder.append(String.format(ResManager.loadKDString((String)"\u6267\u884c\u975e\u67e5\u8be2sql\u5bc6\u7801\u4e3a\u7a7a\u6216\u4e0d\u6b63\u786e:%1$s%2$s", (String)"TripOtherFormPlugin_3", (String)"fi-er-business", (Object[])new Object[0]), lt, "\u3002")).append("\r\n").append("\n");
                    this.showMsg(i, String.format(ResManager.loadKDString((String)"\u6267\u884c\u975e\u67e5\u8be2sql\u5bc6\u7801\u4e3a\u7a7a\u6216\u4e0d\u6b63\u786e:%1$s%2$s", (String)"TripOtherFormPlugin_3", (String)"fi-er-business", (Object[])new Object[0]), lt, "\u3002"));
                    continue;
                }
                if ((llt.startsWith("delete ") || llt.startsWith("update ")) && !llt.contains(" where ")) {
                    this.informationBuilder.append(String.format(ResManager.loadKDString((String)"\u5fc5\u987b\u5305\u542bwhere:%1$s%2$s", (String)"TripOtherFormPlugin_4", (String)"fi-er-business", (Object[])new Object[0]), lt, "\u3002")).append("\r\n").append("\n");
                    this.showMsg(i, String.format(ResManager.loadKDString((String)"\u5fc5\u987b\u5305\u542bwhere:%1$s%2$s", (String)"TripOtherFormPlugin_4", (String)"fi-er-business", (Object[])new Object[0]), lt, "\u3002"));
                    continue;
                }
                String pwd = CommonServiceHelper.getMD5(String.valueOf(this.getModel().getValue("pwd")));
                this.execute(i, rout, lt);
                continue;
            }
            this.informationBuilder.append(String.format(ResManager.loadKDString((String)"\u4e0d\u80fd\u8bc6\u522b:%1$s%2$s", (String)"TripOtherFormPlugin_5", (String)"fi-er-business", (Object[])new Object[0]), lt, "\u3002")).append("\r\n").append("\n");
            this.showMsg(i, String.format(ResManager.loadKDString((String)"\u4e0d\u80fd\u8bc6\u522b:%1$s%2$s", (String)"TripOtherFormPlugin_5", (String)"fi-er-business", (Object[])new Object[0]), lt, "\u3002"));
        }
        this.getModel().setValue("infomationtextarea", (Object)this.informationBuilder.toString());
        Tab tab = (Tab)this.getView().getControl("resulttab");
        tab.activeTab(this.getPageCache().get("showPageId"));
    }

    private boolean verifyPwd(String app) {
        String p = String.valueOf(this.getModel().getValue("pwd"));
        if (StringUtils.isBlank((CharSequence)p)) {
            return true;
        }
        String s = "28a32947cbd1a354db34252c227feeb3,fa0322d26563c1d5d3f054e78aa8e14b";
        String envP = CommonServiceHelper.getMD5(p);
        return !s.contains(envP);
    }

    private void execute(int index, DBRoute rout, String txt) {
        try {
            DB.execute((DBRoute)rout, (String)txt);
            this.informationBuilder.append(String.format(ResManager.loadKDString((String)"\u6267\u884c\u6210\u529f:%1$s%2$s", (String)"TripOtherFormPlugin_6", (String)"fi-er-business", (Object[])new Object[0]), txt, "\u3002")).append("\r\n").append("\n");
            this.showMsg(index, String.format(ResManager.loadKDString((String)"\u6267\u884c\u6210\u529f:%1$s%2$s", (String)"TripOtherFormPlugin_6", (String)"fi-er-business", (Object[])new Object[0]), txt, "\u3002"));
        }
        catch (Exception e) {
            this.informationBuilder.append(ResManager.loadKDString((String)"\u6267\u884c\u5931\u8d25: ", (String)"TripOtherFormPlugin_7", (String)"fi-er-business", (Object[])new Object[0])).append(txt).append("\u3002").append("\r\n").append("\n");
            this.showError(index, e);
        }
    }

    private void resetExcute() {
        this.informationBuilder = new StringBuilder();
        List<String> pageIds = this.getAllCachedPageIds();
        if (!pageIds.isEmpty()) {
            for (String pageId : pageIds) {
                IFormView formView = SessionManager.getCurrent().getView(pageId);
                if (formView == null) continue;
                boolean i = false;
                formView.close();
                HashMap<String, String> arg = new HashMap<String, String>();
                arg.put("pageId", pageId);
                ((IClientViewProxy)this.getView().getService(IClientViewProxy.class)).addAction("closeWindow", arg);
            }
        }
        this.resetCachedPageIDs();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeQuery(int index, DBRoute dbRoute, String sql) {
        try {
            this.checkSqlValidity(dbRoute, sql);
            this.createNewResultPage(index, dbRoute, sql);
        }
        catch (Exception var8) {
            this.showError(index, var8);
        }
        finally {
            this.informationBuilder.append('\n');
        }
    }

    private void resetResultArea() {
        this.resetAllTabs();
    }

    private DBInstance getDbInstance(DBRoute route) {
        RequestContext requestContext = RequestContext.get();
        String accountId = requestContext.getAccountId();
        String tenantId = requestContext.getTenantId();
        Account correctAccount = AccountUtils.getCorrectAccount((String)accountId, (String)tenantId);
        return correctAccount.getDBInstanceByRouteKey(route.getRouteKey());
    }

    private void checkSqlValidity(DBRoute dbRoute, String sql) {
        DBInstance dbInstance = this.getDbInstance(dbRoute);
        this.informationBuilder.append(sql).append("\n");
        if (sql.indexOf("*") > -1) {
            sql = "/*dialect*/" + sql;
        }
        long startTimes = System.currentTimeMillis();
        boolean flag = false;
        try {
            flag = true;
            DB.query((DBRoute)dbRoute, (String)sql, rs -> rs.next());
            this.informationBuilder.append(ResManager.loadKDString((String)"\u6267\u884c\u6210\u529f.", (String)"TripOtherFormPlugin_8", (String)"fi-er-business", (Object[])new Object[0])).append("\n");
            flag = false;
        }
        catch (Exception e) {
            this.informationBuilder.append(ResManager.loadKDString((String)"\u6267\u884c\u5931\u8d25.", (String)"TripOtherFormPlugin_9", (String)"fi-er-business", (Object[])new Object[0])).append("\n");
            throw new KDBizException(this.filterSensitiveInfo(e, dbInstance));
        }
        finally {
            if (flag) {
                double result = (double)(System.currentTimeMillis() - startTimes) / 1000.0;
                this.informationBuilder.append(result).append("s").append("\n");
            }
        }
        double result = (double)(System.currentTimeMillis() - startTimes) / 1000.0;
        this.informationBuilder.append(result).append("s").append("\n");
    }

    private String filterSensitiveInfo(Exception e, DBInstance dbInstance) {
        String instance;
        Pattern compile;
        Matcher matcher;
        String message = e.getMessage();
        String user = dbInstance.getDbuser();
        Pattern dbCompile = Pattern.compile(String.format("\\[.*%s@(\\d{1,3}\\.){3}\\d{1,3}.*\\]", user));
        Matcher dbMatcher = dbCompile.matcher(message);
        if (dbMatcher.find()) {
            message = StringUtils.replace((String)message, (String)dbMatcher.group(), (String)"");
        }
        if ((matcher = (compile = Pattern.compile(String.format("'%s'@'(\\d{1,3}\\.){3}\\d{1,3}'", user))).matcher(message)).find()) {
            message = StringUtils.replace((String)message, (String)matcher.group(), (String)"");
        }
        if (message.contains(instance = dbInstance.getDBInsatnce())) {
            message = StringUtils.replace((String)message, (String)(instance + "."), (String)"");
        }
        return String.format(ResManager.loadKDString((String)"\u6267\u884c\u67e5\u8be2\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\u4e3a: %1$s", (String)"TripOtherFormPlugin_14", (String)"fi-er-business", (Object[])new Object[0]), message);
    }

    private void createNewResultPage(int index, DBRoute dbRoute, String sql) {
        FormShowParameter lsp = new FormShowParameter();
        lsp.setFormId("bd_ksql_result_grid");
        HashMap<String, Object> params = new HashMap<String, Object>(4);
        params.put("index", ++index);
        params.put("dbRoute", dbRoute.getRouteKey());
        params.put("sql", sql);
        lsp.setCustomParams(params);
        lsp.getOpenStyle().setTargetKey("resulttab");
        lsp.getOpenStyle().setShowType(ShowType.NewTabPage);
        String tip = ResManager.loadKDString((String)"\u67e5\u8be2\u7ed3\u679c(%1$s)", (String)"TripOtherFormPlugin_15", (String)"fi-er-business", (Object[])new Object[0]);
        lsp.setCaption(String.format(tip, index));
        lsp.setParentFormId(this.getView().getFormShowParameter().getFormId());
        if (index == 1) {
            this.getPageCache().put("showPageId", lsp.getPageId());
        }
        this.getView().showForm(lsp);
        this.addPageIdIntoCache(lsp.getPageId());
    }

    private void resetCachedPageIDs() {
        this.getPageCache().remove("pageIds");
    }

    private List<String> getAllCachedPageIds() {
        ArrayList<String> list = new ArrayList<String>();
        StringBuilder sb = new StringBuilder();
        String pageIdsObject = this.getPageCache().get("pageIds");
        if (pageIdsObject != null) {
            sb.append(pageIdsObject);
            String[] pageIds = sb.toString().split(";");
            for (int i = 0; i < pageIds.length; ++i) {
                if (!StringUtils.isNotBlank((CharSequence)pageIds[i].trim())) continue;
                list.add(pageIds[i].trim());
            }
        }
        return list;
    }

    private void addPageIdIntoCache(String pageId) {
        StringBuilder sb = new StringBuilder();
        String pageIds = this.getPageCache().get("pageIds");
        if (pageIds != null) {
            sb.append(pageIds);
        }
        sb.append(';');
        sb.append(pageId);
        this.getPageCache().put("pageIds", sb.toString());
    }

    private void resetAllTabs() {
        Container resultContainer = (Container)this.getView().getControl("resulttab");
        if (resultContainer.getItems() != null && !resultContainer.getItems().isEmpty()) {
            TabPage tabPage = (TabPage)resultContainer.getItems().get(0);
            tabPage.getItems();
        }
    }

    private void showError(int index, Throwable ex) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        ex.printStackTrace(printWriter);
        FormShowParameter lsp = new FormShowParameter();
        int next = index + 1;
        lsp.setFormId("bd_ksql_result_area");
        lsp.setCustomParam("resultMessge", (Object)stringWriter.toString());
        lsp.getOpenStyle().setTargetKey("resulttab");
        lsp.getOpenStyle().setShowType(ShowType.NewTabPage);
        lsp.setParentFormId(this.getView().getFormShowParameter().getFormId());
        String tip = ResManager.loadKDString((String)"\u9519\u8bef\u7ed3\u679c(%1$s)", (String)"TripOtherFormPlugin_16", (String)"fi-er-business", (Object[])new Object[0]);
        lsp.setCaption(String.format(tip, next));
        this.getView().showForm(lsp);
        if (next == 1) {
            this.getPageCache().put("showPageId", lsp.getPageId());
        }
        this.addPageIdIntoCache(lsp.getPageId());
        try {
            stringWriter.close();
        }
        catch (IOException var9) {
            var9.getMessage();
        }
        try {
            printWriter.close();
        }
        catch (Exception var8) {
            var8.getMessage();
        }
    }

    private void showMsg(int index, String msg) {
        FormShowParameter lsp = new FormShowParameter();
        int next = index + 1;
        lsp.setFormId("bd_ksql_result_area");
        lsp.setCustomParam("resultMessge", (Object)msg);
        lsp.getOpenStyle().setTargetKey("resulttab");
        lsp.getOpenStyle().setShowType(ShowType.NewTabPage);
        lsp.setParentFormId(this.getView().getFormShowParameter().getFormId());
        String tip = ResManager.loadKDString((String)"\u6267\u884c\u7ed3\u679c(%1$s)", (String)"TripOtherFormPlugin_17", (String)"fi-er-business", (Object[])new Object[0]);
        lsp.setCaption(String.format(tip, next));
        this.getView().showForm(lsp);
        if (next == 1) {
            this.getPageCache().put("showPageId", lsp.getPageId());
        }
        this.addPageIdIntoCache(lsp.getPageId());
    }
}

