/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.trip.iscadmin;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.er.business.trip.supplier.Supplier;
import kd.fi.er.business.trip.util.TripCommonUtil;

public class TripSyncToolsPlugin
extends AbstractFormPlugin {
    private static final Log logger = LogFactory.getLog(TripSyncToolsPlugin.class);
    private static final List<String> PUSH_OP_CODE = Collections.unmodifiableList(Lists.newArrayList((Object[])new String[]{"user", "org", "req", "dailyvehicle", "mealapply", "dailyapply"}));
    private static final List<String> PULL_OP_CODE = Collections.unmodifiableList(Lists.newArrayList((Object[])new String[]{"order", "orderupdate", "checking"}));
    private static List<String> OP_CODE = new ArrayList<String>();
    private static List<String> TROP_CODE = Collections.unmodifiableList(Lists.newArrayList((Object[])new String[]{"bee", "corp", "travelnoone", "didi", "meituan", "gaode", "dtg", "ali", "qicheng", "meiya"}));

    public void registerListener(EventObject e) {
        super.registerListener(e);
        for (String op_code : OP_CODE) {
            for (String trip_code : TROP_CODE) {
                this.addClickListeners(new String[]{trip_code + op_code});
            }
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Map<String, String> supplierKeyMap = Supplier.getSupplierKeyMap();
        int showTip = supplierKeyMap.size();
        for (Map.Entry<String, String> entry : supplierKeyMap.entrySet()) {
            String supplierKey = entry.getKey();
            String supplierValue = entry.getValue();
            Boolean isExistsServer = TripCommonUtil.isEnbleServer(supplierValue);
            if (isExistsServer.booleanValue()) continue;
            if (Supplier.MEITUAN.getValue().equals(supplierValue)) {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"mttrip"});
            } else {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{supplierKey + "trip"});
            }
            --showTip;
        }
        if (showTip == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u670d\u52a1\u5546\u8bbe\u7f6e\u5747\u4e3a\u7981\u7528\u72b6\u6001\uff0c\u8bf7\u5148\u542f\u7528\u670d\u52a1\u5546\u3002", (String)"TripSyncToolsPlugin_0", (String)"fi-er-business", (Object[])new Object[0]));
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        String tripcode = "";
        String opcode = "";
        for (String op_code : OP_CODE) {
            if (key.indexOf(op_code) == -1) continue;
            tripcode = key.replace(op_code, "");
        }
        for (String trop_code : TROP_CODE) {
            if (key.indexOf(trop_code) == -1) continue;
            opcode = key.replace(trop_code, "");
        }
        String number = Supplier.getSupplierKeyMap().get(tripcode);
        FormShowParameter param = new FormShowParameter();
        HashMap<String, String> customParams = new HashMap<String, String>(1);
        customParams.put("number", number);
        customParams.put("opcode", opcode);
        param.setCustomParams(customParams);
        param.getOpenStyle().setShowType(ShowType.Floating);
        if (PUSH_OP_CODE.contains(opcode)) {
            param.setFormId("er_tripsync_pushsel");
            if (opcode.equals("user")) {
                param.setCaption(ResManager.loadKDString((String)"\u540c\u6b65\u4eba\u5458", (String)"TripSyncToolsPlugin_1", (String)"fi-er-business", (Object[])new Object[0]));
            }
            if (opcode.equals("org")) {
                param.setCaption(ResManager.loadKDString((String)"\u540c\u6b65\u7ec4\u7ec7", (String)"TripSyncToolsPlugin_2", (String)"fi-er-business", (Object[])new Object[0]));
            }
            if (opcode.equals("req")) {
                param.setCaption(ResManager.loadKDString((String)"\u540c\u6b65\u51fa\u5dee\u7533\u8bf7\u5355", (String)"TripSyncToolsPlugin_3", (String)"fi-er-business", (Object[])new Object[0]));
            }
            if (opcode.equals("dailyvehicle")) {
                param.setCaption(ResManager.loadKDString((String)"\u540c\u6b65\u7528\u8f66\u7533\u8bf7\u5355", (String)"TripSyncToolsPlugin_4", (String)"fi-er-business", (Object[])new Object[0]));
            }
            if (opcode.equals("mealapply")) {
                param.setCaption(ResManager.loadKDString((String)"\u540c\u6b65\u7528\u9910\u7533\u8bf7\u5355", (String)"TripSyncToolsPlugin_9", (String)"fi-er-business", (Object[])new Object[0]));
            }
            if (opcode.equals("dailyapply")) {
                param.setCaption(ResManager.loadKDString((String)"\u540c\u6b65\u4f1a\u8bae\u8d39\u3001\u62db\u5f85\u8d39\u7533\u8bf7\u5355", (String)"TripSyncToolsPlugin_10", (String)"fi-er-business", (Object[])new Object[0]));
            }
            logger.info("\u5546\u65c5\u96c6\u6210\uff0c\u5546\u65c5\u63a8\u9001\u9009\u62e9\uff0c\u53c2\u6570customParams\u4e3a\uff1a{}", customParams);
        }
        if (PULL_OP_CODE.contains(opcode)) {
            param.setFormId("er_tripsync_pullsel");
            if (opcode.equals("order")) {
                param.setCaption(ResManager.loadKDString((String)"\u83b7\u53d6\u8ba2\u5355", (String)"TripSyncToolsPlugin_5", (String)"fi-er-business", (Object[])new Object[0]));
            }
            if (opcode.equals("orderupdate")) {
                param.setCaption(ResManager.loadKDString((String)"\u83b7\u53d6T+2\u7ed3\u7b97", (String)"TripSyncToolsPlugin_8", (String)"fi-er-business", (Object[])new Object[0]));
            }
            if (opcode.equals("checking")) {
                param.setCaption(ResManager.loadKDString((String)"\u83b7\u53d6\u7ed3\u7b97\u5355", (String)"TripSyncToolsPlugin_7", (String)"fi-er-business", (Object[])new Object[0]));
            }
            logger.info("\u5546\u65c5\u96c6\u6210\uff0c\u5546\u65c5\u62c9\u53d6\u9009\u62e9\uff0c\u53c2\u6570customParams\u4e3a\uff1a{}", customParams);
        }
        this.getView().showForm(param);
    }

    static {
        OP_CODE.addAll(PUSH_OP_CODE);
        OP_CODE.addAll(PULL_OP_CODE);
    }
}

