/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.trip.model;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.CollectionUtils;
import kd.fi.er.business.trip.annotation.KDTripEntity;
import kd.fi.er.business.trip.exception.TripException;
import kd.fi.er.business.trip.model.AbstractCheckingBillDetailModel;
import kd.fi.er.business.trip.model.CheckingBillExistDataModel;
import kd.fi.er.business.trip.model.CheckingBillHeaderModel;
import kd.fi.er.business.trip.model.ExistDataModel;
import kd.fi.er.business.trip.model.IDataModel;
import kd.fi.er.business.trip.service.validate.Validate;
import kd.fi.er.business.trip.supplier.Supplier;
import kd.fi.er.business.trip.util.TripCommonUtil;
import kd.fi.er.business.trip.util.TripSyncConfigUtil;
import kd.fi.er.business.trip.util.TripVerifyComparator;
import kd.fi.er.business.utils.ErCommonUtils;
import org.apache.commons.lang.StringUtils;

public class CheckingBillModel
implements IDataModel {
    private static final Log logger = LogFactory.getLog(CheckingBillModel.class);
    private CheckingBillHeaderModel checkingBillHeaderModel;
    private List<AbstractCheckingBillDetailModel> checkingBillDetailModels;
    private CheckingBillExistDataModel existData;
    private static final String[][] compareProps = new String[][]{{"ordernum"}, {"totalamount"}, {"server"}, {"operationtype"}};
    private static final TripVerifyComparator verifyComparator = new TripVerifyComparator(compareProps);

    public CheckingBillHeaderModel getCheckingBillHeaderModel() {
        return this.checkingBillHeaderModel;
    }

    public void setCheckingBillHeaderModel(CheckingBillHeaderModel checkingBillHeaderModel) {
        this.checkingBillHeaderModel = checkingBillHeaderModel;
    }

    public List<AbstractCheckingBillDetailModel> getCheckingBillDetailModels() {
        return this.checkingBillDetailModels;
    }

    public void setCheckingBillDetailModels(List<AbstractCheckingBillDetailModel> checkingBillDetailModels) {
        this.checkingBillDetailModels = checkingBillDetailModels;
    }

    @Override
    public void addExistDataFilter(ExistDataModel existData) {
        this.setHeaderValue();
        this.existData = (CheckingBillExistDataModel)existData;
        this.checkingBillHeaderModel.addExistDataFilter(existData);
        if (CollectionUtils.isNotEmpty(this.checkingBillDetailModels)) {
            for (AbstractCheckingBillDetailModel model : this.checkingBillDetailModels) {
                model.addExistDataFilter(existData);
            }
        }
    }

    private void setHeaderValue() {
        if (this.checkingBillHeaderModel != null && this.checkingBillDetailModels != null && this.checkingBillDetailModels.size() > 0) {
            AbstractCheckingBillDetailModel model = this.checkingBillDetailModels.get(0);
            this.checkingBillHeaderModel.setOperationType(model.getOperationType());
            KDTripEntity entity = model.getClass().getAnnotation(KDTripEntity.class);
            this.checkingBillHeaderModel.setFormId(entity.name());
            if (Supplier.CHAILVYIHAO.name().equals(this.checkingBillHeaderModel.getServer())) {
                this.checkingBillHeaderModel.setSettlemain(model.getSettlemain());
            }
        }
    }

    @Override
    public void generateData() throws TripException {
        List<DynamicObject> sameBatchNoCheckingList;
        this.checkingBillHeaderModel.generateData();
        if (CollectionUtils.isNotEmpty(this.checkingBillDetailModels)) {
            for (AbstractCheckingBillDetailModel model : this.checkingBillDetailModels) {
                model.setCheckingbillnum(this.checkingBillHeaderModel.getBillNo());
                model.generateData();
            }
        }
        if (this.checkingBillDetailModels != null && this.checkingBillDetailModels.size() > 0 && this.checkingBillHeaderModel != null && null != this.existData.getCheckingbillDetailMapping() && this.existData.getCheckingbillDetailMapping().values().stream().findFirst().isPresent() && CollectionUtils.isNotEmpty(sameBatchNoCheckingList = this.existData.getCheckingbillDetailMapping().values().stream().filter(dynamicObject -> dynamicObject.get("checkingbillnum").equals(this.checkingBillHeaderModel.getBillNo())).collect(Collectors.toList()))) {
            int paramValue = TripSyncConfigUtil.getIntValue("Ctrip_Billing_method", 1, Arrays.asList(1, 2, 3));
            int companyValue = TripSyncConfigUtil.getIntValue("Ctrip_company_display", 1, Arrays.asList(0, 1));
            DynamicObject checking = this.getFirstNotNull(sameBatchNoCheckingList, companyValue);
            if (checking != null && paramValue != 1 && Supplier.XIECHENG.name().equalsIgnoreCase(checking.getString("server"))) {
                DynamicObject dynamicObject2 = this.existData.checkingbill.get(this.checkingBillHeaderModel.getBillNo());
                String propKey = "";
                if (companyValue == 0) {
                    propKey = "company";
                } else if (companyValue == 1) {
                    propKey = "settlemain";
                }
                if (dynamicObject2 != null) {
                    Object prop;
                    if (checking.get(propKey) instanceof Long) {
                        dynamicObject2.set("settlemain", (Object)checking.getLong(propKey));
                        dynamicObject2.set("settlemain_id", (Object)checking.getLong(propKey));
                    }
                    if (checking.get(propKey) instanceof DynamicObject) {
                        prop = checking.getDynamicObject(propKey);
                        dynamicObject2.set("settlemain", (Object)(prop == null ? Long.valueOf(0L) : ErCommonUtils.getPk(prop)));
                        dynamicObject2.set("settlemain_id", (Object)(prop == null ? Long.valueOf(0L) : ErCommonUtils.getPk(prop)));
                    }
                    if (checking.get(propKey) instanceof String) {
                        prop = checking.getString(propKey);
                        dynamicObject2.set("settlemain", (Object)(StringUtils.isEmpty((String)prop) ? 0L : Long.parseLong((String)prop)));
                        dynamicObject2.set("settlemain_id", (Object)(StringUtils.isEmpty((String)prop) ? 0L : Long.parseLong((String)prop)));
                    }
                }
            }
        }
        this.autoBalanceAccount();
    }

    private DynamicObject getFirstNotNull(List<DynamicObject> sameBatchNoCheckingList, int paramValue) {
        boolean isExist;
        DynamicObject org = null;
        if (paramValue == 0) {
            boolean isExist2 = sameBatchNoCheckingList.stream().anyMatch(dynamicObject -> dynamicObject.get("company") != null);
            if (isExist2) {
                org = sameBatchNoCheckingList.stream().filter(dynamicObject -> dynamicObject.get("company") != null).findFirst().get();
            }
        } else if (paramValue == 1 && (isExist = sameBatchNoCheckingList.stream().anyMatch(dynamicObject -> dynamicObject.get("settlemain") != null))) {
            org = sameBatchNoCheckingList.stream().filter(dynamicObject -> dynamicObject.get("settlemain") != null).findFirst().get();
        }
        return org;
    }

    private void autoBalanceAccount() {
        Map<String, DynamicObject> allCheckingbills = this.existData.allCheckingBillDynamicMapping;
        Map<String, DynamicObject> allOrders = this.existData.allOrderBillMapping;
        HashSet flag = new HashSet();
        logger.info(String.format("allCheckingbills.size:%s;allOrders.size:%s", allCheckingbills.size(), allOrders.size()));
        AtomicBoolean isReverseCost = new AtomicBoolean(true);
        HashSet<String> serverSet = new HashSet<String>();
        serverSet.add(this.checkingBillHeaderModel.getServer());
        Map<Object, DynamicObject> setCostMap = TripCommonUtil.getTripServiceInfoDOMap(serverSet);
        setCostMap.forEach((id, dynamicObject) -> {
            String param = dynamicObject.getString("setcostorg");
            if (param != null && StringUtils.isNotBlank((String)param) && "1".equalsIgnoreCase(param)) {
                isReverseCost.set(false);
            }
        });
        allCheckingbills.forEach((orderNum, allCheckingbill) -> {
            DynamicObject checkingDetail = this.existData.checkingbillDetailMapping.get(orderNum);
            if (checkingDetail == null || "C".equalsIgnoreCase(checkingDetail.getString("billstatus"))) {
                return;
            }
            if (null == checkingDetail.get("isbalance") || "".equals(checkingDetail.getString("isbalance"))) {
                checkingDetail.set("isbalance", (Object)"2");
            }
            if (null == allCheckingbill.get("isbalance") || "".equals(allCheckingbill.getString("isbalance"))) {
                allCheckingbill.set("isbalance", (Object)"2");
            }
            DynamicObject orderDetail = this.existData.orderDetailMapping.get(orderNum);
            DynamicObject allOrder = (DynamicObject)allOrders.get(orderNum);
            if (allOrder == null || orderDetail == null) {
                checkingDetail.set("isreconciliation", (Object)Boolean.FALSE);
                checkingDetail.set("isbalance", (Object)"2");
                allCheckingbill.set("isreconciliation", (Object)Boolean.FALSE);
                allCheckingbill.set("isbalance", (Object)"2");
                flag.add("0");
                return;
            }
            checkingDetail.set("allorderbase_id", allOrder.getPkValue());
            allCheckingbill.set("allorderbase_id", allOrder.getPkValue());
            DynamicObjectType dynamicObjectType = checkingDetail.getDynamicObjectType();
            String formID = dynamicObjectType.getName();
            if (("er_vehiclecheckingbill".equalsIgnoreCase(formID) || "er_hotelcheckingbill".equalsIgnoreCase(formID) || "er_traincheckingbill".equalsIgnoreCase(formID) || "er_planecheckingbill".equalsIgnoreCase(formID)) && "2".equalsIgnoreCase(checkingDetail.getString("producttype")) && "2".equalsIgnoreCase(checkingDetail.getString("servicefeepaytype"))) {
                return;
            }
            allOrder.set("server", allOrder.getString("server") == null ? null : allOrder.getString("server").replace(" ", ""));
            if (verifyComparator.compare((DynamicObject)allCheckingbill, allOrder) != 0) {
                checkingDetail.set("isreconciliation", (Object)Boolean.FALSE);
                checkingDetail.set("isbalance", (Object)"2");
                allCheckingbill.set("isreconciliation", (Object)Boolean.FALSE);
                allCheckingbill.set("isbalance", (Object)"2");
                orderDetail.set("isreconciliation", (Object)Boolean.FALSE);
                allOrder.set("isreconciliation", (Object)Boolean.FALSE);
                flag.add("0");
            } else {
                checkingDetail.set("isreconciliation", (Object)Boolean.TRUE);
                checkingDetail.set("isbalance", (Object)"1");
                int orgwritebackorder = TripSyncConfigUtil.getIntValue("trip_org_writeback_order", 1);
                if (orgwritebackorder == 0) {
                    isReverseCost.set(false);
                }
                if (orgwritebackorder == 1 || orgwritebackorder == 2) {
                    isReverseCost.set(true);
                }
                if (isReverseCost.get()) {
                    checkingDetail.set("settlemain", allOrder.get("expcommitcomnum"));
                    checkingDetail.set("settledept", allOrder.get("expcommitdepnum"));
                } else if (orgwritebackorder != 0) {
                    if (checkingDetail.get("settlemain") != null) {
                        orderDetail.set("expcommitcomnum", checkingDetail.get("settlemain"));
                        allOrder.set("expcommitcomnum", checkingDetail.get("settlemain"));
                    }
                    if (checkingDetail.get("settledept") != null) {
                        orderDetail.set("expcommitdepnum", checkingDetail.get("settledept"));
                        allOrder.set("expcommitdepnum", checkingDetail.get("settledept"));
                    }
                }
                allCheckingbill.set("isreconciliation", (Object)Boolean.TRUE);
                allCheckingbill.set("isbalance", (Object)"1");
                allOrder.set("isreconciliation", (Object)Boolean.TRUE);
                orderDetail.set("isreconciliation", (Object)Boolean.TRUE);
            }
        });
        if (flag.size() > 0) {
            this.existData.checkingbill.get(this.checkingBillHeaderModel.getBillNo()).set("result", (Object)"2");
        } else {
            this.existData.checkingbill.get(this.checkingBillHeaderModel.getBillNo()).set("result", (Object)"1");
        }
        logger.info("autoBalanceAccount end");
    }

    @Override
    public Validate validate() {
        Validate result = new Validate();
        Validate headVaildate = null;
        if (this.checkingBillHeaderModel == null) {
            result.result.success = false;
            result.result.message.append(ResManager.loadKDString((String)"\u5bf9\u8d26\u5355\u5934\u4e0d\u5b58\u5728\uff0c\u8bf7\u786e\u8ba4", (String)"CheckingBillModel_0", (String)"fi-er-business", (Object[])new Object[0]));
            result.result.message.append(" |");
            return result;
        }
        headVaildate = this.checkingBillHeaderModel.validate();
        if (!headVaildate.result.success) {
            result.result.success = false;
            result.result.message.append((CharSequence)headVaildate.result.message);
        }
        if (this.checkingBillDetailModels != null) {
            for (AbstractCheckingBillDetailModel model : this.checkingBillDetailModels) {
                Validate detail = model.validate();
                if (detail.result.success) continue;
                result.result.success = false;
                result.result.message.append((CharSequence)detail.result.message);
            }
        }
        return result;
    }
}

