/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.trip.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.fi.er.business.dao.IErDao;
import kd.fi.er.business.dao.factory.ErDaoFactory;
import kd.fi.er.business.message.ErMessageServiceHelper;
import kd.fi.er.business.trip.dailybiz.TripReimUpdateOrderEntrysUtil;
import kd.fi.er.business.trip.exception.TripException;
import kd.fi.er.business.trip.model.ExistDataModel;
import kd.fi.er.business.trip.supplier.Supplier;
import kd.fi.er.business.trip.supplier.ctrip.invoke.convert.ConvertUtil;
import kd.fi.er.business.utils.ErCommonUtils;

public class OrderExistDataModel
extends ExistDataModel {
    private static final Log logger = LogFactory.getLog(OrderExistDataModel.class);
    private Map<String, DynamicObject> allOrderMapping = new HashMap<String, DynamicObject>();
    private Map<String, Map<String, DynamicObject>> orderMapping = new HashMap<String, Map<String, DynamicObject>>();
    private Map<String, DynamicObject> allcheckingMapping = new HashMap<String, DynamicObject>();
    private Set<String> existAllOrderKey = new HashSet<String>();
    private Set<String> allOrderFilter = new HashSet<String>();
    private Map<String, Set<String>> orderFilter = new HashMap<String, Set<String>>();
    private Map<String, DynamicObject> checkingOrderMapping = new HashMap<String, DynamicObject>();

    public Map<String, DynamicObject> getAllOrderMapping() {
        return this.allOrderMapping;
    }

    public Map<String, Map<String, DynamicObject>> getOrderMapping() {
        return this.orderMapping;
    }

    public Map<String, DynamicObject> getAllCheckingMapping() {
        return this.allcheckingMapping;
    }

    public Set<String> getExistAllOrderKey() {
        return this.existAllOrderKey;
    }

    public Set<String> getAllOrderFilter() {
        return this.allOrderFilter;
    }

    public Map<String, Set<String>> getOrderFilter() {
        return this.orderFilter;
    }

    public Map<String, DynamicObject> getCheckingOrderMapping() {
        return this.checkingOrderMapping;
    }

    @Override
    public void query() {
        DynamicObject[] allCheckings;
        DynamicObject[] allOrders;
        super.query();
        IErDao allOrderdao = ErDaoFactory.getInstance("er_allorderbill");
        for (DynamicObject allOrder : allOrders = allOrderdao.query(new QFilter("ordernum", "in", this.allOrderFilter).and(new QFilter("server", "=", (Object)this.getServer())))) {
            this.allOrderMapping.put(allOrder.getString("ordernum"), allOrder);
            this.existAllOrderKey.add(allOrder.getString("ordernum"));
        }
        IErDao allCheckingdao = ErDaoFactory.getInstance("er_allcheckingbill");
        for (DynamicObject allChecking : allCheckings = allCheckingdao.query(new QFilter("ordernum", "in", this.allOrderFilter).and(new QFilter("server", "=", (Object)this.getServer())))) {
            this.allcheckingMapping.put(allChecking.getString("ordernum"), allChecking);
        }
        this.orderFilter.forEach((k, v) -> {
            DynamicObject[] orders;
            IErDao orderdao = ErDaoFactory.getInstance(k);
            for (DynamicObject order : orders = orderdao.query(new QFilter("ordernum", "in", v).and(new QFilter("server", "=", (Object)this.getServer())))) {
                Map<String, DynamicObject> typeOrders = this.orderMapping.get(k);
                if (typeOrders == null) {
                    typeOrders = new HashMap<String, DynamicObject>();
                    this.orderMapping.put((String)k, typeOrders);
                }
                typeOrders.put(order.getString("ordernum"), order);
            }
        });
        if (!Supplier.ZHONGXING.name().equalsIgnoreCase(this.getServer())) {
            DynamicObject[] checkingDetailBillDynamics;
            QFilter checkingFilter = new QFilter("orderNum", "in", this.allOrderFilter).and(new QFilter("server", "=", (Object)this.getServer())).and(new QFilter("operationtype", "=", (Object)"2"));
            IErDao checkingDetailDao = ErDaoFactory.getInstance("er_planecheckingbill");
            for (DynamicObject checkingDetail : checkingDetailBillDynamics = checkingDetailDao.query("id, orderNum, ticketstatus,itinerarynum,itinerarydate,downloadlink,kddownloadlink", checkingFilter)) {
                String orderNum = checkingDetail.getString("orderNum");
                this.checkingOrderMapping.put(orderNum, checkingDetail);
                logger.info("\u5546\u65c5\u96c6\u6210,OrderExistDataModel query checkingOrderMapping:" + orderNum + "_" + checkingDetail.getPkValue());
            }
        }
    }

    @Override
    public void save() throws TripException {
        try (TXHandle txHandle = TX.requiresNew();){
            try {
                if (this.allOrderMapping != null && this.allOrderMapping.size() > 0) {
                    SaveServiceHelper.save((DynamicObject[])this.allOrderMapping.values().toArray(new DynamicObject[this.allOrderMapping.size()]));
                }
                IErDao allOrderdao = ErDaoFactory.getInstance("er_allorderbill");
                if (this.allOrderMapping != null) {
                    DynamicObject[] allOrders;
                    for (DynamicObject allOrder : allOrders = allOrderdao.query(new QFilter("ordernum", "in", this.allOrderMapping.keySet()).and(new QFilter("server", "=", (Object)this.getServer())))) {
                        this.allOrderMapping.put(allOrder.getString("ordernum"), allOrder);
                    }
                }
                this.orderMapping.values().forEach(v -> {
                    Collection values;
                    if (v != null && (values = v.values()).size() > 0) {
                        for (DynamicObject value : values) {
                            if (!"er_vehiclebill".equals(value.getDataEntityType().getName())) continue;
                            value.set("allorderbase_id", (Object)ErCommonUtils.getPk(this.allOrderMapping.get(value.get("ordernum"))));
                        }
                        SaveServiceHelper.save((DynamicObject[])values.toArray(new DynamicObject[values.size()]));
                    }
                });
                if (this.checkingOrderMapping != null && this.checkingOrderMapping.size() > 0) {
                    SaveServiceHelper.save((DynamicObject[])this.checkingOrderMapping.values().toArray(new DynamicObject[this.checkingOrderMapping.size()]));
                }
            }
            catch (Exception e) {
                txHandle.markRollback();
                throw new RuntimeException(e);
            }
        }
        catch (Exception e) {
            logger.error("\u6570\u636e\u4fdd\u5b58\u5931\u8d25:", (Throwable)e);
            throw new RuntimeException(e);
        }
        this.orderMapping.values().forEach(v -> {
            Collection values;
            if (v != null && (values = v.values()).size() > 0) {
                TripReimUpdateOrderEntrysUtil.updateOrderEntrys(values.toArray(new DynamicObject[values.size()]));
            }
        });
        this.sendMessageToReimburser();
        this.sendConfrimMessage();
    }

    private void sendMessageToReimburser() {
        try {
            if (this.orderMapping == null || this.orderMapping.size() < 1) {
                return;
            }
            String msgTime = (String)ErCommonUtils.getEMParameter(OrgUnitServiceHelper.getRootOrgId(), "tripmsgtype");
            String string = msgTime = msgTime == null ? "none" : msgTime;
            if (msgTime == null || "none".equals(msgTime)) {
                return;
            }
            for (Map.Entry<String, Map<String, DynamicObject>> orderMappingEntry : this.orderMapping.entrySet()) {
                Map<String, DynamicObject> orderBills = orderMappingEntry.getValue();
                logger.info("\u5546\u65c5\u96c6\u6210,\u8ba2\u5355\u4fdd\u5b58,\u53d1\u9001\u6d88\u606f\u7684\u8ba2\u5355IDs:" + orderBills.keySet());
                for (Map.Entry<String, DynamicObject> orderBill : orderBills.entrySet()) {
                    if ("update".equals(msgTime) && !this.existAllOrderKey.contains(orderBill.getKey()) || "addnew".equals(msgTime) && this.existAllOrderKey.contains(orderBill.getKey())) continue;
                    DynamicObject billDym = orderBill.getValue();
                    ErMessageServiceHelper.sendMessageByBillDO("trip_order_change", orderMappingEntry.getKey(), new DynamicObject[]{billDym}, "sourceBookedId");
                }
            }
        }
        catch (Exception e) {
            logger.error("\u5546\u65c5\u96c6\u6210,\u8ba2\u5355\u4fdd\u5b58,\u53d1\u9001\u6d88\u606f\u5931\u8d25:", (Throwable)e);
        }
    }

    private void sendConfrimMessage() {
        for (Map.Entry<String, Map<String, DynamicObject>> entry : this.orderMapping.entrySet()) {
            List ids = entry.getValue().values().stream().map(e -> e.getPkValue()).collect(Collectors.toList());
            String key = entry.getKey();
            if ("er_planebill".equals(key) || "er_hotelbill".equals(key) || "er_vehiclebill".equals(key)) {
                ids = entry.getValue().values().stream().filter(m -> m.getBigDecimal("totalamount") != null && ConvertUtil.getOrderAmountInit().compareTo(m.getBigDecimal("totalamount")) != 0).map(n -> n.getPkValue()).collect(Collectors.toList());
            }
            if (ids == null || ids.size() == 0) {
                return;
            }
            DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((Object[])ids.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)entry.getKey()));
            List<DynamicObject> list = Arrays.stream(dynamicObjects).filter(e -> !e.getBoolean("isconfirm") && e.getInt("noticetimes") < 1).collect(Collectors.toList());
            if (list.size() > 0) {
                ErMessageServiceHelper.sendTripOrderConfrimMessage(list.toArray(new DynamicObject[0]), entry.getKey(), true, true);
                continue;
            }
            logger.info("\u6ca1\u6709\u9700\u8981\u53d1\u9001\u6d88\u606f\u7684\u8ba2\u5355");
        }
    }
}

