/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.trip.model;

import java.math.BigDecimal;
import java.util.Date;
import java.util.Set;
import kd.fi.er.business.trip.annotation.KDTripEntity;
import kd.fi.er.business.trip.annotation.KDTripField;
import kd.fi.er.business.trip.dao.PlaneCheckingDetailDao;
import kd.fi.er.business.trip.model.AbstractCheckingBillDetailModel;
import kd.fi.er.business.trip.model.ExistDataModel;
import kd.fi.er.business.trip.model.PlaneOrderModel;
import kd.fi.er.business.trip.supplier.ctrip.systemexternal.CorpSync;

@KDTripEntity(name="er_planecheckingbill")
public class PlaneCheckingBillDetailModel
extends AbstractCheckingBillDetailModel
implements Cloneable {
    private String ticketNum;
    private String flightNo;
    private String fromCityName;
    private String toCityName;
    @KDTripField(ignore=true)
    private String sourceTravelerId;
    private BigDecimal ticketPrice;
    private BigDecimal discount;
    private BigDecimal airportPrice;
    private BigDecimal fuelPrice;
    private BigDecimal refundAmount;
    private BigDecimal assuranceAmount;
    private BigDecimal serviceFee;
    private String cabin;
    private String cabinClass;
    private Date takeOffTime;
    private Date landingtime;
    private String travelername;
    @KDTripField(ignore=true, mustInput=true, alias="\u8ba2\u5355\u72b6\u6001")
    private PlaneOrderModel.OrderStatus orderStatus;
    private String itinerarynum;
    private Date itinerarydate;
    private String ticketstatus;
    @KDTripField(ignore=true)
    private String downloadlink;
    private BigDecimal endorsementAmount;
    private String airlineName;
    private BigDecimal lowestPirce;
    private BigDecimal otherAmount;
    private String isLowestPirce;

    public PlaneCheckingBillDetailModel() {
        this.handle = new PlaneCheckingDetailDao();
        this.billFormId = "er_planecheckingbill";
    }

    @Override
    public void addExistDataFilter(ExistDataModel existData) {
        super.addExistDataFilter(existData);
        if (this.sourceTravelerId != null && !this.sourceTravelerId.trim().isEmpty()) {
            existData.getUserFilter().add(this.sourceTravelerId);
        }
        KDTripEntity entityAnnotation = this.getClass().getAnnotation(KDTripEntity.class);
        String entityName = entityAnnotation.name();
        Set<String> orderNums = this.existData.checingBillFilter.get(entityName);
        String oldOrderNum = CorpSync.splicOldOrderNum(this.parentordernum, this.ticketNum, this.orderType.getKey());
        orderNums.add(oldOrderNum);
    }

    public BigDecimal getOtherAmount() {
        return this.otherAmount;
    }

    public void setOtherAmount(BigDecimal otherAmount) {
        this.otherAmount = otherAmount;
    }

    public String getTicketNum() {
        return this.ticketNum;
    }

    public void setTicketNum(String ticketNum) {
        this.ticketNum = ticketNum;
    }

    public String getFlightNo() {
        return this.flightNo;
    }

    public void setFlightNo(String flightNo) {
        this.flightNo = flightNo;
    }

    public String getFromCityName() {
        return this.fromCityName;
    }

    public void setFromCityName(String fromCityName) {
        this.fromCityName = fromCityName;
    }

    public String getToCityName() {
        return this.toCityName;
    }

    public void setToCityName(String toCityName) {
        this.toCityName = toCityName;
    }

    public String getSourceTravelerId() {
        return this.sourceTravelerId;
    }

    public void setSourceTravelerId(String sourceTravelerId) {
        this.sourceTravelerId = sourceTravelerId;
    }

    public BigDecimal getTicketPrice() {
        return this.ticketPrice;
    }

    public void setTicketPrice(BigDecimal ticketPrice) {
        this.ticketPrice = ticketPrice;
    }

    public BigDecimal getDiscount() {
        return this.discount;
    }

    public void setDiscount(BigDecimal discount) {
        this.discount = discount;
    }

    public BigDecimal getAirportPrice() {
        return this.airportPrice;
    }

    public void setAirportPrice(BigDecimal airportPrice) {
        this.airportPrice = airportPrice;
    }

    public BigDecimal getFuelPrice() {
        return this.fuelPrice;
    }

    public void setFuelPrice(BigDecimal fuelPrice) {
        this.fuelPrice = fuelPrice;
    }

    public BigDecimal getRefundAmount() {
        return this.refundAmount;
    }

    public void setRefundAmount(BigDecimal refundAmount) {
        this.refundAmount = refundAmount;
    }

    public BigDecimal getAssuranceAmount() {
        return this.assuranceAmount;
    }

    public void setAssuranceAmount(BigDecimal assuranceAmount) {
        this.assuranceAmount = assuranceAmount;
    }

    public BigDecimal getServiceFee() {
        return this.serviceFee;
    }

    public void setServiceFee(BigDecimal serviceFee) {
        this.serviceFee = serviceFee;
    }

    public PlaneOrderModel.OrderStatus getOrderStatus() {
        return this.orderStatus;
    }

    public void setOrderStatus(PlaneOrderModel.OrderStatus orderStatus) {
        this.orderStatus = orderStatus;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public String getCabin() {
        return this.cabin;
    }

    public void setCabin(String cabin) {
        this.cabin = cabin;
    }

    public String getCabinClass() {
        return this.cabinClass;
    }

    public void setCabinClass(String cabinClass) {
        this.cabinClass = cabinClass;
    }

    public Date getTakeOffTime() {
        return this.takeOffTime;
    }

    public void setTakeOffTime(Date takeOffTime) {
        this.takeOffTime = takeOffTime;
    }

    public Date getLandingtime() {
        return this.landingtime;
    }

    public void setLandingtime(Date landingtime) {
        this.landingtime = landingtime;
    }

    public String getTravelername() {
        return this.travelername;
    }

    public void setTravelername(String travelername) {
        this.travelername = travelername;
    }

    public Date getItinerarydate() {
        return this.itinerarydate;
    }

    public void setItinerarydate(Date itinerarydate) {
        this.itinerarydate = itinerarydate;
    }

    public String getItinerarynum() {
        return this.itinerarynum;
    }

    public void setItinerarynum(String itinerarynum) {
        this.itinerarynum = itinerarynum;
    }

    public String getTicketstatus() {
        return this.ticketstatus;
    }

    public void setTicketstatus(String ticketstatus) {
        this.ticketstatus = ticketstatus;
    }

    public String getDownloadlink() {
        return this.downloadlink;
    }

    public void setDownloadlink(String downloadlink) {
        this.downloadlink = downloadlink;
    }

    public BigDecimal getEndorsementAmount() {
        return this.endorsementAmount;
    }

    public void setEndorsementAmount(BigDecimal endorsementAmount) {
        this.endorsementAmount = endorsementAmount;
    }

    public String getAirlineName() {
        return this.airlineName;
    }

    public void setAirlineName(String airlineName) {
        this.airlineName = airlineName;
    }

    public BigDecimal getLowestPirce() {
        return this.lowestPirce;
    }

    public void setLowestPirce(BigDecimal lowestPirce) {
        this.lowestPirce = lowestPirce;
    }

    public String getIsLowestPirce() {
        return this.isLowestPirce;
    }

    public void setIsLowestPirce(String isLowestPirce) {
        this.isLowestPirce = isLowestPirce;
    }
}

