/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.trip.mq.consumer;

import java.util.Map;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.MessageAcker;
import kd.bos.mq.MessageConsumer;
import kd.fi.er.business.trip.dailybiz.DailyReimWriteBackOrderUtil;
import kd.fi.er.business.trip.dailybiz.TripReimWriteBackOrderUtil;
import kd.fi.er.business.utils.ErEntityTypeUtils;

public class ReimburseBillReverseOrderConsumer
implements MessageConsumer {
    private static final Log logger = LogFactory.getLog(ReimburseBillReverseOrderConsumer.class);

    public void onMessage(Object msgBody, String msgId, boolean resend, MessageAcker ack) {
        if (msgBody == null || resend) {
            ack.discard(msgId);
        } else {
            Map msg = (Map)msgBody;
            Long billId = (Long)msg.get("billId");
            boolean isReimburse = (Boolean)msg.get("isReimburse");
            boolean isAudit = (Boolean)msg.get("isAudit");
            String operateKey = (String)msg.get("operateKey");
            String entityName = (String)msg.get("entityName");
            if (billId == null) {
                ack.discard(msgId);
            } else {
                try {
                    if (ErEntityTypeUtils.isPublicReimburseBill(entityName) || ErEntityTypeUtils.isDailyReimburseBill(entityName)) {
                        DailyReimWriteBackOrderUtil.reverseOrderBill(billId, isReimburse, isAudit, operateKey, entityName);
                    } else {
                        TripReimWriteBackOrderUtil.reverseOrderBill(billId, isReimburse, isAudit, operateKey);
                    }
                }
                catch (Exception e) {
                    logger.error("\u5546\u65c5\u96c6\u6210,\u5dee\u65c5\u62a5\u9500\u5355\u53cd\u5199\u8ba2\u5355\u548c\u7ed3\u7b97\u5355,\u6267\u884c\u51fa\u9519:", (Throwable)e);
                    ack.discard(msgId);
                }
            }
        }
    }
}

