/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.trip.mq.consumer;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.MessageAcker;
import kd.bos.mq.MessageConsumer;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.er.business.trip.service.factory.TripServiceFactory;
import kd.fi.er.business.trip.service.iservice.ITripService;
import kd.fi.er.business.trip.supplier.Supplier;
import kd.fi.er.business.trip.util.TripCommonUtil;

public class SyncMealApplicationBillToTripConsumer
implements MessageConsumer {
    private static Log logger = LogFactory.getLog(SyncMealApplicationBillToTripConsumer.class);
    static final List<String> operationTypeList = new ArrayList<String>(2);
    static final List<String> syncStatusList = new ArrayList<String>(2);

    public void onMessage(Object msgBody, String msgId, boolean resend, MessageAcker messageAcker) {
        try {
            if (Objects.isNull(msgBody)) {
                messageAcker.discard(msgId);
                return;
            }
            logger.info("\u7528\u9910\u7533\u8bf7\u5355\u540c\u6b65,MQ\u6267\u884c\u5f00\u59cb:" + JSON.toJSONString((Object)msgBody));
            Map msgMap = (Map)msgBody;
            String billType = (String)msgMap.get("billType");
            Long billId = (Long)msgMap.get("billId");
            String operationType = (String)msgMap.get("operationType");
            String syncStatus = (String)msgMap.get("syncStatus");
            DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)billId, (String)"er_mealapplication_bill");
            if (dynamicObject == null) {
                logger.info("\u5355\u636eID,\u7528\u9910\u7533\u8bf7\u5355\u4e0d\u5b58\u5728" + billId);
                messageAcker.discard(msgId);
                return;
            }
            HashSet<String> serverSet = new HashSet<String>();
            for (Supplier key : Supplier.values()) {
                String server = key.name();
                if (!operationTypeList.contains(operationType) || !TripCommonUtil.isEnbleServer(server).booleanValue()) continue;
                serverSet.add(server);
            }
            serverSet.forEach(v -> {
                String server = v;
                String tripServiceName = TripCommonUtil.getStandtripname().get(server);
                try {
                    ITripService iTripService = TripServiceFactory.getTripService(tripServiceName);
                    iTripService.synMealApplicationBillToTrip(billId, syncStatus);
                }
                catch (Exception e) {
                    logger.error("\u5546\u65c5\u96c6\u6210,\u7528\u9910\u7533\u8bf7\u5355\u540c\u6b65,MQ\u6267\u884c\u5931\u8d25,\u5f53\u524d\u670d\u52a1\u5546:" + server, (Throwable)e);
                }
            });
            logger.info(String.format("\u5546\u65c5\u96c6\u6210,\u7528\u9910\u7533\u8bf7\u5355\u540c\u6b65\u7ed3\u675f,\u7528\u9910ID:%s", billId));
            messageAcker.ack(msgId);
        }
        catch (Exception exception) {
            logger.error("\u7528\u9910\u7533\u8bf7\u5355MQ\u6267\u884c\u5931\u8d25:", (Throwable)exception);
        }
    }

    static {
        operationTypeList.add("audit");
        syncStatusList.add("1");
        syncStatusList.add("2");
    }
}

