/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.trip.service.function;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.er.business.dao.impl.ErOrm;
import kd.fi.er.business.trip.model.AbstractCheckingBillInvoiceModel;
import kd.fi.er.business.trip.service.function.template.InPutFunctionTemp;
import kd.fi.er.business.trip.supplier.Supplier;
import kd.fi.er.business.trip.util.TripCheckingInvoiceImageInfoUtil;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractCheckingBillImageInvoke<T>
extends InPutFunctionTemp {
    private static Log logger = LogFactory.getLog(AbstractCheckingBillImageInvoke.class);
    public ErOrm dao;

    @Override
    protected String supplier() {
        return Supplier.CHAILVYIHAO.name();
    }

    @Override
    protected String function() {
        return "imageInvoke";
    }

    public abstract List<DynamicObject> handleFieldValue(List<Object> var1, ErOrm var2);

    public Map<String, List<String>> getCheckingBillDatas() {
        HashMap typeAndBillNumsMap = Maps.newHashMapWithExpectedSize((int)16);
        try {
            if (this.params.isEmpty()) {
                String monthOfDay = TripCheckingInvoiceImageInfoUtil.getMonthOfDay();
                SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
                Date date = format.parse(monthOfDay);
                QFilter qFilter = new QFilter("periodstartdate", ">=", (Object)date).and(new QFilter("periodenddate", "<=", (Object)date));
                DynamicObject[] datas = BusinessDataServiceHelper.load((String)"er_checkingbill", (String)"billnum,operationtype", (QFilter[])new QFilter[]{qFilter});
                ArrayList planeBillNumsList = Lists.newArrayListWithCapacity((int)16);
                ArrayList trainBillNumsList = Lists.newArrayListWithCapacity((int)16);
                for (DynamicObject data : datas) {
                    String operationtype = data.getString("operationtype");
                    String billnum = data.getString("billnum");
                    billnum = TripCheckingInvoiceImageInfoUtil.dealBillNum(billnum);
                    if (StringUtils.equalsAny((CharSequence)operationtype, (CharSequence[])new String[]{"2", "4"})) {
                        planeBillNumsList.add(billnum);
                        continue;
                    }
                    if (!StringUtils.equals((CharSequence)operationtype, (CharSequence)"6")) continue;
                    trainBillNumsList.add(billnum);
                }
                Set allOrderBillNums = Arrays.stream(datas).filter(dynamicObject -> StringUtils.isNotEmpty((CharSequence)dynamicObject.getString("billnum"))).map(dynamicObject -> TripCheckingInvoiceImageInfoUtil.dealBillNum(dynamicObject.getString("billnum"))).collect(Collectors.toSet());
                typeAndBillNumsMap.put("plane", planeBillNumsList);
                typeAndBillNumsMap.put("train", trainBillNumsList);
                typeAndBillNumsMap.put("all", new ArrayList(allOrderBillNums));
            } else {
                typeAndBillNumsMap.putAll(this.params);
            }
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u6708\u7ed3\u6570\u636e\u9519\u8bef", (Throwable)e);
        }
        return typeAndBillNumsMap;
    }

    protected void handleSpecialFieldValue(List<? extends AbstractCheckingBillInvoiceModel> models) {
    }
}

