/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.trip.service.function;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.dlock.DLock;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.fi.er.business.dao.IErDao;
import kd.fi.er.business.dao.factory.ErDaoFactory;
import kd.fi.er.business.fileservice.ErFileServiceHelper;
import kd.fi.er.business.trip.model.AbstractOrderModel;
import kd.fi.er.business.trip.model.PlaneOrderModel;
import kd.fi.er.business.trip.model.TrainImageModel;
import kd.fi.er.business.trip.service.function.template.InPutFunctionTemp;
import kd.fi.er.business.utils.RSAUtils;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractImageInvoke<T>
extends InPutFunctionTemp {
    private static final Log logger = LogFactory.getLog(AbstractImageInvoke.class);
    private static String suffixes = "jpeg|jpg|png|pdf";

    public AbstractImageInvoke() {
    }

    public AbstractImageInvoke(Map params) {
        super(params);
    }

    @Override
    protected String supplier() {
        return null;
    }

    @Override
    protected String function() {
        return "imageInvoke";
    }

    @Override
    protected void saveInfos(Object infos) {
        this.saveImages(infos);
        logger.info("\u5546\u65c5\u96c6\u6210,\u5f71\u50cf\u4fe1\u606f\u4fdd\u5b58,end");
    }

    private void saveImages(Object infos) {
        HashMap resultMap;
        block20: {
            List orders = (List)infos;
            if (orders == null || orders.size() == 0) {
                return;
            }
            resultMap = Maps.newHashMapWithExpectedSize((int)16);
            this.validateBeforeSave(orders);
            ArrayList planeImages = Lists.newArrayListWithCapacity((int)16);
            ArrayList trainImages = Lists.newArrayListWithCapacity((int)16);
            for (AbstractOrderModel order : orders) {
                if (order instanceof TrainImageModel) {
                    trainImages.add((TrainImageModel)order);
                    continue;
                }
                if (!(order instanceof PlaneOrderModel)) continue;
                planeImages.add((PlaneOrderModel)order);
            }
            String lockKey = "fi.er.trip.image" + ((AbstractOrderModel)orders.get(0)).getOrderNum();
            try (DLock dLock = DLock.create((String)lockKey);){
                boolean isLock = dLock.tryLock(30000L);
                if (isLock) {
                    resultMap.putAll(this.dealPlaneImages(planeImages));
                    resultMap.putAll(this.dealTrainImages(trainImages));
                    break block20;
                }
                logger.info(String.format("\u5c1d\u8bd5\u83b7\u53d6\u9501\u5931\u8d25%s\u3002", lockKey));
                throw new KDBizException(ResManager.loadKDString((String)"\u5c1d\u8bd5\u83b7\u53d6\u9501\u5931\u8d25\u3002", (String)"AbstractImageInvoke_0", (String)"fi-er-business", (Object[])new Object[0]));
            }
            catch (Exception e) {
                logger.error("\u5546\u65c5\u96c6\u6210,\u884c\u7a0b\u5355\u5f71\u50cf\u4fe1\u606f\u4fdd\u5b58,\u5931\u8d25:", (Throwable)e);
                throw new RuntimeException(e);
            }
        }
        try {
            this.handleAfterSave(resultMap);
        }
        catch (Exception e) {
            logger.error("\u5f71\u50cf\u4fdd\u5b58\u540e\u6269\u5c55\u62a5\u9519", (Throwable)e);
        }
    }

    private Map<String, Map<String, DynamicObject>> dealPlaneImages(List<PlaneOrderModel> planeImages) {
        DynamicObject[] checkingDetailBillDynamics;
        if (CollectionUtils.isEmpty(planeImages)) {
            return Maps.newHashMap();
        }
        HashSet<String> allOrderFilter = new HashSet<String>(planeImages.size());
        String server = planeImages.get(0).getServer();
        for (AbstractOrderModel abstractOrderModel : planeImages) {
            allOrderFilter.add(abstractOrderModel.getOrderNum());
        }
        HashMap resultMap = Maps.newHashMapWithExpectedSize((int)16);
        HashMap<String, DynamicObject> hashMap = new HashMap<String, DynamicObject>();
        HashMap<String, DynamicObject> checkingOrderMapping = new HashMap<String, DynamicObject>();
        IErDao orderdao = ErDaoFactory.getInstance("er_planebill");
        DynamicObject[] planorders = orderdao.query(new QFilter("ordernum", "in", allOrderFilter).and(new QFilter("server", "=", (Object)server)));
        Map orderModelMap = planeImages.stream().collect(Collectors.toMap(AbstractOrderModel::getOrderNum, Function.identity()));
        String type = "pdf";
        String tempSuffixes = suffixes;
        for (DynamicObject order : planorders) {
            PlaneOrderModel orderModel = (PlaneOrderModel)orderModelMap.get(order.getString("ordernum"));
            if (null == orderModel) continue;
            if (StringUtils.isNotEmpty((CharSequence)orderModel.getImageSuffixes())) {
                tempSuffixes = orderModel.getImageSuffixes();
            }
            Pattern pat = Pattern.compile("[\\w]+[\\.](" + tempSuffixes + ")");
            if ((null == order.getString("downloadlink") || order.getString("downloadlink").isEmpty()) && null != orderModel.getDownloadlink() && !orderModel.getDownloadlink().isEmpty()) {
                String ownloadlink = orderModel.getDownloadlink();
                Matcher mc = pat.matcher(ownloadlink);
                while (mc.find()) {
                    String name = mc.group();
                    logger.info("ErFileServiceHelper_uploadFile>>> matchname{}", (Object)name);
                    type = name.substring(name.lastIndexOf(".") + 1);
                }
                logger.info("ErFileServiceHelper_uploadFile>>>type:{}", (Object)type);
                order.set("downloadlink", (Object)orderModel.getDownloadlink());
                String path = ErFileServiceHelper.uploadFile(ownloadlink, orderModel.getServer() + "_" + orderModel.getOrderNum() + "." + type, "/tripplane/");
                order.set("kddownloadlink", (Object)path);
            }
            order.set("itinerarynum", (Object)orderModel.getItinerarynum());
            hashMap.put(order.getString("ordernum"), order);
        }
        QFilter checkingFilter = new QFilter("orderNum", "in", allOrderFilter).and(new QFilter("server", "=", (Object)server)).and(new QFilter("operationtype", "=", (Object)"2"));
        IErDao checkingDetailDao = ErDaoFactory.getInstance("er_planecheckingbill");
        for (DynamicObject checkingDetail : checkingDetailBillDynamics = checkingDetailDao.query("id, orderNum, ticketstatus,itinerarynum,itinerarydate,downloadlink,kddownloadlink,serialno,invoiceidentityflag,identityerrormsg,settlemain,formid", checkingFilter)) {
            String orderNum = checkingDetail.getString("orderNum");
            DynamicObject order = (DynamicObject)hashMap.get(checkingDetail.getString("ordernum"));
            if (null == order || null == order.getString("downloadlink") || order.getString("downloadlink").isEmpty()) continue;
            checkingDetail.set("downloadlink", (Object)order.getString("downloadlink"));
            checkingDetail.set("kddownloadlink", (Object)order.getString("kddownloadlink"));
            checkingDetail.set("itinerarynum", (Object)order.getString("itinerarynum"));
            checkingOrderMapping.put(orderNum, checkingDetail);
        }
        this.saveData(hashMap, checkingOrderMapping);
        resultMap.put("er_planebill", hashMap);
        resultMap.put("er_planecheckingbill", checkingOrderMapping);
        return resultMap;
    }

    public void saveData(Map<String, DynamicObject> orderMapping, Map<String, DynamicObject> checkingOrderMapping) {
        try (TXHandle txHandle = TX.requiresNew();){
            try {
                if (orderMapping != null && orderMapping.size() > 0) {
                    SaveServiceHelper.save((DynamicObject[])orderMapping.values().toArray(new DynamicObject[orderMapping.size()]));
                }
                if (checkingOrderMapping != null && checkingOrderMapping.size() > 0) {
                    SaveServiceHelper.save((DynamicObject[])checkingOrderMapping.values().toArray(new DynamicObject[checkingOrderMapping.size()]));
                }
            }
            catch (Exception e) {
                txHandle.markRollback();
                throw new RuntimeException(e);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private Map<String, Map<String, DynamicObject>> dealTrainImages(List<TrainImageModel> trainImages) {
        if (CollectionUtils.isEmpty(trainImages)) {
            return new HashMap<String, Map<String, DynamicObject>>();
        }
        HashMap resultMap = Maps.newHashMapWithExpectedSize((int)16);
        HashMap<String, DynamicObject> orderMapping = new HashMap<String, DynamicObject>();
        HashMap<String, DynamicObject> checkingOrderMapping = new HashMap<String, DynamicObject>();
        IErDao dao = ErDaoFactory.getInstance("er_trainbill");
        String server = trainImages.get(0).getServer();
        Set nameSet = trainImages.stream().filter(trainImageModel -> StringUtils.isNotEmpty((CharSequence)trainImageModel.getUserName())).map(TrainImageModel::getUserName).collect(Collectors.toSet());
        DynamicObject[] trainOrders = dao.query(new QFilter("passegername", "in", nameSet).and(new QFilter("server", "=", (Object)server)));
        if (trainOrders == null || trainOrders.length == 0) {
            return new HashMap<String, Map<String, DynamicObject>>();
        }
        HashSet waitDealBills = Sets.newHashSetWithExpectedSize((int)16);
        Set orderIds = trainImages.stream().filter(trainImageModel -> StringUtils.isNotEmpty((CharSequence)trainImageModel.getOrderId())).map(TrainImageModel::getOrderId).collect(Collectors.toSet());
        for (DynamicObject trainOrder : trainOrders) {
            String ordernum = trainOrder.getString("ordernum");
            if (ordernum.contains("-")) {
                ordernum = ordernum.substring(0, ordernum.indexOf("-"));
            }
            if (!orderIds.contains(ordernum)) continue;
            waitDealBills.add(trainOrder);
        }
        Iterator<DynamicObject> iterator = waitDealBills.iterator();
        Map<String, TrainImageModel> orderModelMap = trainImages.stream().collect(Collectors.toMap(AbstractOrderModel::getOrderNum, Function.identity()));
        this.dealTrainBill(orderMapping, iterator, orderModelMap);
        this.dealTrainCheckingBill(server, orderMapping, checkingOrderMapping, waitDealBills);
        this.saveData(orderMapping, checkingOrderMapping);
        resultMap.put("er_trainbill", orderMapping);
        resultMap.put("er_traincheckingbill", checkingOrderMapping);
        return resultMap;
    }

    private void dealTrainCheckingBill(String server, Map<String, DynamicObject> orderMapping, Map<String, DynamicObject> checkingOrderMapping, HashSet<DynamicObject> waitDealBills) {
        Set orderNumFilter;
        IErDao checkingDetailDao = ErDaoFactory.getInstance("er_traincheckingbill");
        DynamicObject[] checkingBills = checkingDetailDao.query("id, ordernum,trainticketnum,downloadlink,kddownloadlink,serialno,invoiceidentityflag,identityerrormsg,settlemain,formid", new QFilter[]{new QFilter("ordernum", "in", orderNumFilter = waitDealBills.stream().filter(dynamicObject -> StringUtils.isNotEmpty((CharSequence)dynamicObject.getString("ordernum"))).map(dynamicObject -> dynamicObject.getString("ordernum")).collect(Collectors.toSet())), new QFilter("server", "=", (Object)server)});
        if (checkingBills == null || checkingBills.length == 0) {
            return;
        }
        for (DynamicObject checkingDetail : checkingBills) {
            String orderNum = checkingDetail.getString("ordernum");
            DynamicObject order = orderMapping.get(orderNum);
            if (null == order || StringUtils.isEmpty((CharSequence)order.getString("downloadlink"))) continue;
            checkingDetail.set("downloadlink", (Object)order.getString("downloadlink"));
            checkingDetail.set("kddownloadlink", (Object)order.getString("kddownloadlink"));
            checkingDetail.set("trainticketnum", (Object)order.getString("trainticketnum"));
            checkingOrderMapping.put(orderNum, checkingDetail);
        }
    }

    private void dealTrainBill(Map<String, DynamicObject> orderMapping, Iterator<DynamicObject> iterator, Map<String, TrainImageModel> orderModelMap) {
        String tempSuffixes = suffixes;
        String type = "pdf";
        while (iterator.hasNext()) {
            TrainImageModel trainImageModel;
            DynamicObject order = iterator.next();
            String ordernum = order.getString("ordernum");
            if (ordernum.contains("-")) {
                ordernum = ordernum.substring(0, ordernum.indexOf("-"));
            }
            if ((trainImageModel = orderModelMap.get(ordernum + "-" + order.getString("passegername"))) == null) continue;
            if (StringUtils.isNotEmpty((CharSequence)trainImageModel.getImageSuffixes())) {
                tempSuffixes = trainImageModel.getImageSuffixes();
            }
            Pattern pat = Pattern.compile("[\\w]+[\\.](" + tempSuffixes + ")");
            if (StringUtils.isNotEmpty((CharSequence)trainImageModel.getImageAddress())) {
                String decryptAddress = RSAUtils.decrypt(trainImageModel.getImageAddress());
                Matcher mc = pat.matcher(decryptAddress);
                while (mc.find()) {
                    String name = mc.group();
                    logger.info("dealTrainImages>>> matchname{}", (Object)name);
                    type = name.substring(name.lastIndexOf(".") + 1);
                }
                logger.info("dealTrainImages>>>type:{}", (Object)type);
                order.set("downloadlink", (Object)decryptAddress);
                String path = ErFileServiceHelper.uploadFile(decryptAddress, trainImageModel.getServer() + "_" + trainImageModel.getOrderId() + "." + type, "/tripplane/");
                order.set("kddownloadlink", (Object)path);
            }
            order.set("trainticketnum", (Object)trainImageModel.getTrainTicketNum());
            orderMapping.put(order.getString("ordernum"), order);
        }
    }

    protected void validateBeforeSave(List<? extends AbstractOrderModel> orders) {
    }

    protected void handleBeforeSave(Map<String, Map<String, DynamicObject>> orderMapping) {
    }

    protected void handleAfterSave(Map<String, Map<String, DynamicObject>> orderMapping) {
    }

    public void handlePlaneImageExtCovert(PlaneOrderModel planeOrderModel, JSONObject planeJsonInfo) {
    }

    public void handleTrainImageExtCovert(TrainImageModel trainImageModel, JSONObject trainJsonInfo) {
    }
}

