/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.trip.service.function;

import com.alibaba.fastjson.JSONObject;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.er.business.trip.model.InvoiceExistDataModel;
import kd.fi.er.business.trip.model.InvoiceModel;
import kd.fi.er.business.trip.service.function.template.InPutFunctionTemp;
import kd.fi.er.business.trip.service.validate.Validate;
import kd.fi.er.business.trip.util.TripSyncConfigUtil;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractInvoiceReceiveInvoke<T>
extends InPutFunctionTemp {
    private static final Log logger = LogFactory.getLog(AbstractInvoiceReceiveInvoke.class);

    public AbstractInvoiceReceiveInvoke() {
    }

    public AbstractInvoiceReceiveInvoke(Map params) {
        super(params);
    }

    @Override
    protected String supplier() {
        return null;
    }

    @Override
    protected String function() {
        return "invoiceReceiveInvoke";
    }

    @Override
    protected void saveInfos(Object infos) {
        this.saveInvoice(infos);
        logger.info("\u5546\u65c5\u96c6\u6210,\u53d1\u7968\u63a5\u6536\u4fdd\u5b58,end");
    }

    private void saveInvoice(Object infos) {
        List invoices = (List)infos;
        if (invoices == null || invoices.size() == 0) {
            return;
        }
        if (TripSyncConfigUtil.getBoolean("trip_sync_orderbill_isverify_mustinput")) {
            StringBuilder message = new StringBuilder();
            for (InvoiceModel invoice : invoices) {
                Validate result = invoice.validate();
                if (result.result.success) continue;
                message.append(invoice.getTrdInvoiceId()).append(':').append(result.result.message.toString());
            }
            if (StringUtils.isNotBlank((CharSequence)message.toString())) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6821\u9a8c\u51fa\u9519:%s", (String)"AbstractInvoiceReceiveInvoke_0", (String)"fi-er-business", (Object[])new Object[0]), message));
            }
        }
        this.validateBeforeSave(invoices);
        InvoiceExistDataModel model = new InvoiceExistDataModel();
        try {
            for (InvoiceModel invoice : invoices) {
                invoice.addExistDataFilter(model);
            }
            model.query();
            for (InvoiceModel invoice : invoices) {
                invoice.generateData();
            }
            this.handleBeforeSave(model.getInvoiceMapping());
            model.save();
        }
        catch (Exception e) {
            logger.error("\u5546\u65c5\u96c6\u6210,\u53d1\u7968\u63a5\u6536\u4fdd\u5b58,\u5931\u8d25:", (Throwable)e);
            throw e;
        }
        this.handleAfterSave(model.getInvoiceMapping());
    }

    protected void validateBeforeSave(List<InvoiceModel> invoices) {
    }

    protected void handleBeforeSave(Map<String, DynamicObject> invoiceMapping) {
    }

    protected void handleAfterSave(Map<String, DynamicObject> invoiceMapping) {
    }

    protected void handleInvoiceReceiveExtConvert(InvoiceModel invoiceModel, JSONObject invoiceJsonInfo) {
    }

    protected void handleInvoiceGetExtConvert(List<InvoiceModel> invoiceModel, JSONObject invoiceJsonInfo) {
    }
}

