/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.trip.supplier.ctrip.invoke;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.er.business.servicehelper.HttpServiceHelper;
import kd.fi.er.business.trip.service.function.AbstractTripBudgetInvoke;
import kd.fi.er.business.trip.supplier.Supplier;
import kd.fi.er.business.trip.supplier.ctrip.systemexternal.CorpSync;
import kd.fi.er.business.trip.util.TripCommonUtil;
import org.apache.commons.codec.digest.DigestUtils;

public class CTripBudgetInvoke
extends AbstractTripBudgetInvoke {
    private static final Log logger = LogFactory.getLog(CTripBudgetInvoke.class);

    @Override
    protected String supplier() {
        return Supplier.XIECHENG.name();
    }

    @Override
    protected Object getInnerData() {
        Long billId = Long.parseLong(this.getParams().get("billId").toString());
        this.tripSyncLogParam.setBillid(String.valueOf(billId));
        QFilter qFilter = new QFilter("id", "=", (Object)billId);
        DynamicObject info = QueryServiceHelper.queryOne((String)"er_tripreqbill", (String)"billno,approveamount", (QFilter[])new QFilter[]{qFilter});
        if (info == null) {
            this.tripSyncLogParam.setStatus("B");
            this.tripSyncLogParam.setMessage(String.format(ResManager.loadKDString((String)"\u6839\u636e\u51fa\u5dee\u5355ID\uff1a%s\uff0c\u672a\u627e\u5230\u51fa\u5dee\u5355\u6570\u636e\u3002", (String)"AbstractTripReqBillInvoke_0", (String)"fi-er-business", (Object[])new Object[0]), billId));
        } else {
            this.tripSyncLogParam.setBillno((String)info.get("billno"));
        }
        return info;
    }

    protected Object convert(Object info) {
        if (info == null) {
            return null;
        }
        logger.info("\u5546\u65c5\u96c6\u6210,\u643a\u7a0b\u9884\u7b97\u843d\u5730\u63a5\u53e3\u6570\u636e\u540c\u6b65,convert");
        DynamicObject reqBill = (DynamicObject)info;
        String billNo = reqBill.getString("billno");
        Map<String, String> corpMap = TripCommonUtil.getTripServiceInfo(Supplier.XIECHENG.name());
        if (corpMap == null) {
            return null;
        }
        String appSecurity = corpMap.get("appsecurity");
        JSONObject data = new JSONObject();
        JSONObject budgetInfo = new JSONObject();
        budgetInfo.put("Products", (Object)"543");
        BigDecimal amount = reqBill.getBigDecimal("approveamount");
        if (BigDecimal.ZERO.compareTo(amount) == 0) {
            this.tripSyncLogParam.setStatus("A");
            logger.info("\u5546\u65c5\u96c6\u6210,\u643a\u7a0b\u9884\u7b97\u843d\u5730\u63a5\u53e3\u6570\u636e\u540c\u6b65,\u91d1\u989d\u4e3a0,\u4e0d\u540c\u6b65,\u89c6\u4f5c\u8c03\u7528\u6210\u529f,\u5355\u636e\u7f16\u53f7\uff1a{}", (Object)billNo);
            return null;
        }
        budgetInfo.put("BudgetAmount", (Object)String.valueOf(amount));
        List<JSONObject> budgetInfoList = Collections.singletonList(budgetInfo);
        data.put("BudgetInfoList", budgetInfoList);
        try {
            JSONObject auth = CorpSync.getAuthentification();
            data.put("Auth", (Object)auth);
        }
        catch (KDBizException e) {
            this.tripSyncLogParam.setRequesturl("https://ct.ctrip.com/SwitchAPI/Order/Ticket");
            this.tripSyncLogParam.setStatus("B");
            throw new KDBizException(new ErrorCode("doPost", String.format(ResManager.loadKDString((String)"\u6267\u884c\u8bf7\u6c42\u8fc7\u7a0b\u4e2d\u51fa\u73b0\u5f02\u5e38\u3002%s", (String)"CTripReqbillInvoke_0", (String)"fi-er-business", (Object[])new Object[0]), new Object[]{e})), new Object[0]);
        }
        data.put("ApprovalNumber", (Object)billNo);
        data.put("Signature", (Object)CTripBudgetInvoke.createSign(billNo, appSecurity, budgetInfoList));
        data.put("ActionType", (Object)"cover");
        return data;
    }

    protected String batPushProcess(Object object) {
        JSONObject status;
        if (object == null) {
            String code = null;
            if ("A".equals(this.tripSyncLogParam.getStatus())) {
                code = "200";
            }
            return code;
        }
        String reqString = JSONObject.toJSONString((Object)object);
        String url = "https://corpsz.ctrip.com/PreApproval/saveBudget";
        this.tripSyncLogParam.setRequestdata(object);
        this.tripSyncLogParam.setRequesturl(url);
        String result = HttpServiceHelper.PostData(url, reqString);
        this.tripSyncLogParam.setResponsedata(result);
        JSONObject resultObject = JSONObject.parseObject((String)result);
        if (resultObject != null && (status = resultObject.getJSONObject("status")) != null) {
            Boolean success = status.getBoolean("success");
            Integer errorCode = status.getInteger("errorCode");
            if (success.booleanValue() && errorCode != null && errorCode == 0) {
                return "200";
            }
        }
        return null;
    }

    private static String createSign(String approvalNumber, String appSecurity, List<JSONObject> budgetInfoList) {
        if (approvalNumber == null || appSecurity == null || budgetInfoList == null || budgetInfoList.size() == 0) {
            logger.error("\u643a\u7a0b\u9884\u7b97\u843d\u5730\uff0c\u52a0\u5bc6\u53c2\u6570\u5f02\u5e38");
            return "";
        }
        StringBuilder budgetStr = new StringBuilder();
        for (JSONObject budgetInfo : budgetInfoList) {
            budgetStr.append(budgetInfo.get((Object)"Products")).append(budgetInfo.get((Object)"BudgetAmount"));
        }
        String plainText = approvalNumber + budgetStr + DigestUtils.sha1Hex((String)appSecurity);
        return DigestUtils.sha1Hex((String)plainText);
    }
}

