/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.trip.supplier.ctrip.invoke;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.er.business.servicehelper.HttpRetryServiceHelper;
import kd.fi.er.business.trip.exception.TripException;
import kd.fi.er.business.trip.exception.TripSyncLogParam;
import kd.fi.er.business.trip.model.InvoiceModel;
import kd.fi.er.business.trip.service.function.AbstractInvoiceReceiveInvoke;
import kd.fi.er.business.trip.supplier.Supplier;
import kd.fi.er.business.trip.supplier.ctrip.systemexternal.CorpSync;
import kd.fi.er.business.utils.ErCommonUtils;

public class CTripInvoiceReceiveInvoke
extends AbstractInvoiceReceiveInvoke<JSONObject> {
    private static final Log logger = LogFactory.getLog(CTripInvoiceReceiveInvoke.class);

    public CTripInvoiceReceiveInvoke() {
    }

    public CTripInvoiceReceiveInvoke(Map<String, List<Object>> params) {
        super(params);
    }

    @Override
    protected String supplier() {
        return Supplier.XIECHENG.name();
    }

    protected Object process(Map params) throws TripException {
        if (params == null || params.isEmpty()) {
            return null;
        }
        Object data = params.get("jsondata");
        if (null != data) {
            JSONObject ret = new JSONObject();
            ret.put("invoices", data);
            return ret;
        }
        ErCommonUtils.removeKeyFromAppCache("CTripInvoiceReceiveInvoke" + RequestContext.get().getTenantId());
        Map maps = params;
        JSONArray array = new JSONArray();
        for (Map.Entry entry : maps.entrySet()) {
            TripSyncLogParam currentLog;
            List invoiceOrderIds;
            String accountId = (String)entry.getKey();
            JSONObject invoiceDetail = this.getInvoiceDetail(accountId, invoiceOrderIds = (List)entry.getValue(), currentLog = this.tripSyncLogParam.clone());
            if (0 == invoiceDetail.getJSONObject("Status").getInteger("ErrorCode")) {
                array.add((Object)invoiceDetail);
            } else {
                currentLog.setStatus("B");
                logger.info("\u5546\u65c5\u96c6\u6210,\u643a\u7a0b\u53d1\u7968\u63a5\u6536,\u83b7\u53d6\u53d1\u7968\u51fa\u9519:" + invoiceDetail.getJSONObject("Status").getInteger("ErrorCode"));
            }
            this.tripSyncLogParamList.add(currentLog);
        }
        JSONObject ret = new JSONObject();
        ret.put("invoices", (Object)array);
        logger.info("\u5546\u65c5\u96c6\u6210,\u643a\u7a0b\u53d1\u7968\u63a5\u6536,\u8fd4\u56de\u7ed3\u679cret:" + ret);
        return ret;
    }

    private JSONObject getInvoiceDetail(String accountID, List<Object> invoiceOrderIds, TripSyncLogParam currentLog) {
        JSONObject auth = CorpSync.getCacheAuthentification("CTripInvoiceReceiveInvoke");
        JSONObject paramJson = new JSONObject();
        paramJson.put("Auth", (Object)auth);
        paramJson.put("AccountID", (Object)accountID);
        paramJson.put("CustInvSequences", invoiceOrderIds);
        String jsonStr = paramJson.toJSONString();
        currentLog.setBillid(accountID);
        currentLog.setRequestdata(jsonStr);
        currentLog.setRequesturl("https://ct.ctrip.com/SwitchApi/CorpSettlement/GetInvoiceDetail");
        JSONObject retJson = HttpRetryServiceHelper.doPost("https://ct.ctrip.com/SwitchApi/CorpSettlement/GetInvoiceDetail", jsonStr, JSONObject.class);
        currentLog.setResponsedata(retJson);
        return retJson;
    }

    protected Object convert(Object t) throws TripException {
        ArrayList<InvoiceModel> list = new ArrayList<InvoiceModel>();
        JSONArray jsonArray = ((JSONObject)t).getJSONArray("invoices");
        for (int i = 0; i < jsonArray.size(); ++i) {
            JSONArray invoiceDetails = jsonArray.getJSONObject(i).getJSONArray("InvoiceDetailList");
            for (int k = 0; k < invoiceDetails.size(); ++k) {
                JSONObject invoiceDetail = invoiceDetails.getJSONObject(k).getJSONObject("InvoiceInfo");
                JSONArray invoiceItemInfos = invoiceDetails.getJSONObject(k).getJSONArray("InvoiceItemInfoList");
                InvoiceModel model = new InvoiceModel();
                model.setServer(this.supplier());
                model.setTrdInvoiceId(invoiceDetail.getString("CustInvSequence"));
                model.setInvoicenum(invoiceDetail.getString("InvNr"));
                model.setInvoicecode(invoiceDetail.getString("InvCode"));
                model.setCustInvSequence(invoiceDetail.getString("CustInvSequence"));
                model.setInvoiceamount(this.getTaxAmount(invoiceItemInfos)[1]);
                model.setTaxamount(this.getTaxAmount(invoiceItemInfos)[0]);
                this.handleInvoiceReceiveExtConvert(model, invoiceDetail);
                list.add(model);
            }
        }
        return list;
    }

    private BigDecimal[] getTaxAmount(JSONArray invoiceItemInfos) {
        BigDecimal[] result = new BigDecimal[]{BigDecimal.ZERO, BigDecimal.ZERO};
        for (int i = 0; i < invoiceItemInfos.size(); ++i) {
            result[0] = result[0].add(invoiceItemInfos.getJSONObject(i).getBigDecimal("Tax"));
            result[1] = result[1].add(invoiceItemInfos.getJSONObject(i).getBigDecimal("Amount"));
        }
        return result;
    }
}

