/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.trip.supplier.ctrip.invoke;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.er.business.servicehelper.CommonServiceHelper;
import kd.fi.er.business.trip.service.function.AbstractLoginInvoke;
import kd.fi.er.business.trip.supplier.Supplier;
import kd.fi.er.business.trip.supplier.ctrip.systemexternal.CorpSync;
import kd.fi.er.business.trip.util.TripCityUtil;
import kd.fi.er.business.trip.util.TripCommonUtil;
import kd.fi.er.business.trip.util.TripSyncConfigUtil;
import org.apache.commons.lang3.StringUtils;

public class CTripLoginInvoke
extends AbstractLoginInvoke {
    private static final List<String> LANGUAGES = Collections.unmodifiableList(Lists.newArrayList((Object[])new String[]{"zh-TW", "zh-CN", "en-US"}));
    private static final Log logger = LogFactory.getLog(CTripLoginInvoke.class);

    public CTripLoginInvoke() {
    }

    public CTripLoginInvoke(Map<String, Object> param) {
        super(param);
    }

    @Override
    public String login() {
        Map<String, String> corpMap = TripCommonUtil.getTripServiceInfo(Supplier.XIECHENG.name());
        String token = CorpSync.getTicket("https://ct.ctrip.com/corpservice/authorize/getticket", corpMap);
        Boolean isPC = (Boolean)this.param.get("isPC");
        String url = "";
        url = isPC != false ? this.getPCLoginUrl(corpMap, token) : this.getH5SignUrl(corpMap, token);
        logger.info("\u5546\u65c5\u96c6\u6210,\u643a\u7a0b\u767b\u5f55,loginUrl:" + url);
        return url;
    }

    private String getH5SignUrl(Map<String, String> corpMap, String token) {
        String language;
        String accessUserId = corpMap.get("appkey");
        String appSecurity = corpMap.get("appsecurity");
        String appid = corpMap.get("orationid");
        String employeeId = this.param.get("employeeNumber") != null ? (String)this.param.get("employeeNumber") : "";
        String initPage = this.param.get("InitPage") != null ? (String)this.param.get("InitPage") : "";
        String corpPayType = "public";
        String signature = CommonServiceHelper.getMD5(accessUserId + employeeId + corpPayType + CommonServiceHelper.getMD5(appSecurity).toLowerCase()).toLowerCase();
        String site = this.param.get("site") != null ? (String)this.param.get("site") : "";
        String orderNumber = this.param.get("orderNumber") != null ? (String)this.param.get("orderNumber") : "";
        String businessType = (String)this.param.get("businessType");
        String loginHtml = "triplogin.html";
        RequestContext requestContext = RequestContext.get();
        String clientFullContextPath = requestContext.getClientFullContextPath();
        String callback = clientFullContextPath + "mobile.html?form=er_mainpage";
        IFormView formView = (IFormView)this.param.get("view");
        String appID = formView.getFormShowParameter().getAppId();
        if ("exp".equals(appID)) {
            callback = clientFullContextPath + "mobile.html?form=er_mainpage_daily";
        }
        if (null == (language = requestContext.getLang().getLangTag()) || !LANGUAGES.contains(language)) {
            language = Lang.defaultLang().getLangTag();
        }
        if ("en-US".equals(language)) {
            language = "en";
        }
        StringBuilder sBuilder = new StringBuilder(clientFullContextPath);
        if ("domair".equals(businessType)) {
            initPage = "FlightSearch";
        } else if ("hotel".equals(businessType)) {
            initPage = "HotelSearch";
        } else if ("car".equals(businessType)) {
            initPage = "CarOC";
        } else if ("train".equals(businessType)) {
            initPage = "TrainSearch";
        } else if ("home".equals(businessType)) {
            initPage = "Home";
        }
        if (this.param.get("dotneedreqbill") != null && !"car".equals(businessType) || "home".equals(businessType)) {
            String url = "https://ct.ctrip.com/m/SingleSignOn/H5SignInfo";
            StringBuilder params = new StringBuilder();
            params.append("accessuserid=").append(accessUserId).append("&employeeid=").append(employeeId).append("&token=").append(token).append("&appid=").append(appid).append("&signature=").append(signature).append("&initpage=").append(initPage).append("&Language=").append(language).append("&callback=").append(callback);
            logger.info("\u5546\u65c5\u96c6\u6210\uff0c\u643a\u7a0bH5 params:{}", (Object)params.toString());
            try {
                byte[] textByte = params.toString().getBytes("UTF-8");
                String encodedText = Base64.getEncoder().encodeToString(textByte);
                url = url + "?SsoData=" + encodedText;
            }
            catch (UnsupportedEncodingException | KDBizException e) {
                logger.error("\u5546\u65c5\u96c6\u6210\uff0c\u643a\u7a0bH5\u8f6c\u7801\u5931\u8d25\uff01" + e);
                throw new KDBizException(ResManager.loadKDString((String)"\u5546\u65c5\u96c6\u6210\u7684\u643a\u7a0bH5\u8f6c\u7801\u5931\u8d25\u3002", (String)"CTripLoginInvoke_0", (String)"fi-er-business", (Object[])new Object[0]));
            }
            return url;
        }
        String endorsementID = this.param.get("applyBillNumber") != null ? (String)this.param.get("applyBillNumber") : "";
        String trip_start_date = (String)this.param.get("startDate");
        String trip_end_date = (String)this.param.get("endDate");
        String startDate = TripCommonUtil.dateStr2DateStr(trip_start_date, "yyyy-MM-dd", "yyyy-M-d");
        String endDate = TripCommonUtil.dateStr2DateStr(trip_end_date, "yyyy-MM-dd", "yyyy-M-d");
        Map<String, String> cityMap = TripCityUtil.getCityInfo(this.param.get("fromId"), this.param.get("toId"));
        String fromCode = cityMap.get("fromCode") != null ? cityMap.get("fromCode") : "";
        String toCode = cityMap.get("toCode") != null ? cityMap.get("toCode") : "";
        String toID = cityMap.get("toID") != null ? cityMap.get("toID") : "";
        String fullFromCityId = cityMap.get("fromFullCityID") != null ? cityMap.get("fromFullCityID") : "";
        String fullToCityId = cityMap.get("toFullCityID") != null ? cityMap.get("toFullCityID") : "";
        HashMap<String, String> paramsMap = new HashMap<String, String>(8);
        paramsMap.put("accessuserid", accessUserId);
        paramsMap.put("employeeid", employeeId);
        paramsMap.put("signature", signature);
        paramsMap.put("initpage", initPage);
        paramsMap.put("appid", appid);
        paramsMap.put("endorsementID", endorsementID);
        paramsMap.put("token", token);
        paramsMap.put("site", site);
        paramsMap.put("orderNumber", orderNumber);
        paramsMap.put("callback", callback);
        paramsMap.put("FlightSearchType", "S");
        paramsMap.put("Ddate", startDate);
        paramsMap.put("Adate", endDate);
        paramsMap.put("DCityCode", fromCode);
        paramsMap.put("ACityCode", toCode);
        paramsMap.put("IsOversea", "F");
        paramsMap.put("corpPayType", "public");
        paramsMap.put("CityID", toID);
        paramsMap.put("CheckInDate", startDate);
        paramsMap.put("CheckOutDate", endDate);
        paramsMap.put("DCityId", fullFromCityId);
        paramsMap.put("ACityId", fullToCityId);
        paramsMap.put("Language", language);
        paramsMap.put("action", "https://ct.ctrip.com/m/SingleSignOn/H5SignInfo");
        String url = sBuilder.append("timeline/trip/corp/gen/").append(loginHtml).toString();
        try {
            return url + "?paramsMap=" + URLEncoder.encode(JSON.toJSONString(paramsMap), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    private String getPCLoginUrl(Map<String, String> corpMap, String token) {
        String loginHtml = "triplogin.html";
        HashMap<String, Object> paramsMap = new HashMap<String, Object>(8);
        RequestContext requestContext = RequestContext.get();
        String clientFullContextPath = requestContext.getClientFullContextPath();
        StringBuilder sBuilder = new StringBuilder(clientFullContextPath);
        String url = sBuilder.append("timeline/trip/corp/gen/").append(loginHtml).toString();
        Boolean dotNeedReqBill = this.param.getOrDefault("dotneedreqbill", Boolean.FALSE);
        String appKey = corpMap.get("appkey");
        String appSecurity = corpMap.get("appsecurity");
        String employeeId = this.param.get("employeeNumber") != null ? (String)this.param.get("employeeNumber") : "";
        String forCorp = "0";
        String searchType = "";
        String billno = this.param.get("applyBillNumber") != null ? (String)this.param.get("applyBillNumber") : "";
        String signature = CommonServiceHelper.getMD5(appKey + employeeId + billno + forCorp + CommonServiceHelper.getMD5(appSecurity).toLowerCase()).toLowerCase();
        String businessType = (String)this.param.get("businessType");
        String language = RequestContext.get().getLang().getLangTag();
        if (null == language || !LANGUAGES.contains(language)) {
            language = Lang.defaultLang().getLangTag();
        }
        if ("zh-TW".equals(language)) {
            language = "zh-HK";
        }
        String initPage = "";
        if ("domair".equals(businessType)) {
            initPage = "FlightHome";
        } else if ("intair".equals(businessType)) {
            initPage = "FlightIntlHome";
        } else if ("hotel".equals(businessType)) {
            initPage = "HotelHome";
        } else if ("inthotel".equals(businessType)) {
            initPage = "HotelIntlHome";
        } else if ("car".equals(businessType)) {
            initPage = "CarHome";
        } else if ("train".equals(businessType)) {
            initPage = "TrainHome";
        } else if ("home".equals(businessType)) {
            initPage = "Home";
        }
        paramsMap.put("action", "https://ct.ctrip.com/corpservice/authorize/login");
        Integer loginmode = dotNeedReqBill != false ? 0 : TripSyncConfigUtil.getIntValue("ctrip_login_mode", 1);
        paramsMap.put("AppKey", appKey);
        paramsMap.put("Ticket", token);
        paramsMap.put("EmployeeID", employeeId);
        paramsMap.put("Signature", signature);
        paramsMap.put("TA", billno);
        paramsMap.put("CurrentLang", language);
        paramsMap.put("initPage", initPage);
        paramsMap.put("language", language);
        if (loginmode == 0 || StringUtils.equals((CharSequence)businessType, (CharSequence)"home")) {
            try {
                return url + "?paramsMap=" + URLEncoder.encode(JSON.toJSONString(paramsMap), "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        String startDate = (String)this.param.get("startDate");
        String endDate = (String)this.param.get("endDate");
        Map<String, String> cityMap = TripCityUtil.getCityInfo(this.param.get("fromId"), this.param.get("toId"));
        String fromCode = cityMap.get("fromCode") != null ? cityMap.get("fromCode") : "";
        String toCode = cityMap.get("toCode") != null ? cityMap.get("toCode") : "";
        String fromPinyin = cityMap.get("fromPinyin") != null ? cityMap.get("fromPinyin") : "";
        String toPinyin = cityMap.get("toPinyin") != null ? cityMap.get("toPinyin") : "";
        String toID = cityMap.get("toID") != null ? cityMap.get("toID") : "";
        Integer fullFromCityId = cityMap.get("fromFullCityID") != null ? Integer.valueOf(Integer.parseInt(cityMap.get("fromFullCityID"))) : null;
        Integer fullToCityId = cityMap.get("toFullCityID") != null ? Integer.valueOf(Integer.parseInt(cityMap.get("toFullCityID"))) : null;
        boolean isUsedFullCityId = Boolean.parseBoolean(cityMap.get("isUsedFullCityId"));
        paramsMap.put("CorpPayType", "C");
        switch (businessType) {
            case "domair": {
                searchType = "1";
                paramsMap.put("SearchType", "1");
                paramsMap.put("FlightSearchType", "S");
                paramsMap.put("ClassType", "Y");
                paramsMap.put("PassengerType", "ADU");
                paramsMap.put("PassengerQuantity", 1);
                paramsMap.put("DDate1", startDate);
                paramsMap.put("DCity1", fromCode);
                paramsMap.put("ACity1", toCode);
                if (!isUsedFullCityId) break;
                if (fullFromCityId != null) {
                    paramsMap.put("DCityId1", fullFromCityId);
                }
                if (fullToCityId == null) break;
                paramsMap.put("ACityId1", fullToCityId);
                break;
            }
            case "intair": {
                paramsMap.put("SearchType", "2");
                paramsMap.put("FlightSearchType", "S");
                paramsMap.put("ClassType", "Y");
                paramsMap.put("PassengerType", "ADU");
                paramsMap.put("PassengerQuantity", 1);
                paramsMap.put("DDate1", startDate);
                paramsMap.put("DCity1", fromCode);
                paramsMap.put("ACity1", toCode);
                if (!isUsedFullCityId) break;
                if (fullFromCityId != null) {
                    paramsMap.put("DCityId1", fullFromCityId);
                }
                if (fullToCityId == null) break;
                paramsMap.put("ACityId1", fullToCityId);
                break;
            }
            case "hotel": {
                paramsMap.put("SearchType", "3");
                paramsMap.put("CityID", toID);
                paramsMap.put("CheckInDate", startDate);
                paramsMap.put("CheckOutDate", endDate);
                paramsMap.put("RoomNumber", "1");
                break;
            }
            case "inthotel": {
                paramsMap.put("SearchType", "4");
                paramsMap.put("CityID", toID);
                paramsMap.put("CheckInDate", startDate);
                paramsMap.put("CheckOutDate", endDate);
                paramsMap.put("RoomNumber", "1");
                break;
            }
            case "train": {
                paramsMap.put("SearchType", "5");
                paramsMap.put("From", fromPinyin);
                paramsMap.put("To", toPinyin);
                paramsMap.put("DDate", startDate);
                if (!isUsedFullCityId) break;
                if (fullFromCityId != null) {
                    paramsMap.put("FromCityId", fullFromCityId);
                }
                if (fullToCityId == null) break;
                paramsMap.put("ToCityId", fullToCityId);
            }
        }
        try {
            return url + "?paramsMap=" + URLEncoder.encode(JSON.toJSONString(paramsMap), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected void process(String loginString) {
        IFormView formView = (IFormView)this.param.get("view");
        formView.openUrl(loginString);
    }
}

