/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.trip.supplier.ctrip.invoke;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Sets;
import java.security.SecureRandom;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.fi.er.business.servicehelper.CoreBaseBillServiceHelper;
import kd.fi.er.business.servicehelper.HttpRetryServiceHelper;
import kd.fi.er.business.trip.exception.TripSyncLogParam;
import kd.fi.er.business.trip.exception.TripSyncLogUtils;
import kd.fi.er.business.trip.model.UserModel;
import kd.fi.er.business.trip.service.function.AbstractUserInvoke;
import kd.fi.er.business.trip.supplier.Supplier;
import kd.fi.er.business.trip.supplier.ctrip.systemexternal.CorpSync;
import kd.fi.er.business.trip.util.TripCommonUtil;
import kd.fi.er.business.trip.util.TripSyncConfigUtil;
import kd.fi.er.business.utils.TripUserGrantUtils;
import org.apache.commons.lang.StringUtils;

public class CTripUserInvoke
extends AbstractUserInvoke<Set<JSONObject>> {
    private static final Log logger = LogFactory.getLog(CTripUserInvoke.class);
    private static final String SUCCESS = "Success";
    public static final List<String> IGNORE_STATUS = Arrays.asList("1127", "1070");

    @Override
    protected String supplier() {
        return Supplier.XIECHENG.name();
    }

    @Override
    protected Object getInnerData(String changeTime, Integer pageIndex, Integer pageSize, Map<String, Object> map) {
        if (map == null) {
            map = new HashMap<String, Object>();
            map.put("params_sbaccount", TripSyncConfigUtil.getIntValue("Access_range_subaccount", 0));
        } else {
            map.put("params_sbaccount", TripSyncConfigUtil.getIntValue("Access_range_subaccount", 0));
        }
        return super.getInnerData(changeTime, pageIndex, pageSize, map);
    }

    public Set<JSONObject> convert(Object s) {
        int batch;
        Set set = (Set)s;
        HashSet<JSONObject> userJsonObject = new HashSet<JSONObject>();
        int batchTemp = batch = TripSyncConfigUtil.getIntValue("trip_sync_org_user_size", 10);
        JSONArray userBatch = new JSONArray();
        HashSet notSubAccountSet = Sets.newHashSetWithExpectedSize((int)16);
        HashSet numberSet = Sets.newHashSetWithExpectedSize((int)16);
        DynamicObjectCollection servers = TripUserGrantUtils.getServers(this.supplier());
        if (CollectionUtils.isNotEmpty((Collection)set) && CollectionUtils.isNotEmpty((Collection)servers)) {
            DynamicObjectCollection dynamicObjects = TripUserGrantUtils.queryUserGrantInfosByServer(Collections.singletonList(this.supplier()));
            Set grantUserNos = dynamicObjects.stream().map(dynamicObject -> dynamicObject.getString("grantuserno")).collect(Collectors.toSet());
            set = set.stream().filter(userModel -> grantUserNos.contains(userModel.getEmployeeID())).collect(Collectors.toSet());
        }
        DynamicObject serverData = QueryServiceHelper.queryOne((String)"er_biz_info", (String)"autoopened", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)this.supplier())});
        boolean autoopened = serverData.getBoolean("autoopened");
        for (UserModel user : set) {
            JSONObject userJson = new JSONObject();
            numberSet.add(user.getEmployeeID());
            if (!autoopened) {
                if (StringUtils.isNotEmpty((String)user.getSubaccountName())) {
                    userJson.put("SubAccountName", (Object)user.getSubaccountName());
                } else {
                    notSubAccountSet.add(user.getName() + "(" + user.getEmployeeID() + ")");
                    continue;
                }
            }
            --batchTemp;
            userJson.put("EmployeeID", (Object)user.getEmployeeID());
            int intValue = TripSyncConfigUtil.getIntValue("trip_Superior", 0, Arrays.asList(0, 1));
            if (intValue == 1) {
                userJson.put("SuperiorEID", (Object)user.getSuperiorEID());
            }
            userJson.put("Name", (Object)user.getName());
            userJson.put("MobilePhone", (Object)user.getMobilePhone());
            userJson.put("Email", (Object)user.getEmail());
            userJson.put("Dept1", (Object)user.getDept1());
            String Valid = user.getEnableFlag().equals("Y") ? "A" : "I";
            userJson.put("Valid", (Object)Valid);
            if (null != user.getDeptId() && !user.getDeptId().isEmpty() && !"null".equals(user.getDeptId())) {
                Long orgId = CoreBaseBillServiceHelper.getAccountOrgId(Long.parseLong(user.getDeptId()));
                Map orgMap = OrgUnitServiceHelper.getCompanyByAdminOrg((Long)orgId);
                if (null != orgId && 0L != orgId && null != orgMap) {
                    userJson.put("CostCenter", orgMap.get("name"));
                }
            }
            int paramValue = TripSyncConfigUtil.getIntValue("ctrip_personnel_rank", 2, Arrays.asList(1, 2, 3, 4, 5));
            DynamicObject dynamicObject2 = null;
            if (null != user.getDeptId() && !user.getDeptId().isEmpty() && !"null".equals(user.getDeptId())) {
                Long companyId = CoreBaseBillServiceHelper.initCompanyByDept(Long.parseLong(user.getDeptId()));
                dynamicObject2 = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_org", (String)"id,name,number", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)companyId)});
            }
            String reimburseleveName = user.getReimburseleveName();
            switch (paramValue) {
                case 1: {
                    if (null == dynamicObject2 || !StringUtils.isNotEmpty((String)reimburseleveName)) break;
                    userJson.put("RankName", (Object)(dynamicObject2.getString("number") + reimburseleveName));
                    break;
                }
                case 3: {
                    if (dynamicObject2 != null && StringUtils.isNotEmpty((String)reimburseleveName)) {
                        userJson.put("RankName", (Object)(dynamicObject2.getString("number") + reimburseleveName));
                        break;
                    }
                    if (dynamicObject2 == null || !StringUtils.isEmpty((String)reimburseleveName)) break;
                    String defaultName = ResManager.loadKDString((String)"\u666e\u901a\u5458\u5de5", (String)"CTripUserInvoke_0", (String)"fi-er-business", (Object[])new Object[0]);
                    userJson.put("RankName", (Object)(dynamicObject2.getString("number") + defaultName));
                    break;
                }
                case 4: {
                    if (StringUtils.isNotEmpty((String)reimburseleveName)) {
                        userJson.put("RankName", (Object)reimburseleveName);
                        break;
                    }
                    userJson.put("RankName", (Object)ResManager.loadKDString((String)"\u666e\u901a\u5458\u5de5", (String)"CTripUserInvoke_0", (String)"fi-er-business", (Object[])new Object[0]));
                    break;
                }
                case 5: {
                    if (dynamicObject2 != null && StringUtils.isNotBlank((String)reimburseleveName)) {
                        userJson.put("RankName", (Object)(dynamicObject2.getString("number") + reimburseleveName));
                        break;
                    }
                    if (!StringUtils.isBlank((String)reimburseleveName)) break;
                    userJson.put("RankName", (Object)ResManager.loadKDString((String)"\u666e\u901a\u5458\u5de5", (String)"CTripUserInvoke_0", (String)"fi-er-business", (Object[])new Object[0]));
                    break;
                }
                default: {
                    if (!StringUtils.isNotEmpty((String)reimburseleveName)) break;
                    userJson.put("RankName", (Object)reimburseleveName);
                }
            }
            JSONObject authenticationInfoObject = new JSONObject();
            authenticationInfoObject.put("Sequence", (Object)CTripUserInvoke.getSequence());
            authenticationInfoObject.put("Authentication", (Object)userJson);
            userBatch.add((Object)authenticationInfoObject);
            if (batchTemp != 0) continue;
            this.generateBatchJSON(userJsonObject, userBatch);
            batchTemp = batch;
            userBatch = new JSONArray();
        }
        this.tripSyncLogParam.setBillno(StringUtils.join((Collection)numberSet, (String)","));
        if (batchTemp != 0 && batchTemp != batch) {
            this.generateBatchJSON(userJsonObject, userBatch);
        }
        if (CollectionUtils.isNotEmpty((Collection)notSubAccountSet)) {
            String msg = String.join((CharSequence)",", notSubAccountSet);
            if (CollectionUtils.isEmpty(userJsonObject)) {
                this.tripSyncLogParam.setMessage(String.format(ResManager.loadKDString((String)"\u4eba\u5458\u672a\u8bbe\u7f6e\u643a\u7a0b\u5b50\u8d26\u6237,\u8bf7\u8bbe\u7f6e:%s", (String)"CTripUserInvoke_1", (String)"fi-er-business", (Object[])new Object[0]), msg));
                this.tripSyncLogParam.setStatus("B");
            } else {
                TripSyncLogParam tripSyncLog = new TripSyncLogParam(RequestContext.get().getTraceId(), this.supplier(), this.function());
                tripSyncLog.setMessage(String.format(ResManager.loadKDString((String)"\u4eba\u5458\u672a\u8bbe\u7f6e\u643a\u7a0b\u5b50\u8d26\u6237,\u8bf7\u8bbe\u7f6e:%s", (String)"CTripUserInvoke_1", (String)"fi-er-business", (Object[])new Object[0]), msg));
                tripSyncLog.setStatus("B");
                tripSyncLog.setBillno(StringUtils.join((Collection)numberSet, (String)","));
                TripSyncLogUtils.saveErrorLog(Collections.singletonList(tripSyncLog));
            }
        }
        return userJsonObject;
    }

    private static long getSequence() {
        long seq = 0L;
        SimpleDateFormat sf = new SimpleDateFormat("yyyyMMddHHmmss");
        String temp = sf.format(new Date());
        SecureRandom secRandom = new SecureRandom();
        int random = (int)(secRandom.nextDouble() * 10000.0);
        seq = Long.parseLong(temp + random);
        return seq;
    }

    private void generateBatchJSON(Set<JSONObject> userJsonObject, JSONArray userBatch) {
        JSONObject corpCustInfo = new JSONObject();
        Map<String, String> corpMap = TripCommonUtil.getTripServiceInfo(this.supplier());
        corpCustInfo.put("Language", null);
        corpCustInfo.put("Appkey", (Object)corpMap.get("appkey"));
        corpCustInfo.put("Ticket", (Object)CorpSync.getTicket("https://ct.ctrip.com/SwitchAPI/Order/Ticket", corpMap));
        corpCustInfo.put("CorporationID", (Object)corpMap.get("orationid"));
        corpCustInfo.put("AuthenticationInfoList", (Object)userBatch);
        userJsonObject.add(corpCustInfo);
    }

    protected String batPushProcess(Object set) {
        Set userJSONObjectSet = (Set)set;
        String code = "200";
        for (JSONObject postJson : userJSONObjectSet) {
            TripSyncLogParam currentLog = this.tripSyncLogParam.clone();
            currentLog.setRequestdata(postJson);
            currentLog.setRequesturl("https://ct.ctrip.com/corpservice/CorpCustService/SaveCorpCustInfoList");
            JSONObject backJson = HttpRetryServiceHelper.httpPost("https://ct.ctrip.com/corpservice/CorpCustService/SaveCorpCustInfoList", postJson, 50000);
            currentLog.setResponsedata(backJson);
            if (backJson != null) {
                if (null == backJson.get((Object)"Result") || !((String)backJson.get((Object)"Result")).equals(SUCCESS)) {
                    logger.info("\u5546\u65c5\u96c6\u6210,\u643a\u7a0b\u4eba\u5458,\u8fd4\u56de: " + backJson.toJSONString());
                    if (null != backJson.get((Object)"ErrorMessageList")) {
                        JSONArray errorMessageList = backJson.getJSONArray("ErrorMessageList");
                        for (Object o : errorMessageList) {
                            JSONObject errorMessage = (JSONObject)o;
                            if (null != errorMessage.get((Object)"ErrorCode") && IGNORE_STATUS.contains(errorMessage.getString("ErrorCode"))) continue;
                            code = "300";
                            break;
                        }
                        if (code.equals("300")) {
                            currentLog.setStatus("B");
                        }
                    } else {
                        code = "300";
                        currentLog.setStatus("B");
                    }
                }
            } else {
                currentLog.setStatus("B");
            }
            this.addTripSyncLogParam(currentLog);
            this.tripSyncLogParamList.add(currentLog);
        }
        return code;
    }

    @Override
    protected boolean syncUserByPage() {
        return true;
    }
}

