/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.trip.supplier.ctrip.invoke.convert;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import kd.fi.er.business.trip.model.AbstractCheckingBillDetailModel;
import kd.fi.er.business.trip.model.AbstractOrderModel;
import kd.fi.er.business.trip.model.HotelCheckingBillDetailModel;
import kd.fi.er.business.trip.model.HotelOrderModel;
import kd.fi.er.business.trip.supplier.Supplier;
import kd.fi.er.business.trip.util.CTripHotelUtil;
import kd.fi.er.business.trip.util.TripClassUtil;
import kd.fi.er.business.trip.util.TripCommonUtil;
import kd.fi.er.business.trip.util.TripSyncConfigUtil;
import kd.fi.er.business.utils.ActionLocalCache;
import org.apache.commons.lang3.StringUtils;

public class CTripHotelCheckingDetailConvert {
    public static List<HotelCheckingBillDetailModel> convert(JSONObject settlementInfoDetailObject) throws CloneNotSupportedException {
        String date;
        String accCheckBatchNo;
        boolean paramValue = (Boolean)ActionLocalCache.get().get("Split_hotel_settlement", "Split_hotel_settlement", () -> TripSyncConfigUtil.getBoolean("Split_hotel_settlement", Boolean.TRUE));
        ArrayList<HotelCheckingBillDetailModel> details = new ArrayList<HotelCheckingBillDetailModel>(4);
        HotelCheckingBillDetailModel hotelCheckingBillDetailModel = new HotelCheckingBillDetailModel();
        JSONObject settlementDetailObject = settlementInfoDetailObject.getJSONObject("SettlementDetail");
        settlementDetailObject = settlementDetailObject == null ? new JSONObject() : settlementDetailObject;
        JSONObject orderDetailObject = settlementInfoDetailObject.getJSONObject("OrderDetail");
        orderDetailObject = orderDetailObject == null ? new JSONObject() : orderDetailObject;
        JSONObject hotelDetailObject = settlementInfoDetailObject.getJSONObject("HotelDetail");
        hotelDetailObject = hotelDetailObject == null ? new JSONObject() : hotelDetailObject;
        hotelCheckingBillDetailModel.setParentordernum(settlementDetailObject.getOrDefault((Object)"OrderID", (Object)"").toString());
        String journeyID = orderDetailObject.getOrDefault((Object)"HotelRelatedJourneyNo", (Object)"").toString();
        hotelCheckingBillDetailModel.setOaBillNum(journeyID);
        hotelCheckingBillDetailModel.setBatchno(settlementDetailObject.getOrDefault((Object)"AccCheckBatchNo", (Object)"").toString());
        hotelCheckingBillDetailModel.setSubBatchno(settlementDetailObject.getOrDefault((Object)"SubAccCheckBatchNo", (Object)"").toString());
        hotelCheckingBillDetailModel.setServer(Supplier.XIECHENG.name());
        hotelCheckingBillDetailModel.setAccountID(settlementDetailObject.getIntValue("AccountId"));
        Date createTime = TripCommonUtil.strToDate(settlementDetailObject.getOrDefault((Object)"Createtime", (Object)"").toString(), "yyyy-MM-dd HH:mm:ss.SSS");
        Date orderDate = TripCommonUtil.strToDate(orderDetailObject.getOrDefault((Object)"OrderDate", (Object)"").toString(), "yyyy-MM-dd HH:mm:ss.SSS");
        hotelCheckingBillDetailModel.setOrderDate(orderDate);
        hotelCheckingBillDetailModel.setHappendDate(createTime);
        if (!TripSyncConfigUtil.getBoolean("ttrip_period_value", Boolean.TRUE).booleanValue() && (accCheckBatchNo = settlementDetailObject.getOrDefault((Object)"AccCheckBatchNo", (Object)"").toString()).contains("_") && (date = accCheckBatchNo.substring(accCheckBatchNo.lastIndexOf("_") + 1)).length() == 8) {
            Calendar cal = Calendar.getInstance();
            cal.set(Integer.parseInt(date.substring(0, 4)), Integer.parseInt(date.substring(4, 6)) - 1, Integer.parseInt(date.substring(6, 8)));
            cal.set(12, 0);
            cal.set(13, 0);
            cal.set(14, 0);
            hotelCheckingBillDetailModel.setHappendDate(cal.getTime());
        }
        BigDecimal amount = TripClassUtil.getDefaultBigDecimal(settlementDetailObject.getBigDecimal("Amount"));
        BigDecimal servicefee = TripClassUtil.getDefaultBigDecimal(settlementDetailObject.getBigDecimal("Servicefee"));
        BigDecimal extraCharge = TripClassUtil.getDefaultBigDecimal(settlementDetailObject.getBigDecimal("ExtraCharge"));
        BigDecimal frontendServiceFee = TripClassUtil.getDefaultBigDecimal(settlementDetailObject.getBigDecimal("FrontendServiceFee"));
        BigDecimal expressFee = TripClassUtil.getDefaultBigDecimal(settlementDetailObject.getBigDecimal("ExpressFee"));
        BigDecimal settlementPersonAmt = TripClassUtil.getDefaultBigDecimal(orderDetailObject.getBigDecimal("SettlementPersonAmt"));
        hotelCheckingBillDetailModel.setRoomAmount(amount.subtract(frontendServiceFee).subtract(expressFee).add(settlementPersonAmt).setScale(2, 4));
        if ("Y".equals(settlementDetailObject.getOrDefault((Object)"PayType", (Object)"Y").toString())) {
            hotelCheckingBillDetailModel.setServiceFee(frontendServiceFee.add(servicefee).setScale(2, 4));
            hotelCheckingBillDetailModel.setTotalAmount(amount.add(servicefee).add(extraCharge).setScale(2, 4));
        } else {
            hotelCheckingBillDetailModel.setServiceFee(servicefee.setScale(2, 4));
            hotelCheckingBillDetailModel.setTotalAmount(servicefee.setScale(2, 4));
        }
        hotelCheckingBillDetailModel.setPersonalFee(settlementPersonAmt);
        hotelCheckingBillDetailModel.setOrderNatrue(AbstractOrderModel.OrderNatrue.A);
        hotelCheckingBillDetailModel.setOrderType(AbstractOrderModel.OrderType.O);
        hotelCheckingBillDetailModel.setOrderNum(settlementDetailObject.getOrDefault((Object)"OrderID", (Object)"").toString());
        hotelCheckingBillDetailModel.setOrderStatus(HotelOrderModel.OrderStatus.G);
        hotelCheckingBillDetailModel.setProductType(CTripHotelCheckingDetailConvert.setProductType(settlementDetailObject.getOrDefault((Object)"PayType", (Object)"").toString()));
        hotelCheckingBillDetailModel.setSourceBookedId(orderDetailObject.getOrDefault((Object)"EmployeeID", (Object)"").toString());
        hotelCheckingBillDetailModel.setBookedname(orderDetailObject.getOrDefault((Object)"EmployeeName", (Object)"").toString());
        hotelCheckingBillDetailModel.setHotelName(hotelDetailObject.getOrDefault((Object)"HotelName", (Object)"").toString());
        if (null != hotelDetailObject.getBoolean("IsDomestic") && hotelDetailObject.getBoolean("IsDomestic").booleanValue()) {
            hotelCheckingBillDetailModel.setOrderSort(AbstractCheckingBillDetailModel.OrderSort.A);
            hotelCheckingBillDetailModel.setOperationType(AbstractOrderModel.OperationType.A);
        } else {
            hotelCheckingBillDetailModel.setOrderSort(AbstractCheckingBillDetailModel.OrderSort.B);
            hotelCheckingBillDetailModel.setOperationType(AbstractOrderModel.OperationType.E);
        }
        hotelCheckingBillDetailModel.setCheckindate(TripCommonUtil.strToDate(orderDetailObject.getOrDefault((Object)"StartTime", (Object)"").toString(), "yyyy-MM-dd HH:mm:ss.SSS"));
        hotelCheckingBillDetailModel.setCheckoutdate(TripCommonUtil.strToDate(orderDetailObject.getOrDefault((Object)"EndTime", (Object)"").toString(), "yyyy-MM-dd HH:mm:ss.SSS"));
        hotelCheckingBillDetailModel.setRoomstylename(orderDetailObject.getOrDefault((Object)"RoomName", (Object)"").toString());
        hotelCheckingBillDetailModel.setRoomcount(orderDetailObject.getIntValue("RoomQuantity"));
        hotelCheckingBillDetailModel.setCityName(hotelDetailObject.getOrDefault((Object)"CityName", (Object)"").toString());
        hotelCheckingBillDetailModel.setPriceBillingType(CTripHotelUtil.dealInvoiceType(orderDetailObject));
        JSONArray travelers = orderDetailObject.getJSONArray("ClientDetailList");
        travelers = travelers == null ? new JSONArray() : travelers;
        int size = travelers.size();
        String clientName = settlementDetailObject.getOrDefault((Object)"ClientName", (Object)"").toString();
        for (int j = 0; j < size; ++j) {
            BigDecimal personal_down;
            BigDecimal room_down;
            BigDecimal service_down;
            BigDecimal amount_down;
            JSONObject traveler;
            boolean breakFlag = false;
            HotelCheckingBillDetailModel checkingDetail = (HotelCheckingBillDetailModel)hotelCheckingBillDetailModel.clone();
            if (null == checkingDetail || null == (traveler = travelers.getJSONObject(j))) continue;
            checkingDetail.setSourcetravelerid(traveler.getOrDefault((Object)"EmployeeID", (Object)"").toString());
            String tmpClientName = traveler.getOrDefault((Object)"ClientName", (Object)"").toString();
            checkingDetail.setTravelername(tmpClientName);
            if (paramValue) {
                if (size > 1) {
                    checkingDetail.setOrderNum(hotelCheckingBillDetailModel.getOrderNum() + "-" + (j + 1));
                    amount_down = hotelCheckingBillDetailModel.getTotalAmount().divide(new BigDecimal(size), 2, 1);
                    service_down = hotelCheckingBillDetailModel.getServiceFee().divide(new BigDecimal(size), 2, 1);
                    room_down = hotelCheckingBillDetailModel.getRoomAmount().divide(new BigDecimal(size), 2, 1);
                    personal_down = hotelCheckingBillDetailModel.getPersonalFee().divide(new BigDecimal(size), 2, 1);
                    if (j == 0) {
                        BigDecimal amount_rest = hotelCheckingBillDetailModel.getTotalAmount().subtract(amount_down.multiply(new BigDecimal(size - 1)));
                        BigDecimal service_rest = hotelCheckingBillDetailModel.getServiceFee().subtract(service_down.multiply(new BigDecimal(size - 1)));
                        BigDecimal room_rest = hotelCheckingBillDetailModel.getRoomAmount().subtract(room_down.multiply(new BigDecimal(size - 1)));
                        BigDecimal personal_rest = hotelCheckingBillDetailModel.getPersonalFee().subtract(personal_down.multiply(new BigDecimal(size - 1)));
                        checkingDetail.setTotalAmount(amount_rest);
                        checkingDetail.setServiceFee(service_rest);
                        checkingDetail.setRoomAmount(room_rest);
                        checkingDetail.setPersonalFee(personal_rest);
                    } else {
                        checkingDetail.setTotalAmount(amount_down);
                        checkingDetail.setServiceFee(service_down);
                        checkingDetail.setRoomAmount(room_down);
                        checkingDetail.setPersonalFee(personal_down);
                    }
                }
            } else if (tmpClientName.equals(clientName)) {
                breakFlag = true;
                if (size > 1) {
                    checkingDetail.setOrderNum(hotelCheckingBillDetailModel.getOrderNum() + "-" + (j + 1));
                }
                amount_down = hotelCheckingBillDetailModel.getTotalAmount();
                service_down = hotelCheckingBillDetailModel.getServiceFee();
                room_down = hotelCheckingBillDetailModel.getRoomAmount();
                personal_down = hotelCheckingBillDetailModel.getPersonalFee();
                checkingDetail.setTotalAmount(amount_down);
                checkingDetail.setServiceFee(service_down);
                checkingDetail.setRoomAmount(room_down);
                checkingDetail.setPersonalFee(personal_down);
                if (StringUtils.isNotBlank((CharSequence)traveler.getString("ClientPreApprovalNo"))) {
                    checkingDetail.setOaBillNum(traveler.getString("ClientPreApprovalNo"));
                }
                if ("R".equals(settlementDetailObject.getOrDefault((Object)"DetailType", (Object)"").toString())) {
                    HotelCheckingBillDetailModel rCheckingDetail = (HotelCheckingBillDetailModel)checkingDetail.clone();
                    rCheckingDetail.setOrderNum(checkingDetail.getOrderNum() + "-T1");
                    rCheckingDetail.setOrderStatus(HotelOrderModel.OrderStatus.I);
                    rCheckingDetail.setOrderType(AbstractOrderModel.OrderType.T);
                    details.add(rCheckingDetail);
                    continue;
                }
            }
            if ("R".equals(settlementDetailObject.getOrDefault((Object)"DetailType", (Object)"").toString()) && paramValue) {
                HotelCheckingBillDetailModel rCheckingDetail = (HotelCheckingBillDetailModel)checkingDetail.clone();
                rCheckingDetail.setOrderNum(checkingDetail.getOrderNum() + "-T1");
                rCheckingDetail.setOrderStatus(HotelOrderModel.OrderStatus.I);
                rCheckingDetail.setOrderType(AbstractOrderModel.OrderType.T);
                details.add(rCheckingDetail);
                continue;
            }
            if (!paramValue && breakFlag) {
                details.add(checkingDetail);
            }
            if (paramValue) {
                details.add(checkingDetail);
            }
            if (breakFlag) break;
        }
        return details;
    }

    private static AbstractOrderModel.ProductType setProductType(String productType) {
        if ("Y".equals(productType)) {
            return AbstractOrderModel.ProductType.A;
        }
        return AbstractOrderModel.ProductType.B;
    }
}

