/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.trip.supplier.ctrip.invoke.convert;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.er.business.trip.model.AbstractOrderModel;
import kd.fi.er.business.trip.model.PlaneOrderModel;
import kd.fi.er.business.trip.supplier.Supplier;
import kd.fi.er.business.trip.supplier.ctrip.invoke.convert.ConvertUtil;
import kd.fi.er.business.trip.supplier.ctrip.systemexternal.CorpSync;
import kd.fi.er.business.trip.util.TripCommonUtil;
import org.apache.commons.lang3.StringUtils;

public class CTripPlaneOrderConvert {
    private static final Log logger = LogFactory.getLog(CTripPlaneOrderConvert.class);
    private static String[] USER_STATUS = new String[]{"2", "3", "4"};
    private static String[] REFUNDED_STATUS = new String[]{"5", "6"};
    private static String ACCNT = "ACCNT";

    public static List<AbstractOrderModel> convert(JSONObject planeObject) throws CloneNotSupportedException {
        JSONObject flightTicketPrintInfo;
        ArrayList<AbstractOrderModel> orderModels = new ArrayList<AbstractOrderModel>(4);
        PlaneOrderModel planeOrderModel = new PlaneOrderModel();
        JSONObject basicInfoObject = planeObject.getJSONObject("BasicInfo");
        JSONObject jSONObject = basicInfoObject = basicInfoObject == null ? new JSONObject() : basicInfoObject;
        if (null == basicInfoObject || basicInfoObject.isEmpty()) {
            return new ArrayList<AbstractOrderModel>();
        }
        if (null != basicInfoObject && !ACCNT.equals(basicInfoObject.getOrDefault((Object)"PrepayType", (Object)"").toString())) {
            return new ArrayList<AbstractOrderModel>();
        }
        planeOrderModel = CTripPlaneOrderConvert.handleBasicInfo(basicInfoObject);
        JSONArray flightInfoArray = planeObject.getJSONArray("FlightInfo");
        flightInfoArray = flightInfoArray == null ? new JSONArray() : flightInfoArray;
        JSONArray passengerInfoArray = planeObject.getJSONArray("PassengerInfo");
        passengerInfoArray = passengerInfoArray == null ? new JSONArray() : passengerInfoArray;
        String orderID = basicInfoObject.getOrDefault((Object)"OrderID", (Object)"").toString();
        for (int j = 0; j < passengerInfoArray.size(); ++j) {
            JSONObject passengerInfoObject = passengerInfoArray.getJSONObject(j);
            if (null == passengerInfoObject || passengerInfoObject.isEmpty()) continue;
            JSONObject passengerBasicObejct = passengerInfoObject.getJSONObject("PassengerBasic");
            passengerBasicObejct = passengerBasicObejct == null ? new JSONObject() : passengerBasicObejct;
            String passengerName = passengerBasicObejct.getOrDefault((Object)"PassengerName", (Object)"").toString();
            planeOrderModel.setTravelername(passengerName);
            planeOrderModel.setSourcetravelerid(passengerBasicObejct.getOrDefault((Object)"CorpEid", (Object)"").toString());
            JSONArray sequenceInfoArray = passengerInfoObject.getJSONArray("SequenceInfo");
            sequenceInfoArray = sequenceInfoArray == null ? new JSONArray() : sequenceInfoArray;
            for (int k = 0; k < sequenceInfoArray.size(); ++k) {
                JSONObject sequenceInfoObject = sequenceInfoArray.getJSONObject(k);
                JSONArray ticketInfoArray = sequenceInfoObject.getJSONArray("TicketInfo");
                JSONArray jSONArray = ticketInfoArray = ticketInfoArray == null ? new JSONArray() : ticketInfoArray;
                if (ticketInfoArray == null || ticketInfoArray.isEmpty()) continue;
                PlaneOrderModel seqplaneOrderModel = (PlaneOrderModel)planeOrderModel.clone();
                JSONObject ticketInfoObject = null;
                for (Object o : ticketInfoArray) {
                    if (Arrays.asList(USER_STATUS).contains(JSON.parseObject((String)JSON.toJSONString(o)).getOrDefault((Object)"Status", (Object)"").toString())) {
                        ticketInfoObject = JSON.parseObject((String)JSON.toJSONString(o));
                        break;
                    }
                    if (!Arrays.asList(REFUNDED_STATUS).contains(JSON.parseObject((String)JSON.toJSONString(o)).getOrDefault((Object)"Status", (Object)"").toString())) continue;
                    ticketInfoObject = JSON.parseObject((String)JSON.toJSONString(o));
                    break;
                }
                if (null == ticketInfoObject) {
                    ticketInfoObject = ticketInfoArray.getJSONObject(ticketInfoArray.size() - 1);
                }
                String ticketNo = CTripPlaneOrderConvert.handelTicketNo(ticketInfoObject.getOrDefault((Object)"TicketNo", (Object)"").toString());
                String status = ticketInfoObject.getOrDefault((Object)"Status", (Object)"").toString();
                seqplaneOrderModel.setTicketNum(ticketNo);
                seqplaneOrderModel.setTicketStatus(CTripPlaneOrderConvert.setTicketStatus(status));
                int sequence = sequenceInfoObject.getIntValue("Sequence");
                CTripPlaneOrderConvert.setFlightInfo(sequence, seqplaneOrderModel, flightInfoArray);
                String orderNumNotype = CorpSync.splicOrderNumNotype(orderID, passengerName, seqplaneOrderModel.getToCityName());
                seqplaneOrderModel.setOrderNum(orderNumNotype + "-" + seqplaneOrderModel.getOrderType().getKey());
                planeOrderModel.setOrderNum(orderNumNotype + "-" + seqplaneOrderModel.getOrderType().getKey());
                JSONArray insuranceInfoArray = sequenceInfoObject.getJSONArray("InsuranceInfo");
                JSONArray jSONArray2 = insuranceInfoArray = insuranceInfoArray == null ? new JSONArray() : insuranceInfoArray;
                if (insuranceInfoArray != null) {
                    List<PlaneOrderModel> insuranceOrderModels = CTripPlaneOrderConvert.handleRefundInsurance(seqplaneOrderModel, insuranceInfoArray);
                    orderModels.addAll(insuranceOrderModels);
                }
                orderModels.add(seqplaneOrderModel);
                JSONArray changeInfoArray = sequenceInfoObject.getJSONArray("ChangeInfo");
                JSONArray jSONArray3 = changeInfoArray = changeInfoArray == null ? new JSONArray() : changeInfoArray;
                if (changeInfoArray == null) continue;
                for (int p = 0; p < changeInfoArray.size(); ++p) {
                    JSONObject changeInfoObject = changeInfoArray.getJSONObject(p);
                    String cStatus = changeInfoObject.getOrDefault((Object)"CStatus", (Object)"").toString();
                    if (!"\u6539\u7b7e\u6210\u529f".equals(cStatus) || !ACCNT.equals(changeInfoObject.getOrDefault((Object)"CPrepayType", (Object)"").toString())) continue;
                    seqplaneOrderModel.setOrderStatus(PlaneOrderModel.OrderStatus.C);
                    PlaneOrderModel planeChangeOrderModel = CTripPlaneOrderConvert.setFlightChangeInfo(changeInfoObject, seqplaneOrderModel);
                    orderModels.add(planeChangeOrderModel);
                }
            }
        }
        JSONArray refundInfoArray = planeObject.getJSONArray("RefundInfo");
        JSONArray jSONArray = refundInfoArray = refundInfoArray == null ? new JSONArray() : refundInfoArray;
        if (refundInfoArray != null) {
            for (int j = 0; j < refundInfoArray.size(); ++j) {
                String refundStatus;
                JSONObject refundInfoObject = refundInfoArray.getJSONObject(j);
                if (null == refundInfoObject || refundInfoObject.isEmpty() || !"S".equals(refundStatus = refundInfoObject.getOrDefault((Object)"RefundStatus", (Object)"").toString())) continue;
                planeOrderModel.setOrderStatus(PlaneOrderModel.OrderStatus.E);
                PlaneOrderModel planeRefundOrderModel = (PlaneOrderModel)planeOrderModel.clone();
                planeRefundOrderModel.setOrderDate(refundInfoObject.getDate("RefundTime"));
                planeRefundOrderModel.setOrderType(AbstractOrderModel.OrderType.T);
                planeRefundOrderModel.setOrderStatus(PlaneOrderModel.OrderStatus.E);
                planeRefundOrderModel.setTicketStatus(PlaneOrderModel.TicketStatus.C);
                planeRefundOrderModel.setHappendDate(refundInfoObject.getDate("RefundTime"));
                planeRefundOrderModel.setRefundReason(refundInfoObject.getOrDefault((Object)"RefundResonDesc", (Object)"").toString());
                JSONArray refundDetailArray = refundInfoObject.getJSONArray("RefundDetail");
                refundDetailArray = refundDetailArray == null ? new JSONArray() : refundDetailArray;
                for (int k = 0; k < refundDetailArray.size(); ++k) {
                    PlaneOrderModel planeRefundDetailOrderModel = (PlaneOrderModel)planeRefundOrderModel.clone();
                    JSONObject refundDetailObject = refundDetailArray.getJSONObject(k);
                    if (null == refundDetailObject) continue;
                    String ticketNo = CTripPlaneOrderConvert.handelTicketNo(refundDetailObject.getOrDefault((Object)"TicketNo", (Object)"").toString());
                    planeRefundDetailOrderModel.setTicketNum(ticketNo);
                    planeRefundDetailOrderModel.setTravelername(refundDetailObject.getOrDefault((Object)"PassengerName", (Object)"").toString());
                    int seq = refundDetailObject.getIntValue("Sequence");
                    CTripPlaneOrderConvert.setFlightInfo(seq, planeRefundDetailOrderModel, flightInfoArray);
                    String orderNumNotype = CorpSync.splicOrderNumNotype(orderID, planeRefundDetailOrderModel.getTravelername(), planeRefundDetailOrderModel.getToCityName());
                    String orderNum = orderNumNotype + "-" + AbstractOrderModel.OrderType.T.getKey();
                    logger.info("\u5546\u65c5\u96c6\u6210,\u643a\u7a0b\u8ba2\u5355,\u643a\u7a0b\u673a\u7968\u9000\u7968\u5355\u8ba2\u5355\u53f7:" + orderNum);
                    planeRefundDetailOrderModel.setOrderNum(orderNum);
                    planeRefundDetailOrderModel.setTotalAmount(ConvertUtil.getOrderAmountInit());
                    orderModels.add(planeRefundDetailOrderModel);
                }
            }
        }
        JSONObject jSONObject2 = flightTicketPrintInfo = (flightTicketPrintInfo = planeObject.getJSONObject("FlightTicketPrintInfo")) == null ? new JSONObject() : flightTicketPrintInfo;
        if (null != flightTicketPrintInfo) {
            JSONArray segmentPrintInfoList = flightTicketPrintInfo.getJSONArray("segmentPrintInfoList");
            JSONArray jSONArray4 = segmentPrintInfoList = segmentPrintInfoList == null ? new JSONArray() : segmentPrintInfoList;
            if (segmentPrintInfoList != null) {
                for (int j = 0; j < segmentPrintInfoList.size(); ++j) {
                    String ticketNum;
                    JSONObject segmentPrintInfo = segmentPrintInfoList.getJSONObject(j);
                    String segmentTicketNo = CTripPlaneOrderConvert.handelTicketNo(segmentPrintInfo.getOrDefault((Object)"TicketNo", (Object)"").toString());
                    if (!StringUtils.equals((CharSequence)segmentTicketNo, (CharSequence)(ticketNum = planeOrderModel.getTicketNum()))) continue;
                    planeOrderModel.setItinerarydate(TripCommonUtil.convertToDate(segmentPrintInfo.getOrDefault((Object)"PrintTime", (Object)"").toString()));
                    planeOrderModel.setItinerarynum(segmentPrintInfo.getOrDefault((Object)"PrintNo", (Object)"").toString());
                }
            }
        }
        return orderModels;
    }

    private static PlaneOrderModel handleBasicInfo(JSONObject basicInfoObject) {
        PlaneOrderModel planeOrderModel = new PlaneOrderModel();
        planeOrderModel.setServer(Supplier.XIECHENG.name().trim());
        String orderID = basicInfoObject.getOrDefault((Object)"OrderID", (Object)"").toString();
        String orderSort = basicInfoObject.getOrDefault((Object)"FlightClass", (Object)"").toString();
        if ("I".equals(orderSort)) {
            planeOrderModel.setOrderSort(AbstractOrderModel.OrderSort.B);
            planeOrderModel.setOperationType(AbstractOrderModel.OperationType.D);
        } else {
            planeOrderModel.setOrderSort(AbstractOrderModel.OrderSort.A);
            planeOrderModel.setOperationType(AbstractOrderModel.OperationType.B);
        }
        planeOrderModel.setOrderNum(orderID);
        planeOrderModel.setParentOrderNum(orderID);
        planeOrderModel.setOrderDate(basicInfoObject.getDate("PrintTicketTime"));
        planeOrderModel.setOrderType(AbstractOrderModel.OrderType.O);
        planeOrderModel.setSourceBookedId(basicInfoObject.getOrDefault((Object)"EmployeeID", (Object)"").toString());
        planeOrderModel.setBookedname(basicInfoObject.getOrDefault((Object)"PreEmployName", (Object)"").toString());
        planeOrderModel.setOaBillNum(basicInfoObject.getOrDefault((Object)"JourneyID", (Object)"").toString());
        planeOrderModel.setOrderNatrue(CTripPlaneOrderConvert.setOrderNatrue(basicInfoObject.getOrDefault((Object)"CorpPayType", (Object)"").toString()));
        planeOrderModel.setProductType(CTripPlaneOrderConvert.setProductType(basicInfoObject.getOrDefault((Object)"PrepayType", (Object)"").toString()));
        planeOrderModel.setOrderStatus(CTripPlaneOrderConvert.setOrderStatus(basicInfoObject.getOrDefault((Object)"OrderStatus", (Object)"").toString()));
        planeOrderModel.setHappendDate(basicInfoObject.getDate("PrintTicketTime"));
        planeOrderModel.setCurrency(basicInfoObject.getOrDefault((Object)"Currency", (Object)"").toString());
        return planeOrderModel;
    }

    private static List<PlaneOrderModel> handleRefundInsurance(PlaneOrderModel seqplaneOrderModel, JSONArray insuranceInfoArray) {
        ArrayList<PlaneOrderModel> models = new ArrayList<PlaneOrderModel>();
        for (int i = 0; i < insuranceInfoArray.size(); ++i) {
            JSONObject insuranceInfoObject = insuranceInfoArray.getJSONObject(i);
            String insuranceStatus = insuranceInfoObject.getOrDefault((Object)"InsuranceStatus", (Object)"").toString();
            if (!insuranceStatus.equals("R")) continue;
            try {
                PlaneOrderModel insuranceOrderModel = (PlaneOrderModel)seqplaneOrderModel.clone();
                String orderNum = CTripPlaneOrderConvert.handelOrderNum(seqplaneOrderModel.getOrderNum(), insuranceOrderModel.getTravelername(), AbstractOrderModel.OrderType.T.getKey());
                if (insuranceInfoArray.size() > 1) {
                    insuranceOrderModel.setOrderNum(orderNum + (i + 1));
                } else {
                    insuranceOrderModel.setOrderNum(orderNum);
                }
                insuranceOrderModel.setOrderType(AbstractOrderModel.OrderType.T);
                insuranceOrderModel.setOrderStatus(PlaneOrderModel.OrderStatus.E);
                insuranceOrderModel.setTotalAmount(ConvertUtil.getOrderAmountInit());
                models.add(insuranceOrderModel);
                continue;
            }
            catch (CloneNotSupportedException e) {
                logger.error("\u5546\u65c5\u96c6\u6210,\u643a\u7a0b\u8ba2\u5355,handleRefundInsurance error:", (Throwable)e);
            }
        }
        return models;
    }

    private static String handelTicketNo(String ticketNo) {
        if (ticketNo.contains("-")) {
            ticketNo = ticketNo.substring(ticketNo.indexOf("-") + 1, ticketNo.length());
            return ticketNo;
        }
        return ticketNo;
    }

    private static String handelOrderNum(String orderNum, String passengerName, String orderType) {
        String spiltFalg = "-";
        if (orderNum.contains("-")) {
            String[] orderNumStrs = orderNum.split("-");
            String orderId = orderNumStrs[0];
            String toCityName = orderNumStrs[2];
            orderNum = orderId + spiltFalg + passengerName + spiltFalg + toCityName + spiltFalg + orderType;
            return orderNum;
        }
        return orderNum;
    }

    private static void setFlightInfo(int sequence, PlaneOrderModel planeOrderModel, JSONArray flightInfoArray) {
        for (int i = 0; i < flightInfoArray.size(); ++i) {
            JSONObject flightInfoObject = flightInfoArray.getJSONObject(i);
            if (sequence != flightInfoObject.getIntValue("Sequence")) continue;
            planeOrderModel.setAirlineName(flightInfoObject.getOrDefault((Object)"AirLineName", (Object)"").toString());
            planeOrderModel.setCabinClass(flightInfoObject.getOrDefault((Object)"ClassName", (Object)"").toString());
            planeOrderModel.setCabin(flightInfoObject.getOrDefault((Object)"SubClass", (Object)"").toString());
            planeOrderModel.setFlightNo(flightInfoObject.getOrDefault((Object)"Flight", (Object)"").toString());
            planeOrderModel.setFromCityName(flightInfoObject.getOrDefault((Object)"DCityName", (Object)"").toString());
            planeOrderModel.setTakeoffPortName(flightInfoObject.getOrDefault((Object)"DPortName", (Object)"").toString());
            planeOrderModel.setToCityName(flightInfoObject.getOrDefault((Object)"ACityName", (Object)"").toString());
            planeOrderModel.setLandingPortName(flightInfoObject.getOrDefault((Object)"APortName", (Object)"").toString());
            planeOrderModel.setTakeoffTime(flightInfoObject.getDate("TakeoffTime"));
            planeOrderModel.setLandingTime(flightInfoObject.getDate("ArrivalTime"));
            String reasonDesc = flightInfoObject.getOrDefault((Object)"ClassReasonDesc", (Object)"").toString();
            planeOrderModel.setOverDesc(reasonDesc);
            planeOrderModel.setOverflag(StringUtils.isEmpty((CharSequence)reasonDesc) ? ResManager.loadKDString((String)"\u5426", (String)"CTripPlaneOrderConvert_1", (String)"fi-er-business", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u662f", (String)"CTripPlaneOrderConvert_2", (String)"fi-er-business", (Object[])new Object[0]));
            planeOrderModel.setChooseNotMinReason(flightInfoObject.getOrDefault((Object)"ReasonDesc", (Object)"").toString());
            planeOrderModel.setTotalAmount(ConvertUtil.getOrderAmountInit());
        }
    }

    private static PlaneOrderModel setFlightChangeInfo(JSONObject changeInfoObject, PlaneOrderModel planeOrderModel) {
        try {
            PlaneOrderModel planeChangeOrderModel = (PlaneOrderModel)planeOrderModel.clone();
            String cTicketNO = changeInfoObject.getOrDefault((Object)"CTicketNO", (Object)"").toString();
            planeChangeOrderModel.setTicketNum(cTicketNO);
            String orderNum = CTripPlaneOrderConvert.handelOrderNum(planeChangeOrderModel.getOrderNum(), planeChangeOrderModel.getTravelername(), AbstractOrderModel.OrderType.G.getKey());
            planeChangeOrderModel.setOrderNum(orderNum);
            planeChangeOrderModel.setOrderType(AbstractOrderModel.OrderType.G);
            planeChangeOrderModel.setOrderDate(changeInfoObject.getDate("RebookingTime"));
            planeChangeOrderModel.setOrderStatus(PlaneOrderModel.OrderStatus.A);
            planeChangeOrderModel.setHappendDate(changeInfoObject.getDate("RebookingTime"));
            planeChangeOrderModel.setAirlineName(changeInfoObject.getOrDefault((Object)"CAirlineName", (Object)"").toString());
            planeChangeOrderModel.setCabinClass(changeInfoObject.getOrDefault((Object)"CClassName", (Object)"").toString());
            planeChangeOrderModel.setCabin(changeInfoObject.getOrDefault((Object)"CClass", (Object)"").toString());
            planeChangeOrderModel.setFlightNo(changeInfoObject.getOrDefault((Object)"CFlight", (Object)"").toString());
            planeChangeOrderModel.setFromCityName(changeInfoObject.getOrDefault((Object)"CDCityName", (Object)"").toString());
            planeChangeOrderModel.setTakeoffPortName(changeInfoObject.getOrDefault((Object)"CDPortName", (Object)"").toString());
            planeChangeOrderModel.setToCityName(changeInfoObject.getOrDefault((Object)"CACityName", (Object)"").toString());
            planeChangeOrderModel.setLandingPortName(changeInfoObject.getOrDefault((Object)"CAPortName", (Object)"").toString());
            planeChangeOrderModel.setTakeoffTime(changeInfoObject.getDate("CTakeOffTime"));
            planeChangeOrderModel.setLandingTime(changeInfoObject.getDate("CArrivalTime"));
            planeChangeOrderModel.setChangeReason(changeInfoObject.getOrDefault((Object)"RebookResonDesc", (Object)"").toString());
            planeChangeOrderModel.setTotalAmount(ConvertUtil.getOrderAmountInit());
            return planeChangeOrderModel;
        }
        catch (CloneNotSupportedException e) {
            logger.error("\u5546\u65c5\u96c6\u6210,\u643a\u7a0b\u8ba2\u5355,", (Throwable)e);
            return null;
        }
    }

    private static AbstractOrderModel.OrderNatrue setOrderNatrue(String orderNatrue) {
        if ("\u56e0\u516c".equals(orderNatrue)) {
            return AbstractOrderModel.OrderNatrue.A;
        }
        return AbstractOrderModel.OrderNatrue.B;
    }

    private static PlaneOrderModel.TicketStatus setTicketStatus(String string) {
        switch (string) {
            case "2": 
            case "3": 
            case "4": 
            case "7": {
                return PlaneOrderModel.TicketStatus.A;
            }
            case "1": 
            case "8": {
                return PlaneOrderModel.TicketStatus.B;
            }
            case "5": 
            case "6": {
                return PlaneOrderModel.TicketStatus.C;
            }
        }
        return PlaneOrderModel.TicketStatus.A;
    }

    private static PlaneOrderModel.OrderStatus setOrderStatus(String string) {
        switch (string) {
            case "\u5df2\u6210\u4ea4": {
                return PlaneOrderModel.OrderStatus.A;
            }
            case "\u5df2\u53d6\u6d88": {
                return PlaneOrderModel.OrderStatus.B;
            }
            case "\u5904\u7406\u4e2d": {
                return PlaneOrderModel.OrderStatus.H;
            }
            case "\u5168\u90e8\u9000\u7968": {
                return PlaneOrderModel.OrderStatus.E;
            }
            case "\u90e8\u5206\u9000\u7968": {
                return PlaneOrderModel.OrderStatus.I;
            }
            case "\u6539\u7b7e\u5df2\u63d0\u4ea4": 
            case "\u6539\u7b7e\u5904\u7406\u4e2d": {
                return PlaneOrderModel.OrderStatus.B;
            }
            case "\u6539\u7b7e\u6210\u529f": {
                return PlaneOrderModel.OrderStatus.C;
            }
            case "\u6539\u7b7e\u5931\u8d25": {
                return PlaneOrderModel.OrderStatus.J;
            }
            case "\u6539\u7b7e\u5df2\u53d6\u6d88": {
                return PlaneOrderModel.OrderStatus.K;
            }
        }
        return PlaneOrderModel.OrderStatus.A;
    }

    private static PlaneOrderModel.OrderStatus setOrderStatusByChecking(String string) {
        switch (string) {
            case "S": {
                return PlaneOrderModel.OrderStatus.A;
            }
            case "C": {
                return PlaneOrderModel.OrderStatus.B;
            }
            case "P": {
                return PlaneOrderModel.OrderStatus.H;
            }
            case "R": {
                return PlaneOrderModel.OrderStatus.E;
            }
            case "T": {
                return PlaneOrderModel.OrderStatus.I;
            }
            case "W": {
                return PlaneOrderModel.OrderStatus.F;
            }
        }
        return PlaneOrderModel.OrderStatus.A;
    }

    private static AbstractOrderModel.ProductType setProductType(String productType) {
        if ("ACCNT".equals(productType)) {
            return AbstractOrderModel.ProductType.A;
        }
        return AbstractOrderModel.ProductType.B;
    }

    public static void updateConvert(PlaneOrderModel planeOrderModel, JSONObject OrderSettlementList) {
        JSONObject flightOrderSettlementBaseInfo = OrderSettlementList.getJSONObject("OrderSettlementBaseInfo");
        flightOrderSettlementBaseInfo = flightOrderSettlementBaseInfo == null ? new JSONObject() : flightOrderSettlementBaseInfo;
        JSONObject flightOrderBaseInfo = OrderSettlementList.getJSONObject("OrderBaseInfo");
        flightOrderBaseInfo = flightOrderBaseInfo == null ? new JSONObject() : flightOrderBaseInfo;
        JSONObject flightOrderPassenger = OrderSettlementList.getJSONObject("OrderPassengerInfo");
        flightOrderPassenger = flightOrderPassenger == null ? new JSONObject() : flightOrderPassenger;
        JSONObject orderFlightInfo = OrderSettlementList.getJSONObject("OrderFlightInfo");
        orderFlightInfo = orderFlightInfo == null ? new JSONObject() : orderFlightInfo;
        planeOrderModel.setTicketStatus(CTripPlaneOrderConvert.setTicketStatus(flightOrderPassenger.getOrDefault((Object)"CorpPassengerTicketStatus", (Object)"").toString()));
        String orderID = flightOrderSettlementBaseInfo.getOrDefault((Object)"OrderID", (Object)"").toString();
        String ticketNo = flightOrderPassenger.getOrDefault((Object)"TicketNo", (Object)"").toString();
        planeOrderModel.setOaBillNum(flightOrderBaseInfo.getOrDefault((Object)"JourneyID", (Object)"").toString());
        planeOrderModel.setTicketNum(CTripPlaneOrderConvert.handelTicketNo(ticketNo));
        planeOrderModel.setParentOrderNum(orderID);
        Date happenDate = TripCommonUtil.strToDate(flightOrderSettlementBaseInfo.getOrDefault((Object)"CreateTime", (Object)"").toString(), "yyyy-MM-dd HH:mm:ss.SSS");
        planeOrderModel.setHappendDate(happenDate);
        planeOrderModel.setServer(Supplier.XIECHENG.name());
        Date orderDate = TripCommonUtil.strToDate(flightOrderBaseInfo.getOrDefault((Object)"OrderDate", (Object)"").toString(), "yyyy-MM-dd HH:mm:ss.SSS");
        planeOrderModel.setOrderDate(orderDate);
        if ("I".equals(flightOrderBaseInfo.getOrDefault((Object)"FlightClass", (Object)"").toString())) {
            planeOrderModel.setOrderSort(AbstractOrderModel.OrderSort.B);
            planeOrderModel.setOperationType(AbstractOrderModel.OperationType.D);
        } else {
            planeOrderModel.setOrderSort(AbstractOrderModel.OrderSort.A);
            planeOrderModel.setOperationType(AbstractOrderModel.OperationType.B);
        }
        planeOrderModel.setOrderNatrue(AbstractOrderModel.OrderNatrue.A);
        planeOrderModel.setProductType(AbstractOrderModel.ProductType.A);
        planeOrderModel.setOrderStatus(CTripPlaneOrderConvert.setOrderStatusByChecking(flightOrderBaseInfo.getOrDefault((Object)"OrderStatus", (Object)"").toString()));
        planeOrderModel.setHappendDate(flightOrderBaseInfo.getDate("PrintTicketTime"));
        planeOrderModel.setCurrency(flightOrderBaseInfo.getOrDefault((Object)"Currency", (Object)"").toString());
        planeOrderModel.setSourceBookedId(flightOrderBaseInfo.getOrDefault((Object)"PreEmployeeID", (Object)"").toString());
        planeOrderModel.setBookedname(flightOrderBaseInfo.getOrDefault((Object)"Name", (Object)"").toString());
        planeOrderModel.setSourcetravelerid(flightOrderBaseInfo.getOrDefault((Object)"EmployeeID", (Object)"").toString());
        String travelername = flightOrderPassenger.getOrDefault((Object)"PassengerName", (Object)"").toString();
        planeOrderModel.setTravelername(travelername);
        planeOrderModel.setFlightNo(orderFlightInfo.getOrDefault((Object)"Flight", (Object)"").toString());
        planeOrderModel.setFromCityName(orderFlightInfo.getOrDefault((Object)"DCityName", (Object)"").toString());
        String toCityName = orderFlightInfo.getOrDefault((Object)"ACityName", (Object)"").toString();
        planeOrderModel.setToCityName(toCityName);
        planeOrderModel.setCabin(orderFlightInfo.getOrDefault((Object)"SubClass", (Object)"").toString());
        planeOrderModel.setCabinClass(orderFlightInfo.getOrDefault((Object)"ClassName", (Object)"").toString());
        planeOrderModel.setAirlineName(orderFlightInfo.getOrDefault((Object)"AirLineName", (Object)"").toString());
        planeOrderModel.setTakeoffPortName(orderFlightInfo.getOrDefault((Object)"DPortName", (Object)"").toString());
        planeOrderModel.setTakeoffTime(orderFlightInfo.getDate("TakeOffTime"));
        planeOrderModel.setLandingPortName(orderFlightInfo.getOrDefault((Object)"APortName", (Object)"").toString());
        planeOrderModel.setLandingTime(orderFlightInfo.getDate("ArrivalTime"));
        planeOrderModel.setChooseNotMinReason(orderFlightInfo.getOrDefault((Object)"ReasonDesc", (Object)"").toString());
        String reasonDesc = orderFlightInfo.getOrDefault((Object)"ClassReasonDesc", (Object)"").toString();
        planeOrderModel.setOverDesc(reasonDesc);
        planeOrderModel.setOverflag(StringUtils.isEmpty((CharSequence)reasonDesc) ? ResManager.loadKDString((String)"\u5426", (String)"CTripPlaneOrderConvert_1", (String)"fi-er-business", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u662f", (String)"CTripPlaneOrderConvert_2", (String)"fi-er-business", (Object[])new Object[0]));
        String orderDetailType = flightOrderSettlementBaseInfo.getOrDefault((Object)"OrderDetailType", (Object)"").toString();
        String str = "\u6539\u7b7e";
        if (str.equals(orderDetailType)) {
            JSONObject orderRebookInfo = OrderSettlementList.getJSONObject("OrderRebookInfo");
            orderRebookInfo = orderRebookInfo == null ? new JSONObject() : orderRebookInfo;
            ticketNo = orderRebookInfo.getOrDefault((Object)"TicketNo", (Object)"").toString();
            planeOrderModel.setTicketNum(CTripPlaneOrderConvert.handelTicketNo(ticketNo));
            travelername = orderRebookInfo.getOrDefault((Object)"PassengerName", (Object)"").toString();
            planeOrderModel.setTravelername(travelername);
            planeOrderModel.setFlightNo(orderRebookInfo.getOrDefault((Object)"ExchangeFlight", (Object)"").toString());
            planeOrderModel.setFromCityName(orderRebookInfo.getOrDefault((Object)"DCityName", (Object)"").toString());
            toCityName = orderRebookInfo.getOrDefault((Object)"ACityName", (Object)"").toString();
            planeOrderModel.setToCityName(toCityName);
            planeOrderModel.setCabin(orderRebookInfo.getOrDefault((Object)"CClass", (Object)"").toString());
            planeOrderModel.setCabinClass(orderRebookInfo.getOrDefault((Object)"CClassName", (Object)"").toString());
            planeOrderModel.setAirlineName(orderRebookInfo.getOrDefault((Object)"RebookAirLineName", (Object)"").toString());
            planeOrderModel.setTakeoffPortName(orderRebookInfo.getOrDefault((Object)"DPortName", (Object)"").toString());
            planeOrderModel.setTakeoffTime(orderRebookInfo.getDate("RebookTakeOffTime"));
            planeOrderModel.setLandingPortName(orderRebookInfo.getOrDefault((Object)"APortName", (Object)"").toString());
            planeOrderModel.setLandingTime(orderRebookInfo.getDate("RebookArrivalTime"));
            planeOrderModel.setChangeReason(orderRebookInfo.getOrDefault((Object)"RebookReasonDesc", (Object)"").toString());
        }
    }
}

