/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.trip.supplier.didi.invoke;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.er.business.servicehelper.HttpRetryServiceHelper;
import kd.fi.er.business.trip.exception.TripException;
import kd.fi.er.business.trip.service.function.template.InPutFunctionTemp;
import kd.fi.er.business.trip.supplier.Supplier;
import kd.fi.er.business.trip.supplier.didi.systemexternal.DiDiServiceUtil;
import kd.fi.er.business.trip.util.TripCityUtil;
import kd.fi.er.business.trip.util.TripCommonUtil;
import kd.fi.er.business.trip.util.TripSyncConfigUtil;
import kd.fi.er.common.ExternalConstants;
import org.apache.commons.lang.StringUtils;

public class DiDiTripCityInvoke
extends InPutFunctionTemp<JSONObject> {
    private static Log logger = LogFactory.getLog(DiDiTripCityInvoke.class);
    private String SHI = ResManager.loadKDString((String)"\u5e02", (String)"DiDiTripCityInvoke_0", (String)"fi-er-business", (Object[])new Object[0]);
    private String COUNTRY = ResManager.loadKDString((String)"\u4e2d\u56fd", (String)"DiDiTripCityInvoke_1", (String)"fi-er-business", (Object[])new Object[0]);

    @Override
    protected String supplier() {
        return Supplier.DIDI.name();
    }

    @Override
    protected String function() {
        return "tripCityInvoke";
    }

    @Override
    protected JSONObject process(Map<String, ? extends Object> params) throws TripException {
        Map<String, String> supplierMap = TripCommonUtil.getTripServiceInfo(this.supplier());
        String client_id = supplierMap.get("appkey");
        String access_token = DiDiServiceUtil.getCacheToken(new Date());
        if (access_token == null) {
            return null;
        }
        HashMap<String, Object> signMap = new HashMap<String, Object>();
        signMap.put("client_id", client_id);
        signMap.put("access_token", access_token);
        signMap.put("timestamp", String.valueOf(System.currentTimeMillis() / 1000L));
        String signKey = supplierMap.get("reservedfield1");
        String regulationSign = DiDiServiceUtil.genSign(signMap, signKey);
        HashMap<String, String> cityparamMap = new HashMap<String, String>();
        cityparamMap.put("client_id", client_id);
        cityparamMap.put("access_token", access_token);
        cityparamMap.put("timestamp", String.valueOf(System.currentTimeMillis() / 1000L));
        cityparamMap.put("sign", regulationSign);
        this.tripSyncLogParam.setRequesturl((String)ExternalConstants.DIDIURLMAP.get("cityKey"));
        JSONObject result = HttpRetryServiceHelper.doGet((String)ExternalConstants.DIDIURLMAP.get("cityKey"), cityparamMap, JSONObject.class);
        this.tripSyncLogParam.setRequestdata(cityparamMap);
        this.tripSyncLogParam.setResponsedata(result);
        if (Integer.parseInt(String.valueOf(result.get((Object)"errno"))) == 0) {
            this.tripSyncLogParam.setStatus("A");
        } else {
            this.tripSyncLogParam.setStatus("B");
        }
        return result;
    }

    @Override
    protected Object convert(JSONObject value) throws TripException {
        if (value == null) {
            this.tripSyncLogParam.setMessage(ResManager.loadKDString((String)"\u5546\u65c5\u96c6\u6210,\u83b7\u53d6\u6ef4\u6ef4\u57ce\u5e02,\u8fd4\u56de\u6570\u636e\u4e3a\u3002", (String)"DiDiTripCityInvoke_2", (String)"fi-er-business", (Object[])new Object[0]));
            return null;
        }
        ArrayList<DynamicObject> tripCityDynamicObjectList = new ArrayList<DynamicObject>();
        String setectProperties = "id,nameen,admindivisionid.name,admindivisionid.country.name,admindivisionid.fullspell,didicityid";
        DynamicObject[] cityObjMaps = BusinessDataServiceHelper.load((String)"er_city", (String)setectProperties, (QFilter[])new QFilter[0]);
        List tripCityObjList = Stream.of(cityObjMaps).filter(city -> this.COUNTRY.equals(city.getString("admindivisionid.country.name")) && StringUtils.isNotEmpty((String)"admindivisionid.name")).collect(Collectors.toList());
        ArrayList cityArray = (ArrayList)value.get((Object)"data");
        int paramValue = TripSyncConfigUtil.getIntValue("trip_cityid_update", 0, Arrays.asList(1, 0));
        for (int i = 0; i < cityArray.size(); ++i) {
            LinkedHashMap didiCityMap = (LinkedHashMap)cityArray.get(i);
            int cityId = (Integer)didiCityMap.get("city_id");
            String cityName = (String)didiCityMap.get("city_name");
            List tripCityObjListTemp = cityName.lastIndexOf(this.SHI) == cityName.length() - 1 ? tripCityObjList.stream().filter(tripCityObj -> tripCityObj.getString("admindivisionid.name").contains(cityName.substring(0, cityName.length() - 1))).collect(Collectors.toList()) : tripCityObjList.stream().filter(tripCityObj -> cityName.contains(tripCityObj.getString("admindivisionid.name"))).collect(Collectors.toList());
            if (tripCityObjListTemp == null || tripCityObjListTemp.size() != 1) continue;
            DynamicObject cityTemp = (DynamicObject)tripCityObjListTemp.get(0);
            String cityid = cityTemp.getString("didicityid");
            if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)cityid) && 0 == paramValue) {
                cityTemp.set("didicityid", (Object)cityId);
            }
            if ("0".equals(cityid)) {
                cityTemp.set("didicityid", (Object)cityId);
            }
            tripCityDynamicObjectList.add(cityTemp);
        }
        return tripCityDynamicObjectList;
    }

    @Override
    protected void saveInfos(Object infos) throws TripException {
        List tripCityDynamicObjectList = (List)infos;
        TripCityUtil.saveTripCityData(tripCityDynamicObjectList);
    }
}

