/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.trip.supplier.didi.invoke;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.fi.er.business.servicehelper.HttpServiceHelper;
import kd.fi.er.business.trip.exception.TripSyncLogParam;
import kd.fi.er.business.trip.exception.TripSyncLogUtils;
import kd.fi.er.business.trip.model.DailyVehicleBillModel;
import kd.fi.er.business.trip.model.TripSyncDataMappingModel;
import kd.fi.er.business.trip.service.function.AbstractDailyVehicleBillInvoke;
import kd.fi.er.business.trip.supplier.Supplier;
import kd.fi.er.business.trip.supplier.didi.systemexternal.DiDiServiceUtil;
import kd.fi.er.business.trip.supplier.didi.systemexternal.DiDiTripCarRegulationUtil;
import kd.fi.er.business.trip.util.TripCityUtil;
import kd.fi.er.business.trip.util.TripCommonUtil;
import kd.fi.er.business.trip.util.TripSyncDataMappingUtil;
import kd.fi.er.common.ExternalConstants;
import org.apache.commons.lang.StringUtils;

public class DiDiTripDailyVehicleBillInvoke
extends AbstractDailyVehicleBillInvoke<JSONObject> {
    private static final Log logger = LogFactory.getLog(DiDiTripDailyVehicleBillInvoke.class);
    private static int APPROVAL_TYPE = 2;

    @Override
    protected String supplier() {
        return Supplier.DIDI.name();
    }

    protected Object convert(Object value) {
        String syncStatus;
        switch (syncStatus = (String)this.getParams().get("syncStatus")) {
            case "1": {
                return this.convertPushBill(value, false);
            }
            case "2": {
                return this.convertCloseBill(value);
            }
        }
        return null;
    }

    protected JSONObject convertPushBill(Object info) {
        return this.convertPushBill(info, false);
    }

    protected JSONObject convertPushBill(Object info, boolean updateFlag) {
        String access_token;
        DailyVehicleBillModel reqbill = (DailyVehicleBillModel)info;
        String out_approval_id = reqbill.getBillNo();
        logger.info("\u5546\u65c5\u96c6\u6210,\u6ef4\u6ef4\u7528\u8f66\u7533\u8bf7\u5355,\u63a8\u9001\u5355\u636e,\u5f00\u59cb\u6570\u636e\u8f6c\u6362,\u51fa\u5dee\u5355\u53f7:" + out_approval_id);
        Map<String, String> supplierMap = TripCommonUtil.getTripServiceInfo(this.supplier());
        String client_id = supplierMap.get("appkey");
        String company_id = supplierMap.get("orationid");
        try {
            access_token = DiDiServiceUtil.getCacheToken(new Date());
        }
        catch (KDBizException e) {
            this.tripSyncLogParam.setRequesturl(TripCommonUtil.getTravelNoOneApiUrl("tokenurlkey"));
            this.tripSyncLogParam.setStatus("B");
            throw new KDBizException(new ErrorCode("doPost", String.format(ResManager.loadKDString((String)"\u6267\u884c\u8bf7\u6c42\u8fc7\u7a0b\u4e2d\u51fa\u73b0\u5f02\u5e38\u3002%s", (String)"DiDiTripDailyVehicleBillInvoke_0", (String)"fi-er-business", (Object[])new Object[0]), new Object[]{e})), new Object[0]);
        }
        if (access_token == null) {
            this.tripSyncLogParam.setMessage(String.format(ResManager.loadKDString((String)"\u5546\u65c5\u96c6\u6210,\u7528\u8f66\u5355\u53f7:%s,\u83b7\u53d6\u6ef4\u6ef4token\u4e3a\u7a7a,\u8bf7\u68c0\u67e5\u914d\u7f6e!", (String)"DiDiTripDailyVehicleBillInvoke_1", (String)"fi-er-business", (Object[])new Object[0]), out_approval_id));
            this.tripSyncLogParam.setStatus("B");
            return null;
        }
        String phone = reqbill.getApplyEmpPhone();
        String vehicletype = reqbill.getVehicletype();
        int approval_type = APPROVAL_TYPE;
        if ("2".equals(vehicletype)) {
            approval_type = 2;
        } else if ("4".equals(vehicletype)) {
            approval_type = 3;
        }
        String regulation_id = DiDiTripCarRegulationUtil.getUserTripCarRegulationByVehicle(phone, approval_type);
        if (StringUtils.isBlank((String)regulation_id)) {
            this.tripSyncLogParam.setMessage(String.format(ResManager.loadKDString((String)"\u5546\u65c5\u96c6\u6210,\u7528\u8f66\u5355\u53f7:%s,\u83b7\u53d6\u51fa\u5dee\u7528\u8f66\u5236\u5ea6\u4e3a\u7a7a,\u8bf7\u68c0\u67e5\u914d\u7f6e!", (String)"DiDiTripDailyVehicleBillInvoke_2", (String)"fi-er-business", (Object[])new Object[0]), out_approval_id));
            this.tripSyncLogParam.setStatus("B");
            return null;
        }
        String reason = reqbill.getDesc();
        String timestamp = String.valueOf(System.currentTimeMillis() / 1000L);
        HashMap<String, Object> signMap = new HashMap<String, Object>();
        signMap.put("client_id", client_id);
        signMap.put("company_id", company_id);
        signMap.put("access_token", access_token);
        signMap.put("regulation_id", regulation_id);
        signMap.put("out_approval_id", out_approval_id);
        signMap.put("phone", phone);
        signMap.put("type", 1);
        QFilter uFilter = new QFilter("server", "=", (Object)this.supplier());
        uFilter.and(new QFilter("datatype", "=", (Object)"bos_org"));
        Map<Object, Object> dataOrgMappingMap = TripSyncDataMappingUtil.getDataMappingMapByFilter(uFilter, "innerdataid", "outdataid");
        Object budgetCenterId = null;
        if (dataOrgMappingMap != null && dataOrgMappingMap.size() > 0) {
            budgetCenterId = TripSyncDataMappingUtil.getBudgetCenterId(reqbill, null, dataOrgMappingMap);
        }
        if (budgetCenterId != null) {
            signMap.put("budget_center_id", budgetCenterId);
        }
        signMap.put("approval_type", approval_type);
        signMap.put("reason", reason.trim());
        JSONObject jsonObject = this.converTravelDetailInfo(reqbill, approval_type);
        signMap.put("business_trip_detail", DiDiTripDailyVehicleBillInvoke.gbEncoding(jsonObject.toString()));
        signMap.put("timestamp", timestamp);
        JSONObject tripReqObj = new JSONObject();
        if (updateFlag) {
            QFilter updateFilter = new QFilter("server", "=", (Object)this.supplier());
            updateFilter.and(new QFilter("datatype", "=", (Object)"er_dailyvehicle"));
            updateFilter.and(new QFilter("number", "=", (Object)out_approval_id));
            Map<Object, Object> updateDataOrgMappingMap = TripSyncDataMappingUtil.getDataMappingMapByFilter(updateFilter, "number", "outdataid");
            logger.info("out_approval_id{}", (Object)out_approval_id);
            Object o = updateDataOrgMappingMap.get(out_approval_id);
            if (o != null) {
                signMap.put("approval_id", o);
                tripReqObj.put("approval_id", o);
            }
        }
        String tripreqSignKey = DiDiServiceUtil.genSign(signMap, supplierMap.get("reservedfield1"));
        tripReqObj.put("client_id", (Object)client_id);
        tripReqObj.put("company_id", (Object)company_id);
        tripReqObj.put("access_token", (Object)access_token);
        tripReqObj.put("timestamp", (Object)timestamp);
        tripReqObj.put("regulation_id", (Object)regulation_id);
        tripReqObj.put("out_approval_id", (Object)out_approval_id);
        tripReqObj.put("phone", (Object)phone);
        tripReqObj.put("approval_type", (Object)approval_type);
        tripReqObj.put("type", (Object)1);
        if (budgetCenterId != null) {
            tripReqObj.put("budget_center_id", budgetCenterId);
        }
        tripReqObj.put("reason", (Object)reason.trim());
        tripReqObj.put("business_trip_detail", (Object)jsonObject);
        tripReqObj.put("sign", (Object)tripreqSignKey);
        return tripReqObj;
    }

    private JSONObject converTravelDetailInfo(DailyVehicleBillModel reqbill, int approval_type) {
        JSONObject travelDetailInfo = new JSONObject();
        Date startDate = reqbill.getStartdate();
        Date endDate = reqbill.getEnddate();
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(endDate.getTime());
        calendar.set(11, 23);
        calendar.set(12, 59);
        calendar.set(13, 59);
        Date time = calendar.getTime();
        if (approval_type == 2) {
            travelDetailInfo.put("start_time", (Object)TripCommonUtil.date2TimeStamp(startDate, "yyyy-MM-dd HH:mm:ss"));
            travelDetailInfo.put("end_time", (Object)TripCommonUtil.date2TimeStamp(time, "yyyy-MM-dd HH:mm:ss"));
            travelDetailInfo.put("departure_city_id", TripCityUtil.getDiDiCityId(reqbill.getVehiclecity()).get(reqbill.getVehiclecity()));
            travelDetailInfo.put("destination_city_id", TripCityUtil.getDiDiCityId(reqbill.getVehiclecity()).get(reqbill.getVehiclecity()));
            travelDetailInfo.put("departure_city", (Object)reqbill.getVehiclecityName());
            travelDetailInfo.put("destination_city", (Object)reqbill.getVehiclecityName());
            travelDetailInfo.put("trip_times", (Object)reqbill.getVehiclenumber());
        } else if (approval_type == 3) {
            Calendar instance = Calendar.getInstance();
            instance.setTime(time);
            instance.add(11, 6);
            instance.add(13, 1);
            Date newEndDate = instance.getTime();
            travelDetailInfo.put("start_time", (Object)TripCommonUtil.date2TimeStamp(startDate, "yyyy-MM-dd HH:mm:ss"));
            travelDetailInfo.put("end_time", (Object)TripCommonUtil.date2TimeStamp(newEndDate, "yyyy-MM-dd HH:mm:ss"));
        }
        return travelDetailInfo;
    }

    protected String batPushProcess(Object value) {
        String syncStatus;
        if (value == null) {
            String code = "200";
            if (this.tripSyncLogParam.getStatus().equals("B")) {
                code = "300";
            }
            return code;
        }
        String jsonStr = JSON.toJSONString((Object)value, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.DisableCircularReferenceDetect});
        String url = "";
        switch (syncStatus = (String)this.getParams().get("syncStatus")) {
            case "1": {
                url = (String)ExternalConstants.DIDIURLMAP.get("approvalAddKey");
                break;
            }
            case "2": {
                url = (String)ExternalConstants.DIDIURLMAP.get("approvalCancelKey");
            }
        }
        this.tripSyncLogParam.setRequestdata(value);
        this.tripSyncLogParam.setRequesturl(url);
        String result = HttpServiceHelper.PostData(url, jsonStr);
        this.tripSyncLogParam.setResponsedata(result);
        JSONObject resultJsonObject = JSONObject.parseObject((String)result);
        ArrayList<TripSyncDataMappingModel> dataMappingList = new ArrayList<TripSyncDataMappingModel>();
        if (resultJsonObject == null || resultJsonObject.getIntValue("errno") != 0 && resultJsonObject.getIntValue("errno") != 50506) {
            this.tripSyncLogParam.setStatus("B");
            return "300";
        }
        if (resultJsonObject.getIntValue("errno") == 50506) {
            logger.info("didi update api");
            String errmsg = resultJsonObject.getString("errmsg");
            if (null == errmsg) {
                logger.info("\u5546\u65c5\u96c6\u6210\uff0c\u6ef4\u6ef4\u7528\u8f66\u7533\u8bf7\u5355\u540c\u6b65\uff1a{}", (Object)resultJsonObject.toJSONString());
                return "300";
            }
            if (null == (errmsg = errmsg.substring(errmsg.lastIndexOf("("), errmsg.lastIndexOf(")")))) {
                logger.info("\u5546\u65c5\u96c6\u6210\uff0c\u6ef4\u6ef4\u7528\u8f66\u7533\u8bf7\u5355\u540c\u6b65\uff1a{}", (Object)resultJsonObject.toJSONString());
                return "300";
            }
            StringBuilder sb = new StringBuilder();
            for (char c : errmsg.toCharArray()) {
                if (!Character.isDigit(c)) continue;
                sb.append(c);
            }
            this.dealData(jsonStr);
            TripSyncDataMappingModel TripSyncDataMappingObj = new TripSyncDataMappingModel("er_dailyvehicle", this.supplier());
            String outdataid = sb.toString();
            JSONObject reqJson = JSONObject.parseObject((String)jsonStr);
            String out_approval_id = reqJson.getString("out_approval_id");
            TripSyncDataMappingObj.setNumber(out_approval_id);
            TripSyncDataMappingObj.setOutdataid(Long.parseLong(outdataid));
            dataMappingList.add(TripSyncDataMappingObj);
            TripSyncDataMappingUtil.saveTripSyncDataMapping(dataMappingList);
            Object updateValue = this.redealJson();
            String updateJsonStr = JSON.toJSONString((Object)updateValue, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.DisableCircularReferenceDetect});
            TripSyncLogParam updateTripSyncLogParam = new TripSyncLogParam(RequestContext.get().getTraceId(), this.supplier(), this.function());
            String updateUrl = (String)ExternalConstants.DIDIURLMAP.get("approvalUpdateKey");
            updateTripSyncLogParam.setRequestdata(updateValue);
            updateTripSyncLogParam.setRequesturl(updateUrl);
            String updateResult = HttpServiceHelper.PostData(updateUrl, updateJsonStr);
            updateTripSyncLogParam.setResponsedata(updateResult);
            JSONObject updateResultJsonObject = JSONObject.parseObject((String)updateResult);
            if (updateResultJsonObject == null || updateResultJsonObject.getIntValue("errno") != 0) {
                updateTripSyncLogParam.setStatus("B");
            } else {
                updateTripSyncLogParam.setStatus("A");
            }
            TripSyncLogUtils.saveErrorLog(Collections.singletonList(updateTripSyncLogParam));
            return "200";
        }
        this.tripSyncLogParam.setStatus("A");
        if (StringUtils.equals((String)syncStatus, (String)"1")) {
            this.dealData(jsonStr);
            TripSyncDataMappingModel TripSyncDataMappingObj = new TripSyncDataMappingModel("er_dailyvehicle", this.supplier());
            JSONObject data = JSON.parseObject((String)JSON.toJSONString((Object)resultJsonObject.get((Object)"data")));
            String outdataid = data.getString("approval_id");
            String billNo = JSON.parseObject((String)JSON.toJSONString((Object)value)).getString("out_approval_id");
            TripSyncDataMappingObj.setNumber(billNo);
            TripSyncDataMappingObj.setOutdataid(Long.parseLong(outdataid));
            dataMappingList.add(TripSyncDataMappingObj);
        }
        TripSyncDataMappingUtil.saveTripSyncDataMapping(dataMappingList);
        return "200";
    }

    private void dealData(String jsonStr) {
        JSONObject jsonObject = JSONObject.parseObject((String)jsonStr);
        if (jsonObject != null) {
            String applyNumber = jsonObject.getString("out_approval_id");
            DeleteServiceHelper.delete((String)"er_tripsync_datamapping", (QFilter[])new QFilter[]{new QFilter("server", "=", (Object)this.supplier()), new QFilter("number", "=", (Object)applyNumber)});
        }
    }

    private static String gbEncoding(String s) {
        char[] c;
        StringBuilder buf = new StringBuilder();
        for (char tmp : c = s.toCharArray()) {
            buf = tmp > '\u00ff' ? buf.append("\\u").append(Integer.toHexString(tmp)) : buf.append(tmp);
        }
        return buf.toString();
    }

    private Object convertCloseBill(Object value) {
        String access_token;
        DailyVehicleBillModel reqbill = (DailyVehicleBillModel)value;
        String out_approval_id = reqbill.getBillNo();
        Map<String, String> supplierMap = TripCommonUtil.getTripServiceInfo(this.supplier());
        String client_id = supplierMap.get("appkey");
        try {
            access_token = DiDiServiceUtil.getCacheToken(new Date());
        }
        catch (KDBizException e) {
            this.tripSyncLogParam.setRequesturl(TripCommonUtil.getTravelNoOneApiUrl("tokenurlkey"));
            this.tripSyncLogParam.setStatus("B");
            throw new KDBizException(new ErrorCode("doPost", String.format(ResManager.loadKDString((String)"\u6267\u884c\u8bf7\u6c42\u8fc7\u7a0b\u4e2d\u51fa\u73b0\u5f02\u5e38\u3002%s", (String)"DiDiTripDailyVehicleBillInvoke_0", (String)"fi-er-business", (Object[])new Object[0]), new Object[]{e})), new Object[0]);
        }
        if (access_token == null) {
            this.tripSyncLogParam.setMessage(String.format(ResManager.loadKDString((String)"\u5546\u65c5\u96c6\u6210,\u7528\u8f66\u5355\u53f7:%s,\u83b7\u53d6\u6ef4\u6ef4token\u4e3a\u7a7a,\u8bf7\u68c0\u67e5\u914d\u7f6e!", (String)"DiDiTripDailyVehicleBillInvoke_1", (String)"fi-er-business", (Object[])new Object[0]), out_approval_id));
            this.tripSyncLogParam.setStatus("B");
            return null;
        }
        String timestamp = String.valueOf(System.currentTimeMillis() / 1000L);
        String company_id = supplierMap.get("orationid");
        HashMap<String, Object> signMap = new HashMap<String, Object>();
        JSONObject tripReqObj = new JSONObject();
        signMap.put("client_id", client_id);
        signMap.put("access_token", access_token);
        signMap.put("timestamp", timestamp);
        signMap.put("company_id", company_id);
        QFilter updateFilter = new QFilter("server", "=", (Object)this.supplier());
        updateFilter.and(new QFilter("datatype", "=", (Object)"er_dailyvehicle"));
        updateFilter.and(new QFilter("number", "=", (Object)out_approval_id));
        Map<Object, Object> updateDataOrgMappingMap = TripSyncDataMappingUtil.getDataMappingMapByFilter(updateFilter, "number", "outdataid");
        logger.info("out_approval_id{}", (Object)out_approval_id);
        Object o = updateDataOrgMappingMap.get(out_approval_id);
        if (o != null) {
            signMap.put("approval_id", o);
            tripReqObj.put("approval_id", o);
        }
        String tripreqSignKey = DiDiServiceUtil.genSign(signMap, supplierMap.get("reservedfield1"));
        tripReqObj.put("client_id", (Object)client_id);
        tripReqObj.put("access_token", (Object)access_token);
        tripReqObj.put("timestamp", (Object)timestamp);
        tripReqObj.put("company_id", (Object)company_id);
        tripReqObj.put("sign", (Object)tripreqSignKey);
        return tripReqObj;
    }

    private Object redealJson() {
        Object innerData = this.getInnerData();
        return this.convertPushBill(innerData, true);
    }
}

