/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.trip.supplier.didi.invoke;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.er.business.servicehelper.CommonServiceHelper;
import kd.fi.er.business.servicehelper.HttpRetryServiceHelper;
import kd.fi.er.business.trip.exception.TripSyncLogParam;
import kd.fi.er.business.trip.service.function.AbstractInvoiceSendInvoke;
import kd.fi.er.business.trip.supplier.Supplier;
import kd.fi.er.business.trip.supplier.didi.systemexternal.DiDiServiceUtil;
import kd.fi.er.common.ExternalConstants;
import org.apache.commons.lang3.StringUtils;

public class DiDiTripInvoiceSendInvoke
extends AbstractInvoiceSendInvoke<JSONObject> {
    private static final String REPEAT_INVOICE_CODE = "50103";
    private static final String REQUEST_DATA_ARR = "requestDataArr";

    @Override
    protected String supplier() {
        return Supplier.DIDI.getValue();
    }

    @Override
    protected Object getInnerData() {
        return this.pk;
    }

    protected JSONObject convert(Object info) {
        if (info == null) {
            return null;
        }
        DynamicObject[] invoices = (DynamicObject[])info;
        JSONArray requestArray = new JSONArray();
        String userId = RequestContext.getOrCreate().getUserId();
        String email = null;
        if (!StringUtils.isEmpty((CharSequence)userId)) {
            DynamicObject user = CommonServiceHelper.getUser(Long.valueOf(userId));
            email = user.getString("email");
        }
        for (int i = 0; i < invoices.length; ++i) {
            DynamicObject invoice = invoices[i];
            JSONObject request = new JSONObject();
            request.put("invoice_type", (Object)3);
            request.put("receiver_email", (Object)email);
            request.put("invoice_title", (Object)invoice.getString("expcommitcomnum.ffirmname"));
            request.put("tax_registration_number", (Object)invoice.getString("expcommitcomnum.ftaxregnum"));
            request.put("invoice_content", (Object)"*\u8fd0\u8f93\u670d\u52a1*\u5ba2\u8fd0\u670d\u52a1\u8d39");
            request.put("invoice_no", invoice.get("trdinvoiceid"));
            request.put("invoice_amount", (Object)new BigDecimal(invoice.getBigDecimal("settleamountwithtax").stripTrailingZeros().toPlainString()));
            requestArray.add((Object)request);
        }
        JSONObject result = new JSONObject();
        result.put(REQUEST_DATA_ARR, (Object)requestArray);
        return result;
    }

    protected String batPushProcess(Object o) {
        DynamicObject[] invoiceBillArray;
        String invoiceId;
        String trdInvoiceId;
        if (o == null) {
            return null;
        }
        JSONObject param = JSONObject.parseObject((String)String.valueOf(o));
        JSONArray requestArray = param.getJSONArray(REQUEST_DATA_ARR);
        String invoiceChargeUrl = (String)ExternalConstants.DIDIURLMAP.get("invoiceChargeKey");
        HashMap<String, String> invoiceSuccess = new HashMap<String, String>();
        HashMap<String, String> invoiceFail = new HashMap<String, String>();
        StringBuilder code = new StringBuilder("0");
        for (int i = 0; i < requestArray.size(); ++i) {
            JSONObject request = requestArray.getJSONObject(i);
            TripSyncLogParam logParam = this.tripSyncLogParam.clone();
            DiDiServiceUtil.buildRequestParams((Map<String, Object>)request, logParam);
            String responseStr = HttpRetryServiceHelper.PostData(invoiceChargeUrl, request.toJSONString());
            JSONObject result = JSONObject.parseObject((String)responseStr);
            this.tripSyncLogParamList.add(logParam);
            logParam.setRequestdata(request);
            logParam.setResponsedata(result.toJSONString());
            logParam.setRequesturl(invoiceChargeUrl);
            String errno = result.getString("errno");
            trdInvoiceId = request.getString("invoice_no");
            if (result == null || !"0".equals(errno)) {
                if (StringUtils.isEmpty((CharSequence)code)) {
                    code.append(errno);
                } else {
                    code.append(",").append(errno);
                }
                String message = errno != null && errno.equals(REPEAT_INVOICE_CODE) ? ResManager.loadKDString((String)"\u8be5\u6d41\u6c34\u53f7\u5df2\u5f00\u7968\u3002", (String)"DiDiTripInvoiceSendInvoke_0", (String)"fi-er-business", (Object[])new Object[0]) : (errno != null ? result.getString("errmsg") : ResManager.loadKDString((String)"\u8bf7\u6c42\u8fd4\u56de\u7ed3\u679c\u4e3anull\u3002", (String)"DiDiTripInvoiceSendInvoke_1", (String)"fi-er-business", (Object[])new Object[0]));
                logParam.setStatus("B");
                logParam.setMessage(message);
                invoiceFail.put(trdInvoiceId, errno);
                continue;
            }
            invoiceId = result.getJSONObject("data").getString("invoice_id");
            invoiceSuccess.put(trdInvoiceId, invoiceId);
        }
        HashSet invoiceNos = new HashSet();
        if (invoiceSuccess.size() > 0) {
            invoiceNos.addAll(invoiceSuccess.keySet());
        }
        if (invoiceFail.size() > 0) {
            invoiceNos.addAll(invoiceFail.keySet());
        }
        for (DynamicObject invoiceBill : invoiceBillArray = BusinessDataServiceHelper.load((String)"er_invoiceorderbill", (String)"billno,invoicenum,invoicecode,trdinvoiceid,invoicestatus,invoicestatustime", (QFilter[])new QFilter[]{new QFilter("id", "in", invoiceNos)})) {
            trdInvoiceId = invoiceBill.getString("trdinvoiceid");
            invoiceId = (String)invoiceSuccess.get(trdInvoiceId);
            if (StringUtils.isEmpty((CharSequence)invoiceId)) {
                invoiceBill.set("invoicecode", (Object)invoiceId);
                invoiceBill.set("invoicestatus", (Object)"2");
            } else {
                String errCode = (String)invoiceFail.get(trdInvoiceId);
                if (StringUtils.isEmpty((CharSequence)errCode)) {
                    if (errCode.equals(REPEAT_INVOICE_CODE)) continue;
                    invoiceBill.set("invoicestatus", (Object)"5");
                }
            }
            invoiceBill.set("invoicestatustime", (Object)new Date());
        }
        SaveServiceHelper.save((DynamicObject[])invoiceBillArray);
        return code.toString();
    }
}

