/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.trip.supplier.didi.invoke;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.ext.fi.thread.TaskType;
import kd.bos.ext.fi.thread.ThreadService;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.fi.er.business.servicehelper.CoreBaseBillServiceHelper;
import kd.fi.er.business.servicehelper.HttpRetryServiceHelper;
import kd.fi.er.business.trip.dao.UserDao;
import kd.fi.er.business.trip.model.TripSyncDataMappingModel;
import kd.fi.er.business.trip.service.factory.TripServiceFactory;
import kd.fi.er.business.trip.service.function.AbstractLoginInvoke;
import kd.fi.er.business.trip.service.iservice.ITripService;
import kd.fi.er.business.trip.supplier.Supplier;
import kd.fi.er.business.trip.supplier.didi.systemexternal.DiDiServiceUtil;
import kd.fi.er.business.trip.util.TripCommonUtil;
import kd.fi.er.business.trip.util.TripSyncConfigUtil;
import kd.fi.er.business.trip.util.TripSyncDataMappingUtil;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.business.utils.TripUserGrantUtils;
import kd.fi.er.common.ExternalConstants;
import org.apache.commons.lang.StringUtils;

public class DiDiTripLoginInvoke
extends AbstractLoginInvoke {
    private static final Log logger = LogFactory.getLog(DiDiTripLoginInvoke.class);
    private String errorMsg;

    @Override
    public String login() {
        Map<String, String> bizInfoMap = TripCommonUtil.getTripServiceInfo(Supplier.DIDI.name());
        String url = this.getH5SignUrl(bizInfoMap);
        return url;
    }

    private String getH5SignUrl(Map<String, String> supplierMap) {
        DynamicObjectCollection servers = TripUserGrantUtils.getServers(Supplier.DIDI.name());
        String loginEncryptStr = CollectionUtils.isNotEmpty((Collection)servers) ? this.getGrantUrl(supplierMap) : this.getLoginEncryptStr(supplierMap);
        if (loginEncryptStr == null) {
            logger.info("\u5546\u65c5\u96c6\u6210,\u6ef4\u6ef4\u767b\u5f55,\u83b7\u53d6\u5f53\u524d\u7528\u6237\u767b\u5f55\u5730\u70b9\u4f01\u4e1aH5\u7684\u52a0\u5bc6\u4e32\u4e3a\u7a7a.");
            return "";
        }
        StringBuilder h5UrlBuilder = new StringBuilder(loginEncryptStr);
        h5UrlBuilder.append("&client_id =").append(supplierMap.get("appkey"));
        if (this.param.get("businessType").equals("orderlist")) {
            h5UrlBuilder.append("&jumpPage=orderlist");
        }
        logger.info("\u5546\u65c5\u96c6\u6210,\u6ef4\u6ef4\u767b\u5f55,h5Url:" + h5UrlBuilder);
        return h5UrlBuilder.toString();
    }

    protected String getLoginEncryptStr(Map<String, String> supplierMap) {
        String encrypt_str = null;
        try {
            String client_id = supplierMap.get("appkey");
            String company_id = supplierMap.get("orationid");
            String access_token = DiDiServiceUtil.getCacheToken(new Date());
            if (access_token == null) {
                logger.info("\u5546\u65c5\u96c6\u6210,\u6ef4\u6ef4\u767b\u5f55,\u83b7\u53d6token\u4e3a\u7a7a.");
                return "";
            }
            HashMap<String, Object> signMap = new HashMap<String, Object>();
            signMap.put("client_id", client_id);
            signMap.put("company_id", company_id);
            signMap.put("access_token", access_token);
            signMap.put("app_type", 2);
            String employeePhone = (String)this.param.get("tel");
            signMap.put("phone", employeePhone);
            String employeeNumber = this.param.get("number") != null ? (String)this.param.get("number") : "";
            signMap.put("employee_number", employeeNumber);
            String timestamp = String.valueOf(System.currentTimeMillis() / 1000L);
            signMap.put("timestamp", timestamp);
            String signKey = supplierMap.get("reservedfield1");
            String h5LoginSign = DiDiServiceUtil.genSign(signMap, signKey);
            HashMap<String, Object> h5LoginparamMap = new HashMap<String, Object>();
            h5LoginparamMap.put("client_id", client_id);
            h5LoginparamMap.put("company_id", company_id);
            h5LoginparamMap.put("access_token", access_token);
            h5LoginparamMap.put("timestamp", timestamp);
            h5LoginparamMap.put("app_type", 2);
            h5LoginparamMap.put("phone", employeePhone);
            h5LoginparamMap.put("employee_number", employeeNumber);
            h5LoginparamMap.put("sign", h5LoginSign);
            JSONObject result = HttpRetryServiceHelper.doGet((String)ExternalConstants.DIDIURLMAP.get("getLoginEncryptKey"), h5LoginparamMap, JSONObject.class);
            if (Integer.parseInt(String.valueOf(result.get((Object)"errno"))) != 0) {
                this.errorMsg = (String)result.get((Object)"errmsg");
                logger.info("\u5546\u65c5\u96c6\u6210,\u6ef4\u6ef4\u767b\u5f55,\u5458\u5de5\u5de5\u53f7\u4e3a:" + employeeNumber + "\u767b\u5f55\u5931\u8d25\u539f\u56e0:" + result.get((Object)"errmsg"));
                IFormView view = (IFormView)this.param.get("view");
                view.showErrorNotification(result.get((Object)"errmsg") == null ? "" : result.get((Object)"errmsg").toString());
                return null;
            }
            HashMap encryptList = (HashMap)result.get((Object)"data");
            encrypt_str = (String)encryptList.get("encrypt_str");
        }
        catch (Exception e) {
            IFormView view = (IFormView)this.param.get("view");
            view.showErrorNotification(e.getMessage());
        }
        return encrypt_str;
    }

    @Override
    protected void process(String loginString) {
        IFormView formView = (IFormView)this.param.get("view");
        if (!StringUtils.isEmpty((String)loginString)) {
            formView.openUrl(loginString);
        } else {
            formView.showMessage(String.format(ResManager.loadKDString((String)"\u767b\u5f55\u6ef4\u6ef4\u4f01\u4e1a\u7248\u9875\u9762\u5931\u8d25,\u539f\u56e0:%s", (String)"DiDiTripLoginInvoke_0", (String)"fi-er-business", (Object[])new Object[0]), this.errorMsg));
        }
    }

    private String getGrantUrl(Map<String, String> supplierMap) {
        String encrypt_str;
        block13: {
            encrypt_str = null;
            ArrayList<TripSyncDataMappingModel> dataMappingList = new ArrayList<TripSyncDataMappingModel>();
            try {
                String client_id = supplierMap.get("appkey");
                String company_id = supplierMap.get("orationid");
                String access_token = DiDiServiceUtil.getCacheToken(new Date());
                if (access_token == null) {
                    logger.info("\u5546\u65c5\u96c6\u6210,\u6ef4\u6ef4\u767b\u5f55,\u83b7\u53d6token\u4e3a\u7a7a.");
                    return "";
                }
                Object name = this.param.get("name");
                String realName = "";
                if (name instanceof OrmLocaleValue) {
                    OrmLocaleValue name1 = (OrmLocaleValue)name;
                    realName = name1.getLocaleValue();
                }
                String timestamp = String.valueOf(System.currentTimeMillis() / 1000L);
                HashMap signMap = Maps.newHashMapWithExpectedSize((int)16);
                Object budgetCenterId = this.getBudgetCenterId();
                Integer useCompanyMoney = this.getUseCompanyMoney();
                signMap.put("client_id", client_id);
                signMap.put("company_id", company_id);
                signMap.put("access_token", access_token);
                signMap.put("app_type", 2);
                signMap.put("timestamp", timestamp);
                String employeePhone = (String)this.param.get("tel");
                signMap.put("phone", employeePhone);
                signMap.put("realname", realName);
                ArrayList<Map<String, Object>> userChangeInfos = new ArrayList<Map<String, Object>>(1);
                HashMap userChangeInfo = new HashMap(2);
                userChangeInfo.put("id", this.param.get("id"));
                Long companyPk = CoreBaseBillServiceHelper.initCompanyByDept(ErCommonUtils.getPk(this.param.get("org")));
                userChangeInfo.put("companyId", companyPk);
                userChangeInfos.add(userChangeInfo);
                Map<Long, String> reimburseLevelMap = UserDao.getReimburseLevelNumberNew(userChangeInfos);
                this.setUserReimburseLevel(this.param.get("id"), reimburseLevelMap, signMap, companyPk);
                final String employeeNumber = this.param.get("number") != null ? (String)this.param.get("number") : "";
                DynamicObject user = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_user", (String)"entryentity,entryentity.superior,entryentity.superior.number", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)employeeNumber)});
                signMap.put("employee_number", employeeNumber);
                int intValue = TripSyncConfigUtil.getIntValue("trip_Superior", 0, Arrays.asList(0, 1));
                if (intValue == 1) {
                    signMap.put("immediate_superior_employee_number", user.get("entryentity.superior.number") == null ? "" : user.get("entryentity.superior.number"));
                }
                signMap.put("is_remark", 2);
                if (budgetCenterId != null) {
                    signMap.put("budget_center_id", budgetCenterId);
                }
                signMap.put("use_company_money", useCompanyMoney);
                String signKey = supplierMap.get("reservedfield1");
                String h5LoginSign = DiDiServiceUtil.genSign(signMap, signKey);
                HashMap<String, Object> h5LoginparamMap = new HashMap<String, Object>();
                h5LoginparamMap.put("client_id", client_id);
                h5LoginparamMap.put("company_id", company_id);
                h5LoginparamMap.put("access_token", access_token);
                h5LoginparamMap.put("timestamp", timestamp);
                h5LoginparamMap.put("app_type", 2);
                h5LoginparamMap.put("phone", employeePhone);
                h5LoginparamMap.put("employee_number", employeeNumber);
                h5LoginparamMap.put("is_remark", 2);
                h5LoginparamMap.put("realname", realName);
                if (intValue == 1) {
                    h5LoginparamMap.put("immediate_superior_employee_number", user.get("entryentity.superior.number") == null ? "" : user.get("entryentity.superior.number"));
                }
                this.setUserReimburseLevel(this.param.get("id"), reimburseLevelMap, h5LoginparamMap, companyPk);
                if (budgetCenterId != null) {
                    h5LoginparamMap.put("budget_center_id", budgetCenterId);
                }
                h5LoginparamMap.put("use_company_money", useCompanyMoney);
                h5LoginparamMap.put("sign", h5LoginSign);
                logger.info("\u5373\u5c06\u767b\u5f55\u6388\u6743\u63a5\u53e3DIDI");
                JSONObject result = HttpRetryServiceHelper.doGet((String)ExternalConstants.DIDIURLMAP.get("grantLoginEncryptKey"), h5LoginparamMap, JSONObject.class);
                logger.info("\u6388\u6743\u63a5\u53e3\u8fd4\u56de\u6570\u636e:{}", (Object)result);
                Object errno = result.get((Object)"errno");
                if (Integer.parseInt(String.valueOf(errno)) == 0) {
                    HashMap encryptList = (HashMap)result.get((Object)"data");
                    encrypt_str = (String)encryptList.get("encrypt_str");
                    try {
                        TripSyncDataMappingModel TripSyncDataMappingObj = new TripSyncDataMappingModel("bos_user", Supplier.DIDI.name());
                        Object outdataid = encryptList.get("member_id");
                        if (outdataid == null) {
                            logger.info("\u6ef4\u6ef4\u5355\u70b9\u6388\u6743URL:{}", (Object)encrypt_str);
                            return encrypt_str;
                        }
                        String userNumber = employeeNumber;
                        TripSyncDataMappingObj.setNumber(userNumber);
                        TripSyncDataMappingObj.setOutdataid(Long.parseLong(outdataid.toString()));
                        dataMappingList.add(TripSyncDataMappingObj);
                        TripSyncDataMappingUtil.saveTripSyncDataMapping(dataMappingList);
                    }
                    catch (Exception e) {
                        logger.error("\u5546\u65c5\u96c6\u6210,\u6ef4\u6ef4\u6388\u6743\u767b\u5f55,\u5458\u5de5\u5de5\u53f7\u4e3a:" + employeeNumber + "\u8bb0\u5f55\u6ef4\u6ef4\u4fa7\u4eba\u5458ID\u5931\u8d25\u539f\u56e0:", (Throwable)e);
                    }
                    break block13;
                }
                if (Integer.parseInt(String.valueOf(errno)) == 50252) {
                    this.errorMsg = (String)result.get((Object)"errmsg");
                    logger.info("\u5546\u65c5\u96c6\u6210,\u6ef4\u6ef4\u767b\u5f55,\u5458\u5de5\u5de5\u53f7\u4e3a:" + employeeNumber + "\u767b\u5f55\u5931\u8d25\u539f\u56e0:" + result.get((Object)"errmsg"));
                    IFormView view = (IFormView)this.param.get("view");
                    view.getFormShowParameter().setCustomParam("error", (Object)"true");
                    view.showErrorNotification(ResManager.loadKDString((String)"\u6b63\u5728\u540c\u6b65\u4eba\u5458,\u8bf7\u7a0d\u540e\u91cd\u8bd5\u3002", (String)"DiDiTripLoginInvoke_1", (String)"fi-er-business", (Object[])new Object[0]));
                    ThreadService.execute((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            String tmpNumber = employeeNumber;
                            ITripService iTripService = TripServiceFactory.getTripService("DiDiTripService");
                            HashMap<String, Object> params = new HashMap<String, Object>(1);
                            DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_user", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)tmpNumber)});
                            params.put("userList", Collections.singletonList(ErCommonUtils.getPk(dynamicObject)));
                            params.put("didi", 1);
                            iTripService.synUserToTrip(params);
                        }
                    }, (TaskType)TaskType.ER_TRIP_TASK, (RequestContext)RequestContext.get());
                    break block13;
                }
                this.errorMsg = (String)result.get((Object)"errmsg");
                logger.info("\u5546\u65c5\u96c6\u6210,\u6ef4\u6ef4\u767b\u5f55,\u5458\u5de5\u5de5\u53f7\u4e3a:" + employeeNumber + "\u767b\u5f55\u5931\u8d25\u539f\u56e0:" + result.get((Object)"errmsg"));
                IFormView view = (IFormView)this.param.get("view");
                view.getFormShowParameter().setCustomParam("error", (Object)"true");
                view.showErrorNotification(result.get((Object)"errmsg") == null ? "" : result.get((Object)"errmsg").toString());
                return null;
            }
            catch (Exception e) {
                logger.error("\u6388\u6743\u63a5\u53e3\u5931\u8d25:", (Throwable)e);
                IFormView view = (IFormView)this.param.get("view");
                view.getFormShowParameter().setCustomParam("error", (Object)"true");
                view.showErrorNotification(e.getMessage());
            }
        }
        logger.info("\u6ef4\u6ef4\u5355\u70b9\u6388\u6743URL:{}", encrypt_str);
        return encrypt_str;
    }

    private void setUserReimburseLevel(Object userId, Map<Long, String> reimburseLevelMap, Map<String, Object> userDataJsonObject, Long companyPk) {
        String dtrip_personnel_rank = TripSyncConfigUtil.getTripsyncSettingByKey("dtrip_personnel_rank");
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)dtrip_personnel_rank)) {
            return;
        }
        String reimbursenumber = reimburseLevelMap.get(Long.parseLong(userId.toString()));
        if ("0".equals(dtrip_personnel_rank)) {
            return;
        }
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_org", (String)"id,name,number", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)companyPk)});
        switch (dtrip_personnel_rank) {
            case "1": {
                if (!org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)reimbursenumber)) break;
                userDataJsonObject.put("out_rank_id", dynamicObject.getString("number") + "-" + reimbursenumber.trim());
                break;
            }
            case "2": {
                if (!org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)reimbursenumber)) break;
                userDataJsonObject.put("out_rank_id", reimbursenumber.trim());
                break;
            }
            case "3": {
                if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)reimbursenumber)) {
                    userDataJsonObject.put("out_rank_id", dynamicObject.getString("number") + "-" + reimbursenumber.trim());
                    break;
                }
                userDataJsonObject.put("out_rank_id", dynamicObject.getString("number") + "-General-01");
                break;
            }
            case "4": {
                if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)reimbursenumber)) {
                    userDataJsonObject.put("out_rank_id", reimbursenumber.trim());
                    break;
                }
                userDataJsonObject.put("out_rank_id", "General-01");
                break;
            }
            case "5": {
                if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)reimbursenumber)) {
                    userDataJsonObject.put("out_rank_id", dynamicObject.getString("number") + "-" + reimbursenumber.trim());
                    break;
                }
                userDataJsonObject.put("out_rank_id", "General-01");
            }
        }
    }

    private Integer getUseCompanyMoney() {
        return TripSyncConfigUtil.getBoolean("dtrip_use_company_money") ? 1 : 0;
    }

    private Object getBudgetCenterId() {
        QFilter uFilter = new QFilter("server", "=", (Object)Supplier.DIDI.name());
        uFilter.and(new QFilter("datatype", "=", (Object)"bos_org"));
        Map<Object, Object> dataOrgMappingMap = TripSyncDataMappingUtil.getDataMappingMapByFilter(uFilter, "innerdataid", "outdataid");
        if (dataOrgMappingMap.isEmpty()) {
            return 0;
        }
        DynamicObject userInfo = BusinessDataServiceHelper.loadSingle((String)"bos_user", (String)"id,number,entryentity.dpt,entryentity.ispartjob,entryentity.id", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)RequestContext.get().getCurrUserId())});
        if (userInfo == null) {
            return 0;
        }
        int paramValue = TripSyncConfigUtil.getIntValue("budget_center_id", 1);
        Object budgetCenterId = null;
        Long dptId = this.getDptId(userInfo);
        logger.info("\u5f53\u524d\u4eba\u5458\u90e8\u95e8ID:{}", (Object)dptId);
        switch (paramValue) {
            case 0: 
            case 2: {
                budgetCenterId = dataOrgMappingMap.get(dptId);
                break;
            }
            case 1: {
                Long companyId = CoreBaseBillServiceHelper.initCompanyByDept(dptId);
                logger.info("\u5f53\u524d\u4eba\u5458\u516c\u53f8ID:{}", (Object)companyId);
                budgetCenterId = dataOrgMappingMap.get(companyId);
                break;
            }
            case 3: {
                Long accountOrgId = CoreBaseBillServiceHelper.getAccountOrgId(Long.parseLong(dptId.toString()));
                logger.info("\u5f53\u524d\u4eba\u5458\u6838\u7b97\u7ec4\u7ec7ID:{}", (Object)accountOrgId);
                budgetCenterId = dataOrgMappingMap.get(accountOrgId);
            }
        }
        return budgetCenterId;
    }

    private Long getDptId(DynamicObject userInfo) {
        Long dptId = 0L;
        DynamicObjectCollection entryEntity = userInfo.getDynamicObjectCollection("entryentity");
        int size = entryEntity.size();
        for (int i = 0; i < size; ++i) {
            DynamicObject dynamicObject = (DynamicObject)entryEntity.get(i);
            boolean ispartjob = dynamicObject.getBoolean("ispartjob");
            if (ispartjob) continue;
            dptId = ErCommonUtils.getPk(dynamicObject.get("dpt"));
        }
        return dptId;
    }
}

