/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.trip.supplier.meituan.invoke;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.bos.util.StringUtils;
import kd.fi.er.business.servicehelper.HttpServiceHelper;
import kd.fi.er.business.trip.exception.TripSyncLogParam;
import kd.fi.er.business.trip.model.TripSyncDataMappingModel;
import kd.fi.er.business.trip.service.function.AbstractOrgInvoke;
import kd.fi.er.business.trip.supplier.Supplier;
import kd.fi.er.business.trip.supplier.meituan.utils.MeiTuanTripUtil;
import kd.fi.er.business.trip.util.TripCommonUtil;
import kd.fi.er.business.trip.util.TripSyncDataMappingUtil;
import org.apache.http.NameValuePair;

public class MeiTuanTripOrgInvoke
extends AbstractOrgInvoke {
    private static Log logger = LogFactory.getLog(MeiTuanTripOrgInvoke.class);

    @Override
    protected String supplier() {
        return Supplier.MEITUAN.name();
    }

    @Override
    protected Object getInnerData() {
        this.bizInfoObject = BusinessDataServiceHelper.loadSingle((String)"er_biz_info", (String)"lastsyncorgtamp", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)this.supplier())});
        this.lastSyncOrgTamp = this.bizInfoObject.getString("lastsyncorgtamp");
        return this.queryOrgInfo(this.lastSyncOrgTamp);
    }

    public List<JSONObject> queryOrgInfo(String lastSyncOrgTamp) {
        Date changeTime = TripCommonUtil.convertToDate(lastSyncOrgTamp);
        QFilter qFilter = new QFilter("view", "=", (Object)1L);
        if (this.params != null && null != this.params.get("orgList")) {
            qFilter.and(new QFilter("org", "in", this.params.get("orgList")));
        } else {
            QFilter createtimeFilter = new QFilter("createtime", ">=", (Object)changeTime);
            QFilter modifytimeFilter = new QFilter("modifytime", ">=", (Object)changeTime);
            QFilter timeFilter = createtimeFilter.or(modifytimeFilter);
            qFilter.and(timeFilter);
        }
        qFilter.and(new QFilter("isfreeze", "=", (Object)"0"));
        qFilter.and(new QFilter("enable", "=", (Object)"1"));
        DynamicObjectCollection orgDOs = QueryServiceHelper.query((String)"bos_adminorg_structure", (String)"number, org, org.name, parent, createtime, modifytime, isfreeze", (QFilter[])new QFilter[]{qFilter}, (String)"level");
        ArrayList resList = Lists.newArrayListWithCapacity((int)orgDOs.size());
        HashMap<Object, Object> mappingData = TripSyncDataMappingUtil.getIdDataMappingMap(Supplier.MEITUAN.getValue(), "bos_org");
        logger.info("\u5916\u90e8\u5173\u8054\u6570\u636e\u96c6\u5408:" + mappingData);
        orgDOs.stream().forEach(v -> {
            JSONObject dataJson = new JSONObject();
            MeiTuanTripUtil.delaCommonParams(dataJson, "sync_org");
            String parentDeptNO = String.valueOf(v.getLong("parent"));
            if (v.getLong("parent") == 0L) {
                parentDeptNO = "0";
            }
            dataJson.put("unitCode", (Object)v.getLong("org"));
            dataJson.put("name", (Object)v.getString("org.name").replaceAll("-", "").replaceAll(",", ""));
            dataJson.put("status", (Object)"true");
            logger.info("\u7236\u7ea7ID" + parentDeptNO);
            String value = null;
            if (StringUtils.isNotEmpty((String)parentDeptNO)) {
                try {
                    long key = Long.parseLong(parentDeptNO);
                    value = mappingData.getOrDefault(key, parentDeptNO);
                }
                catch (NumberFormatException e) {
                    value = parentDeptNO;
                }
            } else {
                value = parentDeptNO;
            }
            dataJson.put("parentId", (Object)value);
            resList.add(dataJson);
        });
        return resList;
    }

    protected Object convert(Object info) {
        return info;
    }

    protected String batPushProcess(Object o) {
        List datas = (List)o;
        if (CollectionUtils.isEmpty((Collection)datas)) {
            this.tripSyncLogParam.setMessage(ResManager.loadKDString((String)"\u5546\u65c5\u96c6\u6210,\u7ec4\u7ec7\u66f4\u65b0,\u7ec4\u7ec7\u4e3a\u7a7a!", (String)"MeiTuanTripOrgInvoke_0", (String)"fi-er-business", (Object[])new Object[0]));
            return "200";
        }
        String url = "/ent/org/save";
        String requestUrl = MeiTuanTripUtil.getMeiTuanUrl() + url;
        AtomicReference<String> code = new AtomicReference<String>("200");
        boolean interrupt = false;
        if (datas.size() > 100) {
            interrupt = true;
        }
        boolean finalInterrupt = interrupt;
        HashMap tmpMap = new HashMap(16);
        datas.forEach(dataJson -> {
            String unitCode = dataJson.get((Object)"unitCode").toString();
            String parentId = dataJson.get((Object)"parentId").toString();
            if (tmpMap.containsKey(parentId)) {
                dataJson.put("parentId", tmpMap.get(parentId));
            }
            TripSyncLogParam currentLog = this.tripSyncLogParam.clone();
            List<NameValuePair> bodyParams = MeiTuanTripUtil.getBodyParams(dataJson);
            currentLog.setRequestdata(dataJson);
            currentLog.setRequesturl(requestUrl);
            Map<String, Object> resultMap = HttpServiceHelper.httpPost(requestUrl, bodyParams);
            currentLog.setResponsedata(resultMap);
            if (resultMap != null) {
                if (resultMap.containsKey("status")) {
                    String status = resultMap.get("status").toString();
                    if (!"0".equals(status)) {
                        code.set("B");
                        currentLog.setMessage(resultMap.get("msg"));
                        currentLog.setStatus("B");
                    } else {
                        LinkedHashMap data = (LinkedHashMap)resultMap.get("data");
                        Object orgId = data.get("orgId");
                        TripSyncDataMappingModel mappingModel = new TripSyncDataMappingModel("bos_org", this.supplier());
                        mappingModel.setInnerdataid(Long.parseLong(unitCode));
                        mappingModel.setOutdataid(Long.parseLong(orgId.toString()));
                        mappingModel.setCreatetime(new Date());
                        TripSyncDataMappingUtil.saveTripSyncDataMapping(Collections.singletonList(mappingModel));
                        currentLog.setStatus("A");
                        tmpMap.put(unitCode, orgId.toString());
                    }
                } else {
                    code.set("B");
                    currentLog.setMessage(resultMap.containsKey("message") ? resultMap.get("message") : resultMap.get("msg"));
                    currentLog.setStatus("B");
                }
            } else {
                currentLog.setStatus("B");
            }
            this.tripSyncLogParamList.add(currentLog);
            if (finalInterrupt) {
                try {
                    Thread.sleep(600L);
                }
                catch (InterruptedException e) {
                    logger.error("Line 143 \u7f8e\u56e2\u540c\u6b65\u7ec4\u7ec7\u9519\u8bef", (Throwable)e);
                }
            }
        });
        return code.get();
    }
}

