/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.trip.supplier.meituan.invoke;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.utils.DateUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.bos.util.StringUtils;
import kd.fi.er.business.servicehelper.CoreBaseBillServiceHelper;
import kd.fi.er.business.servicehelper.HttpServiceHelper;
import kd.fi.er.business.trip.dao.UserDao;
import kd.fi.er.business.trip.exception.TripSyncLogParam;
import kd.fi.er.business.trip.service.function.AbstractUserInvoke;
import kd.fi.er.business.trip.supplier.Supplier;
import kd.fi.er.business.trip.supplier.meituan.utils.MeiTuanTripUtil;
import kd.fi.er.business.trip.util.UserHelper;
import org.apache.http.NameValuePair;

public class MeiTuanTripUserInvoke
extends AbstractUserInvoke<Set<JSONObject>> {
    private static Log logger = LogFactory.getLog(MeiTuanTripUserInvoke.class);
    private static final String LAST_SYNC_PEOPLE_TAMP = "lastsyncpeopletamp";

    @Override
    protected String supplier() {
        return Supplier.MEITUAN.name();
    }

    @Override
    protected Object getInnerData() {
        this.bizInfoObject = BusinessDataServiceHelper.loadSingle((String)"er_biz_info", (String)LAST_SYNC_PEOPLE_TAMP, (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)this.supplier())});
        this.lastSyncPeopleTamp = this.bizInfoObject.getString(LAST_SYNC_PEOPLE_TAMP);
        return this.getInnerData(this.lastSyncPeopleTamp, (Integer)1, (Integer)1000000, (Map)null);
    }

    @Override
    protected Object getInnerData(String changeTime, Integer pageIndex, Integer pageSize, Map map) {
        if (map == null) {
            map = new HashMap();
        }
        return this.queryChangeUserInfo(changeTime, pageIndex, pageSize, map);
    }

    private Object queryChangeUserInfo(String changeTime, Integer pageIndex, Integer pageSize, Map map) {
        return this.queryUerInfos(pageIndex, pageSize, DateUtils.parseDate((Object)changeTime), map);
    }

    private Object queryUerInfos(Integer pageIndex, Integer pageSize, Date changetime, Map<String, Object> paramMap) {
        List<Map<String, Object>> changeUserInfos = UserHelper.getUserInfosByTimeNew(pageIndex, pageSize, changetime, paramMap);
        if (CollectionUtils.isEmpty(changeUserInfos)) {
            return null;
        }
        Map<Long, String> reimburseLevelMap = UserDao.getReimburseLevelNew(changeUserInfos);
        ArrayList<Map<String, Object>> maxTimeUserChangeInfos = new ArrayList<Map<String, Object>>();
        changeUserInfos.stream().collect(Collectors.groupingBy(v -> v.get("id").toString())).forEach((key, valueList) -> maxTimeUserChangeInfos.add(valueList.stream().filter(v -> v.get("modifytime") != null).max(Comparator.comparing(v -> (Date)v.get("modifytime"))).get()));
        this.sortList(maxTimeUserChangeInfos);
        if (CollectionUtils.isEmpty(maxTimeUserChangeInfos)) {
            return null;
        }
        logger.info("Line 97 \u5f53\u524d\u540c\u6b65\u4eba\u5458\u6570\u91cf:" + maxTimeUserChangeInfos.size());
        return this.dealDataAndGenerateJson(maxTimeUserChangeInfos, reimburseLevelMap);
    }

    private Object queryAllUserInfos(Integer pageIndex, Integer pageSize, Map<String, Object> map) {
        List<Map<String, Object>> allUserInfos = UserHelper.getAllUserChangeInfos(pageIndex, pageSize, map);
        Map<Long, String> reimburseLevelMap = UserDao.getReimburseLevel(allUserInfos.stream().map(e -> Long.parseLong((String)e.get("id"))).collect(Collectors.toSet()));
        ArrayList<Map<String, Object>> maxTimeUserChangeInfos = new ArrayList<Map<String, Object>>();
        allUserInfos.stream().collect(Collectors.groupingBy(v -> v.get("id").toString())).forEach((key, valueList) -> maxTimeUserChangeInfos.add(valueList.stream().filter(v -> v.get("changetime") != null).max(Comparator.comparing(v -> (Date)v.get("changetime"))).get()));
        this.sortList(maxTimeUserChangeInfos);
        if (CollectionUtils.isEmpty(maxTimeUserChangeInfos)) {
            return null;
        }
        logger.info("Line 114 \u5f53\u524d\u540c\u6b65\u4eba\u5458\u6570\u91cf:" + maxTimeUserChangeInfos.size());
        return this.dealDataAndGenerateJson(maxTimeUserChangeInfos, reimburseLevelMap);
    }

    private Object dealDataAndGenerateJson(List<Map<String, Object>> userInfos, Map<Long, String> reimburseLevelMap) {
        JSONObject dataJson = new JSONObject();
        MeiTuanTripUtil.delaCommonParams(dataJson, "sync_user");
        List lists = Lists.partition(userInfos, (int)50);
        ArrayList resList = Lists.newArrayListWithCapacity((int)lists.size());
        for (int i = 0; i < lists.size(); ++i) {
            List maps = (List)lists.get(i);
            JSONArray staffInfos = new JSONArray();
            for (int j = 0; j < maps.size(); ++j) {
                Map<String, Object> userMap = userInfos.get(j);
                JSONObject userJson = new JSONObject();
                userJson.put("name", userMap.get("name"));
                userJson.put("entstaffNum", userMap.get("number"));
                userJson.put("level", (Object)reimburseLevelMap.get(Long.valueOf(String.valueOf(userMap.get("id")))));
                ArrayList<Object> deptList = new ArrayList<Object>();
                deptList.add(userMap.get("dptId"));
                userJson.put("orgUnitCodes", (Object)deptList.toArray());
                Object type = userMap.get("type");
                if (Arrays.asList("1", "2", "5").contains(type)) {
                    userJson.put("staffStatus", (Object)"0");
                } else if (Objects.equals("4", type)) {
                    userJson.put("staffStatus", (Object)"3");
                }
                userJson.put("status", (Object)"true");
                Long accountOrgId = CoreBaseBillServiceHelper.getAccountOrgId(Long.parseLong(userMap.get("dptId").toString()), true);
                DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)"bos_org", (String)"ftaxregnum", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)accountOrgId)});
                if (dynamicObject != null) {
                    userJson.put("taxNumber", dynamicObject.get("ftaxregnum"));
                }
                staffInfos.add((Object)userJson);
            }
            dataJson.put("staffInfos", (Object)staffInfos);
            resList.add(dataJson);
        }
        return resList;
    }

    @Override
    protected boolean syncUserByPage() {
        return Boolean.TRUE;
    }

    protected Object convert(Object info) {
        return info;
    }

    protected String batPushProcess(Object o) {
        List resList = (List)o;
        if (CollectionUtils.isEmpty((Collection)resList)) {
            this.tripSyncLogParam.setMessage(ResManager.loadKDString((String)"\u5546\u65c5\u96c6\u6210,\u4eba\u5458\u66f4\u65b0,\u4eba\u5458\u4e3a\u7a7a!", (String)"MeiTuanTripUserInvoke_0", (String)"fi-er-business", (Object[])new Object[0]));
            return "200";
        }
        AtomicReference<String> code = new AtomicReference<String>("200");
        String url = "/staff/batch/save";
        String requestUrl = MeiTuanTripUtil.getMeiTuanUrl() + url;
        int size = resList.size();
        boolean interrupt = false;
        if (size > 100) {
            interrupt = true;
        }
        boolean finalInterrupt = interrupt;
        resList.forEach(dataJson -> {
            TripSyncLogParam currentLog = this.tripSyncLogParam.clone();
            List<NameValuePair> bodyParams = MeiTuanTripUtil.getBodyParams(dataJson);
            JSONObject postJson = MeiTuanTripUtil.structurePostJson(dataJson);
            currentLog.setRequestdata(dataJson);
            currentLog.setRequesturl(requestUrl);
            Map<String, Object> resultMap = HttpServiceHelper.httpPost(requestUrl, bodyParams);
            currentLog.setResponsedata(resultMap);
            if (resultMap != null) {
                Object allStatus = resultMap.get("status");
                if (allStatus != null && "0".equals(allStatus.toString())) {
                    LinkedHashMap data = (LinkedHashMap)resultMap.get("data");
                    List staffSyncItems = (List)data.get("staffSyncItems");
                    String status = "";
                    String errorMsg = "";
                    for (int i = 0; i < staffSyncItems.size(); ++i) {
                        LinkedHashMap result = (LinkedHashMap)staffSyncItems.get(i);
                        status = result.get("result").toString();
                        if ("0".equals(status)) continue;
                        errorMsg = result.get("msg").toString();
                        break;
                    }
                    if (!"0".equals(status)) {
                        code.set("300");
                        if (StringUtils.isEmpty((String)errorMsg)) {
                            errorMsg = ResManager.loadKDString((String)"\u5546\u65c5\u96c6\u6210\u5931\u8d25\u3002", (String)"MeiTuanTripUserInvoke_1", (String)"fi-er-business", (Object[])new Object[0]);
                        }
                        currentLog.setMessage(errorMsg);
                        currentLog.setStatus("B");
                    } else {
                        code.set("200");
                        currentLog.setStatus("A");
                    }
                } else {
                    Object msg;
                    code.set("300");
                    Object object = msg = resultMap.containsKey("msg") ? resultMap.get("msg") : resultMap.get("message");
                    if (msg == null) {
                        msg = ResManager.loadKDString((String)"\u5546\u65c5\u96c6\u6210\u5931\u8d25\u3002", (String)"MeiTuanTripUserInvoke_1", (String)"fi-er-business", (Object[])new Object[0]);
                    }
                    currentLog.setMessage(msg);
                    currentLog.setStatus("B");
                }
            } else {
                currentLog.setStatus("B");
            }
            this.addTripSyncLogParam(currentLog);
            this.tripSyncLogParamList.add(currentLog);
            if (finalInterrupt) {
                try {
                    Thread.sleep(600L);
                }
                catch (InterruptedException e) {
                    logger.error("Line 143 \u7f8e\u56e2\u540c\u6b65\u4eba\u5458\u9519\u8bef", (Throwable)e);
                }
            }
        });
        return code.get();
    }

    private void sortList(List<Map<String, Object>> maxTimeUserChangeInfos) {
        maxTimeUserChangeInfos.sort(Comparator.comparing(t -> String.valueOf(t.get("modifytime"))));
    }
}

