/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.trip.supplier.meituan.utils;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.er.business.servicehelper.HttpServiceHelper;
import kd.fi.er.business.trip.exception.TripSyncLogParam;
import kd.fi.er.business.trip.supplier.Supplier;
import kd.fi.er.business.trip.supplier.meituan.utils.EncryptUtil;
import kd.fi.er.business.trip.util.TripCommonUtil;
import org.apache.http.NameValuePair;
import org.apache.http.message.BasicNameValuePair;

public class MeiTuanTripUtil {
    private static final Log logger = LogFactory.getLog(MeiTuanTripUtil.class);
    private static final String USER_TYPE = "sync_user";
    private static final String ORG_TYPE = "sync_org";
    private static final String BILL_TYPE = "sync_bill";
    private static final String ORDER_LIST_TYPE = "order_list_query";
    private static final String ORDER_DETAIL_TYPE = "order_detail_query";
    private static final String VERSION = "1.0";

    public static void delaCommonParams(JSONObject dataJson, String syncType) {
        String syncMethod = "";
        switch (syncType) {
            case "sync_user": {
                syncMethod = "staff.batch.save";
                break;
            }
            case "sync_org": {
                syncMethod = "ent.org.save";
                break;
            }
            case "sync_bill": {
                syncMethod = "repast.apply.sync";
                break;
            }
            case "order_list_query": {
                syncMethod = "order.list.query";
                break;
            }
            case "order_detail_query": {
                syncMethod = "order.detail.query";
            }
        }
        dataJson.put("method", (Object)syncMethod);
        dataJson.put("ts", (Object)String.valueOf(System.currentTimeMillis()).substring(0, 10));
        dataJson.put("entId", (Object)MeiTuanTripUtil.getMeiTuanOrationid());
    }

    public static String getCommonParam(String key) {
        Map<String, String> supplierMap = TripCommonUtil.getTripServiceInfo(Supplier.MEITUAN.name());
        if (supplierMap == null || supplierMap.size() < 1 || supplierMap.get(key) == null) {
            return "";
        }
        return supplierMap.get(key);
    }

    public static String getMeiTuanUrl() {
        return MeiTuanTripUtil.getCommonParam("reservedfield1");
    }

    public static String getMeiTuanAppKey() {
        return MeiTuanTripUtil.getCommonParam("appkey");
    }

    public static String getMeiTuanSecretKey() {
        return MeiTuanTripUtil.getCommonParam("appsecurity");
    }

    public static String getMeiTuanOrationid() {
        return MeiTuanTripUtil.getCommonParam("orationid");
    }

    public static String getMeiTuanH5Url() {
        return MeiTuanTripUtil.getCommonParam("reservedfield2");
    }

    public static JSONObject structurePostJson(JSONObject dataJson) {
        JSONObject postJson = new JSONObject();
        try {
            postJson.put("token", (Object)MeiTuanTripUtil.getMeiTuanAppKey());
            postJson.put("version", (Object)VERSION);
            logger.info("MeiTuanTripUtil.structurePostJson\u52a0\u5bc6\u524d\u7684\u6570\u636e\u4e3a\uff1a" + dataJson.toJSONString());
            postJson.put("content", (Object)EncryptUtil.aesEncrypt(dataJson.toJSONString(), MeiTuanTripUtil.getMeiTuanSecretKey()));
        }
        catch (Exception e) {
            logger.error("Line 124 ", (Throwable)e);
        }
        return postJson;
    }

    public static List<NameValuePair> getBodyParams(JSONObject dataJson) {
        ArrayList<NameValuePair> body_params = new ArrayList<NameValuePair>();
        try {
            body_params.add((NameValuePair)new BasicNameValuePair("token", MeiTuanTripUtil.getMeiTuanAppKey()));
            body_params.add((NameValuePair)new BasicNameValuePair("version", VERSION));
            body_params.add((NameValuePair)new BasicNameValuePair("content", EncryptUtil.aesEncrypt(dataJson.toJSONString(), MeiTuanTripUtil.getMeiTuanSecretKey())));
        }
        catch (Exception e) {
            logger.error("Line 142 ", (Throwable)e);
        }
        return body_params;
    }

    public static JSONObject doHttpPost(JSONObject dataJson, String url, String method, AtomicReference<Boolean> syncSuccessFlag, TripSyncLogParam currentLog, List<TripSyncLogParam> tripSyncLogParamList) {
        MeiTuanTripUtil.delaCommonParams(dataJson, method);
        List<NameValuePair> bodyParams = MeiTuanTripUtil.getBodyParams(dataJson);
        currentLog.setRequesturl(url);
        currentLog.setRequestdata(dataJson);
        Map<String, Object> resultMap = HttpServiceHelper.httpPost(url, bodyParams);
        if (ORDER_DETAIL_TYPE.equals(method)) {
            currentLog.setBillno(dataJson.getString("sqtBizOrderId"));
        }
        currentLog.setResponsedata(resultMap);
        if (resultMap == null) {
            syncSuccessFlag.set(Boolean.FALSE);
            tripSyncLogParamList.add(currentLog);
            return null;
        }
        if (!"0".equals(resultMap.get("status").toString())) {
            currentLog.setStatus("B");
            currentLog.setMessage(resultMap.get("msg"));
            syncSuccessFlag.set(Boolean.FALSE);
            tripSyncLogParamList.add(currentLog);
            return null;
        }
        currentLog.setStatus("A");
        syncSuccessFlag.set(Boolean.TRUE);
        tripSyncLogParamList.add(currentLog);
        return new JSONObject(resultMap);
    }

    public static String getAppPrivateKey() {
        String privateKey = MeiTuanTripUtil.getCommonParam("reservedfield3");
        String afterEncryptStr = "";
        try {
            afterEncryptStr = EncryptUtil.aesDecrypt(privateKey, MeiTuanTripUtil.getMeiTuanSecretKey());
        }
        catch (Exception exception) {
            logger.error("Line 182", (Throwable)exception);
        }
        return afterEncryptStr;
    }

    public static String getAppPrivateKey(boolean decrypt) {
        if (decrypt) {
            return MeiTuanTripUtil.getAppPrivateKey();
        }
        return MeiTuanTripUtil.getCommonParam("reservedfield3");
    }

    public static String getMeiTuanAppId() {
        return MeiTuanTripUtil.getCommonParam("reservedfield4");
    }
}

