/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.trip.supplier.travelno1.invoke;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.er.business.servicehelper.HttpServiceHelper;
import kd.fi.er.business.trip.model.DailyVehicleBillModel;
import kd.fi.er.business.trip.service.function.AbstractDailyVehicleBillInvoke;
import kd.fi.er.business.trip.supplier.Supplier;
import kd.fi.er.business.trip.supplier.travelno1.systemexternal.TravelNoOneSync;
import kd.fi.er.business.trip.util.TripCommonUtil;
import kd.fi.er.business.trip.util.TripSyncConfigUtil;
import org.apache.commons.lang.StringUtils;

public class TTripDailyVehicleBillInvoke
extends AbstractDailyVehicleBillInvoke<JSONObject> {
    private static final Log logger = LogFactory.getLog(TTripDailyVehicleBillInvoke.class);

    public TTripDailyVehicleBillInvoke(Object pk) {
        super(pk);
    }

    public TTripDailyVehicleBillInvoke() {
    }

    @Override
    protected String supplier() {
        return Supplier.CHAILVYIHAO.name();
    }

    protected JSONObject convert(Object value) {
        if (this.pk != null) {
            logger.info("\u5546\u65c5\u96c6\u6210,\u5dee\u65c5\u58f9\u53f7\u7528\u8f66\u7533\u8bf7\u5355,\u5355\u636ebillid\u4e3a:" + this.pk);
            return this.convertPushBill(value);
        }
        String syncStatus = (String)this.getParams().get("syncStatus");
        logger.info("\u5546\u65c5\u96c6\u6210,\u5dee\u65c5\u58f9\u53f7\u7528\u8f66\u7533\u8bf7\u5355,\u540c\u6b65\u7684\u72b6\u6001\u6709:1_\u63a8\u9001\u5355\u636e,2_\u5173\u95ed\u5355\u636e,3_\u542f\u7528\u5355\u636e,4_\u64a4\u9500\u5355\u636e,\u5f53\u524d\u72b6\u6001\u4e3a:" + syncStatus);
        switch (syncStatus) {
            case "1": {
                return this.convertPushBill(value);
            }
        }
        return null;
    }

    protected JSONObject convertPushBill(Object info) {
        DailyVehicleBillModel reqbill = (DailyVehicleBillModel)info;
        logger.info("\u5546\u65c5\u96c6\u6210,\u5dee\u65c5\u58f9\u53f7\u7528\u8f66\u7533\u8bf7\u5355,\u63a8\u9001\u8f6c\u6362:" + reqbill.getBillNo());
        JSONObject bodyDataJson = new JSONObject();
        JSONArray dataArray = new JSONArray();
        JSONArray applyList = new JSONArray();
        JSONArray voyageList = new JSONArray();
        JSONArray staffList = new JSONArray();
        JSONObject dataObject = new JSONObject();
        JSONObject applyObject = new JSONObject();
        JSONObject handoverStaff = new JSONObject();
        JSONObject submitStaff = new JSONObject();
        JSONObject voyageObject = new JSONObject();
        voyageObject.put("beginDate", (Object)TripCommonUtil.date2TimeStamp(reqbill.getStartdate(), "yyyy-MM-dd"));
        voyageObject.put("endDate", (Object)TripCommonUtil.date2TimeStamp(reqbill.getEnddate(), "yyyy-MM-dd"));
        voyageObject.put("fromCity", (Object)reqbill.getVehiclecityName());
        voyageObject.put("toCity", (Object)reqbill.getVehiclecityName());
        voyageObject.put("travelNo", (Object)1);
        voyageObject.put("travelType", (Object)2);
        voyageObject.put("travelTypeName", (Object)ResManager.loadKDString((String)"\u6c7d\u8f66", (String)"TTripDailyVehicleBillInvoke_0", (String)"fi-er-business", (Object[])new Object[0]));
        voyageObject.put("voyageType", (Object)1);
        voyageObject.put("voyageTypeName", (Object)ResManager.loadKDString((String)"\u5f80\u8fd4", (String)"TTripDailyVehicleBillInvoke_1", (String)"fi-er-business", (Object[])new Object[0]));
        voyageList.add((Object)voyageObject);
        JSONObject staffObject1 = new JSONObject();
        staffObject1.put("staffName", (Object)reqbill.getApplyEmpName());
        staffObject1.put("empID", (Object)reqbill.getApplyEmpNum());
        staffList.add((Object)staffObject1);
        if (!reqbill.getCreatEmpNum().equals(reqbill.getApplyEmpNum())) {
            JSONObject staffObject2 = new JSONObject();
            staffObject2.put("staffName", (Object)reqbill.getCreatEmpName());
            staffObject2.put("empID", (Object)reqbill.getCreatEmpNum());
            staffList.add((Object)staffObject2);
        }
        applyObject.put("staffList", (Object)staffList);
        applyObject.put("voyageList", (Object)voyageList);
        applyList.add((Object)applyObject);
        handoverStaff.put("staffName", (Object)reqbill.getAduitEmpName());
        handoverStaff.put("empID", (Object)reqbill.getAduitEmpNum());
        submitStaff.put("staffName", (Object)reqbill.getCreatEmpName());
        submitStaff.put("empID", (Object)reqbill.getCreatEmpNum());
        dataObject.put("applyId", (Object)reqbill.getBillNo());
        dataObject.put("applyList", (Object)applyList);
        dataObject.put("applyPassState", (Object)0);
        dataObject.put("applyPurpose", (Object)reqbill.getDesc());
        dataObject.put("applyReason", (Object)reqbill.getDesc());
        dataObject.put("businessType", (Object)2);
        QFilter qA = new QFilter("enable", "=", (Object)"1");
        QFilter qB = new QFilter("applysource", "=", (Object)"er_dailyvehiclebill");
        QFilter qC = new QFilter("vehicletype", "=", (Object)reqbill.getVehicletype());
        QFilter qD = new QFilter("server", "=", (Object)Supplier.CHAILVYIHAO.name());
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((String)"er_trip_vehicle_setting", (String)"number,name,vehicletype", (QFilter[])new QFilter[]{qA, qB, qC, qD});
        if (null != dynamicObject) {
            dataObject.put("travelTypeCode", (Object)dynamicObject.getString("number"));
            dataObject.put("travelTypeName", (Object)dynamicObject.getString("name"));
        }
        dataObject.put("applicationUseMaxCounts", (Object)reqbill.getVehiclenumber());
        dataObject.put("applicationUseCount", (Object)0);
        dataObject.put("applyState", (Object)1);
        this.setReqBillSettleOrg(reqbill, dataObject);
        dataObject.put("costCenterType", (Object)1);
        dataObject.put("handoverStaff", (Object)handoverStaff);
        dataObject.put("submitStaff", (Object)submitStaff);
        dataArray.add((Object)dataObject);
        try {
            String token = TravelNoOneSync.getLoginToken();
            bodyDataJson.put("access_token", (Object)token);
        }
        catch (KDBizException e) {
            this.tripSyncLogParam.setRequesturl(TripCommonUtil.getTravelNoOneApiUrl("tokenurlkey"));
            this.tripSyncLogParam.setStatus("B");
            throw new KDBizException(new ErrorCode("doPost", String.format(ResManager.loadKDString((String)"\u6267\u884c\u8bf7\u6c42\u8fc7\u7a0b\u4e2d\u51fa\u73b0\u5f02\u5e38\u3002%s", (String)"TTripDailyVehicleBillInvoke_3", (String)"fi-er-business", (Object[])new Object[0]), new Object[]{e})), new Object[0]);
        }
        bodyDataJson.put("data", (Object)dataArray);
        SimpleDateFormat dataFormat = new SimpleDateFormat("yyyyMMddHHmmssSSS");
        String datestr = dataFormat.format(new Date());
        bodyDataJson.put("requestid", (Object)datestr);
        bodyDataJson.put("version", (Object)"0.0.1");
        return bodyDataJson;
    }

    private void setReqBillSettleOrg(DailyVehicleBillModel reqbill, JSONObject dataObject) {
        Map<String, String> tripInfoDynamic = TripCommonUtil.getTripServiceInfo(Supplier.CHAILVYIHAO.name());
        if (tripInfoDynamic != null && tripInfoDynamic.size() > 0) {
            String deptName;
            String companyName;
            String param = tripInfoDynamic.get("syncreqbillsettleorg");
            boolean flag = param == null || StringUtils.isBlank((String)param) || "0".equalsIgnoreCase(param);
            boolean isTtrpReqSyncId = TripSyncConfigUtil.getBoolean("ttrip_issyncorg_num");
            if (isTtrpReqSyncId) {
                String deptNum;
                String companyNum;
                if (flag) {
                    companyName = reqbill.getCostCompany();
                    companyNum = reqbill.getCostCompanyNum();
                    deptName = reqbill.getCostdept();
                    deptNum = reqbill.getCostdeptNum();
                } else {
                    companyName = reqbill.getCompany();
                    companyNum = reqbill.getCompanyNum();
                    deptName = reqbill.getDept();
                    deptNum = reqbill.getDeptNum();
                }
                dataObject.put("settlementEntityCode", (Object)companyNum);
                dataObject.put("costCenterNo", (Object)deptNum);
            } else {
                Long deptId;
                Long companyId;
                if (flag) {
                    companyName = reqbill.getCostCompany();
                    companyId = reqbill.getCostCompanyId();
                    deptName = reqbill.getCostdept();
                    deptId = reqbill.getCostdeptId();
                } else {
                    companyName = reqbill.getCompany();
                    companyId = reqbill.getCompanyId();
                    deptName = reqbill.getDept();
                    deptId = reqbill.getDeptId();
                }
                dataObject.put("settlementEntityCode", (Object)companyId);
                dataObject.put("costCenterNo", (Object)deptId);
            }
            dataObject.put("settlementEntityName", (Object)companyName);
            dataObject.put("costCenterName", (Object)deptName);
        }
    }

    protected String batPushProcess(Object value) {
        String syncStatus;
        if (value == null) {
            return null;
        }
        JSONObject t = (JSONObject)value;
        String jsonStr = JSON.toJSONString((Object)t, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.DisableCircularReferenceDetect});
        String url = "";
        switch (syncStatus = (String)this.getParams().get("syncStatus")) {
            case "1": {
                url = TripCommonUtil.getTravelNoOneApiUrl("addCarApproval");
                break;
            }
            case "2": {
                url = TripCommonUtil.getTravelNoOneApiUrl("updateApprovalStatus");
            }
        }
        this.tripSyncLogParam.setRequestdata(value);
        this.tripSyncLogParam.setRequesturl(url);
        String result = HttpServiceHelper.PostData(url, jsonStr);
        this.tripSyncLogParam.setResponsedata(result);
        JSONObject jsonObject = JSONObject.parseObject((String)result);
        if (jsonObject != null) {
            if (syncStatus == "4") {
                String backCode = null;
                JSONArray relateOrderList = jsonObject.getJSONArray("relateOrderList");
                String errcode = jsonObject.getString("errcode");
                if ("0".equals(errcode)) {
                    backCode = "200";
                } else if ("1".equals(errcode)) {
                    backCode = relateOrderList == null ? "200" : "300";
                }
                return backCode;
            }
            Boolean isSucess = jsonObject.getBoolean("successful");
            if (isSucess.booleanValue()) {
                return "200";
            }
        }
        return null;
    }

    @Deprecated
    private JSONObject convertCloseBill(Object value, String syncStatus) {
        DailyVehicleBillModel dailyVehicleBillModel = (DailyVehicleBillModel)value;
        JSONObject dataObject = new JSONObject();
        dataObject.put("thirdApplyID", (Object)dailyVehicleBillModel.getBillNo());
        String createDate = TripCommonUtil.date2TimeStamp(dailyVehicleBillModel.getCreatetime(), "yyyy-MM-dd hh:mm");
        dataObject.put("applicationTime", (Object)createDate);
        switch (syncStatus) {
            case "2": {
                dataObject.put("applicationType", (Object)1);
                dataObject.put("dealType", (Object)syncStatus);
            }
        }
        JSONObject bodyDataJson = new JSONObject();
        bodyDataJson.put("access_token", (Object)TravelNoOneSync.getLoginToken());
        bodyDataJson.put("data", (Object)dataObject);
        SimpleDateFormat dataFormat = new SimpleDateFormat("yyyyMMddHHmmssSSS");
        String datestr = dataFormat.format(new Date());
        bodyDataJson.put("requestid", (Object)datestr);
        bodyDataJson.put("version", (Object)"0.0.1");
        return bodyDataJson;
    }
}

