/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.trip.supplier.travelno1.invoke;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.er.business.servicehelper.HttpRetryServiceHelper;
import kd.fi.er.business.trip.exception.TripException;
import kd.fi.er.business.trip.model.InvoiceModel;
import kd.fi.er.business.trip.service.function.AbstractInvoiceReceiveInvoke;
import kd.fi.er.business.trip.supplier.Supplier;
import kd.fi.er.business.trip.supplier.travelno1.systemexternal.TTripPropMapping;
import kd.fi.er.business.trip.supplier.travelno1.systemexternal.TravelNoOneSync;
import kd.fi.er.business.trip.util.TripCommonUtil;
import org.apache.commons.lang3.StringUtils;

public class TTripInvoiceReceiveInvoke
extends AbstractInvoiceReceiveInvoke<JSONObject> {
    private static final Log logger = LogFactory.getLog(TTripInvoiceReceiveInvoke.class);
    private static final String TRAVEL_ITINERARY = "TRAVEL_ITINERARY";
    private static final String INVOICE = "INVOICE";

    @Override
    protected String supplier() {
        return Supplier.CHAILVYIHAO.name();
    }

    protected Object process(Map params) throws TripException {
        if (null != params.get("jsondata")) {
            return (Map)JSON.parseObject((String)JSON.toJSONString((Object)JSON.parseArray((String)JSON.toJSONString(params.get("jsondata"))).get(0))).get((Object)"data");
        }
        if (null == params.get("data")) {
            return this.getData(params);
        }
        this.tripSyncLogParam.setResponsedata(params);
        return (List)params.get("data");
    }

    private Map<String, Object> getData(Map params) {
        JSONObject bodyDataJson = new JSONObject();
        bodyDataJson.put("data", params.get("batchnos"));
        SimpleDateFormat dataFormat = new SimpleDateFormat("yyyyMMddHHmmssSSS");
        String datestr = dataFormat.format(new Date());
        bodyDataJson.put("requestid", (Object)datestr);
        bodyDataJson.put("version", (Object)"0.0.1");
        bodyDataJson.put("dataType", (Object)"1");
        bodyDataJson.put("mark", (Object)"0");
        bodyDataJson.put("withDetail", (Object)true);
        try {
            String token = TravelNoOneSync.getLoginToken();
            bodyDataJson.put("access_token", (Object)token);
        }
        catch (KDBizException e) {
            this.tripSyncLogParam.setRequesturl(TripCommonUtil.getTravelNoOneApiUrl("tokenurlkey"));
            this.tripSyncLogParam.setStatus("B");
            throw new KDBizException(new ErrorCode("doPost", String.format(ResManager.loadKDString((String)"\u6267\u884c\u8bf7\u6c42\u8fc7\u7a0b\u4e2d\u51fa\u73b0\u5f02\u5e38\u3002%s", (String)"TTripInvoiceReceiveInvoke_2", (String)"fi-er-business", (Object[])new Object[0]), new Object[]{e})), new Object[0]);
        }
        String jsonStr = JSON.toJSONString((Object)bodyDataJson, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.DisableCircularReferenceDetect});
        String url = TripCommonUtil.getTravelNoOneApiUrl("fetchImageInfo");
        this.tripSyncLogParam.setRequestdata(bodyDataJson);
        this.tripSyncLogParam.setRequesturl(url);
        String result = HttpRetryServiceHelper.PostData(url, jsonStr);
        this.tripSyncLogParam.setResponsedata(result);
        JSONObject jsonObject = JSONObject.parseObject((String)result);
        if (jsonObject == null || null == jsonObject.getString("data")) {
            this.tripSyncLogParam.setRequesturl(url);
            this.tripSyncLogParam.setStatus("B");
            throw new KDBizException(new ErrorCode("500", ResManager.loadKDString((String)"\u5dee\u65c5\u58f9\u53f7\u83b7\u53d6\u53d1\u7968\u5931\u8d25\u3002", (String)"TTripInvoiceReceiveInvoke_3", (String)"fi-er-business", (Object[])new Object[0])), new Object[0]);
        }
        return (Map)JSON.parseObject((String)jsonObject.getString("data"), Map.class);
    }

    protected Object convert(Object value) throws TripException {
        if (value instanceof List) {
            return this.receiveInvoice(value);
        }
        if (value instanceof Map) {
            return this.getInvoice(value);
        }
        logger.info("\u53d1\u7968\u6570\u636e\u5f02\u5e38\uff1a{}", (Object)JSON.toJSONString((Object)value));
        return new ArrayList();
    }

    private Object getInvoice(Object value) {
        Map objectmap = (Map)value;
        int size = 0;
        if (null != objectmap.get("travelInfo")) {
            List travelInfos = (List)JSON.parseObject((String)JSON.toJSONString(objectmap.get("travelInfo")), List.class);
            size += travelInfos.size();
        }
        if (null != objectmap.get("trainInfo")) {
            List trainInfo = (List)JSON.parseObject((String)JSON.toJSONString(objectmap.get("trainInfo")), List.class);
            size += trainInfo.size();
        }
        if (null != objectmap.get("invoiceInfo")) {
            List invoiceInfos = (List)JSON.parseObject((String)JSON.toJSONString(objectmap.get("invoiceInfo")), List.class);
            size += invoiceInfos.size();
        }
        ArrayList invoiceDataList = Lists.newArrayListWithExpectedSize((int)size);
        if (null != objectmap.get("travelInfo")) {
            this.getTravelInfo(objectmap, invoiceDataList);
        }
        if (null != objectmap.get("trainInfo")) {
            List list = (List)JSON.parseObject((String)JSON.toJSONString(objectmap.get("trainInfo")), List.class);
        }
        if (null != objectmap.get("invoiceInfo")) {
            this.getInvoiceInfo(objectmap, invoiceDataList);
        }
        this.handleInvoiceGetExtConvert(invoiceDataList, JSON.parseObject((String)JSON.toJSONString((Object)value)));
        return invoiceDataList;
    }

    private void getTravelInfo(Map<String, Object> objectmap, List<InvoiceModel> invoiceDataList) {
        List travelInfos = (List)JSON.parseObject((String)JSON.toJSONString((Object)objectmap.get("travelInfo")), List.class);
        for (Object bill : travelInfos) {
            Map billMap = (Map)JSON.parseObject((String)JSON.toJSONString(bill), Map.class);
            if (null == billMap.get("billNo")) {
                logger.info("\u5546\u65c5\u96c6\u6210\uff0c\u83b7\u53d6\u53d1\u7968\uff0c\u53d1\u7968\u6570\u636e\u7f3a\u5931 billNo\uff1a{}", (Object)JSON.toJSONString(bill));
                throw new KDBizException(new ErrorCode("500", String.format(ResManager.loadKDString((String)"\u5dee\u65c5\u58f9\u53f7\u83b7\u53d6\u53d1\u7968\u6570\u636e\u7f3a\u5931billNo\u201c%s\u201d\u3002", (String)"TTripInvoiceReceiveInvoke_4", (String)"fi-er-business", (Object[])new Object[0]), JSON.toJSONString(bill))), new Object[0]);
            }
            if (null == billMap.get("infoList")) {
                logger.info("\u5546\u65c5\u96c6\u6210\uff0c\u83b7\u53d6\u53d1\u7968\uff0c\u53d1\u7968\u6570\u636e\u7f3a\u5931 infoList\uff1a{}", (Object)JSON.toJSONString(bill));
                throw new KDBizException(new ErrorCode("500", String.format(ResManager.loadKDString((String)"\u5dee\u65c5\u58f9\u53f7\u83b7\u53d6\u53d1\u7968\u6570\u636e\u7f3a\u5931infoList\u3002", (String)"TTripInvoiceReceiveInvoke_5", (String)"fi-er-business", (Object[])new Object[0]), JSON.toJSONString(bill))), new Object[0]);
            }
            String billNo = billMap.get("billNo").toString();
            BigDecimal invoiceamount = BigDecimal.ZERO;
            List infoList = (List)JSON.parseObject((String)JSON.toJSONString(billMap.get("infoList")), List.class);
            for (Object info : infoList) {
                Map infoMap = (Map)JSON.parseObject((String)JSON.toJSONString(info), Map.class);
                String businessCode = billNo + "-1";
                invoiceamount = invoiceamount.add((BigDecimal)infoMap.get("ticketTotalMoney"));
                String invoicenum = ResManager.loadKDString((String)"\u884c\u7a0b\u5355", (String)"TTripInvoiceReceiveInvoke_0", (String)"fi-er-business", (Object[])new Object[0]);
                String serviceitem = ResManager.loadKDString((String)"\u673a\u7968\u884c\u7a0b\u5355", (String)"TTripInvoiceReceiveInvoke_1", (String)"fi-er-business", (Object[])new Object[0]);
                InvoiceModel model = new InvoiceModel();
                model.setServer(this.supplier());
                model.setInvoiceamount(invoiceamount);
                model.setCustInvSequence(businessCode + "&" + serviceitem);
                model.setTrdInvoiceId(businessCode + "&" + serviceitem);
                model.setInvoicenum(invoicenum);
                invoiceDataList.add(model);
            }
        }
    }

    private void getInvoiceInfo(Map<String, Object> objectmap, List<InvoiceModel> invoiceDataList) {
        List invoiceInfos = (List)JSON.parseObject((String)JSON.toJSONString((Object)objectmap.get("invoiceInfo")), List.class);
        for (Object bill : invoiceInfos) {
            Map billMap = (Map)JSON.parseObject((String)JSON.toJSONString(bill), Map.class);
            if (null == billMap.get("billNo")) {
                logger.info("\u5546\u65c5\u96c6\u6210\uff0c\u83b7\u53d6\u53d1\u7968\uff0c\u53d1\u7968\u6570\u636e\u7f3a\u5931 billNo\uff1a{}", (Object)JSON.toJSONString(bill));
                throw new KDBizException(new ErrorCode("500", String.format(ResManager.loadKDString((String)"\u5dee\u65c5\u58f9\u53f7\u83b7\u53d6\u53d1\u7968\u6570\u636e\u7f3a\u5931billNo\u201c%s\u201d\u3002", (String)"TTripInvoiceReceiveInvoke_4", (String)"fi-er-business", (Object[])new Object[0]), JSON.toJSONString(bill))), new Object[0]);
            }
            if (null == billMap.get("infoList")) {
                logger.info("\u5546\u65c5\u96c6\u6210\uff0c\u83b7\u53d6\u53d1\u7968\uff0c\u53d1\u7968\u6570\u636e\u7f3a\u5931 infoList\uff1a{}", (Object)JSON.toJSONString(bill));
                throw new KDBizException(new ErrorCode("500", String.format(ResManager.loadKDString((String)"\u5dee\u65c5\u58f9\u53f7\u83b7\u53d6\u53d1\u7968\u6570\u636e\u7f3a\u5931infoList\u3002", (String)"TTripInvoiceReceiveInvoke_5", (String)"fi-er-business", (Object[])new Object[0]), JSON.toJSONString(bill))), new Object[0]);
            }
            String billNo = billMap.get("billNo").toString();
            List infoList = (List)JSON.parseObject((String)JSON.toJSONString(billMap.get("infoList")), List.class);
            for (Object info : infoList) {
                Map infoMap = (Map)JSON.parseObject((String)JSON.toJSONString(info), Map.class);
                if (null == infoMap.get("invoiceCode")) {
                    logger.info("\u5546\u65c5\u96c6\u6210\uff0c\u83b7\u53d6\u53d1\u7968\uff0c\u53d1\u7968\u6570\u636e\u7f3a\u5931 invoiceCode\uff1a{}", (Object)JSON.toJSONString(bill));
                    throw new KDBizException(new ErrorCode("500", String.format(ResManager.loadKDString((String)"\u5dee\u65c5\u58f9\u53f7\u83b7\u53d6\u53d1\u7968\u6570\u636e\u7f3a\u5931invoiceCode\u3002", (String)"TTripInvoiceReceiveInvoke_6", (String)"fi-er-business", (Object[])new Object[0]), JSON.toJSONString(bill))), new Object[0]);
                }
                if (null == infoMap.get("invoiceNum")) {
                    logger.info("\u5546\u65c5\u96c6\u6210\uff0c\u83b7\u53d6\u53d1\u7968\uff0c\u53d1\u7968\u6570\u636e\u7f3a\u5931 invoiceNum\uff1a{}", (Object)JSON.toJSONString(bill));
                    throw new KDBizException(new ErrorCode("500", String.format(ResManager.loadKDString((String)"\u5dee\u65c5\u58f9\u53f7\u83b7\u53d6\u53d1\u7968\u6570\u636e\u7f3a\u5931invoiceNum\u3002", (String)"TTripInvoiceReceiveInvoke_7", (String)"fi-er-business", (Object[])new Object[0]), JSON.toJSONString(bill))), new Object[0]);
                }
                if (null == infoMap.get("invoiceProjects")) {
                    logger.info("\u5546\u65c5\u96c6\u6210\uff0c\u83b7\u53d6\u53d1\u7968\uff0c\u53d1\u7968\u6570\u636e\u7f3a\u5931 invoiceProjects\uff1a{}", (Object)JSON.toJSONString(bill));
                    throw new KDBizException(new ErrorCode("500", String.format(ResManager.loadKDString((String)"\u5dee\u65c5\u58f9\u53f7\u83b7\u53d6\u53d1\u7968\u6570\u636e\u7f3a\u5931invoiceProjects\u3002", (String)"TTripInvoiceReceiveInvoke_8", (String)"fi-er-business", (Object[])new Object[0]), JSON.toJSONString(bill))), new Object[0]);
                }
                String invoiceNum = infoMap.get("invoiceNum").toString();
                String invoiceCode = infoMap.get("invoiceCode").toString();
                List invoiceProjects = (List)JSON.parseObject((String)JSON.toJSONString(infoMap.get("invoiceProjects")), List.class);
                for (Object invoiceProject : invoiceProjects) {
                    Map invoiceProjectMap = (Map)JSON.parseObject((String)JSON.toJSONString(invoiceProject), Map.class);
                    BigDecimal invoicetaxrate = ((BigDecimal)((Object)invoiceProjectMap.getOrDefault("taxRate", 0))).multiply(BigDecimal.valueOf(100L));
                    BigDecimal invoiceamount = (BigDecimal)invoiceProjectMap.get("amountWithOutTax");
                    BigDecimal taxAmount = (BigDecimal)invoiceProjectMap.get("taxAmount");
                    if (null == invoiceProjectMap.get("projectType")) {
                        logger.info("\u5546\u65c5\u96c6\u6210\uff0c\u83b7\u53d6\u53d1\u7968\uff0c\u53d1\u7968\u6570\u636e\u7f3a\u5931 projectType\uff1a{}", (Object)JSON.toJSONString(bill));
                        throw new KDBizException(new ErrorCode("500", String.format(ResManager.loadKDString((String)"\u5dee\u65c5\u58f9\u53f7\u83b7\u53d6\u53d1\u7968\u6570\u636e\u7f3a\u5931projectType\u3002", (String)"TTripInvoiceReceiveInvoke_9", (String)"fi-er-business", (Object[])new Object[0]), JSON.toJSONString(bill))), new Object[0]);
                    }
                    int projectType = (Integer)invoiceProjectMap.get("projectType");
                    String serviceitem = TTripPropMapping.getProjectTypeRelateServiceitemMap().get(String.valueOf(projectType));
                    if (projectType == 0 || projectType == 1 || projectType == 7) {
                        billNo = billNo + "-1";
                    }
                    if (projectType == 4 || projectType == 8) {
                        billNo = billNo + "-3";
                    }
                    if (projectType == 5) {
                        billNo = billNo + "-6";
                    }
                    InvoiceModel model = new InvoiceModel();
                    model.setServer(this.supplier());
                    model.setInvoiceamount(invoiceamount);
                    model.setTaxamount(taxAmount);
                    model.setInvoicetaxrate(invoicetaxrate);
                    model.setCustInvSequence(billNo + "&" + serviceitem);
                    model.setTrdInvoiceId(billNo + "&" + serviceitem);
                    model.setInvoicenum(invoiceNum);
                    model.setInvoicecode(invoiceCode);
                    invoiceDataList.add(model);
                }
            }
        }
    }

    private Object receiveInvoice(Object value) {
        List objects = (List)value;
        int length = objects.size();
        ArrayList invoiceDataList = Lists.newArrayListWithExpectedSize((int)length);
        for (int i = 0; i < length; ++i) {
            HashMap invoiceDetailMap = (HashMap)objects.get(i);
            BigDecimal invoiceamount = BigDecimal.ZERO;
            String imageType = (String)invoiceDetailMap.get("imageType");
            ArrayList imageInfoList = (ArrayList)invoiceDetailMap.get("imageInfo");
            for (int imageInfoIndex = 0; imageInfoIndex < imageInfoList.size(); ++imageInfoIndex) {
                String serviceitem;
                String invoicenum;
                HashMap imageInfo = (HashMap)imageInfoList.get(imageInfoIndex);
                if (StringUtils.endsWithIgnoreCase((CharSequence)imageType, (CharSequence)TRAVEL_ITINERARY)) {
                    String businessCode = invoiceDetailMap.get("businessCode") + "-1";
                    invoiceamount = invoiceamount.add((BigDecimal)imageInfo.get("totalMoney"));
                    invoicenum = ResManager.loadKDString((String)"\u884c\u7a0b\u5355", (String)"TTripInvoiceReceiveInvoke_0", (String)"fi-er-business", (Object[])new Object[0]);
                    serviceitem = ResManager.loadKDString((String)"\u673a\u7968\u884c\u7a0b\u5355", (String)"TTripInvoiceReceiveInvoke_1", (String)"fi-er-business", (Object[])new Object[0]);
                    InvoiceModel model = new InvoiceModel();
                    model.setServer(this.supplier());
                    model.setInvoiceamount(invoiceamount);
                    model.setCustInvSequence(businessCode + "&" + serviceitem);
                    model.setTrdInvoiceId(businessCode + "&" + serviceitem);
                    model.setInvoicenum(invoicenum);
                    invoiceDataList.add(model);
                    continue;
                }
                if (!StringUtils.endsWithIgnoreCase((CharSequence)imageType, (CharSequence)INVOICE)) continue;
                ArrayList invoiceProjectList = (ArrayList)imageInfo.get("invoiceProjects");
                invoicenum = (String)imageInfo.get("invoiceNum");
                String invoiceCode = (String)imageInfo.get("invoiceCode");
                if (imageInfoIndex < imageInfoList.size() - 1) {
                    invoicenum = invoicenum + ",";
                    invoiceCode = invoiceCode + ",";
                }
                for (int invoiceProjectIndex = 0; invoiceProjectIndex < invoiceProjectList.size(); ++invoiceProjectIndex) {
                    String businessCode = null;
                    HashMap invoiceProjectMap = (HashMap)invoiceProjectList.get(invoiceProjectIndex);
                    BigDecimal invoicetaxrate = ((BigDecimal)invoiceProjectMap.get("taxRate")).multiply(BigDecimal.valueOf(100L));
                    invoiceamount = (BigDecimal)invoiceProjectMap.get("amountWithOutTax");
                    BigDecimal taxAmount = (BigDecimal)invoiceProjectMap.get("taxAmount");
                    int projectType = (Integer)invoiceProjectMap.get("projectType");
                    serviceitem = TTripPropMapping.getProjectTypeRelateServiceitemMap().get(String.valueOf(projectType));
                    if (projectType == 0 || projectType == 1 || projectType == 7) {
                        businessCode = invoiceDetailMap.get("businessCode") + "-1";
                    }
                    InvoiceModel model = new InvoiceModel();
                    model.setServer(this.supplier());
                    model.setInvoiceamount(invoiceamount);
                    model.setTaxamount(taxAmount);
                    model.setInvoicetaxrate(invoicetaxrate);
                    model.setCustInvSequence(businessCode + "&" + serviceitem);
                    model.setTrdInvoiceId(businessCode + "&" + serviceitem);
                    model.setInvoicenum(invoicenum);
                    model.setInvoicecode(invoiceCode);
                    invoiceDataList.add(model);
                }
            }
            if (invoiceDataList.size() <= 0) continue;
            this.handleInvoiceReceiveExtConvert((InvoiceModel)invoiceDataList.get(i), JSON.parseObject((String)JSON.toJSONString((Object)invoiceDetailMap)));
        }
        return invoiceDataList;
    }
}

