/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.trip.supplier.travelno1.systemexternal;

import com.alibaba.fastjson.JSONObject;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.er.business.servicehelper.HttpRetryServiceHelper;
import kd.fi.er.business.trip.exception.TripSyncLogParam;
import kd.fi.er.business.trip.supplier.Supplier;
import kd.fi.er.business.trip.util.TripCommonUtil;
import kd.fi.er.business.utils.ErCommonUtils;
import org.apache.commons.lang3.StringUtils;

public class TravelNoOneSync {
    private static final Log logger = LogFactory.getLog(TravelNoOneSync.class);

    public static String getCacheToken(String key) {
        return TravelNoOneSync.getLoginToken();
    }

    public static String getFieldMappingCacheToken(Map<String, Object> map, TripSyncLogParam tripSyncLogParam) {
        String cacheToken = ErCommonUtils.getKeyValueFromAppCache("TTripFieldMappingCacheToken", String.class);
        if (StringUtils.isBlank((CharSequence)cacheToken)) {
            cacheToken = TravelNoOneSync.getLoginToken();
            ErCommonUtils.putKeyValueToAppCache("TTripFieldMappingCacheToken", cacheToken);
        }
        return cacheToken;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getLoginToken() {
        DistributeSessionlessCache distributeSessionlessCache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache();
        String access_token = (String)distributeSessionlessCache.get("TravelNoOne_Access_Token" + RequestContext.get().getTenantId());
        if (StringUtils.isNotEmpty((CharSequence)access_token)) {
            return access_token;
        }
        String token = null;
        Map<String, String> supplierMap = TripCommonUtil.getTripServiceInfo(Supplier.CHAILVYIHAO.name());
        if (supplierMap == null || supplierMap.size() < 1 || supplierMap.get("appkey") == null || supplierMap.get("appsecurity") == null) {
            return token;
        }
        String tokenUrl = TripCommonUtil.getTravelNoOneApiUrl("tokenurlkey");
        if (StringUtils.isBlank((CharSequence)tokenUrl)) {
            return token;
        }
        JSONObject postJson = new JSONObject();
        postJson.put("appid", (Object)supplierMap.get("appkey"));
        postJson.put("appsecret", (Object)supplierMap.get("appsecurity"));
        JSONObject postDataJson = new JSONObject();
        postDataJson.put("data", (Object)postJson);
        SimpleDateFormat dataFormat = new SimpleDateFormat("yyyyMMddHHmmssSSS");
        String datestr = dataFormat.format(new Date());
        postDataJson.put("requestid", (Object)datestr);
        postDataJson.put("version", (Object)"0.0.1");
        try {
            String result = HttpRetryServiceHelper.PostData(tokenUrl, postDataJson.toJSONString());
            JSONObject jsonObject = JSONObject.parseObject((String)result);
            if (jsonObject != null && jsonObject.getString("errmsg").equals(ResManager.loadKDString((String)"\u6210\u529f", (String)"TravelNoOneSync_0", (String)"fi-er-business", (Object[])new Object[0]))) {
                JSONObject data = (JSONObject)jsonObject.get((Object)"data");
                token = data.getString("access_token");
            }
        }
        catch (KDBizException e) {
            logger.info("\u5dee\u65c5\u58f9\u53f7\u83b7\u53d6token \u8bf7\u6c42\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
        }
        finally {
            if (StringUtils.isNotEmpty(token)) {
                distributeSessionlessCache.put("TravelNoOne_Access_Token" + RequestContext.get().getTenantId(), token, 3600000, TimeUnit.MILLISECONDS);
            }
        }
        return token;
    }
}

